/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ibt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fin.LoanException;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.ibt.BillTypeEnum;
import com.kingdee.eas.fm.ibt.IInnerFinancingBorrowingOut;
import com.kingdee.eas.fm.ibt.InnerBorrowingReturnOutInfo;
import com.kingdee.eas.fm.ibt.InnerFinancingBorrowingOutFactory;
import com.kingdee.eas.fm.ibt.InnerFinancingBorrowingOutInfo;
import com.kingdee.eas.fm.ibt.client.AbstractInnerFinancingBorrowingOutListUI;
import com.kingdee.eas.fm.ibt.client.InnerBorrowingOutFilterUI;
import com.kingdee.eas.fm.ibt.client.InnerBorrowingOutParam;
import com.kingdee.eas.fm.ibt.client.InnerFinancingBorrowingOutEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class InnerFinancingBorrowingOutListUI
extends AbstractInnerFinancingBorrowingOutListUI {
    private static final Logger logger = CoreUIObject.getLogger(InnerFinancingBorrowingOutListUI.class);
    private InnerBorrowingOutFilterUI filterUI = null;
    public FillListener fillListener = new FillListener();
    private static final String RESOURCE = "com.kingdee.eas.fm.ibt.client.IbtClientResource";
    private final String fileName = "/FM/IBT/FINANCINGBORROWINGOUT";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.checkSelected();
        if (this.tblMain.getSelectManager().size() > 0) {
            if (this.getSelectedFieldValues("fiVouchered").get(0).equals("true")) {
                this.actionVoucher.setEnabled(false);
            } else {
                this.actionVoucher.setEnabled(true);
            }
        }
        super.tblMain_tableSelectChanged(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        InnerFinancingBorrowingOutInfo info = InnerFinancingBorrowingOutFactory.getRemoteInstance().getInnerFinancingBorrowingOutInfo((IObjectPK)new ObjectStringPK(id));
        if (info.getBillType() == BillTypeEnum.Audit) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"InnerAuditNoChange"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        IInnerFinancingBorrowingOut InnerFinancingBorrowingOut2 = InnerFinancingBorrowingOutFactory.getRemoteInstance();
        ObjectUuidPK pk = new ObjectUuidPK(id);
        InnerFinancingBorrowingOutInfo info = InnerFinancingBorrowingOut2.getInnerFinancingBorrowingOutInfo((IObjectPK)pk);
        if (BillTypeEnum.Audit.equals((Object)info.getBillType())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"InnerAuditNoDel"));
            SysUtil.abort();
        }
        if (InnerFinancingBorrowingOut2.isRelatInnerReturn(id.toString())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"InnerRelationReturnOutNoDel"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        String id;
        if (this.getSelectedIdValues().size() > 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"InnerNoAllSameReturn"));
            this.abort();
        }
        if ((id = this.getSelectedKeyValue()) != null) {
            InnerFinancingBorrowingOutInfo info = InnerFinancingBorrowingOutFactory.getRemoteInstance().getInnerFinancingBorrowingOutInfo((IObjectPK)new ObjectUuidPK(id));
            if (info.getBillType().equals((Object)BillTypeEnum.Submit)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"InnerUnAuditNoOperate"));
                this.abort();
            }
            if (Double.parseDouble(info.getBalance().toString()) <= 0.0) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"InnerBalanceIsZeroNoOperate"));
                this.abort();
            } else {
                FMClientHelper.generateDestBill((CoreBillListUI)this, (String)new InnerFinancingBorrowingOutInfo().getBOSType().toString(), (String)new InnerBorrowingReturnOutInfo().getBOSType().toString(), (String)id);
            }
        }
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanVoucher(0);
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        IInnerFinancingBorrowingOut InnerFinancingBorrowingOut2 = InnerFinancingBorrowingOutFactory.getRemoteInstance();
        ObjectUuidPK pk = new ObjectUuidPK(id);
        InnerFinancingBorrowingOutInfo info = InnerFinancingBorrowingOut2.getInnerFinancingBorrowingOutInfo((IObjectPK)pk);
        if (!BillTypeEnum.Audit.equals((Object)info.getBillType())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"OnlyAuditCantoVoucher"));
            SysUtil.abort();
        }
        super.actionVoucher_actionPerformed(e);
    }

    private void checkCanVoucher(int type) throws Exception {
        this.checkSelected();
        InnerFinancingBorrowingOutInfo InnerInInfo = InnerFinancingBorrowingOutFactory.getRemoteInstance().getInnerFinancingBorrowingOutInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        if (0 == type ? InnerInInfo.isHistoryBill() : 1 == type && InnerInInfo.isHistoryBill()) {
            throw new LoanException(LoanException.CHLOANISNOTVOUCHER);
        }
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new InnerBorrowingOutFilterUI();
        }
        return this.filterUI;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return InnerFinancingBorrowingOutFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return InnerFinancingBorrowingOutEditUI.class.getName();
    }

    public void onLoad() throws Exception {
        FSClientHelper.checkClearingHouseCompany();
        super.onLoad();
        this.btnAuditResult.setVisible(false);
        this.checkBizUnit();
        this.tblMain.getColumn("LocalCurExRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("yearRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("LocalCurExRate").getStyleAttributes().setNumberFormat("#,###.0000");
        this.tblMain.getColumn("yearRate").getStyleAttributes().setNumberFormat("%r{##0.0000!}f");
    }

    protected void checkBizUnit() throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (ContextHelperFactory.getRemoteInstance().isOnlyUnion(company)) {
            this.btnDelVoucher.setVisible(false);
            this.btnAddNew.setVisible(false);
            this.menuItemAddNew.setVisible(false);
            this.btnEdit.setVisible(false);
            this.menuItemEdit.setVisible(false);
            this.btnRemove.setVisible(false);
            this.menuItemRemove.setVisible(false);
        }
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    @Override
    public void actionAnitAudit_actionPerformed(ActionEvent e) throws Exception {
        int i;
        super.actionAnitAudit_actionPerformed(e);
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        ArrayList voucheredList = this.getSelectedFieldValues("fiVouchered");
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (i = 0; i < selectRows.length; ++i) {
            String id;
            ICell cell = this.tblMain.getRow(selectRows[i]).getCell("fiVouchered");
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if (cell.getValue() == null || (id = cell.getValue().toString()) == null) continue;
            voucheredList.add(id);
        }
        for (i = 0; i < idList.size(); ++i) {
            String id = idList.get(i).toString();
            IInnerFinancingBorrowingOut InnerFinancingBorrowingOut2 = InnerFinancingBorrowingOutFactory.getRemoteInstance();
            ObjectUuidPK pk = new ObjectUuidPK(id);
            InnerFinancingBorrowingOutInfo info = InnerFinancingBorrowingOut2.getInnerFinancingBorrowingOutInfo((IObjectPK)pk);
            IBTPManager iBTPManager = BTPManagerFactory.getRemoteInstance();
            if (BillTypeEnum.Audit.equals((Object)info.getBillType())) {
                if (!voucheredList.get(i).equals("true")) {
                    if (!iBTPManager.ifHaveDestBills(id.toString())) {
                        InnerFinancingBorrowingOut2.antiAudit((IObjectPK)pk);
                        this.refreshList();
                        continue;
                    }
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"InnerRelationReturnOutNoAnitAudit"));
                    SysUtil.abort();
                    continue;
                }
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"InnerToVoucherNoAnitAudit"));
                SysUtil.abort();
                continue;
            }
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"AuditMustBeAnitAudit"));
            SysUtil.abort();
        }
        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"SuccessAnitAudit"));
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        InnerFinancingBorrowingOutInfo info;
        ObjectUuidPK pk;
        IInnerFinancingBorrowingOut InnerFinancingBorrowingOut2;
        String id;
        super.actionAudit_actionPerformed(e);
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        for (int i = 0; i < idList.size(); ++i) {
            id = idList.get(i).toString();
            InnerFinancingBorrowingOut2 = InnerFinancingBorrowingOutFactory.getRemoteInstance();
            info = InnerFinancingBorrowingOut2.getInnerFinancingBorrowingOutInfo((IObjectPK)(pk = new ObjectUuidPK(id)));
            if (BillTypeEnum.Audit.equals((Object)info.getBillType())) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"ThisIsAudited"));
                SysUtil.abort();
            }
            if (!BillTypeEnum.Submit.equals((Object)info.getBillType())) continue;
            InnerFinancingBorrowingOut2.audit((IObjectPK)pk);
            this.refreshList();
        }
        for (int j = 0; j < idList.size(); ++j) {
            id = idList.get(j).toString();
            InnerFinancingBorrowingOut2 = InnerFinancingBorrowingOutFactory.getRemoteInstance();
            info = InnerFinancingBorrowingOut2.getInnerFinancingBorrowingOutInfo((IObjectPK)(pk = new ObjectUuidPK(id)));
            if (BillTypeEnum.Audit.equals((Object)info.getBillType())) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"AuditMustBeSubmit"));
            SysUtil.abort();
        }
        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"SuccessAudit"));
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected void execQuery() {
        super.execQuery();
        this.formatFootRow();
    }

    protected IRow appendFootRow() {
        IRow sumRow = super.appendFootRow();
        this.formatFootRow();
        return sumRow;
    }

    private void formatFootRow() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            InnerBorrowingOutParam param = (InnerBorrowingOutParam)this.getFilterUI().getParam();
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrencyId() == null ? company.getBaseCurrency().getId().toString() : AccessHelper.getId((Object)param.getCurrencyId());
            String[] columns = new String[]{"Amount", "intendAccrual"};
            for (int i = 0; i < columns.length; ++i) {
                FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
            }
            FMClientHelper.setNumberFormat((IRow)row, (String)"AmountLocalCur", (String)company.getBaseCurrency().getId().toString());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPrint_actionPerformed(e);
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        KDNoteHelper appHlp = new KDNoteHelper();
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryName());
        appHlp.print("/FM/IBT/FINANCINGBORROWINGOUT", (Object)data, (Component)((Object)this));
    }

    private IMetaDataPK getTDQueryName() {
        return new MetaDataPK("com.kingdee.eas.fm.ibt.app.InnerFinBorrowingOuQuery");
    }

    @Override
    public void actionTDPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPreview_actionPerformed(e);
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        KDNoteHelper appHlp = new KDNoteHelper();
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryName());
        appHlp.printPreview("/FM/IBT/FINANCINGBORROWINGOUT", (Object)data, (Component)((Object)this));
    }

    private FilterInfo getBillCanbeReceived() {
        FilterInfo f = new FilterInfo();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null) {
            Map btpeditparameter = (Map)this.getUIContext().get("BTPEDITPARAMETER");
            String string = (String)btpeditparameter.get("TargetBillType");
        }
        return f;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null && ((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("fromRepayment") != null && ((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("fromRepayment").toString().equals("fromRepayment")) {
            filter.getFilterItems().add(new FilterItemInfo("borrowingOut.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString(), CompareType.EQUALS));
        }
        return filter;
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            if (e == null || e.getLastRow() == -1) {
                return;
            }
            InnerFinancingBorrowingOutListUI.this.tblMain.checkParsed();
            IRow row = null;
            String currencyId = null;
            CompanyOrgUnitInfo companyInfo = null;
            try {
                companyInfo = FSHelper.getCHCompanyInfo(null);
            }
            catch (EASBizException e1) {
                ExceptionHandler.handle((Throwable)e1);
            }
            catch (BOSException e1) {
                ExceptionHandler.handle((Throwable)e1);
            }
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = InnerFinancingBorrowingOutListUI.this.tblMain.getRow(i);
                currencyId = (String)row.getCell("Currency.id").getValue();
                if (currencyId != null) {
                    FMClientHelper.setNumberFormat((IRow)row, (String)"Amount", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"balance", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"intendAccrual", (String)currencyId);
                }
                if (companyInfo == null || companyInfo.getBaseCurrency() == null) continue;
                String baseCurrency = companyInfo.getBaseCurrency().getId().toString();
                FMClientHelper.setNumberFormat((IRow)row, (String)"AmountLocalCur", (String)baseCurrency);
            }
        }
    }
}

