/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ibt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.ibt.FinancingTypeEnum;
import com.kingdee.eas.fm.ibt.RptAvgCostFilterParam;
import com.kingdee.eas.fm.ibt.client.AbstractRptAvgCostFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.util.Date;
import org.apache.log4j.Logger;

public class RptAvgCostFilterUI
extends AbstractRptAvgCostFilterUI {
    private static final long serialVersionUID = 6312911601401036797L;
    private static final Logger logger = CoreUIObject.getLogger(RptAvgCostFilterUI.class);

    protected void init() throws Exception {
        super.init();
        FMClientHelper.initComboCurrency((KDComboBox)this.comboCurrency, (boolean)true);
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.dpStartDate.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.dpEndDate.setValue((Object)DateUtil.getLastDayOfCurMonth());
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.bassCurrency);
        this.comboFinancingType.setSelectedItem((Object)FinancingTypeEnum.all);
    }

    public Object getParam() {
        RptAvgCostFilterParam param = new RptAvgCostFilterParam();
        param.setBeginDate((Date)this.dpStartDate.getValue());
        param.setEndDate((Date)this.dpEndDate.getValue());
        param.setFinancingType(((FinancingTypeEnum)((Object)this.comboFinancingType.getSelectedItem())).getValue());
        Object currency = this.comboCurrency.getSelectedItem();
        if (currency != null) {
            param.setCurrencyID(((CurrencyInfo)currency).getId().toString());
        } else {
            param.setCurrencyID(null);
        }
        return param;
    }

    public void setParam(Object param) {
        if (!(param instanceof RptAvgCostFilterParam)) {
            return;
        }
        RptAvgCostFilterParam p = (RptAvgCostFilterParam)param;
        this.dpStartDate.setValue((Object)p.getBeginDate());
        this.dpEndDate.setValue((Object)p.getEndDate());
        this.comboFinancingType.setSelectedItem((Object)FinancingTypeEnum.getEnum(p.getFinancingType()));
        if (p.getCurrencyID() != null) {
            try {
                CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(p.getCurrencyID()));
                FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)currency);
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.bassCurrency);
        }
    }

    public boolean verify() {
        Date endDate;
        Date startDate = (Date)this.dpStartDate.getValue();
        if (startDate.after(endDate = (Date)this.dpEndDate.getValue())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.ibt.IBTAutoGenerateResource", (String)"11_RptAvgCostFilterUI"));
            SysUtil.abort();
        }
        return super.verify();
    }

    protected Class getParamClass() {
        return RptAvgCostFilterParam.class;
    }
}

