/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ibt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.FMRptClientUtils;
import com.kingdee.eas.fm.common.client.IFMDetailRptHandler;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.ibt.RptAvgCostFilterParam;
import com.kingdee.eas.fm.ibt.client.AbstractRptAvgCostMainUI;
import com.kingdee.eas.fm.ibt.client.RptAvgCostFilterUI;
import com.kingdee.eas.fm.ibt.client.RptAvgCostUIHandler;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class RptAvgCostMainUI
extends AbstractRptAvgCostMainUI {
    private static final long serialVersionUID = 4944726746209782924L;
    private static final Logger logger = CoreUIObject.getLogger(RptAvgCostMainUI.class);
    private RptAvgCostFilterUI filterUI;
    private CompanyOrgUnitInfo currentCompany;

    protected void execQuery() throws BOSException {
        RptAvgCostFilterParam param = (RptAvgCostFilterParam)this.getFilterParam();
        String text = EASResource.getString((String)"com.kingdee.eas.fm.ibt.IBTAutoGenerateResource", (String)"12_RptAvgCostMainUI");
        text = MessageFormat.format(text, Constants.FORMAT_DAY.format(param.getBeginDate()), Constants.FORMAT_DAY.format(param.getEndDate()));
        this.txtBound.setText(text);
        try {
            CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(param.getCurrencyID()));
            this.txtCurrency.setText(currency.getName());
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.tblMain.checkParsed();
        RptAvgCostUIHandler handler = new RptAvgCostUIHandler(param, this.tblMain);
        FMRptClientUtils.executeDetailRptHandle((CoreUI)this, (IFMDetailRptHandler)handler);
    }

    public void onLoad() throws Exception {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (!this.currentCompany.isIsBizUnit()) {
            throw new NTException(NTException.CHANGE_TO_BIZUNIT);
        }
        FSClientHelper.checkClearingHouseCompany();
        super.onLoad();
        this.actionRefresh.setEnabled(true);
        this.actionRefresh.setVisible(true);
        this.actionViewDetail.setVisible(true);
        this.enableExportExcel(this.tblMain);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.getViewManager().freeze(-1, this.tblMain.getColumnIndex("noteGroup") + 1);
        this.txtBound.setEnabled(false);
        this.txtCurrency.setEnabled(false);
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fm.ibt.IBTAutoGenerateResource", (String)"13_RptAvgCostMainUI"));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnViewDetail.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewbill"));
        this.kDMenuItemViewDetail.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewbill"));
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new RptAvgCostFilterUI();
        }
        return this.filterUI;
    }

    @Override
    public void actionViewDetail_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewDetail_actionPerformed(e);
        FMClientHelper.checkSelected((Component)((Object)this), (KDTable)this.tblMain);
        Object id = this.tblMain.getRow(FMClientHelper.getSelectedRow((KDTable)this.tblMain)).getCell("id").getValue();
        if (id == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"SelectValidRecord"));
            return;
        }
        FMClientHelper.viewDetailBill((CoreUIObject)this, (String)id.toString(), (CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }
}

