/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ibt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMDetailRptBaseHandler;
import com.kingdee.eas.fm.common.client.FMKDTableHelper;
import com.kingdee.eas.fm.ibt.FinancingTypeEnum;
import com.kingdee.eas.fm.ibt.RptAvgCostFacadeFactory;
import com.kingdee.eas.fm.ibt.RptAvgCostFilterParam;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;

public class RptAvgCostUIHandler
extends FMDetailRptBaseHandler {
    private RptAvgCostFilterParam param;
    private BigDecimal InnerFinacingR;
    private BigDecimal InnerFinacingS;
    private BigDecimal InnerFinacingY;
    private BigDecimal InnerFinacingK;
    private BigDecimal InnerFinacingW;
    private int InnerFinacingIndex = -1;
    private BigDecimal CreditAssetR;
    private BigDecimal CreditAssetS;
    private BigDecimal CreditAssetY;
    private BigDecimal CreditAssetK;
    private BigDecimal CreditAssetW;
    private int CreditAssetIndex = -1;
    private BigDecimal BillRediscountR;
    private BigDecimal BillRediscountS;
    private BigDecimal BillRediscountY;
    private BigDecimal BillRediscountK;
    private BigDecimal BillRediscountW;
    private int BillRediscountIndex = -1;
    private BigDecimal totalBBiliKW;
    private int precision = 2;

    public RptAvgCostUIHandler(FilterParam filterParam, KDTable kdt) {
        super(filterParam.getFilter(), kdt);
        this.param = (RptAvgCostFilterParam)filterParam;
    }

    protected String getQueryPath() {
        return null;
    }

    public void initHeader() {
    }

    public void setTableStateRow() {
        try {
            CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.param.getCurrencyID()));
            this.precision = currency.getPrecision();
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.kdt.checkParsed();
        int pre = 4;
        FMKDTableHelper.initDecimalColumn((IColumn)this.kdt.getColumn("amount"), (int)this.precision);
        FMKDTableHelper.initDecimalColumn((IColumn)this.kdt.getColumn("Interest"), (int)this.precision);
        FMKDTableHelper.initDecimalColumn((IColumn)this.kdt.getColumn("avgBankrollEngross"), (int)this.precision);
        FMKDTableHelper.initDecimalColumn((IColumn)this.kdt.getColumn("interestRate"), (int)this.precision);
        FMKDTableHelper.initDecimalColumn((IColumn)this.kdt.getColumn("MoneyRate"), (int)pre);
        FMKDTableHelper.initDecimalColumn((IColumn)this.kdt.getColumn("TotalBBili"), (int)pre);
        this.kdt.getColumn("termDate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdt.getColumn("interestRate").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)pre) + "%");
    }

    public IRowSet getRowSet() throws BOSException {
        return RptAvgCostFacadeFactory.getRemoteInstance().getRowSet(this.param);
    }

    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        this.kdt.removeRows();
        if (rs == null) {
            return;
        }
        this.kdt.setRefresh(false);
        this.initCaculateField();
        this.initSumRowIndex();
        EntryInfo info = new EntryInfo();
        int noteKind = 0;
        boolean isInit = false;
        int rowIndex = -1;
        while (rs.next()) {
            info.readData(rs);
            info.caculate();
            if (!isInit) {
                noteKind = info.kind;
                isInit = true;
            }
            if (noteKind != info.kind) {
                this.caculateSum(noteKind);
                this.addSumRow(noteKind);
                this.saveSumRowIndex(noteKind, ++rowIndex);
                noteKind = info.kind;
            }
            info.writeData(this.kdt);
            ++rowIndex;
        }
        if (noteKind != 0) {
            this.caculateSum(noteKind);
            this.addSumRow(noteKind);
            this.saveSumRowIndex(noteKind, ++rowIndex);
        }
        this.caculateTotal();
        this.updateSumRowValue();
        this.addTotalRow();
        this.addExtraRow();
        this.kdt.getGroupManager().group();
        this.kdt.getGroupManager().setGroup(false);
        this.kdt.setRefresh(true);
        this.kdt.reLayoutAndPaint();
    }

    private void initCaculateField() {
        this.InnerFinacingR = Constants.ZERO;
        this.CreditAssetR = Constants.ZERO;
        this.BillRediscountR = Constants.ZERO;
        this.InnerFinacingS = Constants.ZERO;
        this.CreditAssetS = Constants.ZERO;
        this.BillRediscountS = Constants.ZERO;
        this.InnerFinacingY = Constants.ZERO;
        this.CreditAssetY = Constants.ZERO;
        this.BillRediscountY = Constants.ZERO;
        this.InnerFinacingK = Constants.ZERO;
        this.CreditAssetK = Constants.ZERO;
        this.BillRediscountK = Constants.ZERO;
        this.InnerFinacingW = Constants.ZERO;
        this.CreditAssetW = Constants.ZERO;
        this.BillRediscountW = Constants.ZERO;
        this.totalBBiliKW = Constants.ZERO;
    }

    private void initSumRowIndex() {
        this.InnerFinacingIndex = -1;
        this.CreditAssetIndex = -1;
        this.BillRediscountIndex = -1;
    }

    private void saveSumRowIndex(int noteKind, int rowIndex) {
        if (noteKind == 10) {
            this.InnerFinacingIndex = rowIndex;
        }
        if (noteKind == 20) {
            this.CreditAssetIndex = rowIndex;
        }
        if (noteKind == 30) {
            this.BillRediscountIndex = rowIndex;
        }
    }

    private void caculateSum(int noteKind) {
        if (noteKind == 10 && this.InnerFinacingY.compareTo(Constants.ZERO) > 0) {
            this.InnerFinacingK = this.InnerFinacingS.divide(this.InnerFinacingY, 4);
        }
        if (noteKind == 20 && this.CreditAssetY.compareTo(Constants.ZERO) > 0) {
            this.CreditAssetK = this.CreditAssetS.divide(this.CreditAssetY, 4);
        }
        if (noteKind == 30 && this.BillRediscountS.compareTo(Constants.ZERO) > 0) {
            this.BillRediscountK = this.BillRediscountS.divide(this.BillRediscountY, 4);
        }
    }

    private void caculateTotal() {
        BigDecimal totalR = this.InnerFinacingR.add(this.CreditAssetR).add(this.BillRediscountR);
        if (totalR.compareTo(Constants.ZERO) != 0) {
            this.InnerFinacingW = this.InnerFinacingR.setScale(10).divide(totalR, 4);
            this.CreditAssetW = this.CreditAssetR.setScale(10).divide(totalR, 4);
            this.BillRediscountW = this.BillRediscountR.setScale(10).divide(totalR, 4);
            this.InnerFinacingW = this.InnerFinacingW.setScale(this.precision, 4);
            this.CreditAssetW = this.CreditAssetW.setScale(this.precision, 4);
            this.BillRediscountW = this.BillRediscountW.setScale(this.precision, 4);
            this.totalBBiliKW = this.InnerFinacingK.multiply(this.InnerFinacingW);
            this.totalBBiliKW = this.totalBBiliKW.add(this.CreditAssetK.multiply(this.CreditAssetW));
            this.totalBBiliKW = this.totalBBiliKW.add(this.BillRediscountK.multiply(this.BillRediscountW));
            this.totalBBiliKW = this.totalBBiliKW.setScale(4, 4);
        }
    }

    private void addSumRow(int noteKind) {
        IRow row = this.kdt.addRow();
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        row.getCell("noteKind").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.ibt.IBTAutoGenerateResource", (String)"14_RptAvgCostUIHandler"));
        BigDecimal R = Constants.ZERO;
        BigDecimal S = Constants.ZERO;
        BigDecimal Y = Constants.ZERO;
        if (noteKind == 10) {
            R = this.InnerFinacingR;
            S = this.InnerFinacingS;
            Y = this.InnerFinacingY;
        }
        if (noteKind == 20) {
            R = this.CreditAssetR;
            S = this.CreditAssetS;
            Y = this.CreditAssetY;
        }
        if (noteKind == 30) {
            R = this.BillRediscountR;
            S = this.BillRediscountS;
            Y = this.BillRediscountY;
        }
        row.getCell("amount").setValue((Object)R);
        row.getCell("Interest").setValue((Object)S);
        row.getCell("avgBankrollEngross").setValue((Object)Y);
    }

    private void updateSumRowValue() {
        IRow row;
        if (this.InnerFinacingIndex != -1 && (row = this.kdt.getRow(this.InnerFinacingIndex)) != null) {
            row.getCell("MoneyRate").setValue((Object)this.InnerFinacingK);
            row.getCell("TotalBBili").setValue((Object)this.InnerFinacingW);
        }
        if (this.CreditAssetIndex != -1 && (row = this.kdt.getRow(this.CreditAssetIndex)) != null) {
            row.getCell("MoneyRate").setValue((Object)this.CreditAssetK);
            row.getCell("TotalBBili").setValue((Object)this.CreditAssetW);
        }
        if (this.BillRediscountIndex != -1 && (row = this.kdt.getRow(this.BillRediscountIndex)) != null) {
            row.getCell("MoneyRate").setValue((Object)this.BillRediscountK);
            row.getCell("TotalBBili").setValue((Object)this.BillRediscountW);
        }
    }

    private void addTotalRow() {
        IRow row = this.kdt.addRow();
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        row.getCell("noteKind").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.ibt.IBTAutoGenerateResource", (String)"0_BillRediscountInControllerBean"));
        BigDecimal R = this.InnerFinacingR.add(this.CreditAssetR).add(this.BillRediscountR);
        BigDecimal S = this.InnerFinacingS.add(this.CreditAssetS).add(this.BillRediscountS);
        BigDecimal Y = this.InnerFinacingY.add(this.CreditAssetY).add(this.BillRediscountY);
        row.getCell("amount").setValue((Object)R);
        row.getCell("Interest").setValue((Object)S);
        row.getCell("avgBankrollEngross").setValue((Object)Y);
    }

    private void addExtraRow() {
        IRow row = this.kdt.addRow();
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        row.getCell("noteKind").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.ibt.IBTAutoGenerateResource", (String)"15_RptAvgCostUIHandler"));
        row.getCell("number").setValue((Object)this.totalBBiliKW);
    }

    public void endDataFill() {
    }

    class EntryInfo {
        String id;
        String number;
        int kind;
        Date bizDate;
        BigDecimal amount;
        Date beginDate;
        Date endDate;
        int dateDays;
        BigDecimal interestRate;
        BigDecimal interest;
        BigDecimal avgBUser;

        EntryInfo() {
        }

        public void readData(IRowSet rs) throws SQLException {
            this.id = rs.getString("FID");
            this.number = rs.getString("FNumber");
            this.kind = rs.getInt("noteKind");
            this.bizDate = rs.getDate("FBizDate");
            this.amount = rs.getBigDecimal("FAmount");
            this.beginDate = rs.getDate("FStartDate");
            this.endDate = rs.getDate("FEndDate");
            this.dateDays = DateUtil.getDiffDays((Date)this.beginDate, (Date)this.endDate) - 1;
            this.interestRate = rs.getBigDecimal("FYearRate");
            this.interest = rs.getBigDecimal("FIntend");
            if (this.dateDays > 0) {
                BigDecimal days = new BigDecimal("" + this.dateDays).setScale(10);
                this.avgBUser = days.multiply(this.amount).divide(new BigDecimal("360"), 4);
            } else {
                this.avgBUser = Constants.ZERO;
            }
            if (this.interestRate != null) {
                this.interestRate = this.interestRate.setScale(10).divide(Constants.ONE_HUNDRED, 4);
            }
        }

        public void caculate() {
            if (this.amount == null) {
                this.amount = Constants.ZERO;
            }
            if (this.interest == null) {
                this.interest = Constants.ZERO;
            }
            if (this.avgBUser == null) {
                this.avgBUser = Constants.ZERO;
            }
            if (this.kind == 10) {
                RptAvgCostUIHandler.this.InnerFinacingR = RptAvgCostUIHandler.this.InnerFinacingR.add(this.amount);
                RptAvgCostUIHandler.this.InnerFinacingS = RptAvgCostUIHandler.this.InnerFinacingS.add(this.interest);
                RptAvgCostUIHandler.this.InnerFinacingY = RptAvgCostUIHandler.this.InnerFinacingY.add(this.avgBUser);
            }
            if (this.kind == 20) {
                RptAvgCostUIHandler.this.CreditAssetR = RptAvgCostUIHandler.this.CreditAssetR.add(this.amount);
                RptAvgCostUIHandler.this.CreditAssetS = RptAvgCostUIHandler.this.CreditAssetS.add(this.interest);
                RptAvgCostUIHandler.this.CreditAssetY = RptAvgCostUIHandler.this.CreditAssetY.add(this.avgBUser);
            }
            if (this.kind == 30) {
                RptAvgCostUIHandler.this.BillRediscountR = RptAvgCostUIHandler.this.BillRediscountR.add(this.amount);
                RptAvgCostUIHandler.this.BillRediscountS = RptAvgCostUIHandler.this.BillRediscountS.add(this.interest);
                RptAvgCostUIHandler.this.BillRediscountY = RptAvgCostUIHandler.this.BillRediscountY.add(this.avgBUser);
            }
        }

        public void writeData(KDTable kdt) {
            IRow row = kdt.addRow();
            row.getCell("id").setValue((Object)this.id);
            row.getCell("number").setValue((Object)this.number);
            row.getCell("noteKind").setValue((Object)FinancingTypeEnum.getEnum(this.kind));
            row.getCell("bizDate").setValue((Object)this.bizDate);
            row.getCell("amount").setValue((Object)this.amount);
            row.getCell("startDate").setValue((Object)this.beginDate);
            row.getCell("endDate").setValue((Object)this.endDate);
            row.getCell("termDate").setValue((Object)new Integer(this.dateDays));
            row.getCell("interestRate").setValue((Object)this.interestRate);
            row.getCell("Interest").setValue((Object)this.interest);
            row.getCell("avgBankrollEngross").setValue((Object)this.avgBUser);
        }
    }
}

