/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.attachment.BizobjectFacadeFactory;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.im.AccrualBillCollection;
import com.kingdee.eas.fm.im.AccrualBillFactory;
import com.kingdee.eas.fm.im.AccrualBillInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import java.util.Collection;
import java.util.Date;
import java.util.Set;

public class FmImHelper {
    public void botpTransformReceivingbill(Context ctx, IObjectCollection coll) throws BOSException, BTPException, EASBizException {
        CoreBillBaseCollection srcColl = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            srcColl = new CoreBillBaseCollection();
            srcColl.addObject(coll.getObject(i));
            this.botpTransformReceivingbill(ctx, srcColl);
        }
    }

    private void botpTransformReceivingbill(Context ctx, CoreBillBaseCollection coll) throws BOSException, EASBizException {
        BOSObjectType bosType = new ReceivingBillInfo().getBOSType();
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BTPTransformResult result = iBTPManager.transformMultiBill(coll, bosType.toString());
        IObjectCollection destBillColl = result.getBills();
        BOTRelationCollection botRelateColl = result.getBOTRelationCollection();
        ReceivingBillInfo destBillInfo = null;
        int size = destBillColl.size();
        for (int i = 0; i < size; ++i) {
            destBillInfo = (ReceivingBillInfo)destBillColl.getObject(i);
            if (destBillInfo.getBizDate() == null) {
                destBillInfo.setBizDate(new Date());
            }
            if (ctx != null && destBillInfo.getSourceBillId() != null) {
                BizobjectFacadeFactory.getLocalInstance((Context)ctx).copyBizRelation(destBillInfo.getSourceBillId(), destBillInfo.getId().toString());
            }
            iBTPManager.saveRelations((CoreBillBaseInfo)destBillInfo, botRelateColl);
        }
    }

    public static AccrualBillCollection getAccrualBillCol(Context ctx, Set idSet, SelectorItemCollection selectors) throws BOSException, EASBizException {
        AccrualBillCollection coll = new AccrualBillCollection();
        if (FMHelper.isEmpty((Collection)idSet)) {
            return coll;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        evi.setFilter(f);
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setSelector(selectors);
        coll = AccrualBillFactory.getLocalInstance(ctx).getAccrualBillCollection(evi);
        return coll;
    }

    public static AccrualBillInfo getAccrualBillInfoByID(String id, AccrualBillCollection col) {
        for (int i = 0; i < col.size(); ++i) {
            if (!id.equals(col.get(i).getId().toString())) continue;
            return col.get(i);
        }
        return null;
    }

    public static JournalCollection getJournalCollByID(String id, JournalCollection col) {
        JournalCollection resutlCol = new JournalCollection();
        for (int i = 0; i < col.size(); ++i) {
            JournalInfo journal = col.get(i);
            if (!id.equals(journal.getBillId().toString())) continue;
            resutlCol.add(col.get(i));
        }
        return resutlCol;
    }
}

