/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fp.FPMonitorParamCollection;
import com.kingdee.eas.fm.fp.FPMonitorParamInfo;
import com.kingdee.eas.fm.fp.IFPItemParse;
import com.kingdee.eas.fm.im.AccrualBillFactory;
import com.kingdee.eas.fm.im.AccrualBillInfo;

public class IMFPItemParse
implements IFPItemParse {
    public FPMonitorParamCollection getParameters(Context ctx, String billId) throws BOSException, EASBizException {
        FPMonitorParamCollection coll = new FPMonitorParamCollection();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("id");
        selectors.add("number");
        selectors.add("company.id");
        selectors.add("accrualAmt");
        selectors.add("currency.id");
        selectors.add("fpItem.id");
        AccrualBillInfo accrualBillInfo = AccrualBillFactory.getLocalInstance(ctx).getAccrualBillInfo((IObjectPK)new ObjectUuidPK(billId), selectors);
        FPMonitorParamInfo fpMonitorParamInfo = this.getBaseParam(accrualBillInfo);
        fpMonitorParamInfo.setCompanyID(accrualBillInfo.getCompany().getId().toString());
        fpMonitorParamInfo.setAmount(accrualBillInfo.getAccrualAmt());
        fpMonitorParamInfo.setCurrencyID(accrualBillInfo.getCurrency().getId().toString());
        fpMonitorParamInfo.setFpItemID(accrualBillInfo.getFpItem().getId().toString());
        coll.add(fpMonitorParamInfo);
        return coll;
    }

    private FPMonitorParamInfo getBaseParam(AccrualBillInfo billInfo) {
        FPMonitorParamInfo paramInfo = new FPMonitorParamInfo();
        paramInfo.setSrcBillNumber(billInfo.getNumber());
        paramInfo.setSrcBillID(billInfo.getId().toString());
        paramInfo.setBizDate(DateUtil.getDayBegin());
        return paramInfo;
    }
}

