/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fm.im.CycleTypeEnum;
import com.kingdee.eas.fm.im.DateComparator;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class IMUtil {
    private static final Logger logger = CoreUIObject.getLogger(IMUtil.class);
    public static final String RESOURCE_PATH = "com.kingdee.eas.fm.im.client.ImResource";

    public static Date getNextSettleDate(Date lastSettledDate, CycleTypeEnum cycleType, int settleDay) {
        Calendar calLastSettledDate = Calendar.getInstance();
        calLastSettledDate.setTime(lastSettledDate);
        int yearOfLastSettledDate = calLastSettledDate.get(1);
        int monthOfLastSettledDate = calLastSettledDate.get(2);
        Date nextSettledDate = null;
        Calendar calNextSettledDate = Calendar.getInstance();
        if (cycleType == CycleTypeEnum.YEAR) {
            calNextSettledDate.set(yearOfLastSettledDate, 11, settleDay);
            if (!DateTimeUtils.truncateDate((Date)lastSettledDate).before(DateTimeUtils.truncateDate((Date)calNextSettledDate.getTime()))) {
                calNextSettledDate.set(1, yearOfLastSettledDate + 1);
            }
            nextSettledDate = calNextSettledDate.getTime();
        } else if (cycleType == CycleTypeEnum.QUARTER) {
            List quarters = IMUtil.getQuartersList(yearOfLastSettledDate, settleDay);
            calLastSettledDate.set(11, 23);
            quarters.add(calLastSettledDate.getTime());
            Collections.sort(quarters, new DateComparator());
            int lastSettledDateIndex = quarters.indexOf(calLastSettledDate.getTime());
            if (lastSettledDateIndex < quarters.size() - 1) {
                nextSettledDate = (Date)quarters.get(lastSettledDateIndex + 1);
            } else {
                calNextSettledDate.set(yearOfLastSettledDate + 1, 2, settleDay);
                nextSettledDate = calNextSettledDate.getTime();
            }
        } else if (cycleType == CycleTypeEnum.MONTH) {
            calNextSettledDate.setTime(calLastSettledDate.getTime());
            calNextSettledDate.add(2, 1);
            if (calNextSettledDate.getActualMaximum(5) < settleDay) {
                calNextSettledDate.set(5, calNextSettledDate.getActualMaximum(5));
            } else {
                calNextSettledDate.set(5, settleDay);
            }
            nextSettledDate = calNextSettledDate.getTime();
        }
        return DateTimeUtils.truncateDate(nextSettledDate);
    }

    private static List getQuartersList(int yearOfLastSettledDate, int settleDay) {
        ArrayList<Date> quarters = new ArrayList<Date>();
        Calendar q1 = Calendar.getInstance();
        q1.set(yearOfLastSettledDate, 2, settleDay);
        Calendar q2 = Calendar.getInstance();
        q2.set(yearOfLastSettledDate, 5, settleDay);
        Calendar q3 = Calendar.getInstance();
        q3.set(yearOfLastSettledDate, 8, settleDay);
        Calendar q4 = Calendar.getInstance();
        q4.set(yearOfLastSettledDate, 11, settleDay);
        quarters.add(DateTimeUtils.truncateDate((Date)q1.getTime()));
        quarters.add(DateTimeUtils.truncateDate((Date)q2.getTime()));
        quarters.add(DateTimeUtils.truncateDate((Date)q3.getTime()));
        quarters.add(DateTimeUtils.truncateDate((Date)q4.getTime()));
        return quarters;
    }

    public static String getResString(String resName) {
        return EASResource.getString((String)RESOURCE_PATH, (String)resName);
    }

    public static void main(String[] args) {
        Calendar cal = Calendar.getInstance();
        cal.set(2006, 0, 20, 0, 0, 0);
        Date n = IMUtil.getNextSettleDate(cal.getTime(), CycleTypeEnum.MONTH, 31);
        logger.info((Object)n);
    }
}

