/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.im.client.AccrualBillBaseFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.HashSet;
import java.util.Set;

public class AccrualBillAcceptFilterParam
extends AccrualBillBaseFilterParam {
    private static final long serialVersionUID = 4489604572475177968L;
    boolean isSettleQuery = false;
    protected int type;
    private int acceptStatus;

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isSettleQuery() {
        return this.isSettleQuery;
    }

    public void setSettleQuery(boolean isSettleQuery) {
        this.isSettleQuery = isSettleQuery;
    }

    public int getAcceptStatus() {
        return this.acceptStatus;
    }

    public void setAcceptStatus(int acceptStatus) {
        this.acceptStatus = acceptStatus;
    }

    private boolean isClearHouseCompany() throws BOSException, EASBizException {
        CompanyOrgUnitInfo clhCompany = BankFactory.getRemoteInstance().getClearingHouse(null).getRelatedCompany();
        CompanyOrgUnitInfo curCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        return clhCompany != null && curCompany != null && curCompany.getId().equals((Object)clhCompany.getId());
    }

    public FilterItemInfo getCompanyFilterItem() {
        try {
            if (!this.isClearHouseCompany() && !FMHelper.isEmpty((Object[])this.companyIds)) {
                HashSet<String> list = new HashSet<String>(this.companyIds.length);
                for (int i = 0; i < this.companyIds.length; ++i) {
                    list.add(this.companyIds[i]);
                }
                return new FilterItemInfo("company.id", list, CompareType.INCLUDE);
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        return null;
    }

    @Override
    public FilterInfo getFilter() {
        FilterInfo filterInfold = null;
        filterInfold = this.isSettleQuery ? this.getSettleFilter() : super.getFilter();
        FilterInfo filterInfo = new FilterInfo();
        if (this.getAcceptStatus() == 1) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isAccepted", (Object)Boolean.TRUE));
        } else if (this.getAcceptStatus() == 2) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isAccepted", (Object)Boolean.FALSE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(3)));
        try {
            filterInfold.mergeFilter(filterInfo, "and");
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        return filterInfold;
    }

    private FilterInfo getSettleFilter() {
        FilterInfo filter = new FilterInfo();
        if (!FMHelper.isEmpty((Object[])this.getCompanyIds())) {
            Set companyIdSet = FMHelper.asSet((String[])this.getCompanyIds());
            filter.getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)companyIdSet, CompareType.INCLUDE));
        } else {
            CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            filter.getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)currentCompany.getId().toString()));
        }
        if (this.intObjectIds != null && this.intObjectIds.length > 0) {
            HashSet<String> intObjectIdSet = new HashSet<String>();
            for (int i = 0; i < this.intObjectIds.length; ++i) {
                String id = this.intObjectIds[i];
                intObjectIdSet.add(id);
            }
            filter.getFilterItems().add(new FilterItemInfo("intRateObject.id", intObjectIdSet, CompareType.INCLUDE));
        }
        if (this.beginDate != null) {
            filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)this.endDate, CompareType.LESS_EQUALS));
        }
        if (this.endDate != null) {
            filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)this.beginDate, CompareType.GREATER_EQUALS));
        }
        return filter;
    }
}

