/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.im.AccrualTypeEnum;
import com.kingdee.eas.fm.im.IIntObject;
import com.kingdee.eas.fm.im.IntObjectCollection;
import com.kingdee.eas.fm.im.IntObjectFactory;
import com.kingdee.eas.fm.im.client.AbstractAccrualBillAcceptFilterUI;
import com.kingdee.eas.fm.im.client.AccrualBillAcceptFilterParam;
import com.kingdee.eas.fm.im.client.AccrualBillBaseFilterParam;
import com.kingdee.eas.fm.im.client.IntObjectClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.enums.IntEnum;
import java.awt.event.ItemEvent;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class AccrualBillAcceptFilterUI
extends AbstractAccrualBillAcceptFilterUI {
    boolean isSettleQuery = false;

    public AccrualBillAcceptFilterUI() throws Exception {
    }

    public AccrualBillAcceptFilterUI(boolean isSettleQuery) throws Exception {
        this.isSettleQuery = isSettleQuery;
    }

    @Override
    public Object getParam() {
        AccrualBillAcceptFilterParam param = (AccrualBillAcceptFilterParam)super.getParam();
        param.setSettleQuery(this.isSettleQuery);
        if (this.btnHasAccepted.isSelected()) {
            param.setAcceptStatus(1);
        } else if (this.btnNotAccepted.isSelected()) {
            param.setAcceptStatus(2);
        } else {
            param.setAcceptStatus(3);
        }
        param.setType(((IntEnum)this.comboBizType.getSelectedItem()).getValue());
        return param;
    }

    @Override
    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        super.setParam(param);
        if (!(param instanceof AccrualBillAcceptFilterParam)) {
            return;
        }
        AccrualBillAcceptFilterParam filterParam = (AccrualBillAcceptFilterParam)param;
        if (filterParam.getType() == 999) {
            this.comboBizType.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        } else {
            this.comboBizType.setSelectedItem((Object)AccrualTypeEnum.getEnum(filterParam.getType()));
        }
        if (filterParam.getAcceptStatus() == 1) {
            this.btnHasAccepted.setSelected(true);
        } else if (filterParam.getAcceptStatus() == 2) {
            this.btnNotAccepted.setSelected(true);
        } else {
            this.btnAll.setSelected(true);
        }
    }

    public static IntObjectCollection getIntObjectCollection(String[] IntObjectIds) throws BOSException {
        if (FMHelper.isEmpty((Object[])IntObjectIds)) {
            return new IntObjectCollection();
        }
        Set set = FMHelper.asSet((String[])IntObjectIds);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.getSelector().add("name");
        ev.getSelector().add("number");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        ev.setFilter(filter);
        IntObjectCollection coll = null;
        IIntObject intObject = IntObjectFactory.getRemoteInstance();
        coll = intObject.getIntObjectCollection(ev);
        return coll;
    }

    @Override
    protected FilterInfo getIntObjectF7Filter() throws BOSException, EASBizException {
        FilterInfo filter = IntObjectClientHelper.getIntObjF7Filter(this.chkIncDisableIntObj.isSelected());
        filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(3)));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
        try {
            if (!this.isClearHouseCompany()) {
                FilterItemInfo companyFilterItem = this.getCompanyFilterItem();
                if (companyFilterItem == null) {
                    companyFilterItem = this.isSettleQuery ? new FilterItemInfo("applyUnit.id", (Object)this.currentCompany.getId().toString()) : new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString());
                }
                filter.getFilterItems().add(companyFilterItem);
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        return filter;
    }

    private boolean isClearHouseCompany() throws BOSException, EASBizException {
        String curr = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        CompanyOrgUnitInfo clhCompany = BankFactory.getRemoteInstance().getClearingHouse(curr).getRelatedCompany();
        CompanyOrgUnitInfo curCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        return clhCompany != null && curCompany != null && curCompany.getId().equals((Object)clhCompany.getId());
    }

    @Override
    protected void chkIncDisableIntObj_itemStateChanged(ItemEvent e) throws Exception {
        super.chkIncDisableIntObj_itemStateChanged(e);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = this.getIntObjectF7Filter();
        HashSet<Integer> states = new HashSet<Integer>();
        states.add(new Integer(2));
        if (e.getStateChange() == 1) {
            states.add(new Integer(3));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("state", states, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        this.prmtIntObject.setEntityViewInfo(view);
    }

    @Override
    protected AccrualBillBaseFilterParam getANewParamObject() {
        return new AccrualBillAcceptFilterParam();
    }

    @Override
    protected void init() throws Exception {
        super.init();
    }

    public FilterItemInfo getCompanyFilterItem() {
        try {
            if (!this.isClearHouseCompany() && !FMHelper.isEmpty((Object[])this.companyIds)) {
                HashSet<String> list = new HashSet<String>(this.companyIds.length);
                for (int i = 0; i < this.companyIds.length; ++i) {
                    list.add(this.companyIds[i]);
                }
                if (this.isSettleQuery) {
                    return new FilterItemInfo("applyUnit.id", list, CompareType.INCLUDE);
                }
                return new FilterItemInfo("company.id", list, CompareType.INCLUDE);
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        catch (BOSException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        return null;
    }

    @Override
    protected void setDefaultValue() {
        super.setDefaultValue();
        this.pkBeginDate.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.pkEndDate.setValue((Object)DateUtil.transformTimestamp((Date)new Date()));
        this.btnNotAccepted.setSelected(true);
    }

    protected Class getParamClass() {
        return AccrualBillAcceptFilterParam.class;
    }
}

