/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.erec.client.EReceiptInnerClientHelper;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.im.AccrualBillAcceptFacadeFactory;
import com.kingdee.eas.fm.im.AccrualBillFactory;
import com.kingdee.eas.fm.im.IMUtil;
import com.kingdee.eas.fm.im.client.AbstractAccrualBillAcceptListUI;
import com.kingdee.eas.fm.im.client.AccrualBillAcceptFilterUI;
import com.kingdee.eas.fm.im.client.AccrualBillBaseFilterUI;
import com.kingdee.eas.fm.im.client.AccrualBillEditUI;
import com.kingdee.eas.fm.im.client.AccrualBillHandler;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AccrualBillAcceptListUI
extends AbstractAccrualBillAcceptListUI {
    private static final Logger logger = CoreUIObject.getLogger(AccrualBillAcceptListUI.class);
    private AccrualBillBaseFilterUI filterUI;
    private static String resourcePath = "com.kingdee.eas.fm.im.client.ImResource";
    boolean isSettleQuery = false;

    @Override
    public void onLoad() throws Exception {
        String uiParam = (String)this.getUIContext().get("UIClassParam");
        super.onLoad();
        if (this.getUIContext().get("BOTPViewStatus") != null && (Integer)this.getUIContext().get("BOTPViewStatus") == 1) {
            this.isSettleQuery = true;
        } else {
            AccrualBillHandler.checkUIParamIsValid(uiParam);
        }
        if ("SETTLE_QUERY".equalsIgnoreCase(uiParam)) {
            this.isSettleQuery = true;
            this.actionAccept.setVisible(false);
            this.actionAccept.setEnabled(false);
            this.actionCancelAccept.setVisible(false);
            this.actionCancelAccept.setEnabled(false);
            this.actionVoucher.setVisible(false);
            this.actionVoucher.setEnabled(false);
            this.actionDelVoucher.setVisible(false);
            this.actionDelVoucher.setEnabled(false);
            this.actionRemove.setVisible(false);
            this.actionRemove.setEnabled(false);
        }
        if (!this.isSettleQuery) {
            this.checkIsClearingHouse();
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany())) {
            this.actionAccept.setEnabled(false);
            this.actionCancelAccept.setEnabled(false);
        }
        String curr = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        if (BankFactory.getRemoteInstance().getClearingHouse(curr) != null && !ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString().equals(FSClientHelper.getClearingHouseCompany().getId().toString())) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionVoucher.setEnabled(false);
            this.actionDelVoucher.setEnabled(false);
            this.actionAccept.setEnabled(false);
            this.actionCancelAccept.setEnabled(false);
            this.actionAddNew.setEnabled(false);
        }
        this.actionViewBdgBalance.setVisible(true);
        this.actionViewBdgBalance.setEnabled(true);
        this.tblMain.getColumn("auditDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("acceptDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("beginDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("endDate").getStyleAttributes().setNumberFormat(this.dformat);
    }

    protected void execQuery() {
        Map botpCtx;
        if (this.getBOTPViewStatus() == 1 && (botpCtx = (Map)this.getUIContext().get("BTPEDITPARAMETER")) != null) {
            String targetBillType = (String)botpCtx.get("TargetBillType");
            FilterInfo filter = new FilterInfo();
            if (targetBillType != null) {
                if (targetBillType.equals("ReceivingBill")) {
                    filter.getFilterItems().add(new FilterItemInfo("receivingbillId", null, CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString(), CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(3), CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("isAccepted", (Object)Boolean.TRUE, CompareType.EQUALS));
                }
                try {
                    this.mainQuery.getFilter().mergeFilter(filter, "and");
                }
                catch (BOSException e) {
                    this.handUIExceptionAndAbort((Exception)((Object)e));
                }
            }
        }
        super.execQuery();
    }

    private void checkIsClearingHouse() {
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        boolean isUsed = false;
        boolean isSettCompany = false;
        try {
            isUsed = FSClientHelper.clearingHouseIsUsed(null);
            isSettCompany = FSClientHelper.isClearingHouseCompanyId((String)companyInfo.getId().toString()) && isUsed;
        }
        catch (EASBizException e1) {
            this.handUIExceptionAndAbort((Exception)((Object)e1));
        }
        catch (BOSException e1) {
            this.handUIExceptionAndAbort((Exception)((Object)e1));
        }
        if (!isUsed || !isSettCompany) {
            String msg = null;
            msg = !isSettCompany ? EASResource.getString((String)resourcePath, (String)"CompanyNotSettleCenter") : EASResource.getString((String)resourcePath, (String)"SettleCenterFrozen");
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            logger.error((Object)"the company is not settle center, or the settle center is not enabled.");
            SysUtil.abort();
        }
    }

    @Override
    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new AccrualBillAcceptFilterUI(this.isSettleQuery);
        }
        return this.filterUI;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return AccrualBillFactory.getRemoteInstance();
    }

    @Override
    protected String getEditUIName() {
        return AccrualBillEditUI.class.getName();
    }

    protected boolean initDefaultFilter() {
        return false;
    }

    @Override
    public void actionAccept_actionPerformed(ActionEvent e) throws Exception {
        super.actionAccept_actionPerformed(e);
        this.checkIsClearingHouse();
        this.checkSelected();
        AccrualBillAcceptFacadeFactory.getRemoteInstance().accept(this.getSeletedIds());
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"BatchAcceptedSuccess"));
        this.refresh(e);
    }

    @Override
    public void actionCancelAccept_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkIsClearingHouse();
        super.actionCancelAccept_actionPerformed(e);
        if (this.getSeletedIds() == null || this.getSeletedIds().size() == 0) {
            return;
        }
        AccrualBillAcceptFacadeFactory.getRemoteInstance().cancelAccept(this.getSeletedIds());
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"BatchCancelAcceptedSuccess"));
        this.refresh(e);
    }

    private List getSeletedIds() {
        return this.getSelectedIdValues();
    }

    @Override
    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        boolean isInculdeBankAcctBill;
        this.checkIsClearingHouse();
        this.checkSelected();
        Set idSet = this.getSelectedIdSet();
        if (this.isIncludeInnerUnSettledBill(idSet)) {
            MsgBox.showWarning((Component)((Object)this), (String)IMUtil.getResString("InnerUnSettledBillNotGenVoucher"));
            this.abort();
        }
        if (isInculdeBankAcctBill = this.isIncludeBankAcctBill(idSet)) {
            MsgBox.showWarning((Component)((Object)this), (String)IMUtil.getResString("bankAcctSrcCanNotGenVoucher"));
            this.abort();
        }
        super.actionVoucher_actionPerformed(e);
    }

    private boolean isIncludeBankAcctBill(Set idSet) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        HashSet<Integer> sourceTypes = new HashSet<Integer>();
        sourceTypes.add(2);
        sourceTypes.add(5);
        filter.getFilterItems().add(new FilterItemInfo("intRateObject.sourceType", sourceTypes, CompareType.INCLUDE));
        boolean isInculdeBankAcctBill = AccrualBillFactory.getRemoteInstance().exists(filter);
        return isInculdeBankAcctBill;
    }

    private boolean isIncludeInnerUnSettledBill(Set idSet) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("intRateObject.sourceType", (Object)new Integer(3)));
        filter.getFilterItems().add(new FilterItemInfo("isSettled", (Object)new Boolean(false), CompareType.EQUALS));
        return AccrualBillFactory.getRemoteInstance().exists(filter);
    }

    private Set getSelectedIdSet() {
        HashSet<String> idSet = new HashSet<String>();
        ArrayList ids = this.getSelectedIdValues();
        for (String element : ids) {
            if (FMHelper.isEmpty((String)element)) continue;
            idSet.add(element);
        }
        return idSet;
    }

    @Override
    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkIsClearingHouse();
        this.checkSelected();
        Set idSet = this.getSelectedIdSet();
        boolean isInculdeBankAcctBill = this.isIncludeBankAcctBill(idSet);
        if (isInculdeBankAcctBill) {
            MsgBox.showWarning((Component)((Object)this), (String)IMUtil.getResString("bankAcctSrcCanNotDelVoucher"));
            this.abort();
        }
        super.actionDelVoucher_actionPerformed(e);
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAddNew.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_compute"));
        this.actionAccept.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_accept"));
        this.actionCancelAccept.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_cancelcase"));
        this.actionTraceUp.setVisible(false);
        this.actionNavInnerEreceipt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        FMClientHelper.clearSeparatorOnMenu((KDMenu)this.menuFile);
        FMClientHelper.clearSeparatorOnMenu((KDMenu)this.menuEdit);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"TYPE", (Object)"INNER");
    }

    @Override
    public void actionCopyTo_actionPerformed(ActionEvent e) throws Exception {
        this.checkIsClearingHouse();
        super.actionCopyTo_actionPerformed(e);
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkIsClearingHouse();
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        this.checkIsClearingHouse();
        super.actionImportData_actionPerformed(e);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkIsClearingHouse();
        super.actionRemove_actionPerformed(e);
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        this.checkIsClearingHouse();
        super.actionCreateTo_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkIsClearingHouse();
        super.actionAddNew_actionPerformed(e);
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        this.checkIsClearingHouse();
        super.actionTraceUp_actionPerformed(e);
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuEdit.remove((Component)this.kDSeparator3);
        this.menuEdit.remove((Component)this.kDSeparator4);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        IRow row = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
        if (row == null) {
            return;
        }
        if (row.getCell("acceptor.name").getValue() != null) {
            this.actionAccept.setEnabled(false);
        } else {
            this.actionAccept.setEnabled(true);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("fpItem.*"));
        sic.add(new SelectorItemInfo("fpItemOut.*"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("oppBgItemId"));
        sic.add(new SelectorItemInfo("oppBgItemName"));
        sic.add(new SelectorItemInfo("oppBgItemNumber"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("fundFlowItem.*"));
        return sic;
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        if (id != null) {
            FMClientHelper.viewBgBalance4ListUI((Component)((Object)this), (String)id);
        }
    }

    @Override
    public void actionNavInnerEreceipt_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        EReceiptInnerClientHelper.viewInnerEreceiptByBillIdList((List)idList, (Component)((Object)this));
    }

    public String getUITitle() {
        String uiParam = (String)this.getUIContext().get("UIClassParam");
        if (uiParam == null) {
            return EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"413_AccrualBillAcceptListUI");
        }
        return super.getUITitle();
    }
}

