/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.InnerAccountCollection;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.im.AccrualBillAddNewCondParam;
import com.kingdee.eas.fm.im.AccrualBillInfo;
import com.kingdee.eas.fm.im.AccrualTypeEnum;
import com.kingdee.eas.fm.im.IMUtil;
import com.kingdee.eas.fm.im.IntObjectException;
import com.kingdee.eas.fm.im.IntObjectInfo;
import com.kingdee.eas.fm.im.IntRateBaseCollection;
import com.kingdee.eas.fm.im.IntRateBaseFactory;
import com.kingdee.eas.fm.im.client.AbstractAccrualBillAddNewCondUI;
import com.kingdee.eas.fm.im.client.AccrualBillEditTypeEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;

public class AccrualBillAddNewCondUI
extends AbstractAccrualBillAddNewCondUI {
    public static final String resourcePath = "com.kingdee.eas.fm.im.client.ImResource";
    AccrualBillAddNewCondParam param;
    private AccrualTypeEnum accrualType;

    protected AccrualBillEditTypeEnum getEditBillType() {
        String billType = (String)this.getUIContext().get("TYPE");
        if (this.accrualType != null) {
            return AccrualBillEditTypeEnum.OUTCALC;
        }
        if (billType.equals("in")) {
            return AccrualBillEditTypeEnum.ININT;
        }
        if (billType.equals("out")) {
            return AccrualBillEditTypeEnum.OUTINT;
        }
        throw new IllegalArgumentException();
    }

    public void onLoad() throws Exception {
        this.accrualType = (AccrualTypeEnum)((Object)this.getUIContext().get("accrualType"));
        this.setBeginEndDateCtrlVisible(true);
        this.setExtendCtrlVisible(false);
        this.setOverDateVisible(false);
        this.setIntObjectFilterByType(AccrualTypeEnum.DEPOSIT);
        super.onLoad();
    }

    public static AccrualBillAddNewCondParam showDialogWindow(IUIObject ui, AccrualTypeEnum accrualType, String billType) throws UIException {
        UIContext uiContext = new UIContext(ui.getUIContext().get("Owner"));
        uiContext.put((Object)"accrualType", (Object)accrualType);
        uiContext.put((Object)"TYPE", (Object)billType);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AccrualBillAddNewCondUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        AccrualBillAddNewCondUI accrualBillAddNewCondUI = (AccrualBillAddNewCondUI)uiWindow.getUIObject();
        uiWindow.show();
        AccrualBillAddNewCondParam param = accrualBillAddNewCondUI.getParamValues();
        return param;
    }

    private AccrualBillAddNewCondParam getParamValues() {
        return this.param;
    }

    protected void comboType_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 1) {
            AccrualTypeEnum selectedType = (AccrualTypeEnum)((Object)e.getItem());
            if (selectedType == null) {
                return;
            }
            this.setUIProp(selectedType);
            this.setIntObjectFilterByType(selectedType);
        }
    }

    private void setUIProp(AccrualTypeEnum accrualType) {
        int type = accrualType.getValue();
        switch (type) {
            case 1: {
                this.setBeginEndDateCtrlVisible(true);
                this.setExtendCtrlVisible(false);
                this.setOverDateVisible(false);
                break;
            }
            case 3: {
                this.setBeginEndDateCtrlVisible(false);
                this.setExtendCtrlVisible(true);
            }
        }
    }

    private void setIntObjectFilterByType(AccrualTypeEnum selectedType) throws Exception {
        this.prmtIntObject.setData(null);
        this.prmtIntObject.setEntityViewInfo(new EntityViewInfo());
        FilterInfo filter1 = this.getBizTypeFilter(selectedType);
        FilterInfo filter2 = this.getSourceTypeFilter();
        filter1.mergeFilter(filter2, "AND");
        this.prmtIntObject.getEntityViewInfo().setFilter(filter1);
        this.prmtIntObject.setDisplayFormat("$name$");
        this.prmtIntObject.setHasCUDefaultFilter(false);
    }

    private FilterInfo getSourceTypeFilter() {
        String billType;
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        FilterInfo filter2 = new FilterInfo();
        if (currentCompany != null) {
            filter2.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentCompany.getId().toString()));
        }
        if ("OUTER".equalsIgnoreCase(billType = (String)this.getUIContext().get("TYPE"))) {
            filter2.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(3), CompareType.NOTEQUALS));
        } else if ("INNER".equalsIgnoreCase(billType)) {
            filter2.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(3)));
        } else {
            throw new IllegalArgumentException();
        }
        return filter2;
    }

    private FilterInfo getBizTypeFilter(AccrualTypeEnum accrualType) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(2)));
        return filter;
    }

    private void setBeginEndDateCtrlVisible(boolean visible) {
        this.contBeginDate.setVisible(visible);
        this.pkBeginDate.setVisible(visible);
        this.contEndDate.setVisible(visible);
        this.pkEndDate.setVisible(visible);
    }

    private void setExtendCtrlVisible(boolean visible) {
        this.contExtend.setVisible(visible);
        this.prmtExtend.setVisible(visible);
    }

    private void setOverDateVisible(boolean visible) {
        this.contOverDate.setVisible(visible);
        this.prmtOverDate.setVisible(visible);
    }

    @Override
    protected void prmtIntObject_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() != null) {
            IntObjectInfo intObj = (IntObjectInfo)e.getNewValue();
            AccrualTypeEnum selectedType = AccrualTypeEnum.DEPOSIT;
            if (selectedType == AccrualTypeEnum.DEPOSIT) {
                Date lastSettledDate = intObj.getLastSettledDate();
                Date effectiveDate = intObj.getEffectiveDate();
                Date defaultBeginDate = lastSettledDate;
                this.pkBeginDate.setMinimumDate(defaultBeginDate);
                this.pkBeginDate.setValue((Object)defaultBeginDate);
                if (intObj.getScheme() != null) {
                    this.pkEndDate.setValue((Object)intObj.getNextSettledDate());
                } else {
                    this.pkEndDate.setValue(null);
                }
            } else if (selectedType == AccrualTypeEnum.OVERDRAFT) {
                this.prmtExtend.setData(null);
                this.prmtExtend.setEntityViewInfo(new EntityViewInfo());
                this.prmtExtend.getEntityViewInfo().setFilter(new FilterInfo());
                this.prmtExtend.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("intRateObject.id", (Object)intObj.getId().toString()));
                this.prmtExtend.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(1)));
            }
        }
    }

    @Override
    protected void prmtExtend_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtExtend_dataChanged(e);
        this.prmtOverDate.setData(null);
    }

    public boolean verifyInput() {
        IntObjectInfo intObj;
        block20: {
            block19: {
                if (this.prmtIntObject.getData() == null) {
                    this.showMessage(EASResource.getString((String)resourcePath, (String)"intObjNotNull"));
                    return false;
                }
                if (!this.pkBeginDate.isVisible() || !this.pkEndDate.isVisible()) break block19;
                if (this.pkBeginDate.getValue() == null) {
                    this.showMessage(EASResource.getString((String)resourcePath, (String)"startDateNotNull"));
                    return false;
                }
                if (this.pkEndDate.getValue() == null) {
                    this.showMessage(EASResource.getString((String)resourcePath, (String)"endDateNotNull"));
                    return false;
                }
                if (!((Date)this.pkEndDate.getValue()).after((Date)this.pkBeginDate.getValue())) {
                    this.showMessage(EASResource.getString((String)resourcePath, (String)"endDateMustAfterBeforeDate"));
                    return false;
                }
                intObj = (IntObjectInfo)this.prmtIntObject.getData();
                String srcID = intObj.getSourceId();
                Date endDate = DateTimeUtils.truncateDate((Date)((Date)this.pkEndDate.getValue()));
                switch (intObj.getSourceType().getValue()) {
                    case 1: {
                        CompanyOrgUnitInfo curCompanyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
                        PeriodInfo glCurrentPeriod = null;
                        try {
                            glCurrentPeriod = FMClientHelper.getGLCurrentPeriod((Component)((Object)this), (CompanyOrgUnitInfo)curCompanyInfo);
                        }
                        catch (Exception e) {
                            this.handUIExceptionAndAbort(e);
                        }
                        if (!endDate.after(glCurrentPeriod.getEndDate())) break;
                        this.showMessage(EASResource.getString((String)resourcePath, (String)"endDateGreaterThanGLPeriod"));
                        return false;
                    }
                    case 2: 
                    case 5: {
                        AccountBankCollection accountBanks = null;
                        try {
                            accountBanks = AccountBankFactory.getRemoteInstance().getAccountBankCollection("select closeDate where id = '" + srcID + "' and isClosed = 1");
                        }
                        catch (BOSException e) {
                            this.handUIExceptionAndAbort((Exception)((Object)e));
                        }
                        if (accountBanks.size() <= 0 || accountBanks.get(0) == null) break;
                        Date closeDate = accountBanks.get(0).getCloseDate();
                        if ((closeDate = DateTimeUtils.addDay((Date)closeDate, (long)1L)) != null && endDate.after(closeDate)) {
                            this.showMessage(EASResource.getString((String)resourcePath, (String)"endDateGreaterThanBankAcctCloseDate"));
                            return false;
                        }
                        break block20;
                    }
                    case 3: {
                        InnerAccountCollection innerAccounts = null;
                        try {
                            innerAccounts = InnerAccountFactory.getRemoteInstance().getInnerAccountCollection("select closingDate where id = '" + srcID + "' and closed = 1");
                        }
                        catch (BOSException e) {
                            this.handUIExceptionAndAbort((Exception)((Object)e));
                        }
                        if (innerAccounts.size() <= 0 || innerAccounts.get(0) == null) break;
                        Date closeDate = innerAccounts.get(0).getClosingDate();
                        if ((closeDate = DateTimeUtils.addDay((Date)closeDate, (long)1L)) == null || !endDate.after(closeDate)) break;
                        this.showMessage(EASResource.getString((String)resourcePath, (String)"endDateGreaterThanInnerAcctCloseDate"));
                        return false;
                    }
                }
                break block20;
            }
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtExtend);
        }
        if (this.prmtOverDate.isVisible()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtOverDate);
        }
        intObj = (IntObjectInfo)this.prmtIntObject.getData();
        AccrualTypeEnum selectedType = AccrualTypeEnum.DEPOSIT;
        if (selectedType == AccrualTypeEnum.DEPOSIT) {
            Date lastSettledDate = intObj.getLastSettledDate();
            Date effectiveDate = intObj.getEffectiveDate();
            Date defaultBeginDate = lastSettledDate;
            if (!DateTimeUtils.truncateDate((Date)((Date)this.pkBeginDate.getValue())).equals(defaultBeginDate)) {
                int choice = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"notContinueInt"));
                return choice == 0;
            }
        }
        return true;
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.param = null;
        this.disposeUIWindow();
    }

    protected int getShowMessagePolicy() {
        return 3;
    }

    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        IntObjectInfo intObj;
        if (!this.verifyInput()) {
            return;
        }
        this.param = new AccrualBillAddNewCondParam();
        this.param.setIntObjectID(((IntObjectInfo)this.prmtIntObject.getData()).getId().toString());
        this.param.setBeginDate(DateTimeUtils.truncateDate((Date)((Date)this.pkBeginDate.getValue())));
        this.param.setEndDate(DateTimeUtils.truncateDate((Date)((Date)this.pkEndDate.getValue())));
        if (this.prmtExtend.getData() != null) {
            this.param.setRefAccrualBillID(((AccrualBillInfo)this.prmtExtend.getData()).getId().toString());
        }
        if (this.prmtOverDate.getData() != null && ((Object[])this.prmtOverDate.getData()).length > 0) {
            Object[] datas = (Object[])this.prmtOverDate.getData();
            int len = datas.length;
            ArrayList<String> ids = new ArrayList<String>();
            AccrualBillInfo info = null;
            for (int i = 0; i < len; ++i) {
                info = (AccrualBillInfo)datas[i];
                if (info == null) continue;
                ids.add(info.getId().toString());
            }
            this.param.setArrealAccrualBillIDs(ids);
        }
        if ((intObj = (IntObjectInfo)this.prmtIntObject.getData()).getType() != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("type", (Object)intObj.getType().getId()));
            filter.getFilterItems().add(new FilterItemInfo("billstate", (Object)"1"));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            IntRateBaseCollection coll = IntRateBaseFactory.getRemoteInstance().getIntRateBaseCollection(evi);
            if (coll.size() == 0) {
                throw new IntObjectException(IntObjectException.NOINTOBJECTNUM);
            }
        }
        this.disposeUIWindow();
    }

    public PeriodInfo getCurrentPeriod(Component comp, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (currentPeriod == null) {
            MsgBox.showWarning((Component)comp, (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CheckoutResource", (String)"MSG_periodError"));
            SysUtil.abort();
        }
        return currentPeriod;
    }

    @Override
    protected void prmtExtend_willShow(SelectorEvent e) throws Exception {
        super.prmtExtend_willShow(e);
        if (this.prmtIntObject.isVisible() && this.prmtIntObject.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)IMUtil.getResString("selectIntObjectFirst"));
            e.setCanceled(true);
        }
    }

    @Override
    protected void prmtOverDate_willShow(SelectorEvent e) throws Exception {
        super.prmtOverDate_willShow(e);
        if (this.prmtExtend.isVisible() && this.prmtExtend.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)IMUtil.getResString("selectExtendFirst"));
            e.setCanceled(true);
        }
    }
}

