/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.im.AccrualTypeEnum;
import com.kingdee.eas.fm.im.IntObjectCollection;
import com.kingdee.eas.fm.im.IntObjectFactory;
import com.kingdee.eas.fm.im.client.AbstractAccrualBillBaseFilterUI;
import com.kingdee.eas.fm.im.client.AccrualBillBaseFilterParam;
import com.kingdee.eas.fm.im.client.IntObjectClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ItemEvent;
import java.util.Date;
import java.util.HashSet;

public abstract class AccrualBillBaseFilterUI
extends AbstractAccrualBillBaseFilterUI {
    protected void init() throws Exception {
        super.init();
        this.comboBizType.removeAllItems();
        this.comboBizType.addItem((Object)AccrualTypeEnum.DEPOSIT);
        this.comboBizType.addItem((Object)AccrualTypeEnum.OVERDRAFT);
        this.comboBizType.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.setIntObjectF7FilterByOtherCtrl();
    }

    public Object getParam() {
        AccrualBillBaseFilterParam param = this.getANewParamObject();
        param.setCompanyIds(this.getCompanyIds());
        String[] intObjectIds = AccessHelper.getF7Ids((KDBizPromptBox)this.prmtIntObject);
        param.setIntObjectIds(intObjectIds);
        param.setIncludeDisable(this.chkIncDisableIntObj.isSelected());
        param.setBeginDate(DateTimeUtils.truncateDate((Date)((Date)this.pkBeginDate.getValue())));
        param.setEndDate(DateTimeUtils.truncateDate((Date)((Date)this.pkEndDate.getValue())));
        return param;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        AccrualBillBaseFilterParam para = (AccrualBillBaseFilterParam)param;
        this.setCompanyIds(para.getCompanyIds());
        String[] intObjectIDs = para.getIntObjectIds();
        HashSet<String> ids = new HashSet<String>();
        if (intObjectIDs != null && intObjectIDs.length > 0) {
            for (int i = 0; i < intObjectIDs.length; ++i) {
                ids.add(intObjectIDs[i]);
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            view.setFilter(filter);
            try {
                IntObjectCollection coll = IntObjectFactory.getRemoteInstance().getIntObjectCollection(view);
                this.prmtIntObject.setData((Object)coll.toArray());
            }
            catch (Exception e) {
                SysUtil.abort((Throwable)e);
            }
        } else {
            this.prmtIntObject.setData(null);
        }
        this.chkIncDisableIntObj.setSelected(para.isIncludeDisable());
        this.pkBeginDate.setValue((Object)para.getBeginDate());
        this.pkEndDate.setValue((Object)para.getEndDate());
    }

    @Override
    protected void chkIncDisableIntObj_itemStateChanged(ItemEvent e) throws Exception {
        super.chkIncDisableIntObj_itemStateChanged(e);
        this.setIntObjectF7FilterByOtherCtrl();
    }

    protected void setIntObjectF7FilterByOtherCtrl() throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = this.getIntObjectF7Filter();
        view.setFilter(filter);
        this.prmtIntObject.setEntityViewInfo(view);
        this.prmtIntObject.setHasCUDefaultFilter(false);
    }

    protected FilterInfo getIntObjectF7Filter() throws BOSException, EASBizException {
        FilterInfo filter = IntObjectClientHelper.getIntObjF7Filter(this.chkIncDisableIntObj.isSelected());
        FilterItemInfo companyFilterItem = this.getCompanyFilterItem();
        if (companyFilterItem == null) {
            companyFilterItem = new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString());
        }
        filter.getFilterItems().add(companyFilterItem);
        return filter;
    }

    protected AccrualBillBaseFilterParam getANewParamObject() {
        return null;
    }

    protected void companyValueChange(Object object) throws Exception {
        super.companyValueChange(object);
        this.setIntObjectF7FilterByOtherCtrl();
    }

    @Override
    protected void comboBizType_itemStateChanged(ItemEvent e) throws Exception {
        super.comboBizType_itemStateChanged(e);
        this.setIntObjectF7FilterByOtherCtrl();
    }

    public boolean verify() {
        FMClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, (Date)((Date)this.pkBeginDate.getValue()), (Date)((Date)this.pkEndDate.getValue()));
        return super.verify();
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.prmtIntObject.setData(null);
        this.chkIncDisableIntObj.setSelected(false);
        Date date = new Date();
        this.pkBeginDate.setValue((Object)date);
        this.pkEndDate.setValue((Object)date);
    }
}

