/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.ProgressDialog;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.im.AccrualBillAcceptFacadeFactory;
import com.kingdee.eas.fm.im.AccrualBillFactory;
import com.kingdee.eas.fm.im.AccrualBillInfo;
import com.kingdee.eas.fm.im.IAccrualBill;
import com.kingdee.eas.fm.im.IMUtil;
import com.kingdee.eas.fm.im.client.AbstractAccrualBillCalculateListUI;
import com.kingdee.eas.fm.im.client.AccrualBillHandler;
import com.kingdee.eas.fm.im.client.BatchCalDateChooserUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class AccrualBillCalculateListUI
extends AbstractAccrualBillCalculateListUI {
    private static final Logger logger = CoreUIObject.getLogger(AccrualBillCalculateListUI.class);
    String billType = null;
    private ProgressDialog progressDialog;
    private Set ids = null;
    private static String resourcePath = "com.kingdee.eas.fm.im.client.ImResource";

    @Override
    public void onLoad() throws Exception {
        Set ids;
        PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)this.getOrgPK((ItemAction)this.actionOnLoad), (String)"im_accrualBill_04batchBill");
        super.checkLicense();
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
        this.billType = (String)this.getUIContext().get("UIClassParam");
        AccrualBillHandler.checkUIParamIsValid(this.billType);
        if (this.billType.equalsIgnoreCase("INNER")) {
            AccrualBillHandler.checkIsCH();
        }
        if ((ids = this.calculate(this.billType)) != null && ids.size() > 0) {
            RealModeIDList idList = new RealModeIDList();
            for (String id : ids) {
                idList.add(id);
            }
            this.getUIContext().put("IDList", idList);
        } else {
            this.abort();
        }
        super.onLoad();
        this.accept.setVisible(this.billType.equalsIgnoreCase("INNER"));
        this.cancelAccept.setVisible(this.billType.equalsIgnoreCase("INNER"));
        this.tblMain.checkParsed();
        if (this.billType.equalsIgnoreCase("INNER")) {
            this.tblMain.getColumn("auditor.name").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("auditDate").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("cashier").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("settleDate").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("acceptor").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("acceptDate").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("auditor.name").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("auditDate").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("cashier").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("settleDate").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("acceptor").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("acceptDate").getStyleAttributes().setHided(true);
        }
        this.tblMain.checkParsed();
        this.actionViewBdgBalance.setVisible(true);
        this.actionViewBdgBalance.setEnabled(true);
        this.actionCreateTo.setVisible(false);
        this.actionCopyTo.setVisible(false);
        this.tblMain.getColumn("auditDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("settleDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("acceptDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("beginDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("endDate").getStyleAttributes().setNumberFormat(this.dformat);
    }

    public String getUITitle() {
        String title = super.getUITitle();
        return AccrualBillHandler.getTitle(this.billType, title);
    }

    private Set calculate(String billType) throws BOSException, EASBizException {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        boolean val = ContextHelperFactory.getRemoteInstance().getBooleanParam("INT001", (IObjectPK)new ObjectUuidPK(currentCompany.getId()));
        Set ids = BatchCalDateChooserUI.getCreateArrcualID((CoreUI)this, billType, val);
        return ids;
    }

    @Override
    public FMFilterBaseUI getFilterUI() throws Exception {
        return null;
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
    }

    public Object getTablePreferenceSchemaKey() {
        if (this.billType != null) {
            return "_" + this.billType;
        }
        return null;
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"TYPE", (Object)this.billType);
    }

    @Override
    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkIsClearingHouse();
        this.checkSelected();
        Set idSet = this.getSelectedIdSet();
        if (this.isIncludeInnerUnSettledBill(idSet)) {
            MsgBox.showWarning((Component)((Object)this), (String)IMUtil.getResString("InnerUnSettledBillNotGenVoucher"));
            this.abort();
        }
        super.actionVoucher_actionPerformed(e);
    }

    private void checkIsClearingHouse() {
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        boolean isUsed = false;
        boolean isSettCompany = false;
        try {
            isUsed = FSClientHelper.clearingHouseIsUsed(null);
            isSettCompany = FSClientHelper.isClearingHouseCompanyId((String)companyInfo.getId().toString()) && FSClientHelper.clearingHouseIsUsed(null);
        }
        catch (EASBizException e1) {
            this.handUIExceptionAndAbort((Exception)((Object)e1));
        }
        catch (BOSException e1) {
            this.handUIExceptionAndAbort((Exception)((Object)e1));
        }
        if (!isUsed || !isSettCompany) {
            String msg = null;
            msg = !isSettCompany ? EASResource.getString((String)resourcePath, (String)"CompanyNotSettleCenter") : EASResource.getString((String)resourcePath, (String)"SettleCenterFrozen");
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            logger.error((Object)"the company is not settle center, or the settle center is not enabled.");
            SysUtil.abort();
        }
    }

    private Set getSelectedIdSet() {
        HashSet<String> idSet = new HashSet<String>();
        ArrayList ids = this.getSelectedIdValues();
        for (String element : ids) {
            if (FMHelper.isEmpty((String)element)) continue;
            idSet.add(element);
        }
        return idSet;
    }

    private boolean isIncludeInnerUnSettledBill(Set idSet) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("intRateObject.sourceType", (Object)new Integer(3)));
        filter.getFilterItems().add(new FilterItemInfo("isSettled", (Object)new Boolean(false), CompareType.EQUALS));
        return AccrualBillFactory.getRemoteInstance().exists(filter);
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.accept.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_accept"));
        this.cancelAccept.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_cancelcase"));
    }

    @Override
    public void accept_actionPerformed(ActionEvent e) throws Exception {
        this.checkIsClearingHouse();
        this.checkSelected();
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        int topRowIndex = block.getTop();
        int bottomRowIndex = block.getBottom();
        AccrualBillAcceptFacadeFactory.getRemoteInstance().accept(this.getSeletedIds());
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"BatchAcceptedSuccess"));
        this.refresh(e);
    }

    private List getSeletedIds() {
        return this.getSelectedIdValues();
    }

    @Override
    public void cancelAccept_actionPerformed(ActionEvent e) throws Exception {
        this.checkIsClearingHouse();
        if (this.getSeletedIds() == null || this.getSeletedIds().size() == 0) {
            return;
        }
        AccrualBillAcceptFacadeFactory.getRemoteInstance().cancelAccept(this.getSeletedIds());
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"BatchCancelAcceptedSuccess"));
        this.refresh(e);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("fpItem.*"));
        sic.add(new SelectorItemInfo("fpItemOut.*"));
        return sic;
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        AccrualBillInfo info = ((IAccrualBill)this.getBizInterface()).getAccrualBillInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
        FMClientHelper.viewBgBalance((Component)((Object)this), (IObjectValue)info);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = null;
        if (this.ids == null || this.ids.size() == 0) {
            filter = super.getDefaultFilterForQuery();
        } else {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.ids, CompareType.INCLUDE));
        }
        return filter;
    }

    protected boolean isDirectShow() {
        return true;
    }
}

