/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.exception.AlreadyBindProcessInstanceException;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.common.NumberValueVerifyRule;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.im.AccrualBillAcceptFacadeFactory;
import com.kingdee.eas.fm.im.AccrualBillAddNewCondParam;
import com.kingdee.eas.fm.im.AccrualBillCollection;
import com.kingdee.eas.fm.im.AccrualBillEntryCollection;
import com.kingdee.eas.fm.im.AccrualBillEntryInfo;
import com.kingdee.eas.fm.im.AccrualBillFactory;
import com.kingdee.eas.fm.im.AccrualBillInfo;
import com.kingdee.eas.fm.im.AccrualTypeEnum;
import com.kingdee.eas.fm.im.IMUtil;
import com.kingdee.eas.fm.im.IntObjectFactory;
import com.kingdee.eas.fm.im.IntObjectInfo;
import com.kingdee.eas.fm.im.IntObjectSourceTypeEnum;
import com.kingdee.eas.fm.im.client.AbstractAccrualBillEditUI;
import com.kingdee.eas.fm.im.client.AccrualBillAddNewCondUI;
import com.kingdee.eas.fm.im.client.AccrualBillHandler;
import com.kingdee.eas.fm.im.client.AccrualBillTDQueryDelegate;
import com.kingdee.eas.fm.im.util.IntCalHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class AccrualBillEditUI
extends AbstractAccrualBillEditUI {
    private static final String COL_KEY_ACCUAMT = "accuAmt";
    private static final String COL_KEY_DAYS = "days";
    private static final String COL_KEY_YEARRATE = "yearRate";
    private static final String COL_KEY_ACCRUALAMT = "accrualAmt";
    private static final String COL_KEY_TAXRATE = "taxRate";
    private static final String COL_KEY_TAXAMT = "taxAmt";
    private static final String COL_KEY_NETAMT = "netAmt";
    private static final String COL_KEY_ISPROMISSSORY = "isPromisssory";
    private static final String COL_KEY_ENDDATE = "endDate";
    private BigDecimal entryMaxValueAccrual = new BigDecimal("10000000000000").subtract(new BigDecimal("0.01"));
    private BigDecimal entryMaxValue = Constants.MAX_TOTAL_VALUE.multiply(Constants.TEN_THOUSAND).subtract(new BigDecimal("0.01"));
    AccrualTypeEnum accrualType = null;
    String billType = null;

    public void onLoad() throws Exception {
        CompanyOrgUnitInfo companyInfo = ClientUtils.getCurrLoginCompany();
        if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.EDIT)) {
            ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)companyInfo);
        }
        String uiParam = (String)this.getUIContext().get("UIClassParam");
        this.accrualType = AccrualBillHandler.getAccrualType(uiParam);
        if (!FMHelper.isEmpty((String)uiParam)) {
            AccrualBillHandler.checkUIParamIsValid(uiParam);
            this.billType = AccrualBillHandler.getBillType(uiParam);
        } else {
            this.billType = (String)this.getUIContext().get("TYPE");
        }
        if (!this.getOprtState().equalsIgnoreCase("FINDVIEW")) {
            AccrualBillHandler.checkUIParamIsValid(this.billType);
            if (this.billType.equalsIgnoreCase("INNER") && !this.getOprtState().equals(OprtState.VIEW)) {
                AccrualBillHandler.checkIsCH();
            }
        }
        FMClientHelper.initComboCurrency((KDComboBox)this.comboCurrency);
        BigDecimal MAXVALUE = this.entryMaxValue;
        this.txtaccuAmt.setMaximumValue((Comparable)MAXVALUE);
        this.txtaccrualAmt.setMaximumValue((Comparable)this.entryMaxValueAccrual);
        this.txttaxAmt.setMaximumValue((Comparable)MAXVALUE);
        this.txtnetAmt.setMaximumValue((Comparable)this.entryMaxValueAccrual);
        this.txtbalanceAmt.setMaximumValue((Comparable)MAXVALUE);
        this.txtNetLocalAmt.setMaximumValue((Comparable)this.entryMaxValueAccrual);
        super.onLoad();
        if (this.billType == null) {
            this.billType = IntObjectSourceTypeEnum.INNERACCT.equals((Object)this.editData.getSourceType()) ? "INNER" : "OUTER";
        }
        if (this.editData != null) {
            BOSUuid currencyUuid = this.editData.getCurrency().getId();
            int prec = FMClientHelper.getPrecOfCurrency((BOSUuid)currencyUuid);
            this.setMaxValueForCtrl(prec);
            this.setNumberFormat(prec);
        }
        FMClientHelper.updateUITitle((CoreUIObject)this, (String)this.resHelper.getString("this.title"));
        FMClientHelper.clearSeparatorOnToolBar((KDToolBar)this.toolBar);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.actionViewBgBalance.setVisible(true);
        this.actionViewBgBalance.setEnabled(true);
        KDTableHelper.updateEnterWithTab((KDTable)this.tblEntries, (boolean)false);
        KDTableHelper.downArrowAutoAddRow((KDTable)this.tblEntries, (boolean)false, null);
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)this.prmtProject);
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtOppBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.input, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
        if (this.billType.equalsIgnoreCase("INNER")) {
            FMClientHelper.initFundFlowItemF7((IUIObject)this, (KDLabelContainer)this.contOppBgItem, (KDLabelContainer)this.contFundFlowItem, (FundFlowDirection)FundFlowDirection.OUT);
        } else {
            FMClientHelper.initFundFlowItemF7((IUIObject)this, (KDLabelContainer)this.contOppBgItem, (KDLabelContainer)this.contFundFlowItem, (FundFlowDirection)FundFlowDirection.IN);
        }
        String dformat = FMHelper.getDateFormatString();
        this.tblEntries.getColumn("beginDate").getStyleAttributes().setNumberFormat(dformat);
        this.tblEntries.getColumn(COL_KEY_ENDDATE).getStyleAttributes().setNumberFormat(dformat);
    }

    public String getUITitle() {
        String title = super.getUITitle();
        return AccrualBillHandler.getTitle(this.billType, title);
    }

    @Override
    public void loadFields() {
        AccrualBillEntryCollection entries = this.editData.getEntries();
        DecimalFormat df = new DecimalFormat("###0.##########");
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            AccrualBillEntryInfo element = (AccrualBillEntryInfo)iter.next();
            element.setAccuAmt(new BigDecimal(df.format(element.getAccuAmt())));
            element.setYearRate(new BigDecimal(df.format(element.getYearRate())));
            element.setTaxRate(new BigDecimal(df.format(element.getTaxRate())));
            element.setFeeAmt(new BigDecimal(df.format(element.getFeeAmt())));
        }
        this.txtaccuAmt.setMaximumValue((Comparable)this.entryMaxValue);
        super.loadFields();
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtOutBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtOppBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[1]);
        BOSUuid currencyUuid = this.editData.getCurrency().getId();
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString());
        int prec = FMClientHelper.getPrecOfCurrency((BOSUuid)currencyUuid);
        this.setMaxValueForCtrl(prec);
        this.setNumberFormat(prec);
        this.txtPeriod.setText(FMHelper.getDateFormat().format(this.editData.getBeginDate()) + "~" + FMHelper.getDateFormat().format(this.editData.getEndDate()));
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
        AccrualBillAddNewCondParam param = new AccrualBillAddNewCondParam();
        param.setType(this.editData.getIntRateObject().getSourceType().getValue());
        param.setIntObjectID(this.editData.getIntRateObject().getId().toString());
        this.setCtrlVisible(param);
        this.txtExhRate.setValue((Object)this.editData.getExhRate());
        this.txtNetLocalAmt.setValue((Object)this.editData.getNetLocalAmt());
    }

    @Override
    protected String getEditUIName() {
        return AccrualBillEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return AccrualBillFactory.getRemoteInstance();
    }

    @Override
    protected KDTable getDetailTable() {
        return this.tblEntries;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return new AccrualBillEntryInfo();
    }

    @Override
    protected IObjectValue createNewData() {
        AccrualBillAddNewCondParam newCond = null;
        try {
            newCond = AccrualBillAddNewCondUI.showDialogWindow((IUIObject)this, this.accrualType, this.billType);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (newCond == null) {
            this.abort();
        }
        this.setCtrlVisible(newCond);
        AccrualBillInfo info = null;
        try {
            info = IntObjectFactory.getRemoteInstance().genAccrualBill(newCond);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (info == null) {
            MsgBox.showWarning((Component)((Object)this), (String)IMUtil.getResString("accrualAmtAndNetAmtNotZero"));
            SysUtil.abort();
        }
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        return info;
    }

    private void setCtrlVisible(AccrualBillAddNewCondParam newCond) {
        if (newCond.getType() == 3) {
            this.getDetailTable().getColumn(COL_KEY_TAXRATE).getStyleAttributes().setHided(true);
            this.getDetailTable().getColumn(COL_KEY_TAXAMT).getStyleAttributes().setHided(true);
        } else {
            this.getDetailTable().getColumn(COL_KEY_TAXRATE).getStyleAttributes().setHided(false);
            this.getDetailTable().getColumn(COL_KEY_TAXAMT).getStyleAttributes().setHided(false);
        }
        this.setArrearVisible(false);
    }

    private void setArrearVisible(boolean visible) {
        this.contaccuAmt.setVisible(!visible);
        this.txtaccuAmt.setVisible(!visible);
        this.tblEntries.getColumn(COL_KEY_ACCUAMT).getStyleAttributes().setHided(visible);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        int cycleType;
        String intobjectid = this.editData.getIntRateObject().getId().toString();
        BigDecimal balance = AccrualBillAcceptFacadeFactory.getRemoteInstance().getbalance(intobjectid);
        this.editData.setAccountBalance(balance);
        this.verify(e);
        if (this.editData.getIntRateObject().getScheme() != null && (cycleType = this.editData.getIntRateObject().getScheme().getCycleType().getValue()) == 100) {
            MsgBox.showWarning((Component)((Object)this), (String)(this.editData.getIntRateObject().getNumber() + EASResource.getString((String)"com.kingdee.eas.fm.im.IMAutoGenerateResource", (String)"21_AccrualBillEditUI")));
            SysUtil.abort();
        }
        this.doBeforeSubmitForWF((CoreBaseInfo)this.editData);
        IObjectPK pk = null;
        try {
            pk = this.runSubmit();
        }
        catch (AlreadyBindProcessInstanceException wfExceptoin) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_BindWfInstance"));
            return;
        }
        this.editData.setId(BOSUuid.read((String)pk.toString()));
        CacheServiceFactory.getInstance().discardType(this.editData.getBOSType());
        this.showMessageForStatus();
        this.showSubmitSuccess();
        this.setDataObject(this.getValue(pk));
        if (this.wfContext.isBindWorkFlow()) {
            this.wfContext.addToDataMap((Object)pk.toString(), (Object)pk.toString());
        }
        this.actionSubmit.setEnabled(false);
        this.loadFields();
        this.setSave(true);
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("intRateObject.name"));
        sic.add(new SelectorItemInfo("intRateObject.sourceType"));
        sic.add(new SelectorItemInfo("intRateObject.sourceId"));
        sic.add(new SelectorItemInfo("interruptedDays"));
        sic.add(new SelectorItemInfo(COL_KEY_ACCUAMT));
        sic.add(new SelectorItemInfo(COL_KEY_ACCRUALAMT));
        sic.add(new SelectorItemInfo("accountbalance"));
        sic.add(new SelectorItemInfo("feeAmt"));
        sic.add(new SelectorItemInfo(COL_KEY_TAXAMT));
        sic.add(new SelectorItemInfo(COL_KEY_NETAMT));
        sic.add(new SelectorItemInfo("balanceAmt"));
        sic.add(new SelectorItemInfo("intRateObject.loanRate.matureDate"));
        sic.add(new SelectorItemInfo("intRateObject.type.rateExpression"));
        sic.add(new SelectorItemInfo("intRateObject.calculateType"));
        sic.add(new SelectorItemInfo(COL_KEY_DAYS));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.beginDate"));
        sic.add(new SelectorItemInfo("entries.endDate"));
        sic.add(new SelectorItemInfo("entries.days"));
        sic.add(new SelectorItemInfo("entries.accuAmt"));
        sic.add(new SelectorItemInfo("entries.yearRate"));
        sic.add(new SelectorItemInfo("entries.accrualAmt"));
        sic.add(new SelectorItemInfo("entries.feeRate"));
        sic.add(new SelectorItemInfo("entries.feeAmt"));
        sic.add(new SelectorItemInfo("entries.feeRate"));
        sic.add(new SelectorItemInfo("entries.feeAmt"));
        sic.add(new SelectorItemInfo("entries.netAmt"));
        sic.add(new SelectorItemInfo("entries.isPromisssory"));
        sic.add(new SelectorItemInfo("entries.isOverDraft"));
        sic.add(new SelectorItemInfo("entries.arrearAmt"));
        sic.add(new SelectorItemInfo("arrearAmt"));
        sic.add(new SelectorItemInfo("intRateObject.bizType"));
        sic.add(new SelectorItemInfo("type"));
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("beginDate"));
        sic.add(new SelectorItemInfo(COL_KEY_ENDDATE));
        sic.add(new SelectorItemInfo("auditDate"));
        sic.add(new SelectorItemInfo("isSettled"));
        sic.add(new SelectorItemInfo("isAccepted"));
        sic.add(new SelectorItemInfo("fiVouchered"));
        sic.add(new SelectorItemInfo("maturityDate"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("oppBgItemName"));
        sic.add(new SelectorItemInfo("oppBgItemNumber"));
        sic.add(new SelectorItemInfo("oppBgItemId"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add("fundFlowItem.*");
        return sic;
    }

    @Override
    protected void tblEntries_editStopped(KDTEditEvent e) throws Exception {
        super.tblEntries_editStopped(e);
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        IntObjectInfo intObj = IntObjectFactory.getRemoteInstance().getIntObjectInfo("select id, type.factorDay where id = '" + this.editData.getIntRateObject().getId().toString() + "'");
        BigDecimal factor = new BigDecimal(String.valueOf(intObj.getType().getFactorDay()));
        int prec = FMClientHelper.getPrecOfCurrency((BOSUuid)this.editData.getCurrency().getId());
        BigDecimal cons = null;
        cons = IntRateTypeExpressionEnum.YEAR == this.editData.getIntRateObject().getType().getRateExpression() ? FMConstants.ONE_HUNDRED : FMConstants.ONE_THOUSAND;
        if (colIndex == this.tblEntries.getColumn(COL_KEY_ACCUAMT).getColumnIndex()) {
            this.reCalAccrual(rowIndex, factor, prec, cons);
            this.reCalTax(rowIndex, prec, cons);
            this.reCalNetAmt(rowIndex);
            this.reSumAccuAmt();
        }
        if (colIndex == this.tblEntries.getColumn(COL_KEY_YEARRATE).getColumnIndex()) {
            this.reCalAccrual(rowIndex, factor, prec, cons);
            this.reCalTax(rowIndex, prec, cons);
            this.reCalNetAmt(rowIndex);
        }
        if (colIndex == this.tblEntries.getColumn(COL_KEY_TAXRATE).getColumnIndex()) {
            this.reCalTax(rowIndex, prec, cons);
            this.reCalNetAmt(rowIndex);
        }
        if (colIndex == this.tblEntries.getColumn(COL_KEY_ACCRUALAMT).getColumnIndex() || colIndex == this.tblEntries.getColumn(COL_KEY_TAXAMT).getColumnIndex()) {
            this.reCalNetAmt(rowIndex);
            this.reSumAccrualAmt();
            this.reSumTaxAmt();
        }
    }

    private void reCalAccrual(int rowIndex, BigDecimal factor, int prec, BigDecimal cons) {
        IRow row = this.tblEntries.getRow(rowIndex);
        BigDecimal accuAmt = (BigDecimal)row.getCell(COL_KEY_ACCUAMT).getValue();
        BigDecimal ar = (BigDecimal)row.getCell(COL_KEY_YEARRATE).getValue();
        if (accuAmt == null || ar == null) {
            return;
        }
        BigDecimal accrualAmt = accuAmt.multiply(ar).divide(cons.multiply(factor), prec, 4);
        row.getCell(COL_KEY_ACCRUALAMT).setValue((Object)accrualAmt);
        if (accrualAmt.compareTo(this.entryMaxValue) > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)IMUtil.getResString("accrualTooBig"));
            SysUtil.abort();
        }
        this.reSumAccrualAmt();
    }

    private void reCalTax(int rowIndex, int prec, BigDecimal cons) {
        IRow row = this.tblEntries.getRow(rowIndex);
        BigDecimal accuAmt = (BigDecimal)row.getCell(COL_KEY_ACCRUALAMT).getValue();
        BigDecimal taxRate = (BigDecimal)row.getCell(COL_KEY_TAXRATE).getValue();
        if (accuAmt == null || taxRate == null) {
            return;
        }
        BigDecimal taxAmt = accuAmt.multiply(taxRate).divide(cons, prec, 4);
        if (taxAmt.compareTo(this.entryMaxValue) > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)IMUtil.getResString("taxAmtTooBig"));
            SysUtil.abort();
        }
        row.getCell(COL_KEY_TAXAMT).setValue((Object)taxAmt);
        this.reSumTaxAmt();
    }

    private void reCalNetAmt(int rowIndex) {
        IRow row = this.tblEntries.getRow(rowIndex);
        BigDecimal accrualAmt = (BigDecimal)row.getCell(COL_KEY_ACCRUALAMT).getValue();
        BigDecimal taxAmt = (BigDecimal)row.getCell(COL_KEY_TAXAMT).getValue();
        if (accrualAmt == null || taxAmt == null) {
            return;
        }
        BigDecimal netAmt = accrualAmt.subtract(taxAmt);
        row.getCell(COL_KEY_NETAMT).setValue((Object)netAmt);
        this.reSumNetAmt();
    }

    private void reSumAccuAmt() {
        int rowCount = this.tblEntries.getRowCount();
        BigDecimal accuAmtTotal = Constants.ZERO;
        BigDecimal overAccuAmtTotal = Constants.ZERO;
        BigDecimal accuAmt = null;
        AccrualTypeEnum type = null;
        for (int i = 0; i < rowCount; ++i) {
            accuAmt = (BigDecimal)this.tblEntries.getCell(i, COL_KEY_ACCUAMT).getValue();
            if (accuAmt == null) continue;
            type = (AccrualTypeEnum)((Object)this.tblEntries.getCell(i, "type").getValue());
            if (AccrualTypeEnum.DEPOSIT == type) {
                accuAmtTotal = accuAmtTotal.add(accuAmt);
            }
            if (AccrualTypeEnum.OVERDRAFT != type) continue;
            overAccuAmtTotal = overAccuAmtTotal.add(accuAmt);
        }
        if (accuAmtTotal.compareTo(this.entryMaxValue) > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)IMUtil.getResString("accuTotalTooBig"));
        }
        if (overAccuAmtTotal.compareTo(this.entryMaxValue) > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)IMUtil.getResString("accuTotalTooBig"));
        }
        this.txtaccuAmt.setValue((Object)accuAmtTotal);
        this.txtoverDraftAccuAm.setValue((Object)overAccuAmtTotal);
    }

    private void reSumAccrualAmt() {
        int rowCount = this.tblEntries.getRowCount();
        BigDecimal accrualAmtTotal = Constants.ZERO;
        BigDecimal overAccrualAmtTotal = Constants.ZERO;
        BigDecimal accrualAmt = null;
        AccrualTypeEnum type = null;
        for (int i = 0; i < rowCount; ++i) {
            accrualAmt = (BigDecimal)this.tblEntries.getCell(i, COL_KEY_ACCRUALAMT).getValue();
            if (accrualAmt == null) continue;
            type = (AccrualTypeEnum)((Object)this.tblEntries.getCell(i, "type").getValue());
            if (AccrualTypeEnum.DEPOSIT == type) {
                accrualAmtTotal = accrualAmtTotal.add(accrualAmt);
            }
            if (AccrualTypeEnum.OVERDRAFT != type) continue;
            overAccrualAmtTotal = overAccrualAmtTotal.add(accrualAmt);
        }
        if (accrualAmtTotal.compareTo(this.entryMaxValueAccrual) > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)IMUtil.getResString("accrualTotalTooBig"));
        }
        if (overAccrualAmtTotal.compareTo(this.entryMaxValueAccrual) > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)IMUtil.getResString("accrualTotalTooBig"));
        }
        this.txtaccrualAmt.setValue((Object)accrualAmtTotal);
        this.txtoverDraftAccrua.setValue((Object)overAccrualAmtTotal);
    }

    private void reSumTaxAmt() {
        int rowCount = this.tblEntries.getRowCount();
        BigDecimal taxAmtTotal = Constants.ZERO;
        BigDecimal taxAmt = null;
        AccrualTypeEnum type = null;
        for (int i = 0; i < rowCount; ++i) {
            taxAmt = (BigDecimal)this.tblEntries.getCell(i, COL_KEY_TAXAMT).getValue();
            if (taxAmt == null || AccrualTypeEnum.DEPOSIT != (type = (AccrualTypeEnum)((Object)this.tblEntries.getCell(i, "type").getValue()))) continue;
            taxAmtTotal = taxAmtTotal.add(taxAmt);
        }
        this.txttaxAmt.setValue((Object)taxAmtTotal);
    }

    private void reSumNetAmt() {
        int rowCount = this.tblEntries.getRowCount();
        AccrualTypeEnum type = null;
        BigDecimal netAmtTotal = Constants.ZERO;
        BigDecimal netAmt = null;
        for (int i = 0; i < rowCount; ++i) {
            netAmt = (BigDecimal)this.tblEntries.getCell(i, COL_KEY_NETAMT).getValue();
            type = (AccrualTypeEnum)((Object)this.tblEntries.getCell(i, "type").getValue());
            if (AccrualTypeEnum.DEPOSIT != type) continue;
            netAmtTotal = netAmtTotal.add(netAmt);
        }
        this.txtnetAmt.setValue((Object)netAmtTotal);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
    }

    protected void inOnload() throws Exception {
        super.inOnload();
        if ("EDIT".equals(this.getOprtState()) && (this.editData.getAuditDate() != null || this.editData.isIsSettled() || this.editData.isIsAccepted() || this.editData.isFiVouchered())) {
            MsgBox.showWarning((Component)((Object)this), (String)IMUtil.getResString("canNotEditAndRemove"));
            SysUtil.abort();
        }
    }

    private void setNumberFormat(int prec) {
        this.txtaccuAmt.setPrecision(prec);
        this.txtaccuAmt.setRemoveingZeroInDispaly(false);
        this.txtaccrualAmt.setPrecision(prec);
        this.txtaccrualAmt.setRemoveingZeroInDispaly(false);
        this.txtnetAmt.setPrecision(prec);
        this.txtnetAmt.setRemoveingZeroInDispaly(false);
        this.txtbalanceAmt.setPrecision(prec);
        this.txtbalanceAmt.setRemoveingZeroInDispaly(false);
        this.txttaxAmt.setPrecision(prec);
        this.txttaxAmt.setRemoveingZeroInDispaly(false);
        this.txtDays.setHorizontalAlignment(4);
        this.txtinterruptedDays.setHorizontalAlignment(4);
        this.txtaccuAmt.setHorizontalAlignment(4);
        this.txtaccrualAmt.setHorizontalAlignment(4);
        this.txttaxAmt.setHorizontalAlignment(4);
        this.txtnetAmt.setHorizontalAlignment(4);
        this.txtbalanceAmt.setHorizontalAlignment(4);
        this.txtFloorAmt.setHorizontalAlignment(4);
        this.txtFloorAmt.setPrecision(prec);
        this.txtFloorAmt.setRemoveingZeroInDispaly(false);
        this.tblEntries.getColumn(COL_KEY_ACCUAMT).getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)prec));
        this.txtExhRate.setPrecision(5);
        this.txtExhRate.setRemoveingZeroInDispaly(false);
        this.txtExhRate.setHorizontalAlignment(4);
        this.txtNetLocalAmt.setPrecision(prec);
        this.txtNetLocalAmt.setRemoveingZeroInDispaly(false);
        this.txtNetLocalAmt.setHorizontalAlignment(4);
        this.txtoverDraftAccuAm.setPrecision(prec);
        this.txtoverDraftAccuAm.setRemoveingZeroInDispaly(false);
        this.txtoverDraftAccuAm.setHorizontalAlignment(4);
        this.txtoverDraftAccrua.setPrecision(prec);
        this.txtoverDraftAccrua.setRemoveingZeroInDispaly(false);
        this.txtoverDraftAccrua.setHorizontalAlignment(4);
        String currencyId = this.editData.getCurrency().getId().toString();
        FMClientHelper.setNumberFormat((KDTable)this.tblEntries, (String)COL_KEY_ACCRUALAMT, (String)currencyId);
        FMClientHelper.setNumberFormat((KDTable)this.tblEntries, (String)COL_KEY_TAXAMT, (String)currencyId);
        FMClientHelper.setNumberFormat((KDTable)this.tblEntries, (String)COL_KEY_NETAMT, (String)currencyId);
        FMClientHelper.setActualDigitNumberFormat((KDTable)this.tblEntries, (String)COL_KEY_YEARRATE);
        FMClientHelper.setActualDigitNumberFormat((KDTable)this.tblEntries, (String)COL_KEY_TAXRATE);
        FMClientHelper.setNumberFormat((KDTable)this.tblEntries, (String)"subAmount", (String)currencyId);
        FMClientHelper.setNumberFormat((KDTable)this.tblEntries, (String)COL_KEY_ACCUAMT, (String)currencyId);
        String rateName = "";
        String rateFormater = "";
        String numberFtm = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)currencyId));
        if (IntRateTypeExpressionEnum.YEAR == this.editData.getIntRateObject().getType().getRateExpression()) {
            rateName = EASResource.getString((String)"com.kingdee.eas.fm.im.IMAutoGenerateResource", (String)"1_AccrualBillEditUI");
            this.tblEntries.getHead().getRow(0).getCell(7).setValue((Object)rateName);
            this.tblEntries.getColumn(COL_KEY_YEARRATE).getStyleAttributes().setNumberFormat("#,##0.00########\\%");
        } else if (IntRateTypeExpressionEnum.MONTH == this.editData.getIntRateObject().getType().getRateExpression()) {
            rateName = EASResource.getString((String)"com.kingdee.eas.fm.im.IMAutoGenerateResource", (String)"2_AccrualBillEditUI");
            this.tblEntries.getHead().getRow(0).getCell(7).setValue((Object)rateName);
            this.tblEntries.getColumn(COL_KEY_YEARRATE).getStyleAttributes().setNumberFormat("#,##0.00########\\\u2030");
        } else {
            rateName = EASResource.getString((String)"com.kingdee.eas.fm.im.IMAutoGenerateResource", (String)"3_AccrualBillEditUI");
            this.tblEntries.getHead().getRow(0).getCell(7).setValue((Object)rateName);
            this.tblEntries.getColumn(COL_KEY_YEARRATE).getStyleAttributes().setNumberFormat("#,##0.00########\\\u2030");
        }
        for (int i = 1; i < this.tblEntries.getRowCount(); ++i) {
            String beforeAmount = "0";
            if (this.tblEntries.getRow(i - 1).getCell("subAmount") != null) {
                beforeAmount = this.tblEntries.getRow(i - 1).getCell("subAmount").getValue().toString();
            }
            AccrualTypeEnum beforeType = (AccrualTypeEnum)((Object)this.tblEntries.getRow(i - 1).getCell("type").getValue());
            String beforeBeginDate = this.tblEntries.getRow(i - 1).getCell("beginDate").getValue().toString();
            String beforeendDate = this.tblEntries.getRow(i - 1).getCell(COL_KEY_ENDDATE).getValue().toString();
            String amount = this.tblEntries.getRow(i).getCell("subAmount").getValue().toString();
            if (!(this.tblEntries.getRow(i).getCell("subAmount").getValue() instanceof BigDecimal)) continue;
            BigDecimal amountMoney = (BigDecimal)this.tblEntries.getRow(i).getCell("subAmount").getValue();
            AccrualTypeEnum type = (AccrualTypeEnum)((Object)this.tblEntries.getRow(i).getCell("type").getValue());
            String beginDate = this.tblEntries.getRow(i).getCell("beginDate").getValue().toString();
            String endDate = this.tblEntries.getRow(i).getCell(COL_KEY_ENDDATE).getValue().toString();
            if (type != beforeType || !amount.equals(beforeAmount) || !beginDate.equals(beforeBeginDate) || !endDate.equals(beforeendDate) || Constants.ZERO.compareTo(amountMoney) == 0) continue;
            this.tblEntries.getRow(i).getCell("subAmount").getStyleAttributes().setNumberFormat("%r{!>" + numberFtm + "}f");
        }
    }

    private void setMaxValueForCtrl(int prec) {
        KDFormattedTextField fmtTextFieldAmt = new KDFormattedTextField();
        fmtTextFieldAmt.setDataType(1);
        fmtTextFieldAmt.setPrecision(prec);
        fmtTextFieldAmt.setMaximumValue((Comparable)this.entryMaxValue);
        KDTDefaultCellEditor numberEditorAmt = new KDTDefaultCellEditor((JTextField)fmtTextFieldAmt);
        KDFormattedTextField fmtTextFieldRate = new KDFormattedTextField();
        fmtTextFieldRate.setDataType(1);
        fmtTextFieldRate.setPrecision(5);
        fmtTextFieldRate.setMaximumValue((Comparable)Constants.ONE_THOUSAND);
        KDTDefaultCellEditor numberEditorRate = new KDTDefaultCellEditor((JTextField)fmtTextFieldRate);
        this.tblEntries.getColumn(COL_KEY_ACCUAMT).setEditor((ICellEditor)numberEditorAmt);
        this.tblEntries.getColumn(COL_KEY_ACCRUALAMT).setEditor((ICellEditor)numberEditorAmt);
        this.tblEntries.getColumn(COL_KEY_TAXAMT).setEditor((ICellEditor)numberEditorAmt);
        this.tblEntries.getColumn(COL_KEY_NETAMT).setEditor((ICellEditor)numberEditorAmt);
        this.tblEntries.getColumn(COL_KEY_YEARRATE).setEditor((ICellEditor)numberEditorRate);
        this.tblEntries.getColumn(COL_KEY_TAXRATE).setEditor((ICellEditor)numberEditorAmt);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if ("FINDVIEW".equals(this.getOprtState())) {
            this.lockUIForViewStatus();
            this.actionAddNew.setEnabled(false);
            this.btnAddNew.setVisible(false);
            this.tblEntries.getStyleAttributes().setLocked(true);
        }
        boolean canModelNumber = "ADDNEW".equals(this.getOprtState());
        this.txtNumber.setEnabled(canModelNumber);
        this.menuWorkflow.setVisible(false);
        this.menuEdit.setVisible(false);
        this.actionTraceUp.setVisible(false);
        this.actionNextPerson.setVisible(false);
        this.actionMultiapprove.setVisible(false);
        this.actionStartWorkFlow.setVisible(false);
        this.actionSave.setVisible(false);
    }

    protected void updateButtonStatus() {
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.actionTraceUp.setEnabled(false);
            this.actionTraceDown.setEnabled(false);
            this.actionAddNew.setEnabled(false);
            this.btnAddNew.setVisible(false);
            this.actionAttachment.setEnabled(false);
            this.btnAttachment.setVisible(false);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_compute"));
        this.btnAddNew.setIsControlByParent(false);
        this.btnAddNew.setTextIconDisStyle((short)3);
        this.actionAddNew.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_compute"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dysz"));
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        AccrualBillCollection bd;
        NumberValueVerifyRule rule = new NumberValueVerifyRule();
        rule.setMaxValue(this.entryMaxValue);
        rule.setMinValue(Constants.ZERO);
        FMClientVerifyHelper.verifyTableMaxMinValue((CoreUIObject)this, (KDTable)this.tblEntries, (NumberValueVerifyRule)rule);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTable)this.tblEntries);
        FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.tblEntries, (String)"beginDate");
        FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.tblEntries, (String)COL_KEY_ENDDATE);
        FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.tblEntries, (String)COL_KEY_DAYS);
        FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.tblEntries, (String)COL_KEY_ACCUAMT);
        FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.tblEntries, (String)COL_KEY_YEARRATE);
        FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.tblEntries, (String)COL_KEY_ACCRUALAMT);
        FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.tblEntries, (String)COL_KEY_TAXRATE);
        FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.tblEntries, (String)COL_KEY_TAXAMT);
        FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.tblEntries, (String)COL_KEY_NETAMT);
        if ("ADDNEW".equals(this.getOprtState()) && null != (bd = AccrualBillFactory.getRemoteInstance().getAccrualBillCollection("select * where number = '" + this.editData.getNumber() + "'")) && bd.size() > 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"170_BankDraftEditUI"));
            this.txtNumber.requestFocus();
            SysUtil.abort();
        }
    }

    @Override
    protected void comboCurrency_actionPerformed(ActionEvent e) throws Exception {
        this.calExhRate();
        this.calNetLocalAmt();
    }

    private void calExhRate() throws Exception {
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        this.txtExhRate.setValue((Object)IntCalHelper.getExchangeRate(null, currencyInfo, null, DateUtil.getDayBegin()));
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (currentCompany.getBaseCurrency() != null && currencyInfo != null) {
            if (currentCompany.getBaseCurrency().getId().toString().equals(currencyInfo.getId().toString())) {
                this.txtExhRate.setEnabled(false);
                this.txtExhRate.setEditable(false);
            } else {
                this.txtExhRate.setEnabled(true);
                this.txtExhRate.setEditable(true);
            }
        }
    }

    @Override
    protected void txtExhRate_dataChanged(DataChangeEvent e) throws Exception {
        this.calNetLocalAmt();
    }

    @Override
    protected void txtnetAmt_dataChanged(DataChangeEvent e) throws Exception {
        this.calNetLocalAmt();
    }

    @Override
    protected void txtoverDraftAccrua_dataChanged(DataChangeEvent e) throws Exception {
        this.calNetLocalAmt();
    }

    private void calNetLocalAmt() {
        BigDecimal exhRate = this.txtExhRate.getBigDecimalValue();
        BigDecimal netAmt = this.txtnetAmt.getBigDecimalValue();
        BigDecimal overAccrualAmt = this.txtoverDraftAccrua.getBigDecimalValue();
        if (netAmt != null && overAccrualAmt != null) {
            this.txtNetLocalAmt.setValue((Object)FMHelper.multiply((BigDecimal)exhRate, (BigDecimal)netAmt.subtract(overAccrualAmt)));
        }
    }

    @Override
    public void storeFields() {
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtOutBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtOppBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[1]);
        super.storeFields();
    }

    @Override
    public void actionViewBgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        this.editData.setCompany(company);
        AccrualBillInfo info = this.editData;
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fm.im.app.AccrualBill", null, (IObjectValue)this.editData);
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPrint_actionPerformed(e);
        ArrayList<String> idList = new ArrayList<String>();
        if (this.editData != null && this.editData.getId() != null) {
            idList.add(this.editData.getId().toString());
        }
        if (idList == null || idList.size() == 0 || OprtState.EDIT == this.getOprtState()) {
            return;
        }
        AccrualBillTDQueryDelegate data = new AccrualBillTDQueryDelegate(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        String FEEBILL_FILENAME = "/FM/IM";
        appHlp.print(FEEBILL_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPrintPreview_actionPerformed(e);
        ArrayList<String> idList = new ArrayList<String>();
        if (this.editData != null && this.editData.getId() != null) {
            idList.add(this.editData.getId().toString());
        }
        if (idList == null || idList.size() == 0 || OprtState.EDIT == this.getOprtState()) {
            return;
        }
        AccrualBillTDQueryDelegate data = new AccrualBillTDQueryDelegate(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        String FEEBILL_FILENAME = "/FM/IM";
        appHlp.printPreview(FEEBILL_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }
}

