/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.im.AccrualTypeEnum;
import com.kingdee.eas.fm.im.client.IntObjectHandler;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AccrualBillHandler {
    private static Logger logger = Logger.getLogger((String)AccrualBillHandler.class.getName());
    public static final String srcPath = "com.kingdee.eas.fm.im.client.ImResource";
    public static final String ACCRUALTYPE = "accrualType";
    public static final String OUTER_DEPOSIT = "OUTER_DEPOSIT";
    public static final String OUTER_OVERDRAFT = "OUTER_OVERDRAFT";
    public static final String INNER_DEPOSIT = "INNER_DEPOSIT";
    public static final String INNER_OVERDRAFT = "INNER_OVERDRAFT";
    public static final String TYPE = "TYPE";
    public static final String TYPE_INNER = "INNER";
    public static final String TYPE_OUTER = "OUTER";
    public static final String INNER_QUERY = "INNER_QUERY";
    public static final String SETTLE_QUERY = "SETTLE_QUERY";
    private static final Map accralTypeMap = new HashMap();
    private static final List uiParamList;

    private static void checkUIParamIsNull(String uiParam) {
        if (FMHelper.isEmpty((String)uiParam)) {
            MsgBox.showError((String)EASResource.getString((String)srcPath, (String)"uiParamIsNull"));
            SysUtil.abort();
        }
    }

    public static void checkUIParamIsValid(String uiParam) {
        AccrualBillHandler.checkUIParamIsNull(uiParam);
        if (!uiParamList.contains(uiParam)) {
            String msg = MessageFormat.format(EASResource.getString((String)srcPath, (String)"uiParamIsNotValid"), uiParam);
            MsgBox.showError((String)msg);
            SysUtil.abort();
        }
    }

    public static String getTitle(String type, String title) {
        if (TYPE_INNER.equalsIgnoreCase(type)) {
            return AccrualBillHandler.getInnerTitle(title);
        }
        return AccrualBillHandler.getOuterTitle(title);
    }

    private static String getInnerTitle(String title) {
        String inner = EASResource.getString((String)srcPath, (String)"inner");
        return inner + title;
    }

    private static String getOuterTitle(String title) {
        String inner = EASResource.getString((String)srcPath, (String)"outer");
        return inner + title;
    }

    public static AccrualTypeEnum getAccrualType(String uiParam) {
        if (FMHelper.isEmpty((String)uiParam)) {
            return null;
        }
        AccrualTypeEnum type = (AccrualTypeEnum)((Object)accralTypeMap.get(uiParam.toUpperCase()));
        return type;
    }

    public static String getBillType(String uiParam) {
        if (uiParam.indexOf(TYPE_INNER) != -1) {
            return TYPE_INNER;
        }
        if (uiParam.indexOf(TYPE_OUTER) != -1) {
            return TYPE_OUTER;
        }
        throw new IllegalArgumentException();
    }

    public static void checkIsCH() throws EASBizException, BOSException {
        if (!IntObjectHandler.isCHCompany() || !FSClientHelper.clearingHouseIsUsed(null)) {
            MsgBox.showError((String)EASResource.getString((String)srcPath, (String)"companyIsNotCH"));
            SysUtil.abort();
        }
    }

    public static void main(String[] args) {
        AccrualTypeEnum type = AccrualBillHandler.getAccrualType("INNER_ARRdaL");
        logger.info((Object)type);
    }

    static {
        accralTypeMap.put(OUTER_DEPOSIT, AccrualTypeEnum.DEPOSIT);
        accralTypeMap.put(OUTER_OVERDRAFT, AccrualTypeEnum.OVERDRAFT);
        accralTypeMap.put(INNER_DEPOSIT, AccrualTypeEnum.DEPOSIT);
        accralTypeMap.put(INNER_OVERDRAFT, AccrualTypeEnum.OVERDRAFT);
        uiParamList = new ArrayList();
        uiParamList.add(OUTER_DEPOSIT);
        uiParamList.add(OUTER_OVERDRAFT);
        uiParamList.add(INNER_DEPOSIT);
        uiParamList.add(INNER_OVERDRAFT);
        uiParamList.add(TYPE_OUTER);
        uiParamList.add(TYPE_INNER);
        uiParamList.add(INNER_QUERY);
        uiParamList.add(SETTLE_QUERY);
    }
}

