/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.im.IIntObject;
import com.kingdee.eas.fm.im.IntObjectCollection;
import com.kingdee.eas.fm.im.IntObjectFactory;
import com.kingdee.eas.fm.im.client.AbstractAccrualBillLedgerFilterUI;
import com.kingdee.eas.fm.im.client.AccrualBillLedgerFilterParam;
import com.kingdee.eas.fm.im.client.AccrualBillLedgerFilterUISrcTypeEnum;
import com.kingdee.eas.fm.im.client.AccrualBillLedgerHandler;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Set;

public class AccrualBillLedgerFilterUI
extends AbstractAccrualBillLedgerFilterUI {
    private AccrualBillLedgerHandler handler;
    private String type;

    public AccrualBillLedgerFilterUI() throws Exception {
        if (this.handler == null) {
            this.handler = AccrualBillLedgerHandler.getInstance();
        }
    }

    public AccrualBillLedgerFilterUI(String type) throws Exception {
        if (this.handler == null) {
            this.handler = AccrualBillLedgerHandler.getInstance();
        }
        this.type = type;
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.comboBizType.removeAllItems();
        this.prmtIntObject.setQueryInfo("com.kingdee.eas.fm.im.IntObjectQuery");
        this.prmtIntObject.setDisplayFormat("$name$");
        this.prmtIntObject.setEditFormat("$number$");
        this.prmtIntObject.setCommitFormat("$number$");
        this.prmtIntObject.setEnabledMultiSelection(true);
        this.pkBeginDate.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.pkEndDate.setValue((Object)DateUtil.getLastDayOfCurMonth());
        this.pkBeginDate.setSupportedEmpty(false);
        this.pkEndDate.setSupportedEmpty(false);
        this.initCurrency();
        if ("INNER".equalsIgnoreCase(this.type)) {
            this.cbSourceType.setSelectedItem((Object)AccrualBillLedgerFilterUISrcTypeEnum.INNER);
        } else if ("OUTER".equalsIgnoreCase(this.type)) {
            this.cbSourceType.setSelectedItem((Object)AccrualBillLedgerFilterUISrcTypeEnum.OUTER);
        }
    }

    private void initCurrency() throws Exception {
        FMClientHelper.initCombCurrency((KDComboBox)this.currency);
        FMClientHelper.setSelectObject((KDComboBox)this.currency, (Object)ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.currentCompany));
        this.currency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
    }

    @Override
    public Object getParam() {
        AccrualBillLedgerFilterParam param = new AccrualBillLedgerFilterParam();
        param.setCompanyIds(this.getCompanyIds());
        String[] intObjectIds = AccessHelper.getF7Ids((KDBizPromptBox)this.prmtIntObject);
        param.setIntObjectIds(intObjectIds);
        if (this.pkBeginDate.getValue() != null) {
            param.setBeginDate(DateTimeUtils.truncateDate((Date)((Date)this.pkBeginDate.getValue())));
        }
        if (this.pkEndDate.getValue() != null) {
            param.setEndDate(DateTimeUtils.truncateDate((Date)((Date)this.pkEndDate.getValue())));
        }
        param.setSrcType((AccrualBillLedgerFilterUISrcTypeEnum)((Object)this.cbSourceType.getSelectedItem()));
        param.setIncludeDisable(this.chkIncDisableIntObj.isSelected());
        param.setShowCompTotal(this.chkShowCompTotal.isSelected());
        if (this.currency.getSelectedItem().equals(FMSysDefinedEnum.SELECT_ALL)) {
            param.setCurrencyId(null);
        } else {
            param.setCurrencyId(((CurrencyInfo)this.currency.getSelectedItem()).getId().toString());
        }
        return param;
    }

    @Override
    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        super.setParam(param);
        if (param instanceof AccrualBillLedgerFilterParam) {
            AccrualBillLedgerFilterParam filterParam = (AccrualBillLedgerFilterParam)param;
            FMClientHelper.setSelectObject((KDComboBox)this.cbSourceType, (Object)((Object)filterParam.getSrcType()));
            String[] companyIds = filterParam.getCompanyIds();
            String[] intObjectIds = filterParam.getIntObjectIds();
            boolean includeDisabled = filterParam.isIncludeDisable();
            Date beginDate = filterParam.getBeginDate();
            Date endDate = filterParam.getEndDate();
            boolean showCompTotal = filterParam.isShowCompTotal();
            this.setCompanyIds(companyIds);
            Object[] obj = this.getIntObjColl(intObjectIds).toArray();
            this.prmtIntObject.setData((Object)obj);
            this.chkIncDisableIntObj.setSelected(includeDisabled);
            this.pkBeginDate.setValue((Object)beginDate);
            this.pkEndDate.setValue((Object)endDate);
            this.chkShowCompTotal.setSelected(showCompTotal);
            String currencyId = filterParam.getCurrencyId();
            CurrencyInfo currencyInfo = null;
            try {
                if (currencyId != null) {
                    ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                    currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                    FMClientHelper.setSelectObject((KDComboBox)this.currency, (Object)currencyInfo);
                }
            }
            catch (Exception e1) {
                SysUtil.abort((Throwable)e1);
            }
        }
    }

    private IntObjectCollection getIntObjColl(String[] ids) {
        IntObjectCollection coll = new IntObjectCollection();
        if (ids == null || ids.length == 0) {
            return coll;
        }
        Set idSet = FMHelper.Array2Set((String[])ids);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        try {
            IIntObject iIntObject = IntObjectFactory.getRemoteInstance();
            coll = iIntObject.getIntObjectCollection(evi);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return coll;
    }

    @Override
    protected void chkIncDisableIntObj_actionPerformed(ActionEvent e) throws Exception {
        super.chkIncDisableIntObj_actionPerformed(e);
        this.setF7IntObject();
    }

    @Override
    protected void comboBizType_actionPerformed(ActionEvent e) throws Exception {
        super.comboBizType_actionPerformed(e);
        this.setF7IntObject();
    }

    @Override
    protected void cbSourceType_actionPerformed(ActionEvent e) throws Exception {
        this.setF7IntObject();
    }

    @Override
    protected void companyValueChange(Object object) throws Exception {
        super.companyValueChange(object);
        this.setF7IntObject();
    }

    private void setF7IntObject() throws EASBizException, BOSException {
        this.prmtIntObject.setData(null);
        FilterInfo filterInfo = new FilterInfo();
        AccrualBillLedgerFilterUISrcTypeEnum srcType = (AccrualBillLedgerFilterUISrcTypeEnum)((Object)this.cbSourceType.getSelectedItem());
        if (AccrualBillLedgerFilterUISrcTypeEnum.OUTER.equals((Object)srcType)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(3), CompareType.NOTEQUALS));
            Object[] companyIDs = this.getCompanyIds();
            if (!FMHelper.isEmpty((Object[])companyIDs)) {
                filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)FMHelper.asSet((String[])companyIDs), CompareType.INCLUDE));
            }
        } else {
            String curr = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
            CompanyOrgUnitInfo clhCompany = BankFactory.getRemoteInstance().getClearingHouse(curr).getRelatedCompany();
            CompanyOrgUnitInfo curCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            boolean isClearHouse = clhCompany.getId().equals((Object)curCompany.getId());
            if (!isClearHouse) {
                Object[] companyIDs = this.getCompanyIds();
                if (!FMHelper.isEmpty((Object[])companyIDs)) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)FMHelper.asSet((String[])companyIDs), CompareType.INCLUDE));
                }
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)curCompany.getId().toString()));
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(3), CompareType.EQUALS));
        }
        if (!this.chkIncDisableIntObj.isSelected()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(2)));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        this.prmtIntObject.setEntityViewInfo(evi);
    }

    @Override
    protected void setDefaultValue() {
        super.setDefaultValue();
        this.pkBeginDate.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.pkEndDate.setValue((Object)DateUtil.getLastDayOfCurMonth());
        this.pkBeginDate.setSupportedEmpty(false);
        this.pkEndDate.setSupportedEmpty(false);
        this.chkShowCompTotal.setSelected(false);
    }

    public void clear() {
        super.clear();
        this.pkBeginDate.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.pkEndDate.setValue((Object)DateUtil.getLastDayOfCurMonth());
        this.pkBeginDate.setSupportedEmpty(false);
        this.pkEndDate.setSupportedEmpty(false);
    }

    protected Class getParamClass() {
        return AccrualBillLedgerFilterParam.class;
    }
}

