/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.im.AccrualTypeEnum;
import com.kingdee.eas.fm.im.client.AccrualBillLedgerFilterParam;
import com.kingdee.eas.fm.im.client.AccrualBillLedgerFilterUISrcTypeEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Locale;

public class AccrualBillLedgerHandler {
    private static AccrualBillLedgerHandler handler;
    DecimalFormat df = new DecimalFormat("###0.##########");
    protected String loc;

    public static AccrualBillLedgerHandler getInstance() {
        if (handler == null) {
            return new AccrualBillLedgerHandler();
        }
        return handler;
    }

    private IRowSet getRowset(AccrualBillLedgerFilterParam param) throws BOSException, EASBizException {
        this.loc = LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
        if (param == null) {
            return null;
        }
        String netAmtSql = this.getNetAmtCaseSql();
        SQLUtil builder = new SQLUtil();
        builder.appendSql("SELECT Company.FName_").appendSql(this.loc).appendSql("  companyname, IntRateObject.FName_").appendSql(this.loc).appendSql("  intobjectname, Currency.FName_").appendSql(this.loc).appendSql("  currencyname, AccrualBillEntry.FBeginDate, AccrualBillEntry.FEndDate, ");
        this.appendSubsectionSql(netAmtSql, builder);
        if (param.getSrcType().equals((Object)AccrualBillLedgerFilterUISrcTypeEnum.INNER)) {
            builder.appendSql("AccrualBill.FApplyUnitID FCompanyID, AccrualBill.FIntRateObjectID, AccrualBillEntry.FYearRate YearRate, AccrualBill.FCurrencyID, IntRateType.FRateExpression");
        } else {
            builder.appendSql("AccrualBill.FCompanyID FCompanyID, AccrualBill.FIntRateObjectID, AccrualBillEntry.FYearRate YearRate, AccrualBill.FCurrencyID, IntRateType.FRateExpression");
        }
        this.appendFromAndJoinSql(builder, param);
        this.appendWhereSql(builder, param);
        if (param.getSrcType().equals((Object)AccrualBillLedgerFilterUISrcTypeEnum.INNER)) {
            builder.appendSql(" ORDER BY AccrualBill.FApplyUnitID,AccrualBill.FIntRateObjectID, AccrualBill.FCurrencyID, AccrualBillEntry.FBeginDate, AccrualBillEntry.FEndDate");
        } else {
            builder.appendSql(" ORDER BY AccrualBill.FCompanyID, AccrualBill.FIntRateObjectID, AccrualBill.FCurrencyID, AccrualBill.FBeginDate, AccrualBill.FEndDate");
        }
        return FMIsqlFacadeFactory.getRemoteInstance().executeQuery(builder.getSql(), builder.getParamaters().toArray());
    }

    private String getNetAmtCaseSql() {
        StringBuffer netAmtSql = new StringBuffer().append(" AccrualBill.FAccrualAmt-(case when AccrualBill.FOverDraftAccrua is null then 0 else AccrualBill.FOverDraftAccrua end )-AccrualBill.FTaxAmt ");
        return netAmtSql.toString();
    }

    public IRowSet getCompTotalRowSet(AccrualBillLedgerFilterParam param) throws BOSException, EASBizException {
        this.loc = LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
        if (param == null) {
            return null;
        }
        String netAmtSql = this.getNetAmtCaseSql();
        SQLUtil builder = new SQLUtil();
        builder.appendSql("SELECT Company.FName_").appendSql(this.loc).appendSql("  companyname, Currency.FName_").appendSql(this.loc).appendSql("  currencyname, ");
        this.appendSumSubsectionSql(netAmtSql, builder);
        if (param.getSrcType().equals((Object)AccrualBillLedgerFilterUISrcTypeEnum.INNER)) {
            builder.appendSql(",AccrualBill.FApplyUnitID FCompanyID,  AccrualBill.FCurrencyID");
        } else {
            builder.appendSql(",AccrualBill.FCompanyID FCompanyID, AccrualBill.FCurrencyID");
        }
        this.appendFromAndJoinSql(builder, param);
        this.appendWhereSql(builder, param);
        builder.appendSql(" GROUP BY Company.FName_").appendSql(this.loc).appendSql(" , ");
        builder.appendSql(" Currency.FName_").appendSql(this.loc).appendSql(" ,  ");
        if (param.getSrcType().equals((Object)AccrualBillLedgerFilterUISrcTypeEnum.INNER)) {
            builder.appendSql(" AccrualBill.FApplyUnitID,AccrualBill.FCurrencyID");
            builder.appendSql(" ORDER BY AccrualBill.FApplyUnitID, AccrualBill.FCurrencyID");
        } else {
            builder.appendSql(" AccrualBill.FCompanyID,AccrualBill.FCurrencyID");
            builder.appendSql(" order by AccrualBill.FCompanyID,AccrualBill.FCurrencyID");
        }
        return FMIsqlFacadeFactory.getRemoteInstance().executeQuery(builder.getSql(), builder.getParamaters().toArray());
    }

    private void appendFromAndJoinSql(SQLUtil builder, AccrualBillLedgerFilterParam param) {
        builder.appendSql(" FROM T_Int_AccrualBill AccrualBill");
        builder.appendSql(" INNER JOIN T_INT_IntObject IntRateObject ");
        builder.appendSql("\tON AccrualBill.FIntRateObjectID = IntRateObject.FID ");
        builder.appendSql(" INNER JOIN T_BD_Currency Currency ");
        builder.appendSql("\tON AccrualBill.FcurrencyID = Currency.FID ");
        if (param.getSrcType().equals((Object)AccrualBillLedgerFilterUISrcTypeEnum.INNER)) {
            builder.appendSql(" INNER JOIN T_ORG_Company Company ");
            builder.appendSql("\tON AccrualBill.FApplyUnitID = Company.FID ");
        } else {
            builder.appendSql(" INNER JOIN T_ORG_Company Company ");
            builder.appendSql("\tON AccrualBill.FCompanyID = Company.FID ");
        }
        builder.appendSql(" left JOIN T_INT_AccrualBillEntry AccrualBillEntry ");
        builder.appendSql("\tON AccrualBillEntry.FParentID = AccrualBill.FID");
        builder.appendSql(" LEFT JOIN T_INT_IntRateType IntRateType ON IntRateObject.FTypeID = IntRateType.FID ");
    }

    public void fillData(KDTable tblMain, AccrualBillLedgerFilterParam param) throws BOSException, EASBizException {
        tblMain.setRefresh(false);
        tblMain.getStyleAttributes().setLocked(true);
        tblMain.removeRows();
        IRow row = null;
        IRowSet rs = this.getRowset(param);
        try {
            while (rs.next()) {
                row = tblMain.addRow();
                this.setCellValue(rs, row, 0);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        this.fillSubTotalRow(tblMain, param);
        if (param.isShowCompTotal()) {
            this.fillCompanyTotalRow(tblMain, param);
        }
        if (param.getCurrencyId() != null) {
            this.fillSumRowSet(tblMain, param);
        }
        tblMain.setRefresh(true);
        tblMain.reLayoutAndPaint();
    }

    private void fillCompanyTotalRow(KDTable tblMain, AccrualBillLedgerFilterParam param) throws BOSException, EASBizException {
        if (tblMain == null || tblMain.getRowCount() < 1 || param == null) {
            return;
        }
        IRowSet totalRs = this.getCompTotalRowSet(param);
        try {
            String tempCompanyID = (String)tblMain.getRow(0).getCell("companyID").getValue();
            String companyID = null;
            IRow row = null;
            for (int j = 0; j < tblMain.getRowCount(); ++j) {
                companyID = (String)tblMain.getRow(j).getCell("companyID").getValue();
                if (companyID == null || tempCompanyID.equals(companyID)) continue;
                totalRs.beforeFirst();
                while (totalRs.next()) {
                    if (!tempCompanyID.equals(totalRs.getString("FCompanyID"))) continue;
                    row = tblMain.addRow(j);
                    this.setCellValue(totalRs, row, 1);
                }
                tempCompanyID = companyID;
            }
            totalRs.beforeFirst();
            while (totalRs.next()) {
                if (!tempCompanyID.equals(totalRs.getString("FCompanyID"))) continue;
                row = tblMain.addRow();
                this.setCellValue(totalRs, row, 1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void setCellValue(IRowSet rs, IRow row, int type) throws SQLException {
        if (rs == null || row == null) {
            return;
        }
        String beginDate = null;
        String endDate = null;
        if (type == 0) {
            row.getCell("companyID").setValue((Object)rs.getString("FCompanyID"));
            row.getCell("intObjectID").setValue((Object)rs.getString("FIntRateObjectID"));
            row.getCell("intObject").setValue((Object)rs.getString("IntObjectName"));
            row.getCell("currencyID").setValue((Object)rs.getString("FCurrencyID"));
            row.getCell("beginDate").setValue((Object)rs.getDate("FBeginDate"));
            row.getCell("endDate").setValue((Object)rs.getDate("FEndDate"));
            beginDate = String.valueOf(rs.getDate("FBeginDate"));
            endDate = String.valueOf(rs.getDate("FEndDate"));
            row.getCell("intPeriod").setValue((Object)(beginDate.replaceAll("-", ".") + " - " + endDate.replaceAll("-", ".")));
            row.getCell("intDays").setValue((Object)new Integer(rs.getInt("FDays")));
            if ("year".equalsIgnoreCase(rs.getString("FRateExpression"))) {
                row.getCell("yearRate").setValue(rs.getObject("YearRate"));
                row.getCell("yearRate").getStyleAttributes().setNumberFormat("#,##0.000000\\%");
            } else {
                row.getCell("yearRate").setValue(rs.getObject("YearRate"));
                row.getCell("yearRate").getStyleAttributes().setNumberFormat("#,##0.000000\\\u2030");
            }
            row.getCell("isPromisssory").setValue((Object)rs.getBoolean("FIsPromisssory"));
            row.getCell("type").setValue((Object)rs.getString("FType"));
            row.getCell("netAmt").setValue((Object)new BigDecimal(this.df.format(rs.getBigDecimal("FAccrualAmt") != null ? rs.getBigDecimal("FAccrualAmt") : Constants.ZERO)));
        } else if (type == 1) {
            row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
            row.getCell("intPeriod").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.im.client.ImResource", (String)"Total"));
            row.getCell("netAmt").setValue((Object)new BigDecimal(this.df.format(rs.getBigDecimal("FNetAmt") != null ? rs.getBigDecimal("FNetAmt") : Constants.ZERO)));
            row.setMergeable(false);
        }
        row.getCell("companyName").setValue((Object)rs.getString("CompanyName"));
        row.getCell("currencyName").setValue((Object)rs.getString("CurrencyName"));
        row.getCell("accuAmt").setValue((Object)new BigDecimal(this.df.format(rs.getBigDecimal("FAccuAmt") != null ? rs.getBigDecimal("FAccuAmt") : Constants.ZERO)));
    }

    private void appendWhereSql(SQLUtil sqlBuilder, AccrualBillLedgerFilterParam param) throws EASBizException, BOSException {
        if (param == null) {
            return;
        }
        sqlBuilder.appendSql(" WHERE   AccrualBill.FEndDate >= ");
        sqlBuilder.appendParam((Object)DateUtil.getSQLBegin((Date)param.getBeginDate()));
        sqlBuilder.appendSql(" AND AccrualBill.FBeginDate <= ");
        sqlBuilder.appendParam((Object)DateUtil.getSQLBegin((Date)param.getEndDate()));
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        boolean isClearingHouseCompany = false;
        isClearingHouseCompany = FSClientHelper.isClearingHouseCompany((CompanyOrgUnitInfo)company);
        Object[] companyIds = param.getCompanyIds();
        if (FMHelper.isEmpty((Object[])companyIds)) {
            companyIds = new String[]{ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString()};
        }
        Integer INNERACCT_VALUE = new Integer(3);
        if (isClearingHouseCompany && param.getSrcType().equals((Object)AccrualBillLedgerFilterUISrcTypeEnum.INNER)) {
            sqlBuilder.appendSql(" AND AccrualBill.FCompanyID IN (");
            sqlBuilder.appendParam((Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString());
            sqlBuilder.appendSql(")");
        }
        if (isClearingHouseCompany) {
            sqlBuilder.appendSql(" AND (IntRateObject.FSourceType = ");
            sqlBuilder.appendParam((Object)INNERACCT_VALUE);
            sqlBuilder.appendSql(" OR (IntRateObject.FSourceType !=  ");
            sqlBuilder.appendParam((Object)INNERACCT_VALUE);
            sqlBuilder.appendSql(" AND AccrualBill.FCompanyID IN (");
            sqlBuilder.appendParam(companyIds);
            sqlBuilder.appendSql(")))");
        } else {
            sqlBuilder.appendSql(" AND AccrualBill.FCompanyID IN (");
            sqlBuilder.appendParam(companyIds);
            sqlBuilder.appendSql(")");
        }
        Object[] intObjectIds = param.getIntObjectIds();
        if (intObjectIds != null && intObjectIds.length > 0) {
            sqlBuilder.appendSql(" AND IntRateObject.FID IN (");
            sqlBuilder.appendParam(intObjectIds);
            sqlBuilder.appendSql(")");
        } else {
            sqlBuilder.appendSql(" AND IntRateObject.FSourceType");
            if (param.getSrcType().equals((Object)AccrualBillLedgerFilterUISrcTypeEnum.INNER)) {
                sqlBuilder.appendSql("=");
            } else {
                sqlBuilder.appendSql("<>");
            }
            sqlBuilder.appendSql(new Integer(3).toString());
            sqlBuilder.appendSql(" ");
        }
        if (!param.isIncludeDisable()) {
            sqlBuilder.appendSql(" AND IntRateObject.FState = ");
            sqlBuilder.appendParam((Object)new Integer(2));
        }
        if (param.getCurrencyId() != null) {
            sqlBuilder.appendSql(" AND AccrualBill.FCurrencyID = '").appendSql(param.getCurrencyId()).appendSql("'");
        }
    }

    public void initTable(KDTable table) {
        FMClientHelper.setActualDigitNumberFormat((KDTable)table, (String)"netAmt");
        FMClientHelper.setActualDigitNumberFormat((KDTable)table, (String)"accuAmt");
    }

    public void initTableByRow(KDTable table) {
        int tableSize = table.getRowCount();
        String lastCurrencyID = "";
        for (int i = 0; i < tableSize; ++i) {
            IRow iRow = table.getRow(i);
            String currencyID = (String)iRow.getCell("currencyID").getValue();
            if (currencyID != null) {
                this.initRow(table.getRow(i), currencyID);
                lastCurrencyID = currencyID;
                continue;
            }
            this.initRow(table.getRow(i), lastCurrencyID);
        }
    }

    public void initRow(IRow row, String currencyID) {
        FMClientHelper.setNumberFormat((IRow)row, (String)"accuAmt", (String)currencyID);
        FMClientHelper.setNumberFormat((IRow)row, (String)"netAmt", (String)currencyID);
    }

    private IRowSet getSumRowSet(AccrualBillLedgerFilterParam param) throws EASBizException, BOSException {
        String netAmtSql = this.getNetAmtCaseSql();
        SQLUtil builder = new SQLUtil();
        builder.appendSql("SELECT ");
        this.appendSumSubsectionSql(netAmtSql, builder);
        this.appendFromAndJoinSql(builder, param);
        this.appendWhereSql(builder, param);
        return FMIsqlFacadeFactory.getRemoteInstance().executeQuery(builder.getSql(), builder.getParamaters().toArray());
    }

    private void fillSumRowSet(KDTable tblMain, AccrualBillLedgerFilterParam param) throws BOSException, EASBizException {
        if (tblMain == null || tblMain.getRowCount() < 1 || param == null) {
            return;
        }
        IRowSet totalRs = this.getSumRowSet(param);
        try {
            while (totalRs.next()) {
                IRow row = tblMain.addRow(tblMain.getRowCount());
                this.setSumCellValue(totalRs, row);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void setSumCellValue(IRowSet rs, IRow row) throws SQLException {
        if (rs == null || row == null) {
            return;
        }
        row.setMergeable(false);
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        row.getCell("companyName").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.im.IMAutoGenerateResource", (String)"4_AccrualBillLedgerHandler"));
        row.getCell("intObject").setValue((Object)" ");
        row.getCell("currencyName").setValue((Object)" ");
        row.getCell("type").setValue((Object)" ");
        row.getCell("netAmt").setValue((Object)new BigDecimal(this.df.format(rs.getBigDecimal("FNetAmt") != null ? rs.getBigDecimal("FNetAmt") : Constants.ZERO)));
        row.getCell("accuAmt").setValue((Object)new BigDecimal(this.df.format(rs.getBigDecimal("FAccuAmt") != null ? rs.getBigDecimal("FAccuAmt") : Constants.ZERO)));
    }

    private void appendSubsectionSql(String netAmtSql, SQLUtil builder) {
        builder.appendSql(" AccrualBillEntry.FDays  fdays,");
        builder.appendSql(" case  when AccrualBillEntry.FType = 1 then '" + AccrualTypeEnum.DEPOSIT.toString() + "'  ");
        builder.appendSql(" else '" + AccrualTypeEnum.OVERDRAFT.toString() + "' end FType ,");
        builder.appendSql(" AccrualBillEntry.FIsPromisssory  FIsPromisssory,");
        builder.appendSql("AccrualBill.FInterruptedDays  FInterruptedDays,");
        builder.appendSql(" AccrualBillEntry.FAccrualAmt  FAccrualAmt, ");
        builder.appendSql("AccrualBill.FOverDraftAccrua FOverdraftAmt, ");
        builder.appendSql("AccrualBill.FArrearAmtForRpt FArrearAmtForRpt, ");
        builder.appendSql("AccrualBill.FFineAmtForRpt FFineAmtForRpt, ");
        builder.appendSql("AccrualBill.FFeeAmt FfeeAmt, ");
        builder.appendSql("AccrualBillEntry.FAccuAmt FAccuAmt,");
        builder.appendSql("AccrualBill.FOverDraftAccuAm FOverAccuAmt,");
        builder.appendSql("AccrualBill.FTaxAmt FtaxAmt, ");
        builder.appendSql("(case AccrualBill.fissettled when 1 then (" + netAmtSql + ") else 0 end) FSettleNetAmt ,");
    }

    private IRowSet getSubTotalRow(AccrualBillLedgerFilterParam param) throws EASBizException, BOSException {
        if (param == null) {
            return null;
        }
        this.loc = LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
        String netAmtSql = this.getNetAmtCaseSql();
        SQLUtil builder = new SQLUtil();
        builder.appendSql("SELECT Company.FName_").appendSql(this.loc).appendSql("  companyname, IntRateObject.FName_").appendSql(this.loc).appendSql("  intobjectname, Currency.FName_").appendSql(this.loc).appendSql("  currencyname, ");
        this.appendSumSubsectionSql(netAmtSql, builder);
        if (param.getSrcType().equals((Object)AccrualBillLedgerFilterUISrcTypeEnum.INNER)) {
            builder.appendSql(",AccrualBill.FApplyUnitID FCompanyID, AccrualBill.FIntRateObjectID, AccrualBill.FCurrencyID");
        } else {
            builder.appendSql(",AccrualBill.FCompanyID FCompanyID, AccrualBill.FIntRateObjectID, AccrualBill.FCurrencyID");
        }
        this.appendFromAndJoinSql(builder, param);
        this.appendWhereSql(builder, param);
        builder.appendSql(" GROUP BY Company.FName_").appendSql(this.loc).appendSql(" , IntRateObject.FName_").appendSql(this.loc).appendSql(" , ");
        builder.appendSql(" Currency.FName_").appendSql(this.loc).appendSql(" ,  ");
        if (param.getSrcType().equals((Object)AccrualBillLedgerFilterUISrcTypeEnum.INNER)) {
            builder.appendSql(" AccrualBill.FApplyUnitID,AccrualBill.FIntRateObjectID,AccrualBill.FCurrencyID");
            builder.appendSql(" ORDER BY AccrualBill.FApplyUnitID,AccrualBill.FIntRateObjectID, AccrualBill.FCurrencyID");
        } else {
            builder.appendSql(" AccrualBill.FCompanyID,AccrualBill.FIntRateObjectID,AccrualBill.FCurrencyID");
            builder.appendSql(" order by AccrualBill.FCompanyID, AccrualBill.FIntRateObjectID,AccrualBill.FCurrencyID");
        }
        return FMIsqlFacadeFactory.getRemoteInstance().executeQuery(builder.getSql(), builder.getParamaters().toArray());
    }

    private void fillSubTotalRow(KDTable tblMain, AccrualBillLedgerFilterParam param) throws EASBizException, BOSException {
        if (tblMain == null || tblMain.getRowCount() < 1 || param == null) {
            return;
        }
        IRowSet totalRs = this.getSubTotalRow(param);
        try {
            String tempCompanyID = (String)tblMain.getRow(0).getCell("intObjectID").getValue();
            String companyID = null;
            IRow row = null;
            for (int j = 0; j < tblMain.getRowCount(); ++j) {
                companyID = (String)tblMain.getRow(j).getCell("intObjectID").getValue();
                if (companyID == null || tempCompanyID.equals(companyID)) continue;
                totalRs.beforeFirst();
                while (totalRs.next()) {
                    if (!tempCompanyID.equals(totalRs.getString("FIntRateObjectID"))) continue;
                    row = tblMain.addRow(j);
                    this.setSubTotalCellValue(totalRs, row);
                }
                tempCompanyID = companyID;
            }
            totalRs.beforeFirst();
            while (totalRs.next()) {
                if (!tempCompanyID.equals(totalRs.getString("FIntRateObjectID"))) continue;
                row = tblMain.addRow();
                this.setSubTotalCellValue(totalRs, row);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void setSubTotalCellValue(IRowSet rs, IRow row) throws SQLException {
        if (rs == null || row == null) {
            return;
        }
        row.setMergeable(false);
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        row.getCell("intPeriod").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.im.client.ImResource", (String)"SubTotal"));
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        row.getCell("companyName").setValue((Object)rs.getString("companyname"));
        row.getCell("intObject").setValue((Object)rs.getString("intobjectname"));
        row.getCell("currencyName").setValue((Object)rs.getString("currencyname"));
        row.getCell("type").setValue((Object)" ");
        row.getCell("netAmt").setValue((Object)new BigDecimal(this.df.format(rs.getBigDecimal("FNetAmt") != null ? rs.getBigDecimal("FNetAmt") : Constants.ZERO)));
        row.getCell("accuAmt").setValue((Object)new BigDecimal(this.df.format(rs.getBigDecimal("FAccuAmt") != null ? rs.getBigDecimal("FAccuAmt") : Constants.ZERO)));
    }

    private void appendSumSubsectionSql(String netAmtSql, SQLUtil builder) {
        builder.appendSql(" sum(case when AccrualBillEntry.Ftype = 1 then AccrualBillEntry.FAccrualAmt else 0-AccrualBillEntry.FAccrualAmt end)  FNetAmt, ");
        builder.appendSql(" sum(case when AccrualBillEntry.Ftype = 1 then AccrualBillEntry.FAccuAmt else 0-AccrualBillEntry.FAccuAmt end) FAccuAmt");
    }
}

