/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.im.AccrualBillCollection;
import com.kingdee.eas.fm.im.AccrualBillFactory;
import com.kingdee.eas.fm.im.AccrualBillInfo;
import com.kingdee.eas.fm.im.IAccrualBill;
import com.kingdee.eas.fm.im.client.AbstractAccrualBillLedgerUI;
import com.kingdee.eas.fm.im.client.AccrualBillHandler;
import com.kingdee.eas.fm.im.client.AccrualBillLedgerFilterParam;
import com.kingdee.eas.fm.im.client.AccrualBillLedgerFilterUI;
import com.kingdee.eas.fm.im.client.AccrualBillLedgerHandler;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Iterator;

public class AccrualBillLedgerUI
extends AbstractAccrualBillLedgerUI {
    private FMFilterBaseUI filterUI;
    private AccrualBillLedgerHandler handler = AccrualBillLedgerHandler.getInstance();
    private String type;

    public Object getTablePreferenceSchemaKey() {
        if (this.type != null) {
            return "_" + this.type;
        }
        return null;
    }

    public String getUITitle() {
        String title = super.getUITitle();
        return AccrualBillHandler.getTitle(this.type, title);
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    protected void execQuery() throws BOSException {
        AccrualBillLedgerFilterParam param = null;
        try {
            param = (AccrualBillLedgerFilterParam)this.getFilterUI().getParam();
            this.handler.fillData(this.tblMain, param);
            this.handler.initTableByRow(this.tblMain);
            this.setTableMergeable();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new AccrualBillLedgerFilterUI(this.type);
        }
        return this.filterUI;
    }

    public CommonQueryDialog getQueryDlg() throws Exception {
        CommonQueryDialog dialog = super.getQueryDlg();
        dialog.setParentUIClassName(this.getMetaDataPK().getFullName() + this.type);
        return dialog;
    }

    @Override
    public void actionViewBill_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewBill_actionPerformed(e);
        this.viewBill();
    }

    public void viewBill() throws Exception {
        AccrualBillCollection coll = this.getSelectedRowData();
        if (coll == null || coll.size() < 1) {
            return;
        }
        String[] idList = new String[coll.size()];
        int i = 0;
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            AccrualBillInfo info = (AccrualBillInfo)iter.next();
            idList[i++] = info.getId().toString();
        }
        CompanyOrgUnitInfo company = null;
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            String companyId = null;
            if (row.getCell("companyId") != null) {
                companyId = (String)row.getCell("companyId").getValue();
            }
            if (companyId != null) {
                company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            }
            UIContext uiCtx = new UIContext((Object)this);
            uiCtx.put((Object)"TYPE", (Object)this.type);
            FMClientHelper.viewDetailBill((CoreUIObject)this, (UIContext)uiCtx, (String[])idList, (CompanyOrgUnitInfo)company);
        }
    }

    private AccrualBillCollection getSelectedRowData() throws BOSException {
        KDTSelectBlock sb = this.tblMain.getSelectManager().get();
        if (sb == null) {
            return null;
        }
        int rowIndex = sb.getTop();
        IRow row = this.tblMain.getRow(rowIndex);
        String companyID = (String)row.getCell("companyID").getValue();
        String intObjectID = (String)row.getCell("intObjectID").getValue();
        Date beginDate = (Date)row.getCell("beginDate").getValue();
        Date endDate = (Date)row.getCell("endDate").getValue();
        if (companyID == null || companyID.trim().length() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.im.client.ImResource", (String)"selectObject"));
            SysUtil.abort();
        }
        FilterInfo filterInfo = new FilterInfo();
        if ("INNER".equalsIgnoreCase(this.type)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)companyID));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("intRateObject.id", (Object)intObjectID));
        filterInfo.getFilterItems().add(new FilterItemInfo("beginDate", (Object)endDate, CompareType.LESS_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("endDate", (Object)beginDate, CompareType.GREATER_EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("id"));
        evi.setFilter(filterInfo);
        IAccrualBill iAccrualBill = AccrualBillFactory.getRemoteInstance();
        AccrualBillCollection coll = iAccrualBill.getAccrualBillCollection(evi);
        return coll;
    }

    public void onLoad() throws Exception {
        if (this.getUIContext().get("UIClassParam") != null) {
            this.type = (String)this.getUIContext().get("UIClassParam");
        }
        AccrualBillHandler.checkUIParamIsValid(this.type);
        if (this.type.equalsIgnoreCase("INNER")) {
            AccrualBillHandler.checkIsCH();
        }
        this.tblMain.checkParsed();
        this.handler.initTable(this.tblMain);
        this.setTableMergeable();
        super.onLoad();
        String dformat = FMHelper.getDateFormatString();
        this.tblMain.getColumn("beginDate").getStyleAttributes().setNumberFormat(dformat);
        this.tblMain.getColumn("endDate").getStyleAttributes().setNumberFormat(dformat);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionViewBill.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
    }

    private void setTableMergeable() {
        this.tblMain.getColumn("yearRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getMergeManager().setMergeMode(1);
        this.tblMain.getColumn("companyName").setMergeable(true);
        this.tblMain.getColumn("intObject").setMergeable(true);
        this.tblMain.getColumn("currencyName").setMergeable(true);
        this.tblMain.getColumn("type").setMergeable(false);
        this.tblMain.getColumn("isPromisssory").setMergeable(false);
        this.tblMain.getColumn("netAmt").setMergeable(false);
        this.tblMain.getColumn("yearRate").setMergeable(false);
        this.tblMain.getColumn("accuAmt").setMergeable(false);
        this.tblMain.getColumn("intDays").setMergeable(false);
        this.tblMain.getColumn("intPeriod").setMergeable(false);
        this.tblMain.getColumn("endDate").setMergeable(false);
        this.tblMain.getColumn("beginDate").setMergeable(false);
    }
}

