/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.im.AccrualBillCollection;
import com.kingdee.eas.fm.im.AccrualBillException;
import com.kingdee.eas.fm.im.AccrualBillFactory;
import com.kingdee.eas.fm.im.AccrualBillInfo;
import com.kingdee.eas.fm.im.IAccrualBill;
import com.kingdee.eas.fm.im.IMUtil;
import com.kingdee.eas.fm.im.client.AbstractAccrualBillListUI;
import com.kingdee.eas.fm.im.client.AccrualBillBaseFilterUI;
import com.kingdee.eas.fm.im.client.AccrualBillMgtFilterUI;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AccrualBillListUI
extends AbstractAccrualBillListUI {
    private static final String COL_KEY_SOURCETYPE = "sourceType";
    private static final String IM_RESOURCE = "com.kingdee.eas.fm.im.IMAutoGenerateResource";
    private static final Logger logger = CoreUIObject.getLogger(AccrualBillListUI.class);
    private AccrualBillBaseFilterUI filterUI;

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAddNew.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_compute"));
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_auditing"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.actionSettle.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_profitandloss"));
        this.actionAntiSettle.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_restore"));
        if ("FINDVIEW".equals(this.getOprtState())) {
            this.actionAddNew.setEnabled(false);
            this.btnAddNew.setVisible(false);
        }
        this.actionTraceUp.setVisible(false);
        FMClientHelper.clearSeparatorOnMenu((KDMenu)this.menuFile);
        FMClientHelper.clearSeparatorOnMenu((KDMenu)this.menuEdit);
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAntiAudit_actionPerformed(e);
        this.checkSelected();
        AccrualBillFactory.getRemoteInstance().antiAudit(this.getSelectedIdSet());
        this.showSucessMessage();
        this.refresh(e);
    }

    @Override
    public void actionAntiSettle_actionPerformed(ActionEvent e) throws Exception {
        super.actionAntiSettle_actionPerformed(e);
        this.checkSelected();
        AccrualBillFactory.getRemoteInstance().antiSettle(this.getSelectedIdSet());
        this.showSucessMessage();
        this.refresh(e);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() <= 0) {
            return;
        }
        boolean idsInProcess = FMHelper.hasWFInstance(null, (List)idList);
        if (idsInProcess) {
            this.actionMultiapprove_actionPerformed(e);
            this.refresh(e);
            return;
        }
        AccrualBillFactory.getRemoteInstance().audit(this.getSelectedIdSet());
        this.showSucessMessage();
        this.refresh(e);
    }

    private void showSucessMessage() {
        this.setMessageText(IMUtil.getResString("operateSuccess"));
        this.showMessage();
    }

    @Override
    public void actionSettle_actionPerformed(ActionEvent e) throws Exception {
        super.actionSettle_actionPerformed(e);
        this.checkSelected();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("isSettled");
        AccrualBillInfo billInfo = AccrualBillFactory.getRemoteInstance().getAccrualBillInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()), selectors);
        if (billInfo.isIsSettled()) {
            throw new AccrualBillException(AccrualBillException.BILL_HAS_SETTLED);
        }
        Object fpItemInfo = null;
        String fpItemID = fpItemInfo == null ? null : fpItemInfo.getId().toString();
        AccrualBillFactory.getRemoteInstance().settle(this.getSelectedIdSet(), fpItemID);
        this.showSucessMessage();
        this.refresh(e);
    }

    private Set getSelectedIdSet() {
        return new HashSet(this.getSelectedIdValues());
    }

    @Override
    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new AccrualBillMgtFilterUI();
            this.filterUI.setListUI((IUIObject)this);
        }
        return this.filterUI;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        IContextHelper ctx = ContextHelperFactory.getRemoteInstance();
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)ctx.getCurrentCompany())) {
            this.tblMain.getColumn("company.name").getStyleAttributes().setHided(false);
            this.actionSettle.setEnabled(false);
            this.actionAntiSettle.setEnabled(false);
            this.actionSettle.setVisible(false);
            this.actionAntiSettle.setVisible(false);
            this.actionAudit.setEnabled(false);
            this.actionAudit.setVisible(false);
            this.actionAntiAudit.setEnabled(false);
            this.actionAntiAudit.setVisible(false);
        }
        this.tblMain.getColumn("accuAmt").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)4));
        FMClientHelper.clearSeparatorOnToolBar((KDToolBar)this.toolBar);
        this.tblMain.getColumn("auditDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("settleDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("beginDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("endDate").getStyleAttributes().setNumberFormat(this.dformat);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        IContextHelper helper = ContextHelperFactory.getRemoteInstance();
        if (helper.isOnlyUnion(helper.getCurrentCompany()) || "FINDVIEW".equals(this.getOprtState())) {
            this.checkSelected();
            String[] idList = new String[]{this.getSelectedKeyValue()};
            FMClientHelper.viewDetailBill((CoreUIObject)this, (String[])idList, (CompanyOrgUnitInfo)helper.getCurrentCompany());
        } else {
            super.actionView_actionPerformed(e);
        }
    }

    protected void setActionState() {
        super.setActionState();
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        int top = block.getTop();
        int sourceTypeColIndex = this.tblMain.getColumn(COL_KEY_SOURCETYPE).getColumnIndex();
        if (((BizEnumValueInfo)this.tblMain.getCell(top, sourceTypeColIndex).getValue()).getInt() == 3) {
            this.setActionStatus(false);
        } else {
            this.setActionStatus(true);
        }
    }

    private void setActionStatus(boolean b) {
        this.actionEdit.setEnabled(b);
        this.actionRemove.setEnabled(b);
        this.actionAudit.setEnabled(b);
        this.actionAntiAudit.setEnabled(b);
        this.actionSettle.setEnabled(b);
        this.actionAntiSettle.setEnabled(b);
        this.actionVoucher.setEnabled(b);
        this.actionDelVoucher.setEnabled(b);
        this.actionTraceUp.setEnabled(b);
        this.actionTraceDown.setEnabled(b);
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        if ("FINDVIEW".equals(oprtType)) {
            this.setActionStatus(false);
            this.actionAddNew.setEnabled(false);
            this.btnAddNew.setVisible(false);
            this.btnEdit.setVisible(false);
            this.actionQuery.setEnabled(false);
            this.btnQuery.setEnabled(false);
        }
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"TYPE", (Object)"OUTER");
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuEdit.remove((Component)this.kDSeparator3);
        this.menuEdit.remove((Component)this.kDSeparator4);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("oppBgItemId"));
        sic.add(new SelectorItemInfo("oppBgItemNumber"));
        sic.add(new SelectorItemInfo("oppBgItemName"));
        return sic;
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        FMClientHelper.viewBgBalance4ListUI((Component)((Object)this), (String)id);
    }

    protected void execQuery() {
        Map botpCtx;
        if (this.getBOTPViewStatus() == 1 && (botpCtx = (Map)this.getUIContext().get("BTPEDITPARAMETER")) != null) {
            String targetBillType = (String)botpCtx.get("TargetBillType");
            FilterInfo filter = new FilterInfo();
            if (targetBillType != null) {
                if (targetBillType.equals("ReceivingBill")) {
                    filter.getFilterItems().add(new FilterItemInfo("receivingbillId", null, CompareType.EQUALS));
                }
                try {
                    this.mainQuery.getFilter().mergeFilter(filter, "and");
                }
                catch (BOSException e) {
                    this.handUIExceptionAndAbort((Exception)((Object)e));
                }
            }
        }
        super.execQuery();
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String id = (String)idList.get(0);
        AccrualBillInfo sourceBill = ((IAccrualBill)this.getBizInterface()).getAccrualBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        this.actionVoucher.setEnabled(!sourceBill.isFiVouchered());
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() <= 0) {
            return;
        }
        boolean idsInProcess = FMHelper.hasWFInstance(null, (List)idList);
        if (idsInProcess) {
            throw new AccrualBillException(AccrualBillException.WORKFLOWPROCESSING);
        }
        super.actionRemove_actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionGenReceivingBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        IMutexServiceControl iMutexServiceControl = MutexServiceControlFactory.getRemoteInstance();
        Map requestMap = iMutexServiceControl.batchRequestObjIDForUpdate((List)idList);
        ArrayList<String> requestIdList = new ArrayList<String>();
        boolean isLocked = false;
        int size = idList.size();
        for (int j = 0; j < size; ++j) {
            String accrualBillId = idList.get(j).toString();
            if (!((Boolean)requestMap.get(accrualBillId)).booleanValue()) {
                isLocked = true;
                continue;
            }
            requestIdList.add(accrualBillId);
        }
        if (isLocked) {
            iMutexServiceControl.batchReleaseObjIDForUpdate(requestIdList);
            throw new AccrualBillException(AccrualBillException.DATAMUTEX);
        }
        try {
            ArrayList<String> errorNumberLsit = new ArrayList<String>();
            CoreBillBaseCollection billCollection = new CoreBillBaseCollection();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.list2Set((List)idList), CompareType.INCLUDE));
            view.setFilter(filter);
            AccrualBillCollection coll = AccrualBillFactory.getRemoteInstance().getAccrualBillCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                AccrualBillInfo accrualBill = coll.get(i);
                if (!accrualBill.isIsGenReceiving() && accrualBill.isHasEffected() && !accrualBill.isIsSettled() && accrualBill.getNetLocalAmt().compareTo(BigDecimal.ZERO) != 0) {
                    billCollection.add((CoreBillBaseInfo)accrualBill);
                    continue;
                }
                errorNumberLsit.add(accrualBill.getNumber());
            }
            if (billCollection.size() > 0) {
                FMClientHelper.generateDestBill((CoreBillListUI)this, (String)new AccrualBillInfo().getBOSType().toString(), (String)new ReceivingBillInfo().getBOSType().toString(), (CoreBillBaseCollection)billCollection, (boolean)false);
            }
            int successCount = billCollection.size();
            int failCount = errorNumberLsit.size();
            String failDetail = EASResource.getString((String)IM_RESOURCE, (String)"GenRec_Detail", (Object[])new Object[]{errorNumberLsit.toString()});
            if (failCount > 0) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)IM_RESOURCE, (String)"GenRec_Result", (Object[])new Object[]{idList.size(), successCount, failCount}), (String)failDetail, (int)2);
            } else {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)IM_RESOURCE, (String)"GenRec_Success", (Object[])new Object[]{successCount}), (String)"", (int)2);
            }
        }
        finally {
            iMutexServiceControl.batchReleaseObjIDForUpdate((List)idList);
        }
        this.refreshList();
    }
}

