/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.fm.AccessHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.IProgressMonitor;
import com.kingdee.eas.fm.common.IRunnableWithProgress;
import com.kingdee.eas.fm.common.ProgressDialog;
import com.kingdee.eas.fm.im.AccrualBillInfo;
import com.kingdee.eas.fm.im.IntObjectFactory;
import com.kingdee.eas.fm.im.client.AbstractBatchCalDateChooserUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BatchCalDateChooserUI
extends AbstractBatchCalDateChooserUI {
    private static final Logger logger = CoreUIObject.getLogger(BatchCalDateChooserUI.class);
    private static String resourcePath = "com.kingdee.eas.fm.im.client.ImResource";
    private ProgressDialog progressDialog;
    private Set createdIntReceivedID;
    private boolean val = false;
    private String type = null;

    public void onLoad() throws Exception {
        super.onLoad();
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            codingRuleManager.readNumber((IObjectValue)new AccrualBillInfo(), ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString());
        }
        catch (Exception e) {
            MsgBox.showWarning((Component)((Object)this), (String)e.getMessage());
            SysUtil.abort();
        }
        this.setTransferValue();
        this.setPrmtAccualBill();
        this.kDLabelContainer1.setVisible(this.val);
        this.dpEndDate.setRequired(true);
        this.dpEndDate.setSupportedEmpty(false);
    }

    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.isEmpty(this.prmtAccualBill.getData())) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"intObjNotNull"));
            SysUtil.abort();
        }
        this.calculateInterest();
        this.disposeUIWindow();
    }

    private void setFilterItems(FilterInfo filter) {
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString()));
        if (!this.val) {
            filter.getFilterItems().add(new FilterItemInfo("scheme.id", null, CompareType.NOTEQUALS));
            this.opNextSettleDateAtThisMonth(filter);
        } else {
            this.opNextSettledDate(filter);
        }
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(2), CompareType.EQUALS));
        this.transferAccualType(filter);
    }

    private void opNextSettledDate(FilterInfo filter) {
        filter.getFilterItems().add(new FilterItemInfo("lastSettledDate", (Object)DateTimeUtils.truncateDate((Date)this.dpEndDate.getSqlDate()), CompareType.LESS));
    }

    private void opNextSettleDateAtThisMonth(FilterInfo filter) {
        Calendar firstDayOfThisMonth = Calendar.getInstance();
        firstDayOfThisMonth.set(5, firstDayOfThisMonth.getActualMinimum(5));
        Calendar lastDayOfThisMonth = Calendar.getInstance();
        lastDayOfThisMonth.set(5, lastDayOfThisMonth.getActualMaximum(5));
        filter.getFilterItems().add(new FilterItemInfo("nextSettledDate", (Object)DateTimeUtils.truncateDate((Date)firstDayOfThisMonth.getTime()), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("nextSettledDate", (Object)DateTimeUtils.truncateDate((Date)lastDayOfThisMonth.getTime()), CompareType.LESS_EQUALS));
    }

    private void transferAccualType(FilterInfo filter) {
        String type = (String)this.getUIContext().get("accrualType");
        if (type == null) {
            return;
        }
        if ("INNER".equalsIgnoreCase(type)) {
            filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(3), CompareType.EQUALS));
        } else if ("OUTER".equalsIgnoreCase(type)) {
            filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(3), CompareType.NOTEQUALS));
        }
    }

    @Override
    protected void prmtLoan_willShow(SelectorEvent e) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        this.setFilterItems(filter);
        evi.setFilter(filter);
        this.prmtAccualBill.setEntityViewInfo(evi);
        this.prmtAccualBill.getQueryAgent().resetRuntimeEntityView();
    }

    private void setPrmtAccualBill() {
        this.prmtAccualBill.setQueryInfo("com.kingdee.eas.fm.im.IntObjectQuery");
        this.prmtAccualBill.setDisplayFormat("$name$");
        this.prmtAccualBill.setEditFormat("$number$");
        this.prmtAccualBill.setCommitFormat("$number$");
    }

    private void setTransferValue() {
        this.val = (Boolean)this.getUIContext().get("val");
        this.type = (String)this.getUIContext().get("accrualType");
    }

    private void batchGenAccrualBills() throws BOSException, EASBizException {
        Set ids = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtAccualBill));
        this.createdIntReceivedID = IntObjectFactory.getRemoteInstance().batchGenAccrualBills(this.type, ids);
    }

    private void batchGenAccrualBillsWithEndDate() throws BOSException, EASBizException {
        Date endDate = DateTimeUtils.truncateDate((Date)((Date)this.dpEndDate.getValue()));
        String type = (String)this.getUIContext().get("accrualType");
        Set ids = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtAccualBill));
        this.createdIntReceivedID = IntObjectFactory.getRemoteInstance().batchGenAccrualBillsWithEndDate(type, endDate, ids);
    }

    private void calculateInterest() {
        if (this.progressDialog == null) {
            this.progressDialog = ProgressDialog.createProgressDialog((Component)((Object)this), (boolean)true);
        }
        if (this.progressDialog.isVisible()) {
            return;
        }
        try {
            this.progressDialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask(EASResource.getString((String)resourcePath, (String)"calculateAssural"), -1);
                        monitor.setTaskName(EASResource.getString((String)resourcePath, (String)"calculatePleaseWait"));
                        monitor.subTaskBegin(EASResource.getString((String)resourcePath, (String)"prepareData"));
                        monitor.subTaskBegin(EASResource.getString((String)resourcePath, (String)"calculate"));
                        try {
                            if (BatchCalDateChooserUI.this.val) {
                                BatchCalDateChooserUI.this.batchGenAccrualBillsWithEndDate();
                            } else {
                                BatchCalDateChooserUI.this.batchGenAccrualBills();
                            }
                        }
                        catch (EASBizException e) {
                            BatchCalDateChooserUI.this.handUIExceptionAndAbort((Exception)((Object)e));
                        }
                        catch (BOSException e) {
                            BatchCalDateChooserUI.this.handUIExceptionAndAbort((Exception)((Object)e));
                        }
                        monitor.subTaskBegin(EASResource.getString((String)resourcePath, (String)"calculateComplete"));
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (Exception e) {
            logger.error((Object)"Much Interest Calculate Progress Error", (Throwable)e);
        }
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.createdIntReceivedID = null;
        this.disposeUIWindow();
    }

    public static Set getCreateArrcualID(CoreUI ui, String billType, boolean val) throws BOSException, EASBizException {
        Set createdIntReceivedID = new HashSet();
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"accrualType", (Object)billType);
            uiContext.put((Object)"val", (Object)val);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BatchCalDateChooserUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            createdIntReceivedID = ((BatchCalDateChooserUI)uiWindow.getUIObject()).getCreatedIntID();
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        return createdIntReceivedID;
    }

    private Set getCreatedIntID() {
        return this.createdIntReceivedID;
    }

    public void showSuccessMsg(String msg) {
        this.setMessageIcon(SHOW_MESSAGE_ICON_OK);
        this.setMessageBgcolor(SHOW_MESSAGE_BG_OK);
        this.setMessageText(msg);
        this.showMessage();
    }

    private boolean isEmpty(Object param) {
        if (param instanceof Object[]) {
            Object[] var = (Object[])param;
            return var == null || var.length == 0 || EmptyUtil.isEmpty((Object)var[0]);
        }
        return param == null;
    }
}

