/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.IInnerAccount;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.client.CurrencyUtil;
import com.kingdee.eas.fm.im.IIntObject;
import com.kingdee.eas.fm.im.IMUtil;
import com.kingdee.eas.fm.im.InAccountTypeEnum;
import com.kingdee.eas.fm.im.IntObjectBPDepositInfo;
import com.kingdee.eas.fm.im.IntObjectCollection;
import com.kingdee.eas.fm.im.IntObjectFinanceInfo;
import com.kingdee.eas.fm.im.IntObjectInfo;
import com.kingdee.eas.fm.im.IntObjectSourceTypeEnum;
import com.kingdee.eas.fm.im.IntObjectTypeEnum;
import com.kingdee.eas.fm.im.IntRateRuleEnum;
import com.kingdee.eas.fm.im.IntRateTypeFactory;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.im.SubDepositRateEntryCollection;
import com.kingdee.eas.fm.im.SubDepositRateEntryInfo;
import com.kingdee.eas.fm.im.SubOverRateEntryCollection;
import com.kingdee.eas.fm.im.SubOverRateEntryInfo;
import com.kingdee.eas.fm.im.client.AbstractIntObjectAddBatchUI;
import com.kingdee.eas.fm.im.client.AccrualBillHandler;
import com.kingdee.eas.fm.im.client.IntObjectHandler;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class IntObjectAddBatchUI
extends AbstractIntObjectAddBatchUI {
    private static final Logger logger = CoreUIObject.getLogger(IntObjectAddBatchUI.class);
    protected static final BigDecimal INITIAL_ACCUMULA_DEFAULT = Constants.ZERO;
    protected static final BigDecimal TAX_RATE_DEFAULT = new BigDecimal("20");
    protected static final BigDecimal UNIT_AMT_DEFAULT = Constants.ONE;
    protected static final BigDecimal DESPOSIT_QUOTA_DEFAULT = new BigDecimal("100000");
    private IntObjectHandler handler = null;
    CompanyOrgUnitInfo currCompanyInfo = null;
    private String type;

    public IntObjectAddBatchUI() throws Exception {
        if (this.handler == null) {
            this.handler = IntObjectHandler.create();
        }
    }

    @Override
    protected void comboCurrency_actionPerformed(ActionEvent e) throws Exception {
        super.comboCurrency_actionPerformed(e);
        this.setInitPre();
    }

    @Override
    protected void txtUnitAmt_dataChanged(DataChangeEvent e) throws Exception {
        super.txtUnitAmt_dataChanged(e);
        this.setInitPre();
    }

    @Override
    protected void txtUnitAmt_actionPerformed(ActionEvent e) throws Exception {
        super.txtUnitAmt_actionPerformed(e);
        this.setInitPre();
    }

    private void setInitPre() throws Exception {
        int bunit;
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (currencyInfo == null) {
            return;
        }
        BigDecimal unit = this.txtUnitAmt.getBigDecimalValue();
        int precision = FMClientHelper.getPrecOfCurrency((BOSUuid)currencyInfo.getId());
        if (unit != null && unit.signum() > 0 && (bunit = IntObjectHandler.getPowOfX(unit)) < precision) {
            precision = bunit;
        }
        this.txtInitialAccumula.setPrecision(precision);
        this.handler.initAmtEditor(this.tableDeposit, currencyInfo.getId().toString(), "subAmount");
        this.handler.initAmtEditor(this.tableOverDraft, currencyInfo.getId().toString(), "subAmount");
    }

    public static void showUI(IUIObject ui, String type, String oprtState) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"TYPE", (Object)type);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(IntObjectAddBatchUI.class.getName(), (Map)uiContext, null, oprtState);
        uiWindow.show();
    }

    public String getUITitle() {
        String title = super.getUITitle();
        return AccrualBillHandler.getTitle(this.type, title);
    }

    public void onLoad() throws Exception {
        if (this.currCompanyInfo == null) {
            this.currCompanyInfo = SysContext.getSysContext().getCurrentFIUnit();
        }
        if (this.getUIContext().get("TYPE") != null) {
            this.type = (String)this.getUIContext().get("TYPE");
        }
        CurrencyUtil.fillCombCurrency((KDComboBox)this.comboCurrency);
        this.handler.initSourceType(this.type, this.comboSourceType);
        this.comboSourceType.removeItem((Object)IntObjectSourceTypeEnum.ACCTANDASST);
        super.onLoad();
        this.initUI();
        if (this.oprtState.equals(OprtState.EDIT) && this.handler.hasIntRecords(this.editData.getId().toString())) {
            this.setPropertyReadOnly(true);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("closed", (Object)Constants.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)Constants.TRUE));
        String curr = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)curr));
        EntityViewInfo evi2 = new EntityViewInfo();
        evi2.setFilter(filter);
        this.f7CpInnerAccount.setEntityViewInfo(evi2);
        this.f7CpInnerAccount.setDisplayFormat("$number$ $name$");
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.setCtrlPropertiesBySourceType();
        }
        FMClientHelper.clearSeparatorOnToolBar((KDToolBar)this.toolBar);
        if ("INNER".equalsIgnoreCase(this.type)) {
            this.comboSourceType.setEnabled(false);
        }
        this.initLeijinPanel();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    private void initUI() {
        this.txtDepositBp.setHorizontalAlignment(4);
        this.txtDepositBp.setRemoveingZeroInDispaly(true);
        this.txtDepositBp.setRemoveingZeroInEdit(true);
        this.txtDepositBp.setSupportedEmpty(true);
        this.txtDepositBp.setMaximumValue((Comparable)Constants.TEN_THOUSAND);
        this.txtFloorAmt.setHorizontalAlignment(4);
        this.txtFloorAmt.setRemoveingZeroInDispaly(true);
        this.txtFloorAmt.setRemoveingZeroInEdit(true);
        this.txtFloorAmt.setSupportedEmpty(true);
        this.txtFloorAmt.setMaximumValue((Comparable)Constants.MAX_VALUE);
        this.txtOverDraftRate.setHorizontalAlignment(4);
        this.txtOverDraftRate.setRemoveingZeroInDispaly(true);
        this.txtOverDraftRate.setRemoveingZeroInEdit(true);
        this.txtOverDraftRate.setSupportedEmpty(true);
        this.txtOverDraftRate.setMaximumNumber((Number)Constants.TEN_THOUSAND);
        this.txtProRate.setHorizontalAlignment(4);
        this.txtProRate.setRemoveingZeroInDispaly(true);
        this.txtProRate.setRemoveingZeroInEdit(true);
        this.txtProRate.setSupportedEmpty(true);
        this.txtProRate.setMaximumNumber((Number)Constants.TEN_THOUSAND);
        this.txtQuota.setHorizontalAlignment(4);
        this.txtQuota.setRemoveingZeroInDispaly(true);
        this.txtQuota.setRemoveingZeroInEdit(true);
        this.txtQuota.setSupportedEmpty(true);
        this.txtQuota.setMaximumNumber((Number)Constants.MAX_VALUE);
        this.txtTaxRate.setHorizontalAlignment(4);
        this.txtTaxRate.setRemoveingZeroInDispaly(true);
        this.txtTaxRate.setRemoveingZeroInEdit(true);
        this.txtTaxRate.setSupportedEmpty(true);
        this.txtTaxRate.setMaximumNumber((Number)Constants.TEN_THOUSAND);
        this.txtInitialAccumula.setHorizontalAlignment(4);
        this.txtInitialAccumula.setRemoveingZeroInDispaly(true);
        this.txtInitialAccumula.setRemoveingZeroInEdit(true);
        this.txtInitialAccumula.setSupportedEmpty(false);
        this.txtInitialAccumula.setMaximumValue((Comparable)Constants.MAX_VALUE);
        this.txtUnitAmt.setHorizontalAlignment(4);
        this.txtUnitAmt.setRemoveingZeroInDispaly(true);
        this.txtUnitAmt.setRemoveingZeroInEdit(true);
        this.txtUnitAmt.setSupportedEmpty(true);
        this.txtUnitAmt.setMaximumValue((Comparable)Constants.MAX_VALUE);
        this.prmtObject.setEnabledMultiSelection(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnFindObject.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.btnDeleteObject.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        FMClientHelper.clearSeparatorOnMenu((KDMenu)this.menuFile);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.actionAddNew.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.prmtObject.setVisible(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.handler.loadDepositFields(this.editData, this);
        FMClientHelper.setSelectObject((KDComboBox)this.comboSourceType, (Object)((Object)this.editData.getSourceType()));
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
        FMClientHelper.setSelectObject((KDComboBox)this.comboInAccountType, (Object)((Object)this.editData.getFinanceAttr().getInAccountType()));
        this.prmtType.setData((Object)this.editData.getType());
        this.f7CpInnerAccount.setValue((Object)this.editData.getFinanceAttr().getCpInneraccount());
        this.setFinanceF7();
        this.loadEntriesFields();
    }

    private void setFinanceF7() {
        String curCompanyId = this.currCompanyInfo.getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)curCompanyId));
        view.setFilter(filter);
        this.prmtSettledAccount.setEntityViewInfo(view);
        AccountTableInfo accountTable = this.currCompanyInfo.getAccountTable();
        String accountTableId = null;
        if (!FMHelper.isEmpty((CoreBaseInfo)accountTable)) {
            accountTableId = accountTable.getId().toString();
        }
        FilterInfo filterInfo1 = new FilterInfo();
        filterInfo1.getFilterItems().add(new FilterItemInfo("PLType", (Object)new Integer(5)));
        filterInfo1.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Constants.TRUE));
        filterInfo1.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Constants.FALSE));
        filterInfo1.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Constants.FALSE));
        filterInfo1.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)curCompanyId));
        if (accountTableId != null) {
            filterInfo1.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTableId));
        }
        EntityViewInfo evi1 = new EntityViewInfo();
        evi1.setFilter(filterInfo1);
        this.prmtAccuralAccount.setEntityViewInfo(evi1);
        this.prmtOverAccount.setEntityViewInfo(evi1);
        FilterInfo filterInfo2 = new FilterInfo();
        filterInfo2.getFilterItems().add(new FilterItemInfo("accountTypeID.property", (Object)FMHelper.asSet((int[])new int[]{0, 1}), CompareType.INCLUDE));
        filterInfo2.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Constants.TRUE));
        filterInfo2.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Constants.FALSE));
        filterInfo2.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Constants.FALSE));
        filterInfo2.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)curCompanyId));
        if (accountTableId != null) {
            filterInfo2.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTableId));
        }
        EntityViewInfo evi2 = new EntityViewInfo();
        evi2.setFilter(filterInfo2);
        this.prmtRecPayableAcct.setEntityViewInfo(evi2);
        FilterInfo filterInfo3 = new FilterInfo();
        filterInfo3.getFilterItems().add(new FilterItemInfo("accountTypeID.property", (Object)new Integer(4)));
        filterInfo3.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Constants.TRUE));
        filterInfo3.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Constants.FALSE));
        filterInfo3.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Constants.FALSE));
        filterInfo3.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)curCompanyId));
        if (accountTableId != null) {
            filterInfo3.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTableId));
        }
        EntityViewInfo evi3 = new EntityViewInfo();
        evi3.setFilter(filterInfo3);
        this.prmtTaxAccount.setEntityViewInfo(evi3);
    }

    private void setRecPayedF7View(boolean isSourceTypeInnerAcct) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (isSourceTypeInnerAcct) {
            HashSet<Integer> values = new HashSet<Integer>();
            values.add(new Integer(0));
            values.add(new Integer(1));
            filterInfo.getFilterItems().add(new FilterItemInfo("accountTypeID.property", values, CompareType.INCLUDE));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("isBank", (Object)Constants.TRUE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Constants.TRUE));
        filterInfo.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Constants.FALSE));
        filterInfo.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Constants.FALSE));
        String companyid = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        filterInfo.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyid));
        AccountTableInfo accountTable = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getAccountTable();
        if (!FMHelper.isEmpty((CoreBaseInfo)accountTable)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTable.getId().toString()));
        }
        view.setFilter(filterInfo);
        this.prmtRecPayedAcct.setEntityViewInfo(view);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.editData.getUnitAmt().compareTo(Constants.ZERO) > 0) {
            BigDecimal unitAmt = this.editData.getUnitAmt();
            BigDecimal initialAccumula = this.editData.getInitialAccumula().divide(unitAmt, 0, 4).multiply(unitAmt);
            this.editData.setInitialAccumula(initialAccumula);
        }
        this.editData.setEffectiveDate(DateTimeUtils.truncateDate((Date)this.editData.getEffectiveDate()));
        this.editData.setLastSettledDate(DateTimeUtils.truncateDate((Date)this.editData.getLastSettledDate()));
        this.handler.storeDepositFields(this.editData, this);
        this.editData.getFinanceAttr().setInAccountType((InAccountTypeEnum)((Object)this.comboInAccountType.getSelectedItem()));
        this.editData.getFinanceAttr().setCpInneraccount((InnerAccountInfo)this.f7CpInnerAccount.getValue());
        this.storeEntries();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        IntObjectCollection coll = new IntObjectCollection();
        IntObjectInfo info = null;
        IRow row = null;
        int count = this.kdtObject.getRowCount();
        for (int i = 0; i < count; ++i) {
            info = (IntObjectInfo)this.editData.clone();
            row = this.kdtObject.getRow(i);
            info.setSourceId(row.getCell(0).getValue().toString());
            info.setNumber(row.getCell(1).getValue().toString());
            info.setName(row.getCell(2).getValue().toString());
            info.setApplyUnit(this.getApplyUnit(info));
            coll.add(info);
        }
        ((IIntObject)this.getBizInterface()).addBatch(coll);
        this.showSubmitSuccess();
        this.actionSubmit.setEnabled(false);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    private CompanyOrgUnitInfo getApplyUnit(IntObjectInfo info) throws EASBizException, BOSException {
        if (info.getSourceType().equals((Object)IntObjectSourceTypeEnum.INNERACCT)) {
            IInnerAccount innerAcct = InnerAccountFactory.getRemoteInstance();
            InnerAccountInfo acctInfo = innerAcct.getInnerAccountInfo((IObjectPK)new ObjectUuidPK(info.getSourceId()));
            return acctInfo.getApplyUnit();
        }
        return null;
    }

    @Override
    protected IObjectValue createNewData() {
        IntObjectInfo info = new IntObjectInfo();
        Date currDate = new Date(System.currentTimeMillis());
        info.setEffectiveDate(DateTimeUtils.truncateDate((Date)currDate));
        info.setLastSettledDate(DateTimeUtils.truncateDate((Date)currDate));
        if ("INNER".equals(this.type)) {
            info.setSourceType(IntObjectSourceTypeEnum.INNERACCT);
        } else if ("OUTER".equalsIgnoreCase(this.type)) {
            info.setSourceType(IntObjectSourceTypeEnum.GLACCT);
        }
        CurrencyInfo currency = new CurrencyInfo();
        try {
            currency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.currCompanyInfo);
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.handUIExceptionAndAbort(e);
        }
        info.setCurrency(currency);
        info.setUnitAmt(UNIT_AMT_DEFAULT);
        info.setInitialAccumula(Constants.ZERO);
        info.setRateRuleEnum(IntRateRuleEnum.CURRENT);
        info.setCompany(this.currCompanyInfo);
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setDepositRate(new IntObjectBPDepositInfo());
        info.getDepositRate().setRate(Constants.ZERO);
        info.setFinanceAttr(new IntObjectFinanceInfo());
        return info;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("scheme.*"));
        sic.add(new SelectorItemInfo("type.id"));
        sic.add(new SelectorItemInfo("type.name"));
        sic.add(new SelectorItemInfo("type.number"));
        sic.add(new SelectorItemInfo("depositRate.*"));
        sic.add(new SelectorItemInfo("loanRate.*"));
        sic.add(new SelectorItemInfo("financeAttr.*"));
        sic.add(new SelectorItemInfo("financeAttr.accuralAccount.id"));
        sic.add(new SelectorItemInfo("financeAttr.accuralAccount.number"));
        sic.add(new SelectorItemInfo("financeAttr.accuralAccount.name"));
        sic.add(new SelectorItemInfo("financeAttr.recPayedAcct.id"));
        sic.add(new SelectorItemInfo("financeAttr.recPayedAcct.number"));
        sic.add(new SelectorItemInfo("financeAttr.recPayedAcct.name"));
        sic.add(new SelectorItemInfo("financeAttr.recPayableAcct.id"));
        sic.add(new SelectorItemInfo("financeAttr.recPayableAcct.number"));
        sic.add(new SelectorItemInfo("financeAttr.recPayableAcct.name"));
        sic.add(new SelectorItemInfo("financeAttr.overAccount.id"));
        sic.add(new SelectorItemInfo("financeAttr.overAccount.number"));
        sic.add(new SelectorItemInfo("financeAttr.overAccount.name"));
        sic.add(new SelectorItemInfo("financeAttr.arrearAccount.id"));
        sic.add(new SelectorItemInfo("financeAttr.arrearAccount.number"));
        sic.add(new SelectorItemInfo("financeAttr.arrearAccount.name"));
        sic.add(new SelectorItemInfo("financeAttr.feeAccount.id"));
        sic.add(new SelectorItemInfo("financeAttr.feeAccount.number"));
        sic.add(new SelectorItemInfo("financeAttr.feeAccount.name"));
        sic.add(new SelectorItemInfo("financeAttr.taxAccount.id"));
        sic.add(new SelectorItemInfo("financeAttr.taxAccount.number"));
        sic.add(new SelectorItemInfo("financeAttr.taxAccount.name"));
        sic.add(new SelectorItemInfo("financeAttr.settledBankAccount.id"));
        sic.add(new SelectorItemInfo("financeAttr.settledBankAccount.number"));
        sic.add(new SelectorItemInfo("financeAttr.settledBankAccount.name"));
        sic.add(new SelectorItemInfo("financeAttr.cpInneraccount.id"));
        sic.add(new SelectorItemInfo("financeAttr.cpInneraccount.number"));
        sic.add(new SelectorItemInfo("financeAttr.cpInneraccount.name"));
        return sic;
    }

    @Override
    protected void pkEffectiveDate_dataChanged(DataChangeEvent e) throws Exception {
        Date effectiveDate = (Date)this.pkEffectiveDate.getValue();
        this.pkLastSettledDate.setValue((Object)effectiveDate);
    }

    @Override
    protected void comboSourceType_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 1) {
            this.setCtrlPropertiesBySourceType();
        }
    }

    private void setCtrlPropertiesBySourceType() {
        IntObjectSourceTypeEnum sourceType = (IntObjectSourceTypeEnum)((Object)this.comboSourceType.getSelectedItem());
        this.contInAccountType.setVisible(false);
        this.contCpInnerAccount.setVisible(false);
        if (sourceType.equals((Object)IntObjectSourceTypeEnum.GLACCT)) {
            this.chkIsTaxable.setEnabled(true);
            this.chkIsTaxableLeijin.setEnabled(true);
            this.prmtSettledAccount.setEnabled(true);
            this.prmtRecPayedAcct.setEnabled(false);
            this.setRecPayedF7View(false);
        } else if (sourceType.equals((Object)IntObjectSourceTypeEnum.BANKACCT) || sourceType.equals((Object)IntObjectSourceTypeEnum.BANKSTATE)) {
            this.chkIsTaxable.setEnabled(true);
            this.chkIsTaxableLeijin.setEnabled(true);
            this.prmtSettledAccount.setEnabled(true);
            this.prmtRecPayedAcct.setEnabled(false);
            this.setRecPayedF7View(false);
        } else if (sourceType.equals((Object)IntObjectSourceTypeEnum.INNERACCT)) {
            this.chkIsTaxable.setSelected(false);
            this.chkIsTaxable.setEnabled(false);
            this.txtTaxRate.setValue(null);
            this.chkIsTaxableLeijin.setSelected(false);
            this.chkIsTaxableLeijin.setEnabled(false);
            this.txtTaxRateLeijin.setValue(null);
            this.prmtSettledAccount.setData(null);
            this.prmtSettledAccount.setEnabled(false);
            this.prmtRecPayedAcct.setEnabled(true);
            this.contInAccountType.setVisible(true);
            this.contCpInnerAccount.setVisible(true);
            this.setRecPayedF7View(true);
        }
        this.handler.setSourceIdBySourceType(sourceType, this.prmtObject);
        this.setFinanceProperty();
    }

    private void setFinanceProperty() {
        this.prmtAccuralAccount.setData(null);
        this.prmtRecPayableAcct.setData(null);
        this.prmtRecPayedAcct.setData(null);
        this.prmtOverAccount.setData(null);
        this.prmtTaxAccount.setData(null);
        this.prmtSettledAccount.setData(null);
    }

    @Override
    protected void btnFindObject_actionPerformed(ActionEvent e) throws Exception {
        this.prmtObject.setDataBySelector();
    }

    @Override
    protected void prmtObject_willShow(SelectorEvent e) throws Exception {
        FilterInfo filterInfo = new FilterInfo();
        if (!this.prmtObject.getEntityViewInfo().getFilter().toString().contains("linkIntObject")) {
            filterInfo.getFilterItems().add(new FilterItemInfo("linkIntObject", (Object)Boolean.FALSE));
            this.prmtObject.getEntityViewInfo().getFilter().mergeFilter(filterInfo, "AND");
            this.prmtObject.getQueryAgent().resetRuntimeEntityView();
        }
    }

    @Override
    protected void btnDeleteObject_actionPerformed(ActionEvent e) throws Exception {
        int size = this.kdtObject.getSelectManager().size();
        if (size == 0 || this.kdtObject.getSelectManager().getActiveRowIndex() < 0) {
            return;
        }
        KDTSelectBlock selectBlock = null;
        for (int i = size - 1; i >= 0; --i) {
            selectBlock = this.kdtObject.getSelectManager().get(i);
            for (int j = selectBlock.getBottom(); j >= selectBlock.getTop(); --j) {
                this.kdtObject.removeRow(j);
            }
        }
        if (this.kdtObject.getRowCount() == 0 && "OUTER".equalsIgnoreCase(this.type)) {
            this.comboSourceType.setEnabled(true);
        }
    }

    @Override
    protected void prmtObject_dataChanged(DataChangeEvent e) throws Exception {
        Object newValue = e.getNewValue();
        if (newValue != null && newValue instanceof Object[] && ((Object[])newValue).length > 0 && ((Object[])newValue)[0] != null) {
            this.comboSourceType.setEnabled(false);
            Set idSet = this.handler.getIntObjectIdSet(this.kdtObject);
            Object[] obj = (Object[])newValue;
            int len = obj.length;
            for (int i = 0; i < len; ++i) {
                DataBaseInfo info;
                String id;
                if (!(obj[i] instanceof DataBaseInfo) || idSet.contains(id = (info = (DataBaseInfo)obj[i]).getId().toString())) continue;
                String number = info.getNumber();
                String name = info.getName();
                IRow row = this.kdtObject.addRow();
                row.getCell(0).setValue((Object)id);
                row.getCell(1).setValue((Object)number);
                row.getCell(2).setValue((Object)name);
            }
        }
    }

    @Override
    protected void pkLastSettledDate_dataChanged(DataChangeEvent e) throws Exception {
        Date effectiveDate = DateTimeUtils.truncateDate((Date)((Date)this.pkEffectiveDate.getValue()));
        Date lastSettledDate = DateTimeUtils.truncateDate((Date)((Date)this.pkLastSettledDate.getValue()));
        if (effectiveDate == null || lastSettledDate == null) {
            return;
        }
        int compareValue = lastSettledDate.compareTo(effectiveDate);
        if (compareValue < 0) {
            this.chkIsPromisssory.setSelected(false);
            this.chkIsPromisssory.setEnabled(false);
            this.txtInitialAccumula.setEnabled(true);
        } else if (compareValue == 0) {
            this.chkIsPromisssory.setEnabled(true);
            this.txtInitialAccumula.setNumberValue((Number)INITIAL_ACCUMULA_DEFAULT);
            this.txtInitialAccumula.setEnabled(false);
        } else {
            this.chkIsPromisssory.setEnabled(true);
            this.txtInitialAccumula.setEnabled(false);
        }
    }

    @Override
    protected void chkIsPromisssory_stateChanged(ChangeEvent e) throws Exception {
        boolean flag = this.chkIsPromisssory.isSelected();
        this.txtQuota.setEnabled(flag);
        this.txtProRate.setEnabled(flag);
        if (flag) {
            this.txtQuota.setValue((Object)DESPOSIT_QUOTA_DEFAULT);
        } else {
            this.txtQuota.setValue((Object)Constants.ZERO);
            this.txtProRate.setValue((Object)Constants.ZERO);
        }
    }

    @Override
    protected void chkIsOverdraft_stateChanged(ChangeEvent e) throws Exception {
        super.chkIsOverdraft_stateChanged(e);
        boolean flag = this.chkIsOverdraft.isSelected();
        this.txtOverDraftRate.setEnabled(flag);
        if (!flag) {
            this.txtOverDraftRate.setValue((Object)Constants.ZERO);
        }
    }

    @Override
    protected void chkIsTaxable_stateChanged(ChangeEvent e) throws Exception {
        super.chkIsTaxable_stateChanged(e);
        boolean flag = this.chkIsTaxable.isSelected();
        this.txtTaxRate.setEnabled(flag);
        if (flag) {
            this.txtTaxRate.setValue((Object)TAX_RATE_DEFAULT);
        } else {
            this.txtTaxRate.setValue((Object)Constants.ZERO);
        }
    }

    protected void verifyInput(ActionEvent arg0) throws Exception {
        super.verifyInput(arg0);
        this.handler.verifyInfoData((CoreUIObject)this, this.editData, true);
    }

    private void setPropertyReadOnly(boolean enable) {
        this.pkEffectiveDate.setEnabled(!enable);
        this.comboCurrency.setEnabled(!enable);
        this.pkLastSettledDate.setEnabled(!enable);
        this.txtInitialAccumula.setEnabled(!enable);
    }

    @Override
    protected void prmtSettledAccount_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtSettledAccount_dataChanged(e);
        if (e.getNewValue() != null) {
            this.setRecPayedAcctBySettledAccount(e.getNewValue());
        }
    }

    private void setRecPayedAcctBySettledAccount(Object o) throws BOSException, EASBizException {
        AccountBankInfo accountBankInfo = (AccountBankInfo)o;
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("account.*");
        accountBankInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountBankInfo.getId()), selectors);
        this.prmtRecPayedAcct.setData((Object)accountBankInfo.getAccount());
    }

    @Override
    protected void prmtType_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtType_dataChanged(e);
        if (!FMHelper.isEmpty((CoreBaseInfo)((CoreBaseInfo)e.getNewValue()))) {
            IntRateTypeInfo rateType = this.getRateTypeInfo(e);
            this.txtDepositBp.setPrecision(rateType.getPrecision());
        }
    }

    private IntRateTypeInfo getRateTypeInfo(DataChangeEvent e) throws BOSException, EASBizException {
        IntRateTypeInfo rateType = (IntRateTypeInfo)e.getNewValue();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("id");
        selectors.add("precision");
        rateType = IntRateTypeFactory.getRemoteInstance().getIntRateTypeInfo((IObjectPK)new ObjectUuidPK(rateType.getId()), selectors);
        return rateType;
    }

    public void onShow() throws Exception {
        super.onShow();
        FMClientHelper.setFirstFocus((Component[])new Component[]{this.pkEffectiveDate});
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    protected void prmtAccuralAccount_willShow(SelectorEvent e) throws Exception {
        super.prmtAccuralAccount_willShow(e);
        this.checkIntObjIsNull(e);
    }

    private void checkIntObjIsNull(SelectorEvent e) {
        if (this.prmtObject.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)IMUtil.getResString("selectIntObjectFirst"));
            e.setCanceled(true);
        }
    }

    @Override
    protected void prmtOverAccount_willShow(SelectorEvent e) throws Exception {
        super.prmtOverAccount_willShow(e);
        this.checkIntObjIsNull(e);
    }

    @Override
    protected void prmtRecPayableAcct_willShow(SelectorEvent e) throws Exception {
        super.prmtRecPayableAcct_willShow(e);
        this.checkIntObjIsNull(e);
    }

    @Override
    protected void prmtRecPayedAcct_willShow(SelectorEvent e) throws Exception {
        super.prmtRecPayedAcct_willShow(e);
        this.checkIntObjIsNull(e);
    }

    @Override
    protected void prmtSettledAccount_willShow(SelectorEvent e) throws Exception {
        super.prmtSettledAccount_willShow(e);
        this.checkIntObjIsNull(e);
    }

    @Override
    protected void prmtTaxAccount_willShow(SelectorEvent e) throws Exception {
        super.prmtTaxAccount_willShow(e);
        this.checkIntObjIsNull(e);
    }

    @Override
    protected void comboInAccountType_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 2) {
            return;
        }
        this.setInnerAcctFilter();
    }

    private void setInnerAcctFilter() {
        EntityViewInfo evi = new EntityViewInfo();
        if (this.comboInAccountType.getSelectedItem() == InAccountTypeEnum.PostAccount) {
            FilterInfo filterInfo = new FilterInfo();
            Set intObjectIdSet = this.handler.getIntObjectIdSet(this.kdtObject);
            if (intObjectIdSet != null && !intObjectIdSet.isEmpty()) {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)intObjectIdSet, CompareType.NOTINCLUDE));
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("isUsed", (Object)Boolean.TRUE));
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString()));
            evi.setFilter(filterInfo);
            this.f7CpInnerAccount.setData(null);
        } else if (this.comboInAccountType.getSelectedItem() == InAccountTypeEnum.TurnProfileAndLoss) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString()));
            evi.setFilter(fi);
        }
        this.f7CpInnerAccount.setEntityViewInfo(evi);
    }

    @Override
    protected void f7CpInnerAccount_willCommit(CommitEvent e) throws Exception {
        this.setInnerAcctFilter();
    }

    @Override
    protected void f7CpInnerAccount_willShow(SelectorEvent e) throws Exception {
        this.setInnerAcctFilter();
    }

    private void initLeijinPanel() throws Exception {
        if (this.editData.getCalculateType() != null) {
            this.comboCaluType.setSelectedItem((Object)this.editData.getCalculateType());
        } else {
            this.comboCaluType.setSelectedItem((Object)IntObjectTypeEnum.standard);
        }
        boolean isStandared = this.comboCaluType.getSelectedItem() == IntObjectTypeEnum.standard;
        this.actionAddDepositLine.setEnabled(!isStandared && this.chkXieding.isSelected());
        this.actionDelDepositLine.setEnabled(!isStandared && this.chkXieding.isSelected());
        this.actionAddOverDraftLine.setEnabled(!isStandared && this.chkTouzhi.isSelected());
        this.actionDelOverDraftLine.setEnabled(!isStandared && this.chkTouzhi.isSelected());
        this.handler.initSubTable(this.tableDeposit);
        if (!this.chkXieding.isSelected()) {
            if (this.tableDeposit.getRowCount() == 0) {
                IRow row = this.tableDeposit.addRow();
                row.getCell("subAmount").setValue((Object)Constants.ZERO);
                row.getCell("subRate").setValue((Object)Constants.ZERO);
                row.getCell("subAmount").getStyleAttributes().setLocked(true);
            }
            this.tableDeposit.getRow(0).getCell("subAmount").getStyleAttributes().setLocked(true);
        }
        this.handler.initSubTable(this.tableOverDraft);
    }

    @Override
    protected void comboCaluType_itemStateChanged(ItemEvent e) throws Exception {
        if (this.comboCaluType.getSelectedItem() != null) {
            IntObjectTypeEnum type = (IntObjectTypeEnum)((Object)this.comboCaluType.getSelectedItem());
            if (IntObjectTypeEnum.progression != type) {
                this.pnlBPDeposit.setVisible(true);
                this.plnLeijin.setVisible(false);
            } else {
                this.pnlBPDeposit.setVisible(false);
                this.plnLeijin.setVisible(true);
            }
        }
    }

    @Override
    public void actionAddDepositLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddDepositLine_actionPerformed(e);
        IRow row = this.tableDeposit.addRow(this.tableDeposit.getRowCount() - 1);
        row.getCell("subAmount").setValue((Object)Constants.ZERO);
        row.getCell("subRate").setValue((Object)Constants.ZERO);
    }

    @Override
    public void actionDelDepositLine_actionPerformed(ActionEvent e) throws Exception {
        int rowToBeDelete = 0;
        KDTable subTable = this.tableDeposit;
        if (this.chkXieding.isSelected()) {
            if (subTable.getRowCount() <= 2) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.im.IMAutoGenerateResource", (String)"5_IntObjectAddBatchUI"));
                SysUtil.abort();
            }
            if (this.confirmRemove()) {
                IntObjectHandler.removeSubTableLine(subTable);
            }
        } else {
            if (subTable.getRowCount() <= 1) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.im.IMAutoGenerateResource", (String)"6_IntObjectAddBatchUI"));
                SysUtil.abort();
            }
            if (this.confirmRemove()) {
                rowToBeDelete = subTable.getRowCount() - 1;
                subTable.removeRow(rowToBeDelete);
            }
        }
    }

    @Override
    public void actionAddOverDraftLine_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.tableOverDraft.addRow(this.tableOverDraft.getRowCount() - 1);
        row.getCell("subAmount").setValue((Object)Constants.ZERO);
        row.getCell("subRate").setValue((Object)Constants.ZERO);
    }

    @Override
    public void actionDelOverDraftLine_actionPerformed(ActionEvent e) throws Exception {
        boolean rowToBeDelete = false;
        KDTable subTable = this.tableOverDraft;
        if (this.chkTouzhi.isSelected()) {
            if (subTable.getRowCount() <= 2) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.im.IMAutoGenerateResource", (String)"7_IntObjectAddBatchUI"));
                SysUtil.abort();
            }
            if (this.confirmRemove()) {
                IntObjectHandler.removeSubTableLine(subTable);
            }
        }
    }

    @Override
    protected void chkXieding_stateChanged(ChangeEvent e) throws Exception {
        super.chkXieding_stateChanged(e);
        this.chkXieDingChange();
    }

    private void chkXieDingChange() {
        boolean flag = this.chkXieding.isSelected();
        this.btnAddDeposit.setEnabled(flag);
        this.btnDelDeposit.setEnabled(flag);
        KDTable subtable = this.tableDeposit;
        if (!flag) {
            subtable.removeRows();
            IRow row = subtable.addRow();
            row.getCell("subAmount").setValue((Object)Constants.ZERO);
            row.getCell("subRate").setValue((Object)Constants.ZERO);
            row.getCell("subAmount").getStyleAttributes().setLocked(true);
        } else {
            this.handler.selectXiedingOrOver(subtable);
        }
    }

    @Override
    protected void chkTouzhi_stateChanged(ChangeEvent e) throws Exception {
        super.chkTouzhi_stateChanged(e);
        this.chkTouzhiChange();
    }

    private void chkTouzhiChange() {
        boolean flag = this.chkTouzhi.isSelected();
        this.btnAddOverdraft.setEnabled(flag);
        this.btnDelOverDraft.setEnabled(flag);
        KDTable subtable = this.tableOverDraft;
        if (!flag) {
            this.tableOverDraft.removeRows();
        } else {
            this.handler.selectXiedingOrOver(subtable);
        }
    }

    @Override
    protected void chkIsTaxableLeijin_stateChanged(ChangeEvent e) throws Exception {
        super.chkIsTaxableLeijin_stateChanged(e);
        boolean flag = this.chkIsTaxableLeijin.isSelected();
        this.txtTaxRateLeijin.setEnabled(flag);
        if (flag) {
            this.txtTaxRateLeijin.setValue((Object)TAX_RATE_DEFAULT);
        } else {
            this.txtTaxRateLeijin.setValue((Object)Constants.ZERO);
        }
    }

    private void storeEntries() {
        SubDepositRateEntryCollection coll = new SubDepositRateEntryCollection();
        for (int i = 0; i < this.tableDeposit.getRowCount3(); ++i) {
            IRow entryRow = this.tableDeposit.getRow(i);
            SubDepositRateEntryInfo entryInfo = new SubDepositRateEntryInfo();
            entryInfo.setSeq(i);
            String subAmount = entryRow.getCell("subAmount").getValue().toString();
            String[] tr = subAmount.split(">");
            if (tr != null && tr.length > 1) {
                subAmount = tr[1];
            }
            entryInfo.setSubAmount(new BigDecimal(subAmount));
            if (entryRow.getCell("subRate").getValue() != null) {
                entryInfo.setSubRate(new BigDecimal(entryRow.getCell("subRate").getValue().toString()));
            }
            if (entryInfo == null) continue;
            coll.add(entryInfo);
        }
        this.editData.getSubDepositRate().clear();
        this.editData.getSubDepositRate().addCollection(coll);
        SubOverRateEntryCollection collOver = new SubOverRateEntryCollection();
        for (int i = 0; i < this.tableOverDraft.getRowCount3(); ++i) {
            IRow entryRow = this.tableOverDraft.getRow(i);
            SubOverRateEntryInfo entryInfo = new SubOverRateEntryInfo();
            entryInfo.setSeq(i);
            String subAmount = entryRow.getCell("subAmount").getValue().toString();
            String[] tr = subAmount.split(">");
            if (tr != null && tr.length > 1) {
                subAmount = tr[1];
            }
            entryInfo.setSubAmount(new BigDecimal(subAmount));
            if (entryRow.getCell("subRate").getValue() != null) {
                entryInfo.setSubRate(new BigDecimal(entryRow.getCell("subRate").getValue().toString()));
            }
            if (entryInfo == null) continue;
            collOver.add(entryInfo);
        }
        this.editData.getSubOverRate().clear();
        this.editData.getSubOverRate().addCollection(collOver);
    }

    private void loadEntriesFields() {
        SubDepositRateEntryCollection coll = this.editData.getSubDepositRate();
        this.tableDeposit.removeRows();
        for (int i = 0; i < coll.size(); ++i) {
            IRow row = this.tableDeposit.addRow();
            SubDepositRateEntryInfo info = coll.get(i);
            row.setUserObject((Object)info);
            if (this.editData.isIsPromisssory() && i == coll.size() - 1) {
                row.getCell("subAmount").setValue((Object)info.getSubAmount());
                row.getCell("subAmount").getStyleAttributes().setNumberFormat("%r{!>#,##0.00}f");
                row.getCell("subAmount").getStyleAttributes().setLocked(true);
            } else {
                row.getCell("subAmount").setValue((Object)info.getSubAmount());
            }
            row.getCell("subRate").setValue((Object)info.getSubRate());
        }
        SubOverRateEntryCollection collOver = this.editData.getSubOverRate();
        this.tableOverDraft.removeRows();
        for (int i = 0; i < collOver.size(); ++i) {
            IRow row = this.tableOverDraft.addRow();
            SubOverRateEntryInfo info = collOver.get(i);
            row.setUserObject((Object)info);
            if (this.editData.isIsOverDraft() && i == collOver.size() - 1) {
                row.getCell("subAmount").setValue((Object)info.getSubAmount());
                row.getCell("subAmount").getStyleAttributes().setNumberFormat("%r{!>#,##0.00}f");
                row.getCell("subAmount").getStyleAttributes().setLocked(true);
            } else {
                row.getCell("subAmount").setValue((Object)info.getSubAmount());
            }
            row.getCell("subRate").setValue((Object)info.getSubRate());
        }
    }

    @Override
    protected void tableDeposit_editStopped(KDTEditEvent e) throws Exception {
        if (e.getOldValue() != null && e.getOldValue().equals(e.getValue())) {
            return;
        }
        KDTable subtable = this.tableDeposit;
        this.handler.tableEditStoped(e, subtable);
    }

    @Override
    protected void tableOverDraft_editStopped(KDTEditEvent e) throws Exception {
        if (e.getOldValue() != null && e.getOldValue().equals(e.getValue())) {
            return;
        }
        KDTable subtable = this.tableOverDraft;
        this.handler.tableEditStoped(e, subtable);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtType);
        if (IntObjectTypeEnum.progression == this.comboCaluType.getSelectedItem()) {
            KDTable subtable = this.tableDeposit;
            if (this.chkXieding.isSelected()) {
                this.handler.verifySubTable(subtable);
            } else if (subtable.getRowCount() < 1) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.im.IMAutoGenerateResource", (String)"8_IntObjectAddBatchUI"));
                SysUtil.abort();
            }
            if (this.chkTouzhi.isSelected()) {
                this.handler.verifySubTable(this.tableOverDraft);
            }
        }
    }
}

