/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.plaf.MultiLangIcon;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.common.GLf7Utils;
import com.kingdee.eas.fi.rpt.IReportCacl;
import com.kingdee.eas.fi.rpt.ReportCaclFactory;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.client.CurrencyUtil;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.im.AccrualBillCollection;
import com.kingdee.eas.fm.im.AccrualBillFactory;
import com.kingdee.eas.fm.im.AssItemsCollection;
import com.kingdee.eas.fm.im.AssItemsInfo;
import com.kingdee.eas.fm.im.IMUtil;
import com.kingdee.eas.fm.im.InAccountTypeEnum;
import com.kingdee.eas.fm.im.IntObjectBPDepositInfo;
import com.kingdee.eas.fm.im.IntObjectFactory;
import com.kingdee.eas.fm.im.IntObjectFinanceInfo;
import com.kingdee.eas.fm.im.IntObjectInfo;
import com.kingdee.eas.fm.im.IntObjectSourceTypeEnum;
import com.kingdee.eas.fm.im.IntObjectStateEnum;
import com.kingdee.eas.fm.im.IntObjectTypeEnum;
import com.kingdee.eas.fm.im.IntRateRuleEnum;
import com.kingdee.eas.fm.im.IntRateTypeFactory;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.im.SubDepositRateEntryCollection;
import com.kingdee.eas.fm.im.SubDepositRateEntryInfo;
import com.kingdee.eas.fm.im.SubOverRateEntryCollection;
import com.kingdee.eas.fm.im.SubOverRateEntryInfo;
import com.kingdee.eas.fm.im.client.AbstractIntObjectEditUI;
import com.kingdee.eas.fm.im.client.AccrualBillHandler;
import com.kingdee.eas.fm.im.client.IntObjectHandler;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class IntObjectEditUI
extends AbstractIntObjectEditUI {
    private boolean isAddNew = false;
    protected static final BigDecimal INITIAL_ACCUMULA_DEFAULT = Constants.ZERO;
    protected static final BigDecimal TAX_RATE_DEFAULT = new BigDecimal("20");
    protected static final BigDecimal UNIT_AMT_DEFAULT = Constants.ONE;
    protected static final BigDecimal DESPOSIT_QUOTA_DEFAULT = new BigDecimal("100000");
    public static final String RES_Path = "com.kingdee.eas.fm.im.client.ImResource";
    private static String description = EASResource.getString((String)"com.kingdee.eas.fm.im.client.ImResource", (String)"descriptionMessage");
    protected IntObjectHandler handler;
    private static final Logger logger = CoreUIObject.getLogger(IntObjectEditUI.class);
    private boolean firstEditLoad = false;
    protected CompanyOrgUnitInfo currCompanyInfo = null;
    private String type;
    protected static final int CUSTOMER_GROUP = 1;
    protected static final int SUPPLIER_GROUP = 2;
    protected static final int MATERIAL_GROUP = 3;
    private static Boolean successFlag;

    @Override
    protected void tableDeposit_editValueChanged(KDTEditEvent e) throws Exception {
    }

    @Override
    protected void tableDeposit_editStarted(KDTEditEvent e) throws Exception {
        super.tableDeposit_editStarted(e);
    }

    @Override
    protected void tableDeposit_editStarting(KDTEditEvent e) throws Exception {
        super.tableDeposit_editStarting(e);
    }

    @Override
    protected void tableDeposit_editStopping(KDTEditEvent e) throws Exception {
        super.tableDeposit_editStopping(e);
    }

    @Override
    protected void comboCurrency_actionPerformed(ActionEvent e) throws Exception {
        super.comboCurrency_actionPerformed(e);
        this.setInitPre();
    }

    @Override
    protected void txtUnitAmt_dataChanged(DataChangeEvent e) throws Exception {
        super.txtUnitAmt_dataChanged(e);
        this.setInitPre();
    }

    @Override
    protected void txtUnitAmt_actionPerformed(ActionEvent e) throws Exception {
        super.txtUnitAmt_actionPerformed(e);
        this.setInitPre();
    }

    private void setInitPre() throws Exception {
        int bunit;
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (currencyInfo == null) {
            return;
        }
        BigDecimal unit = this.txtUnitAmt.getBigDecimalValue();
        int precision = FMClientHelper.getPrecOfCurrency((BOSUuid)currencyInfo.getId());
        if (unit != null && unit.signum() > 0 && (bunit = IntObjectHandler.getPowOfX(unit)) < precision) {
            precision = bunit;
        }
        this.txtInitialAccumula.setPrecision(precision);
        this.handler.initAmtEditor(this.tableDeposit, currencyInfo.getId().toString(), "subAmount");
        this.handler.initAmtEditor(this.tableOverDraft, currencyInfo.getId().toString(), "subAmount");
    }

    public IntObjectEditUI() throws Exception {
        if (this.handler == null) {
            this.handler = IntObjectHandler.create();
        }
    }

    public String getUITitle() {
        String title = super.getUITitle();
        return AccrualBillHandler.getTitle(this.type, title);
    }

    public void onLoad() throws Exception {
        if ("ADDNEW".equalsIgnoreCase(this.getOprtState())) {
            this.isAddNew = true;
        }
        if (this.currCompanyInfo == null) {
            this.currCompanyInfo = SysContext.getSysContext().getCurrentFIUnit();
        }
        if (this.getUIContext().get("TYPE") != null) {
            this.type = (String)this.getUIContext().get("TYPE");
        }
        CurrencyUtil.fillCombCurrency((KDComboBox)this.comboCurrency);
        this.handler.initSourceType(this.type, this.comboSourceType);
        super.onLoad();
        this.txtOverDraftRange.setHorizontalAlignment(4);
        this.txtOverDraftRange.setRemoveingZeroInDispaly(true);
        this.txtOverDraftRange.setRemoveingZeroInEdit(true);
        this.txtOverDraftRange.setSupportedEmpty(false);
        this.txtOverDraftRange.setMinimumValue((Comparable)Constants.ZERO);
        this.txtOverDraftRate.setPrecision(3);
        this.txtOverDraftRangeRate.setHorizontalAlignment(4);
        this.txtOverDraftRangeRate.setRemoveingZeroInDispaly(true);
        this.txtOverDraftRangeRate.setRemoveingZeroInEdit(true);
        this.txtOverDraftRangeRate.setSupportedEmpty(false);
        this.txtOverDraftRangeRate.setPrecision(3);
        this.txtDepositBp.setHorizontalAlignment(4);
        this.txtDepositBp.setRemoveingZeroInDispaly(true);
        this.txtDepositBp.setRemoveingZeroInEdit(true);
        this.txtDepositBp.setSupportedEmpty(true);
        this.txtDepositBp.setMaximumValue((Comparable)Constants.TEN_THOUSAND);
        this.txtFloorAmt.setHorizontalAlignment(4);
        this.txtFloorAmt.setRemoveingZeroInDispaly(true);
        this.txtFloorAmt.setRemoveingZeroInEdit(true);
        this.txtFloorAmt.setSupportedEmpty(true);
        this.txtFloorAmt.setMaximumValue((Comparable)Constants.MAX_VALUE);
        this.txtOverDraftRate.setHorizontalAlignment(4);
        this.txtOverDraftRate.setRemoveingZeroInDispaly(true);
        this.txtOverDraftRate.setRemoveingZeroInEdit(true);
        this.txtOverDraftRate.setSupportedEmpty(true);
        this.txtProRate.setHorizontalAlignment(4);
        this.txtProRate.setRemoveingZeroInDispaly(true);
        this.txtProRate.setRemoveingZeroInEdit(true);
        this.txtProRate.setSupportedEmpty(true);
        this.txtProRate.setPrecision(3);
        this.txtQuota.setHorizontalAlignment(4);
        this.txtQuota.setRemoveingZeroInDispaly(true);
        this.txtQuota.setRemoveingZeroInEdit(true);
        this.txtQuota.setSupportedEmpty(true);
        this.txtTaxRate.setHorizontalAlignment(4);
        this.txtTaxRate.setRemoveingZeroInDispaly(true);
        this.txtTaxRate.setRemoveingZeroInEdit(true);
        this.txtTaxRate.setSupportedEmpty(true);
        this.txtTaxRateLeijin.setHorizontalAlignment(4);
        this.txtTaxRateLeijin.setRemoveingZeroInDispaly(true);
        this.txtTaxRateLeijin.setRemoveingZeroInEdit(true);
        this.txtTaxRateLeijin.setSupportedEmpty(true);
        this.txtTaxRateLeijin.setMaximumNumber((Number)Constants.TEN_THOUSAND);
        this.txtInitialAccumula.setHorizontalAlignment(4);
        this.txtInitialAccumula.setRemoveingZeroInDispaly(true);
        this.txtInitialAccumula.setRemoveingZeroInEdit(true);
        this.txtInitialAccumula.setSupportedEmpty(false);
        this.txtInitialAccumula.setMaximumValue((Comparable)Constants.MAX_VALUE);
        this.txtUnitAmt.setHorizontalAlignment(4);
        this.txtUnitAmt.setRemoveingZeroInDispaly(true);
        this.txtUnitAmt.setRemoveingZeroInEdit(true);
        this.txtUnitAmt.setSupportedEmpty(true);
        this.txtUnitAmt.setMaximumValue((Comparable)Constants.MAX_VALUE);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("closed", (Object)Constants.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)Constants.TRUE));
        String curr = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)curr));
        EntityViewInfo evi2 = new EntityViewInfo();
        evi2.setFilter(filter);
        this.f7CpInnerAccount.setEntityViewInfo(evi2);
        this.f7CpInnerAccount.setDisplayFormat("$number$ $name$");
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("cycleType", (Object)String.valueOf(100), CompareType.NOTEQUALS));
        EntityViewInfo evi1 = new EntityViewInfo();
        evi1.setFilter(filter1);
        this.prmtScheme.setEntityViewInfo(evi1);
        this.updateButtonStatus();
        FMClientHelper.clearSeparatorOnToolBar((KDToolBar)this.toolBar);
        this.setFinancePropertyFromEditData();
        KDBizPromptBox prmtBoxAssActType = new KDBizPromptBox();
        prmtBoxAssActType.setQueryInfo("com.kingdee.eas.basedata.master.auxacct.app.AsstActTypeQuery");
        prmtBoxAssActType.setDisplayFormat("$name");
        this.tblAssItem.getColumn("asstActType").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtBoxAssActType));
        this.tblAssItem.getColumn("asstActType").getStyleAttributes().setLocked(true);
        this.tblAssItem.getColumn("toNumber").getStyleAttributes().setHided(!this.isAddNew);
        this.tblAssItem.getColumn("combineNumber").getStyleAttributes().setHided(true);
        this.tblAssItem.getColumn("tableName").getStyleAttributes().setHided(true);
        CoreBaseInfo srcinfo = (CoreBaseInfo)this.getUIContext().get("Source_Info");
        if (srcinfo != null) {
            if (srcinfo instanceof AccountBankInfo) {
                this.comboSourceType.setSelectedItem((Object)IntObjectSourceTypeEnum.BANKACCT);
                this.comboSourceType.setEnabled(true);
                this.comboSourceType.removeAllItems();
                this.comboSourceType.addItem((Object)IntObjectSourceTypeEnum.BANKACCT);
                this.comboSourceType.addItem((Object)IntObjectSourceTypeEnum.BANKSTATE);
                this.comboSourceType.setSelectedItem((Object)IntObjectSourceTypeEnum.BANKACCT);
            } else {
                this.comboSourceType.setSelectedItem((Object)IntObjectSourceTypeEnum.INNERACCT);
                this.comboSourceType.setEnabled(false);
            }
            this.prmtSourceId.setValue((Object)srcinfo);
            this.prmtSourceId.setEnabled(false);
            this.prmtIntInnerAcct.setValue((Object)srcinfo);
            this.prmtIntInnerAcct.setEnabled(false);
        }
        this.initLeijinPanel();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        if (!"INNER".equalsIgnoreCase(this.type)) {
            this.contIntInnerAcct.setVisible(false);
        }
        if (this.getOprtState().equals(OprtState.EDIT) && (this.editData.getSourceType().equals((Object)IntObjectSourceTypeEnum.BANKACCT) || this.editData.getSourceType().equals((Object)IntObjectSourceTypeEnum.BANKSTATE))) {
            this.comboSourceType.setEnabled(true);
            this.comboSourceType.removeItem((Object)IntObjectSourceTypeEnum.GLACCT);
            this.comboSourceType.removeItem((Object)IntObjectSourceTypeEnum.ACCTANDASST);
        }
        try {
            String intRateObjectId;
            boolean existAccrualBill;
            if (null != this.editData && null != this.editData.getId() && (existAccrualBill = this.checkExistAccrualBill(intRateObjectId = this.editData.getId().toString()))) {
                this.pkLastSettledDate.setEnabled(false);
            }
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
    }

    private void setFinancePropertyFromEditData() {
        if (this.editData.getFinanceAttr() != null) {
            this.prmtAccuralAccount.setData((Object)this.editData.getFinanceAttr().getAccuralAccount());
            this.prmtRecPayableAcct.setData((Object)this.editData.getFinanceAttr().getRecPayableAcct());
            this.prmtRecPayedAcct.setData((Object)this.editData.getFinanceAttr().getRecPayedAcct());
            this.prmtOverAccount.setData((Object)this.editData.getFinanceAttr().getOverAccount());
            this.prmtTaxAccount.setData((Object)this.editData.getFinanceAttr().getTaxAccount());
            this.prmtSettledAccount.setData((Object)this.editData.getFinanceAttr().getSettledBankAccount());
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.handler.loadDepositFields(this.editData, this);
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
        this.firstEditLoad = true;
        String sourceId = this.editData.getSourceId();
        String number = this.editData.getNumber();
        String name = this.editData.getName();
        AccountViewInfo info = null;
        if (sourceId != null && !sourceId.equals("")) {
            if (this.editData.getSourceType().equals((Object)IntObjectSourceTypeEnum.GLACCT) || this.editData.getSourceType().equals((Object)IntObjectSourceTypeEnum.ACCTANDASST)) {
                try {
                    info = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(sourceId));
                }
                catch (Exception e) {
                    this.handUIExceptionAndAbort(e);
                }
            } else if (this.editData.getSourceType().equals((Object)IntObjectSourceTypeEnum.BANKACCT) || this.editData.getSourceType().equals((Object)IntObjectSourceTypeEnum.BANKSTATE)) {
                try {
                    info = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(sourceId));
                }
                catch (Exception e) {
                    this.handUIExceptionAndAbort(e);
                }
            } else if (this.editData.getSourceType().equals((Object)IntObjectSourceTypeEnum.INNERACCT)) {
                try {
                    info = InnerAccountFactory.getRemoteInstance().getInnerAccountInfo((IObjectPK)new ObjectUuidPK(sourceId));
                }
                catch (Exception e) {
                    this.handUIExceptionAndAbort(e);
                }
            }
        }
        this.prmtSourceId.setData(info);
        this.firstEditLoad = false;
        this.initButton();
        this.setFinanceF7();
        this.comboInAccountType.setSelectedItem((Object)this.editData.getFinanceAttr().getInAccountType());
        this.f7CpInnerAccount.setValue((Object)this.editData.getFinanceAttr().getCpInneraccount());
        this.txtDesp.setText(description);
        this.txtDesp.setEditable(false);
        if (this.editData.getCalculateType() == IntObjectTypeEnum.standard) {
            this.txtOverDraftRange.setValue((Object)this.editData.getDepositRate().getOverDraftRange());
            this.txtOverDraftRangeRate.setValue((Object)this.editData.getDepositRate().getOverDraftRangeRate());
            this.txtOverDraftRange.setEnabled(this.chkIsOverdraft.isSelected());
        }
        try {
            this.refreshItem(null);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        AssItemsCollection ac = this.editData.getAssItemCol();
        AssItemsInfo infoTmp = null;
        for (int i = 0; i < ac.size(); ++i) {
            infoTmp = ac.get(i);
            try {
                this.tblAssItem.getRow(i).getCell("selected").setValue((Object)infoTmp.isIsSelected());
                this.tblAssItem.getRow(i).getCell("combineNumber").setValue((Object)infoTmp.getCombineNumber());
                if (infoTmp.getFromID() != null && !infoTmp.getFromID().equals("")) {
                    this.tblAssItem.getRow(i).getCell("fromNumber").setValue((Object)EJBAccessFactory.createRemoteInstance().getEntityInfo(infoTmp.getFromID()));
                }
                if (infoTmp.getToID() == null || infoTmp.getToID().equals("")) continue;
                this.tblAssItem.getRow(i).getCell("toNumber").setValue((Object)EJBAccessFactory.createRemoteInstance().getEntityInfo(infoTmp.getToID()));
                continue;
            }
            catch (EASBizException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
                continue;
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
        }
        this.txtName.setSelectedItemData((Object)this.editData.getName());
        Locale local = SysContext.getSysContext().getLocale();
        LanguageInfo lang = null;
        if (local.toString().equalsIgnoreCase("l3")) {
            MultiLangIcon icon = new MultiLangIcon("TW");
            lang = new LanguageInfo(Locale.TAIWAN, (Icon)icon, "TW", Locale.TAIWAN);
        } else {
            lang = local.toString().equalsIgnoreCase("l2") ? new LanguageInfo(Locale.CHINESE) : new LanguageInfo(Locale.ENGLISH);
        }
        MultiLangItem item = new MultiLangItem(lang, this.txtName.getSelectedItemData());
        this.txtName.setSelectedItem((Object)item);
        this.loadEntriesFields();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    private void setFinanceF7() {
        String curCompanyId = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)curCompanyId));
        view.setFilter(filter);
        this.prmtSettledAccount.setEntityViewInfo(view);
        AccountTableInfo accountTable = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getAccountTable();
        String accountTableId = null;
        if (!FMHelper.isEmpty((CoreBaseInfo)accountTable)) {
            accountTableId = accountTable.getId().toString();
        }
        FilterInfo filterInfo1 = new FilterInfo();
        filterInfo1.getFilterItems().add(new FilterItemInfo("PLType", (Object)new Integer(5)));
        filterInfo1.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Constants.TRUE));
        filterInfo1.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Constants.FALSE));
        filterInfo1.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Constants.FALSE));
        filterInfo1.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)curCompanyId));
        if (accountTableId != null) {
            filterInfo1.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTableId));
        }
        EntityViewInfo evi1 = new EntityViewInfo();
        evi1.setFilter(filterInfo1);
        this.prmtAccuralAccount.setEntityViewInfo(evi1);
        this.prmtOverAccount.setEntityViewInfo(evi1);
        FilterInfo filterInfo2 = new FilterInfo();
        filterInfo2.getFilterItems().add(new FilterItemInfo("accountTypeID.property", (Object)FMHelper.asSet((int[])new int[]{0, 1}), CompareType.INCLUDE));
        filterInfo2.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Constants.TRUE));
        filterInfo2.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Constants.FALSE));
        filterInfo2.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Constants.FALSE));
        filterInfo2.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)curCompanyId));
        if (accountTableId != null) {
            filterInfo2.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTableId));
        }
        EntityViewInfo evi2 = new EntityViewInfo();
        evi2.setFilter(filterInfo2);
        this.prmtRecPayableAcct.setEntityViewInfo(evi2);
        FilterInfo filterInfo3 = new FilterInfo();
        filterInfo3.getFilterItems().add(new FilterItemInfo("accountTypeID.property", (Object)new Integer(4)));
        filterInfo3.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Constants.TRUE));
        filterInfo3.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Constants.FALSE));
        filterInfo3.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Constants.FALSE));
        filterInfo3.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)curCompanyId));
        if (accountTableId != null) {
            filterInfo3.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTableId));
        }
        EntityViewInfo evi3 = new EntityViewInfo();
        evi3.setFilter(filterInfo3);
        this.prmtTaxAccount.setEntityViewInfo(evi3);
    }

    private void setRecPayedF7View(boolean isSourceTypeInnerAcct) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (isSourceTypeInnerAcct) {
            HashSet<Integer> values = new HashSet<Integer>();
            values.add(new Integer(0));
            values.add(new Integer(1));
            filterInfo.getFilterItems().add(new FilterItemInfo("accountTypeID.property", values, CompareType.INCLUDE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Constants.TRUE));
        filterInfo.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Constants.FALSE));
        filterInfo.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Constants.FALSE));
        filterInfo.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString()));
        AccountTableInfo accountTable = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getAccountTable();
        if (!FMHelper.isEmpty((CoreBaseInfo)accountTable)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTable.getId().toString()));
        }
        view.setFilter(filterInfo);
        this.prmtRecPayedAcct.setEntityViewInfo(view);
    }

    protected void initButton() {
        this.actionCancelCancel.setEnabled(false);
        this.actionCancel.setEnabled(false);
        if (this.editData != null) {
            if (IntObjectStateEnum.APPROVED.equals((Object)this.editData.getState())) {
                this.actionCancel.setEnabled(true);
            } else if (IntObjectStateEnum.DISABLED.equals((Object)this.editData.getState())) {
                this.actionCancelCancel.setEnabled(true);
            }
        }
    }

    @Override
    public void storeFields() {
        CoreBaseInfo sourceObject;
        super.storeFields();
        this.editData.setName((String)this.txtName.getSelectedItemData());
        if (this.editData.getUnitAmt().compareTo(Constants.ZERO) > 0) {
            BigDecimal unitAmt = this.editData.getUnitAmt();
            BigDecimal initialAccumula = this.editData.getInitialAccumula().divide(unitAmt, 0, 4).multiply(unitAmt);
            this.editData.setInitialAccumula(initialAccumula);
        }
        if (!FMHelper.isEmpty((CoreBaseInfo)(sourceObject = (CoreBaseInfo)this.prmtSourceId.getData()))) {
            this.editData.setSourceId(sourceObject.getId().toString());
        }
        this.editData.setEffectiveDate(DateTimeUtils.truncateDate((Date)this.editData.getEffectiveDate()));
        this.editData.setLastSettledDate(DateTimeUtils.truncateDate((Date)this.editData.getLastSettledDate()));
        if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.EDIT)) {
            this.setNumber();
            if (this.editData.getSourceType() == IntObjectSourceTypeEnum.INNERACCT) {
                CoreBaseInfo info = (CoreBaseInfo)this.getUIContext().get("Source_Info");
                if (info != null) {
                    InnerAccountInfo innerAccountInfo = (InnerAccountInfo)info;
                    this.editData.setApplyUnit(innerAccountInfo.getApplyUnit());
                } else {
                    InnerAccountInfo innerAccountInfo = (InnerAccountInfo)this.prmtSourceId.getData();
                    if (innerAccountInfo != null && innerAccountInfo.getId() != null && innerAccountInfo != null) {
                        SelectorItemCollection selectors = new SelectorItemCollection();
                        selectors.add("*");
                        selectors.add("applyUnit.id");
                        selectors.add("company.id");
                        try {
                            innerAccountInfo = InnerAccountFactory.getRemoteInstance().getInnerAccountInfo((IObjectPK)new ObjectUuidPK(innerAccountInfo.getId()), selectors);
                        }
                        catch (Exception e) {
                            this.handUIExceptionAndAbort(e);
                        }
                        this.editData.setApplyUnit(innerAccountInfo.getApplyUnit());
                    }
                }
            }
        }
        this.handler.storeDepositFields(this.editData, this);
        this.editData.getFinanceAttr().setInAccountType((InAccountTypeEnum)((Object)this.comboInAccountType.getSelectedItem()));
        this.editData.getFinanceAttr().setCpInneraccount((InnerAccountInfo)this.f7CpInnerAccount.getValue());
        if (this.editData.getSourceType() == IntObjectSourceTypeEnum.ACCTANDASST) {
            this.storeTable2VO(this.editData);
        }
        this.storeEntries();
    }

    private void storeTable2VO(IntObjectInfo editData) {
        int rowCount = this.tblAssItem.getRowCount();
        IRow row = null;
        Object obj = null;
        editData.getAssItemCol().clear();
        for (int i = 0; i < rowCount; ++i) {
            String longNumber;
            row = this.tblAssItem.getRow(i);
            AssItemsInfo itemInfo = new AssItemsInfo();
            Boolean isSelected = (Boolean)row.getCell("selected").getValue();
            itemInfo.setIsSelected(isSelected);
            obj = row.getCell("fieldName").getValue();
            itemInfo.setMappingFileds(obj.toString());
            obj = row.getCell("tableName").getValue();
            itemInfo.setTableName(obj.toString());
            obj = row.getCell("asstActType").getValue();
            itemInfo.setAsstActType((AsstActTypeInfo)obj);
            obj = row.getCell("fromNumber").getValue();
            if (obj == null) {
                itemInfo.setFromNumber("");
                itemInfo.setFromID("");
            } else {
                longNumber = ((AbstractObjectValue)obj).getString("longnumber");
                if (!EmptyUtil.isEmpty((String)longNumber)) {
                    longNumber = longNumber.replaceAll("\\!", "\\.");
                }
                itemInfo.setFromNumber(longNumber == null ? ((AbstractObjectValue)obj).getString("number") : longNumber);
                itemInfo.setFromID(AccessHelper.getId((Object)obj));
                itemInfo.setName(((AbstractObjectValue)obj).getString("name"));
            }
            obj = row.getCell("toNumber").getValue();
            if (obj == null) {
                itemInfo.setToNumber(itemInfo.getFromNumber());
                itemInfo.setToID(itemInfo.getFromID());
            } else {
                longNumber = ((AbstractObjectValue)obj).getString("longnumber");
                if (!EmptyUtil.isEmpty((String)longNumber)) {
                    longNumber = longNumber.replaceAll("\\!", "\\.");
                }
                itemInfo.setToNumber(longNumber == null ? ((AbstractObjectValue)obj).getString("number") : longNumber);
                itemInfo.setToID(AccessHelper.getId((Object)obj));
            }
            this.constructDataFromTable(itemInfo, editData, row);
            itemInfo.setIsSelected(isSelected);
            itemInfo.setParent(editData);
            editData.getAssItemCol().add(itemInfo);
        }
    }

    private String retAcctItemStr() {
        Object bin = this.prmtSourceId.getValue();
        Object end = null;
        String thisBin = "";
        String thisEnd = "";
        thisBin = bin instanceof IObjectValue ? (String)((IObjectValue)bin).get("number") : (String)bin;
        thisEnd = end instanceof IObjectValue ? (String)((IObjectValue)end).get("number") : (String)end;
        if (StringUtils.isEmpty((String)thisBin) && StringUtils.isEmpty((String)thisEnd)) {
            return "";
        }
        if (StringUtils.isEmpty((String)thisBin)) {
            return thisEnd;
        }
        if (StringUtils.isEmpty((String)thisEnd)) {
            return thisBin;
        }
        return thisBin + ':' + thisEnd;
    }

    private void constructDataFromTable(AssItemsInfo itemInfo, IntObjectInfo editData, IRow row) {
        String endAssItem;
        StringBuffer sbRetItem = new StringBuffer();
        String assBin = "";
        String assEnd = "";
        assBin = null;
        assEnd = null;
        HashMap item = (HashMap)row.getUserObject();
        if (!itemInfo.isIsSelected()) {
            return;
        }
        String Ass = (String)item.get("number");
        sbRetItem.append(Ass + "|");
        String startAssItem = itemInfo.getFromNumber();
        if (startAssItem != null) {
            if (startAssItem instanceof GeneralAsstActTypeInfo) {
                assBin = (String)((IObjectValue)startAssItem).get("longnumber");
                assBin = assBin.replaceAll("\\!", "\\.");
            } else {
                assBin = startAssItem instanceof IObjectValue ? (String)((IObjectValue)startAssItem).get("number") : startAssItem;
            }
        }
        if ((endAssItem = itemInfo.getToNumber()) != null) {
            if (endAssItem instanceof GeneralAsstActTypeInfo) {
                assEnd = (String)((GeneralAsstActTypeInfo)endAssItem).get("longnumber");
                assEnd = assEnd.replaceAll("\\!", "\\.");
            } else {
                assEnd = endAssItem instanceof IObjectValue ? (String)((IObjectValue)endAssItem).get("number") : endAssItem;
            }
        }
        if (assBin == null && assEnd == null) {
            return;
        }
        if (assBin != null && assBin.trim().length() > 0 && assEnd != null && assEnd.trim().length() > 0) {
            if (assBin.trim().equals(assEnd.trim())) {
                sbRetItem.append(assBin);
            } else {
                sbRetItem.append(assBin + ":" + assEnd);
            }
        }
        if (assBin != null && assBin.trim().length() > 0 && (assEnd == null || assEnd.trim().length() == 0)) {
            sbRetItem.append(assBin + ":");
        }
        if ((assBin == null || assBin.trim().length() == 0) && assEnd != null && assEnd.trim().length() > 0) {
            sbRetItem.append(assEnd);
        }
        itemInfo.setCombineNumber(sbRetItem.toString());
    }

    private void setNumber() {
        if (this.editData.getSourceType() == IntObjectSourceTypeEnum.ACCTANDASST) {
            return;
        }
        String srcNumber = null;
        String id = null;
        if (this.prmtSourceId.getData() == null) {
            return;
        }
        if (this.prmtSourceId.getData() instanceof CoreBillBaseInfo) {
            srcNumber = ((CoreBillBaseInfo)this.prmtSourceId.getData()).getNumber();
            id = ((CoreBillBaseInfo)this.prmtSourceId.getData()).getId().toString();
        } else {
            srcNumber = ((DataBaseInfo)this.prmtSourceId.getData()).getNumber();
            id = ((DataBaseInfo)this.prmtSourceId.getData()).getId().toString();
        }
        if (srcNumber == null) {
            AccountViewInfo srcInfo = null;
            if (id == null) {
                return;
            }
            String srcID = id;
            if (this.editData.getSourceType() == IntObjectSourceTypeEnum.GLACCT) {
                try {
                    srcInfo = AccountViewFactory.getRemoteInstance().getAccountViewInfo("select number where id = '" + srcID + "'");
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            } else if (this.editData.getSourceType() == IntObjectSourceTypeEnum.BANKACCT || this.editData.getSourceType() == IntObjectSourceTypeEnum.BANKSTATE) {
                try {
                    srcInfo = AccountBankFactory.getRemoteInstance().getDataBaseInfo("select number where id = '" + srcID + "'");
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            } else if (this.editData.getSourceType() == IntObjectSourceTypeEnum.INNERACCT) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)srcID));
                try {
                    boolean isexist = InnerAccountFactory.getRemoteInstance().exists(filter);
                    if (isexist) {
                        srcInfo = InnerAccountFactory.getRemoteInstance().getInnerAccountInfo("select number where id = '" + srcID + "'");
                    }
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
            if (!EmptyUtil.isEmpty(srcInfo)) {
                srcNumber = srcInfo.getString("number");
            }
        }
        this.editData.setNumber(srcNumber);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getUIContext().get("related") != null) {
            this.verify(e);
            this.editData.setIsExit(false);
            this.disposeUIWindow();
        } else {
            this.editData.setBatchAddByAssItems(this.isAddNew);
            super.actionSubmit_actionPerformed(e);
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        HashSet<String> idSet = new HashSet<String>();
        String keyValue = this.editData.getId().toString();
        idSet.add(keyValue);
        this.handler.enable((CoreUIObject)this, idSet);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        HashSet<String> idSet = new HashSet<String>();
        String keyValue = this.editData.getId().toString();
        idSet.add(keyValue);
        this.handler.disable((CoreUIObject)this, idSet);
    }

    @Override
    protected String getEditUIName() {
        return IntObjectEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return IntObjectFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        IntObjectInfo info = new IntObjectInfo();
        CoreBaseInfo srcinfo = (CoreBaseInfo)this.getUIContext().get("Source_Info");
        if (srcinfo != null) {
            if (srcinfo instanceof AccountBankInfo) {
                info.setSourceType(IntObjectSourceTypeEnum.BANKACCT);
                this.type = "OUTER";
                info.setName(srcinfo.getString("name"));
                info.setNumber(srcinfo.getString("number"));
                info.setCalculateType(IntObjectTypeEnum.standard);
                this.comboSourceType.setEnabled(true);
                this.comboSourceType.removeAllItems();
                this.comboSourceType.addItem((Object)IntObjectSourceTypeEnum.BANKACCT);
                this.comboSourceType.addItem((Object)IntObjectSourceTypeEnum.BANKSTATE);
                this.comboSourceType.setSelectedItem((Object)IntObjectSourceTypeEnum.BANKACCT);
            } else {
                info.setSourceType(IntObjectSourceTypeEnum.INNERACCT);
                this.type = "INNER";
                info.setName(srcinfo.getString("name"));
                info.setNumber(srcinfo.getString("number"));
                info.setCalculateType(IntObjectTypeEnum.standard);
                this.comboSourceType.setEnabled(false);
            }
            this.prmtSourceId.setEnabled(false);
        } else if ("INNER".equalsIgnoreCase(this.type)) {
            info.setSourceType(IntObjectSourceTypeEnum.INNERACCT);
            info.setCalculateType(IntObjectTypeEnum.standard);
            this.comboSourceType.setEnabled(false);
        } else if ("OUTER".equalsIgnoreCase(this.type)) {
            info.setSourceType(IntObjectSourceTypeEnum.GLACCT);
            info.setCalculateType(IntObjectTypeEnum.standard);
        }
        if (this.editData != null) {
            info.setSourceType(this.editData.getSourceType());
        }
        Date currDate = new Date(System.currentTimeMillis());
        info.setEffectiveDate(DateTimeUtils.truncateDate((Date)currDate));
        info.setLastSettledDate(DateTimeUtils.truncateDate((Date)currDate));
        CurrencyInfo currency = new CurrencyInfo();
        try {
            currency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(ContextHelperFactory.getRemoteInstance().getCurrentCompany());
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        info.setCurrency(currency);
        info.setUnitAmt(UNIT_AMT_DEFAULT);
        info.setInitialAccumula(Constants.ZERO);
        info.setRateRuleEnum(IntRateRuleEnum.CURRENT);
        info.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setDepositRate(new IntObjectBPDepositInfo());
        info.getDepositRate().setRate(Constants.ZERO);
        info.getDepositRate().setOverDraftRange(Constants.ZERO);
        info.getDepositRate().setOverDraftRangeRate(Constants.ZERO);
        info.setFinanceAttr(new IntObjectFinanceInfo());
        info.setIsExit(true);
        return info;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("scheme.*"));
        sic.add(new SelectorItemInfo("type.id"));
        sic.add(new SelectorItemInfo("type.name"));
        sic.add(new SelectorItemInfo("type.number"));
        sic.add(new SelectorItemInfo("depositRate.*"));
        sic.add(new SelectorItemInfo("loanRate.*"));
        sic.add(new SelectorItemInfo("financeAttr.*"));
        sic.add(new SelectorItemInfo("financeAttr.accuralAccount.id"));
        sic.add(new SelectorItemInfo("financeAttr.accuralAccount.number"));
        sic.add(new SelectorItemInfo("financeAttr.accuralAccount.name"));
        sic.add(new SelectorItemInfo("financeAttr.recPayedAcct.id"));
        sic.add(new SelectorItemInfo("financeAttr.recPayedAcct.number"));
        sic.add(new SelectorItemInfo("financeAttr.recPayedAcct.name"));
        sic.add(new SelectorItemInfo("financeAttr.recPayableAcct.id"));
        sic.add(new SelectorItemInfo("financeAttr.recPayableAcct.number"));
        sic.add(new SelectorItemInfo("financeAttr.recPayableAcct.name"));
        sic.add(new SelectorItemInfo("financeAttr.overAccount.id"));
        sic.add(new SelectorItemInfo("financeAttr.overAccount.number"));
        sic.add(new SelectorItemInfo("financeAttr.overAccount.name"));
        sic.add(new SelectorItemInfo("financeAttr.arrearAccount.id"));
        sic.add(new SelectorItemInfo("financeAttr.arrearAccount.number"));
        sic.add(new SelectorItemInfo("financeAttr.arrearAccount.name"));
        sic.add(new SelectorItemInfo("financeAttr.feeAccount.id"));
        sic.add(new SelectorItemInfo("financeAttr.feeAccount.number"));
        sic.add(new SelectorItemInfo("financeAttr.feeAccount.name"));
        sic.add(new SelectorItemInfo("financeAttr.taxAccount.id"));
        sic.add(new SelectorItemInfo("financeAttr.taxAccount.number"));
        sic.add(new SelectorItemInfo("financeAttr.taxAccount.name"));
        sic.add(new SelectorItemInfo("financeAttr.settledBankAccount.id"));
        sic.add(new SelectorItemInfo("financeAttr.settledBankAccount.number"));
        sic.add(new SelectorItemInfo("financeAttr.settledBankAccount.name"));
        sic.add(new SelectorItemInfo("financeAttr.cpInneraccount.id"));
        sic.add(new SelectorItemInfo("financeAttr.cpInneraccount.number"));
        sic.add(new SelectorItemInfo("financeAttr.cpInneraccount.name"));
        sic.add(new SelectorItemInfo("assItemCol.*"));
        sic.add(new SelectorItemInfo("assItemCol.asstActType.*"));
        sic.add(new SelectorItemInfo("subDepositRate.*"));
        sic.add(new SelectorItemInfo("subDepositRate.subAmount"));
        sic.add(new SelectorItemInfo("subOverRate.*"));
        sic.add(new SelectorItemInfo("intInnerAccount.id"));
        sic.add(new SelectorItemInfo("intInnerAccount.number"));
        sic.add(new SelectorItemInfo("intInnerAccount.name"));
        return sic;
    }

    @Override
    protected void pkEffectiveDate_dataChanged(DataChangeEvent e) throws Exception {
        String intRateObjectId;
        boolean existAccrualBill;
        Date effectiveDate = (Date)this.pkEffectiveDate.getValue();
        if (this.oprtState.equals(OprtState.EDIT) && null != this.editData && null != this.editData.getId() && (existAccrualBill = this.checkExistAccrualBill(intRateObjectId = this.editData.getId().toString()))) {
            return;
        }
        this.pkLastSettledDate.setValue((Object)effectiveDate);
    }

    private boolean checkExistAccrualBill(String intRateObjectId) throws BOSException {
        boolean existAccrualBill = false;
        IntObjectSourceTypeEnum selectedSourceType = (IntObjectSourceTypeEnum)((Object)this.comboSourceType.getSelectedItem());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("intRateObject.id", (Object)intRateObjectId, CompareType.EQUALS));
        view.setFilter(filter);
        AccrualBillCollection existList = AccrualBillFactory.getRemoteInstance().getAccrualBillCollection(view);
        if (!existList.isEmpty()) {
            existAccrualBill = true;
        }
        return existAccrualBill;
    }

    protected void comboBizType_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 1) {
            this.setFinanceProperty();
            this.setFinanceF7();
        }
        this.setCursorOfDefault();
    }

    @Override
    protected void comboSourceType_itemStateChanged(ItemEvent e) throws Exception {
        IntObjectSourceTypeEnum selectedSourceType;
        if (e.getStateChange() == 1) {
            boolean noNeedCleanSourceIdFlag;
            boolean bl = noNeedCleanSourceIdFlag = (e.getItem().equals((Object)IntObjectSourceTypeEnum.BANKACCT) || e.getItem().equals((Object)IntObjectSourceTypeEnum.BANKSTATE)) && this.comboSourceType.getItemCount() == 2;
            if (!noNeedCleanSourceIdFlag) {
                this.setCtrlPropertiesBySourceType();
            }
        }
        if ((selectedSourceType = (IntObjectSourceTypeEnum)((Object)this.comboSourceType.getSelectedItem())) == IntObjectSourceTypeEnum.ACCTANDASST) {
            this.tabPanel.setVisibleAt(2, true);
            this.tabPanel.setEnabledAt(2, true);
        } else {
            this.tabPanel.setVisibleAt(2, false);
            this.tabPanel.setEnabledAt(2, false);
            this.tblAssItem.removeRows();
            this.tabPanel.setSelectedIndex(0);
        }
    }

    private void setCtrlPropertiesBySourceType() throws EASBizException, BOSException {
        this.prmtSourceId.setData(null);
        this.txtName.setSelectedItemData(null);
        IntObjectSourceTypeEnum selectedSourceType = (IntObjectSourceTypeEnum)((Object)this.comboSourceType.getSelectedItem());
        this.contInAccountType.setVisible(false);
        this.contCpInnerAccount.setVisible(false);
        if (selectedSourceType.equals((Object)IntObjectSourceTypeEnum.GLACCT)) {
            this.chkIsTaxable.setEnabled(true);
            this.chkIsTaxableLeijin.setEnabled(true);
            this.prmtSettledAccount.setEnabled(true);
            this.setRecPayedF7View(false);
        } else if (selectedSourceType.equals((Object)IntObjectSourceTypeEnum.BANKACCT) || selectedSourceType.equals((Object)IntObjectSourceTypeEnum.BANKSTATE)) {
            this.chkIsTaxable.setEnabled(true);
            this.chkIsTaxableLeijin.setEnabled(true);
            this.prmtSettledAccount.setEnabled(true);
            this.setRecPayedF7View(false);
        } else if (selectedSourceType.equals((Object)IntObjectSourceTypeEnum.INNERACCT)) {
            this.chkIsTaxable.setSelected(false);
            this.chkIsTaxable.setEnabled(false);
            this.txtTaxRate.setValue(null);
            this.chkIsTaxableLeijin.setSelected(false);
            this.chkIsTaxableLeijin.setEnabled(false);
            this.txtTaxRateLeijin.setValue(null);
            this.prmtSettledAccount.setData(null);
            this.prmtSettledAccount.setEnabled(false);
            this.contInAccountType.setVisible(true);
            this.contCpInnerAccount.setVisible(true);
            this.setRecPayedF7View(true);
        }
        this.handler.setSourceIdBySourceType((IntObjectSourceTypeEnum)((Object)this.comboSourceType.getSelectedItem()), this.prmtSourceId);
        this.handler.setIntInnerAcctBySourceTypeAndSourceId((IntObjectSourceTypeEnum)((Object)this.comboSourceType.getSelectedItem()), this.prmtSourceId, this.prmtIntInnerAcct);
        this.setFinanceProperty();
    }

    @Override
    protected void prmtSourceId_dataChanged(DataChangeEvent e) throws Exception {
        if (this.firstEditLoad) {
            return;
        }
        Object info = this.prmtSourceId.getData();
        if (info == null) {
            this.tblAssItem.removeRows();
            this.txtName.setSelectedItemData((Object)"");
            return;
        }
        if (this.getUIContext().get("related") != null) {
            return;
        }
        String name = this.handler.getIdNamebyIntObject(info, "name");
        this.txtName.setSelectedItemData((Object)name);
        this.setFinanceProperty();
        this.handler.setIntInnerAcctBySourceTypeAndSourceId((IntObjectSourceTypeEnum)((Object)this.comboSourceType.getSelectedItem()), this.prmtSourceId, this.prmtIntInnerAcct);
        this.setAssItems();
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.prmtIntInnerAcct.setData(info);
        }
    }

    private void setAssItems() throws Exception {
        Object info;
        IntObjectSourceTypeEnum selectedSourceType = (IntObjectSourceTypeEnum)((Object)this.comboSourceType.getSelectedItem());
        if (selectedSourceType == IntObjectSourceTypeEnum.ACCTANDASST && (info = this.prmtSourceId.getValue()) instanceof AccountViewInfo) {
            this.refreshItem(null);
        }
        this.repaint();
    }

    private void refreshItem(AcctountAsstItemParser.AsstItem[] items) throws Exception {
        if ((IntObjectSourceTypeEnum)((Object)this.comboSourceType.getSelectedItem()) != IntObjectSourceTypeEnum.ACCTANDASST) {
            return;
        }
        IReportCacl facade = ReportCaclFactory.getRemoteInstance();
        AccountViewInfo selectedAccountView = (AccountViewInfo)this.prmtSourceId.getValue();
        String accountFrom = "";
        String accountTo = "";
        if (selectedAccountView != null) {
            accountFrom = selectedAccountView.getNumber();
            accountTo = selectedAccountView.getNumber();
        }
        if (StringUtils.isEmpty((String)accountFrom) && StringUtils.isEmpty((String)accountTo)) {
            return;
        }
        if (StringUtils.isEmpty((String)accountFrom)) {
            accountFrom = accountTo;
        } else if (StringUtils.isEmpty((String)accountTo)) {
            accountTo = accountFrom;
        }
        HashMap result = facade.getAsstItems(accountFrom, accountTo, this.getCompany().getId().toString(), selectedAccountView.getAccountTableID().getId().toString());
        ArrayList currentItems = (ArrayList)result.get("items");
        this.tblAssItem.removeRows();
        if (currentItems == null || currentItems.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.im.IMAutoGenerateResource", (String)"9_IntObjectEditUI"));
            this.prmtSourceId.requestFocus();
            SysUtil.abort();
        }
        Iterator iter = currentItems.iterator();
        StringBuffer nameAppend = new StringBuffer();
        while (iter.hasNext()) {
            HashMap item = (HashMap)iter.next();
            IRow row = this.tblAssItem.addRow();
            row.setUserObject((Object)item);
            AsstActTypeInfo info = AsstActTypeFactory.getRemoteInstance().getAsstActTypeInfo((IObjectPK)new ObjectUuidPK((String)item.get("id")));
            row.getCell("asstActType").setValue((Object)info);
            nameAppend.append(info.getName()).append("+");
            KDBizPromptBox prmtBox = new KDBizPromptBox();
            prmtBox.setSelector(null);
            prmtBox.setFilterInfoProducer(null);
            prmtBox.setDisplayFormat("$name");
            prmtBox.setEditFormat("$number");
            prmtBox.setCommitFormat("$number");
            GLf7Utils.assignSelector((KDBizPromptBox)prmtBox, (AsstActTypeInfo)info, (CoreUIObject)this);
            row.getCell("fromNumber").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtBox));
            KDBizPromptBox prmtBoxTo = new KDBizPromptBox();
            prmtBoxTo.setSelector(null);
            prmtBoxTo.setFilterInfoProducer(null);
            prmtBoxTo.setDisplayFormat("$name");
            prmtBoxTo.setEditFormat("$name");
            prmtBoxTo.setCommitFormat("$name");
            GLf7Utils.assignSelector((KDBizPromptBox)prmtBoxTo, (AsstActTypeInfo)info, (CoreUIObject)this);
            row.getCell("toNumber").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtBoxTo));
            row.getCell("selected").setValue((Object)Boolean.TRUE);
            String fieldName = (String)item.get("fieldname");
            row.getCell("fieldName").setValue((Object)fieldName);
            String tablename = (String)item.get("tablename");
            row.getCell("tableName").setValue((Object)tablename);
            row.getCell("id").setValue((Object)((String)item.get("id")));
        }
        Object info = this.prmtSourceId.getData();
        String name = this.handler.getIdNamebyIntObject(info, "name");
        this.txtName.setSelectedItemData((Object)name);
    }

    private CompanyOrgUnitInfo getCompany() {
        return ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    }

    private void setFinanceProperty() {
        this.prmtAccuralAccount.setData(null);
        this.prmtRecPayableAcct.setData(null);
        this.prmtRecPayedAcct.setData(null);
        this.prmtOverAccount.setData(null);
        this.prmtTaxAccount.setData(null);
        this.prmtSettledAccount.setData(null);
    }

    @Override
    protected void pkLastSettledDate_dataChanged(DataChangeEvent e) throws Exception {
        String intRateObjectId;
        boolean existAccrualBill;
        if (this.oprtState.equals(OprtState.EDIT) && null != this.editData && null != this.editData.getId() && (existAccrualBill = this.checkExistAccrualBill(intRateObjectId = this.editData.getId().toString()))) {
            this.setMessageText(EASResource.getString((String)RES_Path, (String)"CannotModifyPkLastSettledDate"));
            this.showMessage();
            return;
        }
        Date effectiveDate = DateTimeUtils.truncateDate((Date)((Date)this.pkEffectiveDate.getValue()));
        Date lastSettledDate = DateTimeUtils.truncateDate((Date)((Date)this.pkLastSettledDate.getValue()));
        if (effectiveDate == null || lastSettledDate == null) {
            return;
        }
        int compareValue = lastSettledDate.compareTo(effectiveDate);
        if (compareValue < 0) {
            this.chkIsPromisssory.setSelected(false);
            this.chkIsPromisssory.setEnabled(false);
            this.txtInitialAccumula.setEnabled(true);
        } else if (compareValue == 0) {
            this.chkIsPromisssory.setEnabled(true);
            this.txtInitialAccumula.setNumberValue((Number)INITIAL_ACCUMULA_DEFAULT);
            this.txtInitialAccumula.setEnabled(false);
        } else {
            this.chkIsPromisssory.setEnabled(true);
            this.txtInitialAccumula.setEnabled(false);
        }
    }

    @Override
    protected void chkIsPromisssory_stateChanged(ChangeEvent e) throws Exception {
        super.chkIsPromisssory_stateChanged(e);
        boolean flag = this.chkIsPromisssory.isSelected();
        this.txtQuota.setEnabled(flag);
        this.txtProRate.setEnabled(flag);
        if (flag) {
            this.txtQuota.setValue((Object)DESPOSIT_QUOTA_DEFAULT);
        } else {
            this.txtQuota.setValue((Object)Constants.ZERO);
            this.txtProRate.setValue((Object)Constants.ZERO);
        }
    }

    @Override
    protected void chkIsOverdraft_stateChanged(ChangeEvent e) throws Exception {
        super.chkIsOverdraft_stateChanged(e);
        boolean flag = this.chkIsOverdraft.isSelected();
        this.txtOverDraftRate.setEnabled(flag);
        if (!flag) {
            this.txtOverDraftRate.setValue((Object)Constants.ZERO);
        }
        this.doProcess(flag);
    }

    @Override
    protected void chkIsTaxable_stateChanged(ChangeEvent e) throws Exception {
        super.chkIsTaxable_stateChanged(e);
        boolean flag = this.chkIsTaxable.isSelected();
        this.txtTaxRate.setEnabled(flag);
        if (flag) {
            this.txtTaxRate.setValue((Object)TAX_RATE_DEFAULT);
        } else {
            this.txtTaxRate.setValue((Object)Constants.ZERO);
        }
    }

    protected void verifyInput(ActionEvent arg0) throws Exception {
        super.verifyInput(arg0);
        FMClientVerifyHelper.verifyComboCurrency((CoreUIObject)this, (KDComboBox)this.comboCurrency);
        this.handler.verifyInfoData((CoreUIObject)this, this.editData, false);
    }

    private void setPropertyReadOnly(boolean enable) {
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (((IntObjectSourceTypeEnum)((Object)this.comboSourceType.getSelectedItem())).getValue() == 3 && !this.isClearingHouseCompany()) {
            this.setMessageText(EASResource.getString((String)RES_Path, (String)"CannotModifyInnerAcctIntObj"));
            this.showMessage();
            return;
        }
        if (this.editData.getState() == IntObjectStateEnum.DISABLED || this.editData.getState() == IntObjectStateEnum.CLOSED) {
            this.setMessageText(IMUtil.getResString("cantEditOrDelDisableClosed"));
            this.showMessage();
            return;
        }
        if (this.editData.getSourceType() == IntObjectSourceTypeEnum.INNERACCT && !this.isClearingHouseCompany()) {
            this.setMessageText(EASResource.getString((String)RES_Path, (String)"CannotModifyInnerAcctIntObj"));
            this.showMessage();
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        String id = this.editData.getId().toString();
        if (this.handler.hasIntRecords(id)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_Path, (String)"IntObjectHasRecords"));
            return;
        }
        if (this.editData.getState() == IntObjectStateEnum.DISABLED || this.editData.getState() == IntObjectStateEnum.CLOSED) {
            this.setMessageText(IMUtil.getResString("cantEditOrDelDisableClosed"));
            this.showMessage();
            return;
        }
        if (this.editData.getSourceType() == IntObjectSourceTypeEnum.INNERACCT && !this.isClearingHouseCompany()) {
            this.setMessageText(EASResource.getString((String)RES_Path, (String)"CannotModifyInnerAcctIntObj"));
            this.showMessage();
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    private boolean isClearingHouseCompany() throws EASBizException, BOSException {
        String curr = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        if (BankFactory.getRemoteInstance().getClearingHouse(curr) == null) {
            return false;
        }
        CompanyOrgUnitInfo currCompanyInfo = SysContext.getSysContext().getCurrentFIUnit();
        CompanyOrgUnitInfo clearingHouseInfo = null;
        try {
            clearingHouseInfo = FSClientHelper.getClearingHouseCompany();
        }
        catch (EASBizException bizEx) {
            logger.debug((Object)bizEx);
        }
        catch (BOSException bosEx) {
            logger.debug((Object)bosEx);
        }
        if (clearingHouseInfo == null || currCompanyInfo == null) {
            return false;
        }
        String clearingHouseId = clearingHouseInfo.getId().toString();
        String currCompanyId = currCompanyInfo.getId().toString();
        return currCompanyId.equals(clearingHouseId);
    }

    @Override
    protected void prmtSettledAccount_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtSettledAccount_dataChanged(e);
        if (e.getNewValue() != null) {
            this.setRecPayedAcctBySettledAccount(e.getNewValue());
        }
    }

    private void setRecPayedAcctBySettledAccount(Object o) throws BOSException, EASBizException {
        AccountBankInfo accountBankInfo = (AccountBankInfo)o;
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("account.*");
        accountBankInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountBankInfo.getId()), selectors);
        this.prmtRecPayedAcct.setData((Object)accountBankInfo.getAccount());
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if ("FINDVIEW".equals(this.getOprtState())) {
            this.lockUIForViewStatus();
            this.actionAddNew.setEnabled(false);
            this.actionCancel.setEnabled(false);
            this.actionCancel.setVisible(false);
            this.btnCancel.setEnabled(false);
            this.actionSubmit.setEnabled(false);
        } else if ("ADDNEW".equals(this.getOprtState())) {
            this.setPropertyReadOnly(false);
            boolean enable = false;
            this.pkEffectiveDate.setEnabled(!enable);
            this.comboCurrency.setEnabled(!enable);
            this.pkLastSettledDate.setEnabled(!enable);
            this.txtInitialAccumula.setEnabled(!enable);
        }
        if ("EDIT".equals(this.getOprtState())) {
            this.comboSourceType.setEnabled(false);
            this.prmtSourceId.setEnabled(false);
        }
        if (this.getOprtState().equals(OprtState.EDIT) || this.getOprtState().equals(OprtState.ADDNEW)) {
            this.tblAssItem.setEnabled(true);
            this.tblAssItem.setEditable(true);
        } else {
            this.tblAssItem.setEnabled(false);
            this.tblAssItem.setEditable(false);
        }
    }

    protected void updateButtonStatus() {
        try {
            if (!this.isClearingHouseCompany() && this.editData.getSourceType() == IntObjectSourceTypeEnum.INNERACCT) {
                this.actionEdit.setEnabled(false);
                this.actionRemove.setEnabled(false);
                this.actionCancel.setEnabled(false);
                this.actionCancel.setVisible(false);
                this.actionCancelCancel.setEnabled(false);
            }
        }
        catch (EASBizException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
    }

    @Override
    protected void prmtType_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtType_dataChanged(e);
        if (!FMHelper.isEmpty((CoreBaseInfo)((CoreBaseInfo)e.getNewValue()))) {
            IntRateTypeInfo rateType = this.getRateTypeInfo(e);
            this.txtDepositBp.setPrecision(rateType.getPrecision());
        }
    }

    private IntRateTypeInfo getRateTypeInfo(DataChangeEvent e) throws BOSException, EASBizException {
        IntRateTypeInfo rateType = (IntRateTypeInfo)e.getNewValue();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("id");
        selectors.add("precision");
        rateType = IntRateTypeFactory.getRemoteInstance().getIntRateTypeInfo((IObjectPK)new ObjectUuidPK(rateType.getId()), selectors);
        return rateType;
    }

    public boolean isModify() {
        if (OprtState.VIEW.equals(this.getOprtState()) || "FINDVIEW".equals(this.getOprtState())) {
            return false;
        }
        return super.isModify();
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.comboSourceType.setSelectedItem((Object)IntObjectSourceTypeEnum.GLACCT);
        CurrencyInfo currency = new CurrencyInfo();
        try {
            currency = CurrencyUtil.getLocalCurrency();
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)currency);
        this.comboRateRuleEnum.setSelectedItem((Object)IntRateRuleEnum.CURRENT);
    }

    public void onShow() throws Exception {
        super.onShow();
        FMClientHelper.setFirstFocus((Component[])new Component[]{this.pkEffectiveDate});
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    protected void prmtAccuralAccount_willShow(SelectorEvent e) throws Exception {
        super.prmtAccuralAccount_willShow(e);
        this.checkIntObjIsNull(e);
    }

    private void checkIntObjIsNull(SelectorEvent e) {
        if (this.prmtSourceId.isVisible() && this.prmtSourceId.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)IMUtil.getResString("selectIntObjectFirst"));
            e.setCanceled(true);
        }
    }

    @Override
    protected void prmtOverAccount_willShow(SelectorEvent e) throws Exception {
        super.prmtOverAccount_willShow(e);
        this.checkIntObjIsNull(e);
    }

    @Override
    protected void prmtRecPayableAcct_willShow(SelectorEvent e) throws Exception {
        super.prmtRecPayableAcct_willShow(e);
        this.checkIntObjIsNull(e);
    }

    @Override
    protected void prmtRecPayedAcct_willShow(SelectorEvent e) throws Exception {
        super.prmtRecPayedAcct_willShow(e);
        this.checkIntObjIsNull(e);
    }

    @Override
    protected void prmtSettledAccount_willShow(SelectorEvent e) throws Exception {
        super.prmtSettledAccount_willShow(e);
        this.checkIntObjIsNull(e);
    }

    @Override
    protected void prmtTaxAccount_willShow(SelectorEvent e) throws Exception {
        super.prmtTaxAccount_willShow(e);
        this.checkIntObjIsNull(e);
    }

    @Override
    protected void comboInAccountType_itemStateChanged(ItemEvent e) throws Exception {
        super.comboInAccountType_itemStateChanged(e);
        if (e.getStateChange() == 2) {
            return;
        }
        if (this.comboInAccountType.getSelectedItem() == InAccountTypeEnum.PostAccount) {
            this.f7CpInnerAccount.setData(null);
        }
        this.setInnerAcctFilter();
    }

    private void setInnerAcctFilter() {
        EntityViewInfo evi = new EntityViewInfo();
        if (this.comboInAccountType.getSelectedItem() == InAccountTypeEnum.PostAccount) {
            FilterInfo filterInfo = new FilterInfo();
            CoreBaseInfo srcInfo = (CoreBaseInfo)this.prmtSourceId.getData();
            if (srcInfo != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)srcInfo.getId().toString(), CompareType.NOTEQUALS));
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("isUsed", (Object)Boolean.TRUE));
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString()));
            evi.setFilter(filterInfo);
        } else if (this.comboInAccountType.getSelectedItem() == InAccountTypeEnum.TurnProfileAndLoss) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString()));
            evi.setFilter(fi);
        }
        this.f7CpInnerAccount.getQueryAgent().resetRuntimeEntityView();
        this.f7CpInnerAccount.setEntityViewInfo(evi);
    }

    @Override
    protected void f7CpInnerAccount_willCommit(CommitEvent e) throws Exception {
        this.setInnerAcctFilter();
    }

    @Override
    protected void f7CpInnerAccount_willShow(SelectorEvent e) throws Exception {
        this.setInnerAcctFilter();
    }

    public static IntObjectInfo showIntObjectEditUI(CoreUIObject ui, CoreBaseInfo info) throws UIException, EASBizException {
        successFlag = Boolean.FALSE;
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"Source_Info", (Object)info);
        uiContext.put((Object)"related", (Object)Boolean.TRUE);
        if (info instanceof InnerAccountInfo) {
            uiContext.put((Object)"TYPE", (Object)"INNER");
        } else if (info instanceof AccountBankInfo) {
            uiContext.put((Object)"TYPE", (Object)"OUTER");
        }
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(IntObjectEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
        return (IntObjectInfo)((IntObjectEditUI)uiWindow.getUIObject()).getDataObject();
    }

    private Boolean isSuccess() {
        return successFlag;
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        ((IntObjectInfo)this.getDataObject()).setIsExit(true);
        this.getUIWindow().close();
    }

    @Override
    protected void txtOverDraftRange_dataChanged(DataChangeEvent e) throws Exception {
        BigDecimal overDraftValue = this.txtOverDraftRange.getBigDecimalValue();
        if (overDraftValue.compareTo(Constants.ZERO) == 0) {
            this.txtOverDraftRangeRate.setEnabled(false);
            this.txtOverDraftRangeRate.setValue((Object)this.txtOverDraftRate.getBigDecimalValue());
        } else {
            this.txtOverDraftRangeRate.setEnabled(true);
            this.txtOverDraftRangeRate.setValue((Object)Constants.ZERO);
            this.txtOverDraftRangeRate.requestFocus();
            this.txtOverDraftRangeRate.setValue((Object)this.txtOverDraftRate.getBigDecimalValue());
        }
    }

    private void doProcess(boolean isOverdraft) {
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        int precision = 10;
        if (currencyInfo != null) {
            precision = FMClientHelper.getPrecOfCurrency((BOSUuid)currencyInfo.getId());
        }
        this.txtOverDraftRange.setPrecision(precision);
        this.txtOverDraftRange.setValue((Object)Constants.ZERO);
        if (isOverdraft) {
            BigDecimal overDraftRangeValue = this.txtOverDraftRange.getBigDecimalValue();
            boolean isOverDraftRangeValueZero = overDraftRangeValue.compareTo(Constants.ZERO) == 0;
            this.txtOverDraftRange.setEnabled(true);
            this.txtOverDraftRangeRate.setEnabled(isOverdraft && !isOverDraftRangeValueZero);
        } else {
            this.txtOverDraftRange.setEnabled(false);
            this.txtOverDraftRangeRate.setEnabled(false);
            this.txtOverDraftRange.setValue((Object)Constants.ZERO);
            this.txtOverDraftRangeRate.setValue((Object)Constants.ZERO);
        }
    }

    protected void txtOverDraftRate_dataChanged(DataChangeEvent e) throws Exception {
        this.txtOverDraftRangeRate.setValue((Object)this.txtOverDraftRate.getBigDecimalValue());
    }

    @Override
    protected void tblAssItem_editStopped(KDTEditEvent e) throws Exception {
        AsstActTypeInfo asstActTypeInfo;
        KDTable table = (KDTable)e.getSource();
        int r = e.getRowIndex();
        int c = e.getColIndex();
        String key = table.getColumnKey(c);
        if (key.equals("selected")) {
            Object selected = table.getRow(r).getCell("selected").getValue();
            if (((Boolean)selected).booleanValue()) {
                table.getRow(r).getCell("fromNumber").getStyleAttributes().setLocked(false);
                AsstActTypeInfo asstActTypeInfo2 = (AsstActTypeInfo)table.getRow(r).getCell("asstActType").getValue();
                table.getRow(r).getCell("toNumber").getStyleAttributes().setLocked(this.isLock(asstActTypeInfo2));
            } else {
                table.getRow(r).getCell("fromNumber").getStyleAttributes().setLocked(true);
                table.getRow(r).getCell("fromNumber").setValue(null);
                table.getRow(r).getCell("toNumber").getStyleAttributes().setLocked(true);
                table.getRow(r).getCell("toNumber").setValue(null);
            }
        } else if (key.equals("fromNumber")) {
            table.getRow(r).getCell("toNumber").setValue(table.getRow(r).getCell("fromNumber").getValue());
            asstActTypeInfo = (AsstActTypeInfo)table.getRow(r).getCell("asstActType").getValue();
            if (this.isLock(asstActTypeInfo)) {
                table.getRow(r).getCell("toNumber").getStyleAttributes().setLocked(true);
            }
            this.reSetName();
        }
        asstActTypeInfo = (AsstActTypeInfo)table.getRow(r).getCell("asstActType").getValue();
        if (asstActTypeInfo.getAsstHGAttribute().equals("customer") || asstActTypeInfo.getAsstHGAttribute().equals("project")) {
            Object fromNumber = table.getRow(r).getCell("fromNumber").getValue();
            Object toNumber = table.getRow(r).getCell("toNumber").getValue();
            for (int i = 0; i < this.tblAssItem.getRowCount(); ++i) {
                if (i == r) continue;
                AsstActTypeInfo asstActType = (AsstActTypeInfo)table.getRow(i).getCell("asstActType").getValue();
                if (fromNumber != null && toNumber != null && fromNumber.equals(toNumber)) {
                    if (!asstActType.getAsstHGAttribute().equals("customer") && !asstActType.getAsstHGAttribute().equals("project")) continue;
                    table.getRow(i).getCell("toNumber").getStyleAttributes().setLocked(false);
                    continue;
                }
                if (fromNumber == null || toNumber == null || !asstActType.getAsstHGAttribute().equals("customer") && !asstActType.getAsstHGAttribute().equals("project")) continue;
                table.getRow(i).getCell("toNumber").getStyleAttributes().setLocked(true);
            }
        }
    }

    private void reSetName() {
        int rowCount = this.tblAssItem.getRowCount();
        Boolean selected = Boolean.FALSE;
        ArrayList<String> nameArr = new ArrayList<String>();
        ArrayList<String> numberArr = new ArrayList<String>();
        Object obj = null;
        for (int i = 0; i < rowCount; ++i) {
            selected = (Boolean)this.tblAssItem.getRow(i).getCell("selected").getValue();
            if (!selected.booleanValue() || (obj = this.tblAssItem.getRow(i).getCell("fromNumber").getValue()) == null) continue;
            nameArr.add(((CoreBaseInfo)obj).getString("name"));
            numberArr.add(((CoreBaseInfo)obj).getString("number"));
        }
        Object info = this.prmtSourceId.getData();
        if (info == null) {
            return;
        }
        String name = this.handler.getIdNamebyIntObject(info, "name");
        AccountViewInfo srcInfo = null;
        try {
            srcInfo = AccountViewFactory.getRemoteInstance().getAccountViewInfo("select number where id = '" + AccessHelper.getId((Object)info) + "'");
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        String number = srcInfo.getNumber();
        for (int i = 0; i < nameArr.size(); ++i) {
            name = name + "+";
            name = name + nameArr.get(i).toString();
            number = number + "+";
            number = number + numberArr.get(i).toString();
        }
        this.txtName.setSelectedItemData((Object)name);
        this.editData.setNumber(number);
    }

    private void initLeijinPanel() throws Exception {
        if (this.editData.getCalculateType() != null) {
            this.comboCaluType.setSelectedItem((Object)this.editData.getCalculateType());
        } else {
            this.comboCaluType.setSelectedItem((Object)IntObjectTypeEnum.standard);
        }
        boolean isStandared = this.comboCaluType.getSelectedItem() == IntObjectTypeEnum.standard;
        this.actionAddDepositLine.setEnabled(!isStandared && this.chkXieding.isSelected());
        this.actionDelDepositLine.setEnabled(!isStandared && this.chkXieding.isSelected());
        this.actionAddOverDraftLine.setEnabled(!isStandared && this.chkTouzhi.isSelected());
        this.actionDelOverDraftLine.setEnabled(!isStandared && this.chkTouzhi.isSelected());
        this.handler.initSubTable(this.tableDeposit);
        if (!this.chkXieding.isSelected()) {
            if (this.tableDeposit.getRowCount() == 0) {
                IRow row = this.tableDeposit.addRow();
                row.getCell("subAmount").setValue((Object)Constants.ZERO);
                row.getCell("subRate").setValue((Object)Constants.ZERO);
                row.getCell("subAmount").getStyleAttributes().setLocked(true);
            }
            this.tableDeposit.getRow(0).getCell("subAmount").getStyleAttributes().setLocked(true);
        }
        this.handler.initSubTable(this.tableOverDraft);
    }

    @Override
    protected void comboCaluType_itemStateChanged(ItemEvent e) throws Exception {
        if (this.comboCaluType.getSelectedItem() != null) {
            IntObjectTypeEnum type = (IntObjectTypeEnum)((Object)this.comboCaluType.getSelectedItem());
            if (IntObjectTypeEnum.progression != type) {
                this.pnlBPDeposit.setVisible(true);
                this.plnLeijin.setVisible(false);
            } else {
                this.pnlBPDeposit.setVisible(false);
                this.plnLeijin.setVisible(true);
            }
        }
    }

    @Override
    public void actionAddDepositLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddDepositLine_actionPerformed(e);
        IRow row = this.tableDeposit.addRow(this.tableDeposit.getRowCount() - 1);
        row.getCell("subAmount").setValue((Object)Constants.ZERO);
        row.getCell("subRate").setValue((Object)Constants.ZERO);
    }

    @Override
    public void actionDelDepositLine_actionPerformed(ActionEvent e) throws Exception {
        int rowToBeDelete = 0;
        KDTable subTable = this.tableDeposit;
        if (this.chkXieding.isSelected()) {
            if (subTable.getRowCount() <= 2) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.im.IMAutoGenerateResource", (String)"5_IntObjectAddBatchUI"));
                SysUtil.abort();
            }
            if (this.confirmRemove()) {
                IntObjectHandler.removeSubTableLine(subTable);
            }
        } else {
            if (subTable.getRowCount() <= 1) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.im.IMAutoGenerateResource", (String)"6_IntObjectAddBatchUI"));
                SysUtil.abort();
            }
            if (this.confirmRemove()) {
                rowToBeDelete = subTable.getRowCount() - 1;
                subTable.removeRow(rowToBeDelete);
            }
        }
    }

    @Override
    public void actionAddOverDraftLine_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.tableOverDraft.addRow(this.tableOverDraft.getRowCount() - 1);
        row.getCell("subAmount").setValue((Object)Constants.ZERO);
        row.getCell("subRate").setValue((Object)Constants.ZERO);
    }

    @Override
    public void actionDelOverDraftLine_actionPerformed(ActionEvent e) throws Exception {
        boolean rowToBeDelete = false;
        KDTable subTable = this.tableOverDraft;
        if (this.chkTouzhi.isSelected()) {
            if (subTable.getRowCount() <= 2) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.im.IMAutoGenerateResource", (String)"7_IntObjectAddBatchUI"));
                SysUtil.abort();
            }
            if (this.confirmRemove()) {
                IntObjectHandler.removeSubTableLine(subTable);
            }
        }
    }

    @Override
    protected void chkXieding_stateChanged(ChangeEvent e) throws Exception {
        super.chkXieding_stateChanged(e);
        this.chkXieDingChange();
    }

    private void chkXieDingChange() {
        boolean flag = this.chkXieding.isSelected();
        this.btnAddDeposit.setEnabled(flag);
        this.btnDelDeposit.setEnabled(flag);
        KDTable subtable = this.tableDeposit;
        if (!flag) {
            subtable.removeRows();
            IRow row = subtable.addRow();
            row.getCell("subAmount").setValue((Object)Constants.ZERO);
            row.getCell("subRate").setValue((Object)Constants.ZERO);
            row.getCell("subAmount").getStyleAttributes().setLocked(true);
        } else {
            this.handler.selectXiedingOrOver(subtable);
        }
    }

    @Override
    protected void chkTouzhi_stateChanged(ChangeEvent e) throws Exception {
        super.chkTouzhi_stateChanged(e);
        this.chkTouzhiChange();
    }

    private void chkTouzhiChange() {
        boolean flag = this.chkTouzhi.isSelected();
        this.btnAddOverdraft.setEnabled(flag);
        this.btnDelOverDraft.setEnabled(flag);
        KDTable subtable = this.tableOverDraft;
        if (!flag) {
            this.tableOverDraft.removeRows();
        } else {
            this.handler.selectXiedingOrOver(subtable);
        }
    }

    @Override
    protected void chkIsTaxableLeijin_stateChanged(ChangeEvent e) throws Exception {
        super.chkIsTaxableLeijin_stateChanged(e);
        boolean flag = this.chkIsTaxableLeijin.isSelected();
        this.txtTaxRateLeijin.setEnabled(flag);
        if (flag) {
            this.txtTaxRateLeijin.setValue((Object)TAX_RATE_DEFAULT);
        } else {
            this.txtTaxRateLeijin.setValue((Object)Constants.ZERO);
        }
    }

    private void storeEntries() {
        SubDepositRateEntryCollection coll = new SubDepositRateEntryCollection();
        for (int i = 0; i < this.tableDeposit.getRowCount3(); ++i) {
            IRow entryRow = this.tableDeposit.getRow(i);
            SubDepositRateEntryInfo entryInfo = new SubDepositRateEntryInfo();
            entryInfo.setSeq(i);
            String subAmount = entryRow.getCell("subAmount").getValue().toString();
            String[] tr = subAmount.split(">");
            if (tr != null && tr.length > 1) {
                subAmount = tr[1];
            }
            entryInfo.setSubAmount(new BigDecimal(subAmount));
            if (entryRow.getCell("subRate").getValue() != null) {
                entryInfo.setSubRate(new BigDecimal(entryRow.getCell("subRate").getValue().toString()));
            }
            if (entryInfo == null) continue;
            coll.add(entryInfo);
        }
        this.editData.getSubDepositRate().clear();
        this.editData.getSubDepositRate().addCollection(coll);
        SubOverRateEntryCollection collOver = new SubOverRateEntryCollection();
        for (int i = 0; i < this.tableOverDraft.getRowCount3(); ++i) {
            IRow entryRow = this.tableOverDraft.getRow(i);
            SubOverRateEntryInfo entryInfo = new SubOverRateEntryInfo();
            entryInfo.setSeq(i);
            String subAmount = entryRow.getCell("subAmount").getValue().toString();
            String[] tr = subAmount.split(">");
            if (tr != null && tr.length > 1) {
                subAmount = tr[1];
            }
            entryInfo.setSubAmount(new BigDecimal(subAmount));
            if (entryRow.getCell("subRate").getValue() != null) {
                entryInfo.setSubRate(new BigDecimal(entryRow.getCell("subRate").getValue().toString()));
            }
            if (entryInfo == null) continue;
            collOver.add(entryInfo);
        }
        this.editData.getSubOverRate().clear();
        this.editData.getSubOverRate().addCollection(collOver);
    }

    private void loadEntriesFields() {
        SubDepositRateEntryCollection coll = this.editData.getSubDepositRate();
        this.tableDeposit.removeRows();
        for (int i = 0; i < coll.size(); ++i) {
            IRow row = this.tableDeposit.addRow();
            SubDepositRateEntryInfo info = coll.get(i);
            row.setUserObject((Object)info);
            if (this.editData.isIsPromisssory() && i == coll.size() - 1) {
                row.getCell("subAmount").setValue((Object)info.getSubAmount());
                row.getCell("subAmount").getStyleAttributes().setNumberFormat("%r{!>#,##0.00}f");
                row.getCell("subAmount").getStyleAttributes().setLocked(true);
            } else {
                row.getCell("subAmount").setValue((Object)info.getSubAmount());
            }
            row.getCell("subRate").setValue((Object)info.getSubRate());
        }
        SubOverRateEntryCollection collOver = this.editData.getSubOverRate();
        this.tableOverDraft.removeRows();
        for (int i = 0; i < collOver.size(); ++i) {
            IRow row = this.tableOverDraft.addRow();
            SubOverRateEntryInfo info = collOver.get(i);
            row.setUserObject((Object)info);
            if (this.editData.isIsOverDraft() && i == collOver.size() - 1) {
                row.getCell("subAmount").setValue((Object)info.getSubAmount());
                row.getCell("subAmount").getStyleAttributes().setNumberFormat("%r{!>#,##0.00}f");
                row.getCell("subAmount").getStyleAttributes().setLocked(true);
            } else {
                row.getCell("subAmount").setValue((Object)info.getSubAmount());
            }
            row.getCell("subRate").setValue((Object)info.getSubRate());
        }
    }

    @Override
    protected void tableDeposit_editStopped(KDTEditEvent e) throws Exception {
        if (e.getOldValue() != null && e.getOldValue().equals(e.getValue())) {
            return;
        }
        KDTable subtable = this.tableDeposit;
        this.handler.tableEditStoped(e, subtable);
    }

    @Override
    protected void tableOverDraft_editStopped(KDTEditEvent e) throws Exception {
        if (e.getOldValue() != null && e.getOldValue().equals(e.getValue())) {
            return;
        }
        KDTable subtable = this.tableOverDraft;
        this.handler.tableEditStoped(e, subtable);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtType);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDComboBox)this.comboCaluType);
        if ("INNER".equalsIgnoreCase(this.type)) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtIntInnerAcct);
        }
        if (IntObjectTypeEnum.standard != this.comboCaluType.getSelectedItem()) {
            KDTable subtable = this.tableDeposit;
            if (this.chkXieding.isSelected()) {
                this.handler.verifySubTable(subtable);
            } else if (subtable.getRowCount() < 1) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.im.IMAutoGenerateResource", (String)"8_IntObjectAddBatchUI"));
                SysUtil.abort();
            }
            if (this.chkTouzhi.isSelected()) {
                this.handler.verifySubTable(this.tableOverDraft);
            }
        }
    }

    private boolean isLock(AsstActTypeInfo asstActTypeInfo) {
        return !asstActTypeInfo.getAsstHGAttribute().equals("customer") && !asstActTypeInfo.getAsstHGAttribute().equals("project");
    }
}

