/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.util.SysUtil;
import java.util.HashSet;

public class IntObjectFilterParam
implements FilterParam {
    private static final long serialVersionUID = 353355151472917791L;
    private int source;
    private String[] companyIds;
    private String[] refObjectIds;
    private String currencyId;
    private boolean includeDisabled;

    public FilterInfo getFilter() {
        FilterInfo fi = new FilterInfo();
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        boolean isClearingHouseCompany = false;
        try {
            BankInfo clearingHouse = BankFactory.getRemoteInstance().getClearingHouse(currentCompany.getId().toString());
            CompanyOrgUnitInfo clComp = null;
            if (clearingHouse != null) {
                clComp = clearingHouse.getRelatedCompany();
            }
            if (clComp != null && clComp.getId().equals((Object)currentCompany.getId())) {
                isClearingHouseCompany = true;
            }
        }
        catch (EASBizException e) {
            SysUtil.abort((Throwable)e);
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
        if (!FMHelper.isEmpty((Object[])this.getCompanyIds())) {
            HashSet<String> list = new HashSet<String>(this.companyIds.length);
            for (int i = 0; i < this.companyIds.length; ++i) {
                list.add(this.companyIds[i]);
            }
            fi.getFilterItems().add(new FilterItemInfo("company.id", list, CompareType.INCLUDE));
        } else {
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentCompany.getId().toString()));
        }
        boolean index = false;
        if (this.source != 999) {
            fi.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(this.source)));
        } else {
            fi.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(3), CompareType.NOTEQUALS));
        }
        if (this.refObjectIds != null && this.refObjectIds.length > 0) {
            HashSet<String> intObjectIdSet = new HashSet<String>();
            for (int i = 0; i < this.refObjectIds.length; ++i) {
                String id = this.refObjectIds[i];
                intObjectIdSet.add(id);
            }
            fi.getFilterItems().add(new FilterItemInfo("id", intObjectIdSet, CompareType.INCLUDE));
        }
        if (this.currencyId != null) {
            fi.getFilterItems().add(new FilterItemInfo("currency.id", (Object)this.currencyId));
        }
        if (!this.includeDisabled) {
            fi.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(2)));
        }
        return fi;
    }

    public SorterItemCollection getSorterItems() {
        return null;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public boolean isIncludeDisabled() {
        return this.includeDisabled;
    }

    public void setIncludeDisabled(boolean includeDisabled) {
        this.includeDisabled = includeDisabled;
    }

    public String[] getRefObjectIds() {
        return this.refObjectIds;
    }

    public void setRefObjectIds(String[] refObjectIds) {
        this.refObjectIds = refObjectIds;
    }

    public int getSource() {
        return this.source;
    }

    public void setSource(int source) {
        this.source = source;
    }

    public String[] getCompanyIds() {
        return this.companyIds;
    }

    public void setCompanyIds(String[] companyIds) {
        this.companyIds = companyIds;
    }
}

