/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.im.IntObjectCollection;
import com.kingdee.eas.fm.im.IntObjectFactory;
import com.kingdee.eas.fm.im.IntObjectSourceTypeEnum;
import com.kingdee.eas.fm.im.client.AbstractIntObjectFilterUI;
import com.kingdee.eas.fm.im.client.IntObjectClientHelper;
import com.kingdee.eas.fm.im.client.IntObjectFilterParam;
import com.kingdee.eas.fm.im.client.IntObjectHandler;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.HashSet;

public class IntObjectFilterUI
extends AbstractIntObjectFilterUI {
    private IntObjectHandler handler;
    private String type;

    public IntObjectFilterUI() throws Exception {
        if (this.handler == null) {
            this.handler = IntObjectHandler.create();
        }
    }

    public IntObjectFilterUI(String type) throws Exception {
        if (this.handler == null) {
            this.handler = IntObjectHandler.create();
        }
        this.type = type;
    }

    protected void init() throws Exception {
        super.init();
        this.comboSource.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
    }

    @Override
    protected void comboSource_actionPerformed(ActionEvent e) throws Exception {
        super.comboSource_actionPerformed(e);
        this.changeIntObjFilterByOtherCtrl();
    }

    private void changeIntObjFilterByOtherCtrl() throws BOSException, EASBizException {
        this.prmtIntObject.setData(null);
        FilterInfo fi = this.getIntObjectF7Filter();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(fi);
        this.prmtIntObject.setEntityViewInfo(evi);
        this.prmtIntObject.setSelector(null);
        this.prmtIntObject.setHasCUDefaultFilter(false);
    }

    private FilterInfo getIntObjectF7Filter() throws BOSException, EASBizException {
        FilterInfo fi = IntObjectClientHelper.getIntObjF7Filter(this.chkIncDisableIntObj.isSelected());
        FilterItemInfo companyFilterItem = this.getCompanyFilterItem();
        if (companyFilterItem == null) {
            companyFilterItem = new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString());
        }
        fi.getFilterItems().add(companyFilterItem);
        if (!(this.comboSource.getSelectedItem() instanceof FMSysDefinedEnum)) {
            fi.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(((IntObjectSourceTypeEnum)((Object)this.comboSource.getSelectedItem())).getValue())));
        } else {
            fi.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(3), CompareType.NOTEQUALS));
        }
        return fi;
    }

    public Object getParam() {
        IntObjectFilterParam param = new IntObjectFilterParam();
        param.setCompanyIds(this.getCompanyIds());
        if (!(this.comboSource.getSelectedItem() instanceof FMSysDefinedEnum)) {
            param.setSource(((IntObjectSourceTypeEnum)((Object)this.comboSource.getSelectedItem())).getValue());
        } else {
            param.setSource(999);
        }
        String[] intObjectIds = AccessHelper.getF7Ids((KDBizPromptBox)this.prmtIntObject);
        param.setRefObjectIds(intObjectIds);
        param.setIncludeDisabled(this.chkIncDisableIntObj.isSelected());
        if (!(this.comboCurrency.getSelectedItem() instanceof FMSysDefinedEnum)) {
            param.setCurrencyId(((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString());
        } else {
            param.setCurrencyId(null);
        }
        return param;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (param instanceof IntObjectFilterParam) {
            String currencyId;
            IntObjectFilterParam filterParam = (IntObjectFilterParam)param;
            this.setCompanyIds(filterParam.getCompanyIds());
            int sourceId = filterParam.getSource();
            if (sourceId == 999) {
                this.comboSource.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
            } else {
                this.comboSource.setSelectedItem((Object)IntObjectSourceTypeEnum.getEnum(sourceId));
            }
            boolean includeDisabled = filterParam.isIncludeDisabled();
            this.chkIncDisableIntObj.setSelected(includeDisabled);
            String[] intObjectIDs = filterParam.getRefObjectIds();
            HashSet<String> ids = new HashSet<String>();
            if (intObjectIDs != null && intObjectIDs.length > 0) {
                for (int i = 0; i < intObjectIDs.length; ++i) {
                    ids.add(intObjectIDs[i]);
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
                view.setFilter(filter);
                try {
                    IntObjectCollection coll = IntObjectFactory.getRemoteInstance().getIntObjectCollection(view);
                    this.prmtIntObject.setData((Object)coll.toArray());
                }
                catch (Exception e) {
                    SysUtil.abort((Throwable)e);
                }
            }
            if ((currencyId = filterParam.getCurrencyId()) == null) {
                FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
            } else {
                CurrencyInfo currency = null;
                try {
                    currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
                FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)currency);
            }
        }
    }

    public boolean verify() {
        String[] companyIds;
        if (this.btnCompanySelect.isEnabled() && ((companyIds = this.getCompanyIds()) == null || companyIds.length <= 0)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.im.client.ImResource", (String)"SelectCompany"));
            SysUtil.abort();
        }
        return super.verify();
    }

    @Override
    protected void chkIncDisableIntObj_itemStateChanged(ItemEvent e) throws Exception {
        super.chkIncDisableIntObj_itemStateChanged(e);
        this.changeIntObjFilterByOtherCtrl();
    }

    protected void companyValueChange(Object object) throws Exception {
        super.companyValueChange(object);
        this.changeIntObjFilterByOtherCtrl();
    }

    protected void setDefaultValue() {
        this.chkIncDisableIntObj.setSelected(false);
        this.comboSource.setSelectedIndex(0);
        if ("INNER".equalsIgnoreCase(this.type)) {
            this.comboSource.setSelectedItem((Object)IntObjectSourceTypeEnum.INNERACCT);
            this.comboSource.setEnabled(false);
        } else if ("OUTER".equalsIgnoreCase(this.type)) {
            this.comboSource.removeItem((Object)IntObjectSourceTypeEnum.INNERACCT);
        }
        try {
            FMClientHelper.initComboCurrency((KDComboBox)this.comboCurrency, (boolean)true);
            this.comboCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
            this.changeIntObjFilterByOtherCtrl();
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.prmtIntObject.setEnabledMultiSelection(true);
    }

    protected Class getParamClass() {
        return IntObjectFilterParam.class;
    }
}

