/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.client.BookNotifyClientHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.im.AssItemsCollection;
import com.kingdee.eas.fm.im.AssItemsInfo;
import com.kingdee.eas.fm.im.IIntObject;
import com.kingdee.eas.fm.im.IMUtil;
import com.kingdee.eas.fm.im.InAccountTypeEnum;
import com.kingdee.eas.fm.im.IntObjectBPDepositInfo;
import com.kingdee.eas.fm.im.IntObjectFactory;
import com.kingdee.eas.fm.im.IntObjectFinanceInfo;
import com.kingdee.eas.fm.im.IntObjectInfo;
import com.kingdee.eas.fm.im.IntObjectSourceTypeEnum;
import com.kingdee.eas.fm.im.IntObjectStateEnum;
import com.kingdee.eas.fm.im.IntObjectTypeEnum;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.im.SubDepositRateEntryInfo;
import com.kingdee.eas.fm.im.client.IntObjectAddBatchUI;
import com.kingdee.eas.fm.im.client.IntObjectEditUI;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class IntObjectHandler {
    private static Logger logger = Logger.getLogger((String)IntObjectHandler.class.getName());
    private static final int BASE_NUMBER = 10;
    public static final String resourcePath = "com.kingdee.eas.fm.im.client.ImResource";
    private static final String F7_ACCOUNT_VIEW_QUERY = "com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery";
    private static final String F7_ACCOUNT_BANK_QUERY = "com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery";
    private static final String F7_INNER_ACCOUNT_QUERY = "com.kingdee.eas.fm.fs.F7InnerAccountQuery";
    public static final String SOURCEINFO = "Source_Info";
    public static final String TYPE = "TYPE";
    public static final String TYPE_INNER = "INNER";
    public static final String TYPE_OUTER = "OUTER";

    public static IntObjectHandler create() {
        return new IntObjectHandler();
    }

    public void setSourceIdBySourceType(IntObjectSourceTypeEnum sourceType, KDBizPromptBox prmtSourceId) {
        if (sourceType == null || prmtSourceId == null) {
            return;
        }
        String queryInfo = null;
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection items = filterInfo.getFilterItems();
        if (sourceType.equals((Object)IntObjectSourceTypeEnum.GLACCT) || sourceType.equals((Object)IntObjectSourceTypeEnum.ACCTANDASST)) {
            queryInfo = F7_ACCOUNT_VIEW_QUERY;
            items.add(new FilterItemInfo("accountTableID.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getAccountTable().getId().toString()));
            items.add(new FilterItemInfo("isLeaf", (Object)Constants.TRUE));
            items.add(new FilterItemInfo("isGFreeze", (Object)Constants.FALSE));
            items.add(new FilterItemInfo("isCFreeze", (Object)Constants.FALSE));
            items.add(new FilterItemInfo("companyID.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString()));
        } else if (sourceType.equals((Object)IntObjectSourceTypeEnum.BANKACCT) || sourceType.equals((Object)IntObjectSourceTypeEnum.BANKSTATE)) {
            queryInfo = F7_ACCOUNT_BANK_QUERY;
            items.add(new FilterItemInfo("company.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString()));
        } else if (sourceType.equals((Object)IntObjectSourceTypeEnum.INNERACCT)) {
            queryInfo = F7_INNER_ACCOUNT_QUERY;
            items.add(new FilterItemInfo("closed", (Object)Constants.FALSE));
            items.add(new FilterItemInfo("isUsed", (Object)Constants.TRUE));
            String curr = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
            items.add(new FilterItemInfo("company.id", (Object)curr));
        } else if (sourceType.equals(FMSysDefinedEnum.SELECT_ALL)) {
            prmtSourceId.setEnabled(false);
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        prmtSourceId.setQueryInfo(queryInfo);
        prmtSourceId.setEntityViewInfo(evi);
        prmtSourceId.setDisplayFormat("$number$ $name$");
        prmtSourceId.setSelector(null);
    }

    public void setIntInnerAcctBySourceTypeAndSourceId(IntObjectSourceTypeEnum sourceType, KDBizPromptBox prmtSourceId, KDBizPromptBox prmtIntInnerAcct) throws EASBizException, BOSException {
        if (sourceType == null || prmtSourceId == null || prmtIntInnerAcct == null) {
            return;
        }
        String queryInfo = null;
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection items = filterInfo.getFilterItems();
        if (sourceType.equals((Object)IntObjectSourceTypeEnum.INNERACCT)) {
            queryInfo = F7_INNER_ACCOUNT_QUERY;
            items.add(new FilterItemInfo("closed", (Object)Constants.FALSE));
            items.add(new FilterItemInfo("isUsed", (Object)Constants.TRUE));
            String curr = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
            items.add(new FilterItemInfo("company.id", (Object)curr));
            Object innerAcct = prmtSourceId.getData();
            if (innerAcct != null) {
                InnerAccountInfo innerAcctInfo = null;
                if (innerAcct instanceof InnerAccountInfo) {
                    innerAcctInfo = (InnerAccountInfo)innerAcct;
                } else if (innerAcct instanceof String) {
                    SelectorItemCollection sel = new SelectorItemCollection();
                    sel.add(new SelectorItemInfo("applyUnit.id"));
                    innerAcctInfo = InnerAccountFactory.getRemoteInstance().getInnerAccountInfo((IObjectPK)new ObjectUuidPK((String)innerAcct), sel);
                }
                CompanyOrgUnitInfo applyUnit = innerAcctInfo.getApplyUnit();
                if (applyUnit != null && applyUnit.getId() != null) {
                    items.add(new FilterItemInfo("applyUnit.id", (Object)applyUnit.getId().toString()));
                }
            }
        } else {
            prmtIntInnerAcct.setVisible(false);
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        prmtIntInnerAcct.setQueryInfo(queryInfo);
        prmtIntInnerAcct.setEntityViewInfo(evi);
        prmtIntInnerAcct.setDisplayFormat("$number$ $name$");
        prmtIntInnerAcct.setSelector(null);
        prmtIntInnerAcct.setData(null);
    }

    public String getIdNamebyIntObject(Object intObject, String type) {
        if (intObject == null) {
            return null;
        }
        String Id = null;
        String name = null;
        if (intObject instanceof AccountViewInfo) {
            Id = ((AccountViewInfo)intObject).getId().toString();
            name = ((AccountViewInfo)intObject).getName();
        } else if (intObject instanceof AccountBankInfo) {
            Id = ((AccountBankInfo)intObject).getId().toString();
            name = ((AccountBankInfo)intObject).getName();
        } else if (intObject instanceof InnerAccountInfo) {
            Id = ((InnerAccountInfo)intObject).getId().toString();
            name = ((InnerAccountInfo)intObject).getName();
        }
        if ("name".equals(type)) {
            return name;
        }
        return Id;
    }

    public void setPrmtSourceIdDataName(Object intObject) {
        if (intObject == null) {
            return;
        }
        String Id = this.getIdNamebyIntObject(intObject, "Id");
        if (intObject instanceof AccountViewInfo) {
            ((AccountViewInfo)intObject).setName(Id);
            ((AccountViewInfo)intObject).setNumber(null);
        } else if (intObject instanceof AccountBankInfo) {
            ((AccountBankInfo)intObject).setName(Id);
        } else if (intObject instanceof InnerAccountInfo) {
            ((InnerAccountInfo)intObject).setName(Id);
        }
    }

    public void storeDepositFields(IntObjectInfo info, IntObjectEditUI ui) {
        info.setType((IntRateTypeInfo)ui.prmtType.getData());
        IntObjectBPDepositInfo depositInfo = info.getDepositRate();
        depositInfo.setType((IntRateTypeInfo)ui.prmtType.getData());
        BigDecimal depositBp = ui.txtDepositBp.getBigDecimalValue();
        depositInfo.setRate(depositBp);
        depositInfo.setIsPromisssory(ui.chkIsPromisssory.isSelected());
        BigInteger quota = ui.txtQuota.getBigIntegerValue();
        depositInfo.setQuota(quota == null ? 0 : ((Number)quota).intValue());
        BigDecimal proRate = ui.txtProRate.getBigDecimalValue();
        depositInfo.setProRate(proRate);
        depositInfo.setIsOverdraft(ui.chkIsOverdraft.isSelected());
        depositInfo.setOverDraftRate(ui.txtOverDraftRate.getBigDecimalValue());
        depositInfo.setIsTaxable(ui.chkIsTaxable.isSelected());
        depositInfo.setTaxRate(ui.txtTaxRate.getBigDecimalValue());
    }

    public void loadDepositFields(IntObjectInfo info, IntObjectEditUI ui) {
        ui.prmtType.setData((Object)info.getType());
        IntObjectBPDepositInfo depositInfo = info.getDepositRate();
        ui.txtDepositBp.setValue((Object)depositInfo.getRate());
        ui.chkIsPromisssory.setSelected(depositInfo.isIsPromisssory());
        if (depositInfo.isIsPromisssory()) {
            ui.txtQuota.setEnabled(true);
            ui.txtProRate.setEnabled(true);
        } else {
            ui.txtQuota.setEnabled(false);
            ui.txtProRate.setEnabled(false);
        }
        ui.txtQuota.setValue((Object)new Integer(depositInfo.getQuota()));
        ui.txtProRate.setValue((Object)(depositInfo.getProRate() == null ? Constants.ZERO : depositInfo.getProRate()));
        ui.chkIsOverdraft.setSelected(depositInfo.isIsOverdraft());
        if (depositInfo.isIsOverdraft()) {
            ui.txtOverDraftRate.setEnabled(true);
            ui.txtOverDraftRange.setEnabled(true);
        } else {
            ui.txtOverDraftRate.setEnabled(false);
            ui.txtOverDraftRange.setEnabled(false);
        }
        ui.txtOverDraftRate.setValue((Object)(depositInfo.getOverDraftRate() == null ? Constants.ZERO : depositInfo.getOverDraftRate()));
        ui.chkIsTaxable.setSelected(depositInfo.isIsTaxable());
        if (depositInfo.isIsTaxable()) {
            ui.txtTaxRate.setEnabled(true);
        } else {
            ui.txtTaxRate.setEnabled(false);
        }
        ui.txtTaxRate.setValue((Object)(depositInfo.getTaxRate() == null ? Constants.ZERO : depositInfo.getTaxRate()));
    }

    public void storeDepositFields(IntObjectInfo info, IntObjectAddBatchUI ui) {
        info.setType((IntRateTypeInfo)ui.prmtType.getData());
        IntObjectBPDepositInfo depositInfo = info.getDepositRate();
        depositInfo.setType((IntRateTypeInfo)ui.prmtType.getData());
        BigDecimal depositBp = ui.txtDepositBp.getBigDecimalValue();
        depositInfo.setRate(depositBp);
        depositInfo.setIsPromisssory(ui.chkIsPromisssory.isSelected());
        BigInteger quota = ui.txtQuota.getBigIntegerValue();
        depositInfo.setQuota(quota == null ? 0 : ((Number)quota).intValue());
        BigDecimal proRate = ui.txtProRate.getBigDecimalValue();
        depositInfo.setProRate(proRate);
        depositInfo.setIsOverdraft(ui.chkIsOverdraft.isSelected());
        depositInfo.setOverDraftRate(ui.txtOverDraftRate.getBigDecimalValue());
        depositInfo.setIsTaxable(ui.chkIsTaxable.isSelected());
        depositInfo.setTaxRate(ui.txtTaxRate.getBigDecimalValue());
    }

    public void loadDepositFields(IntObjectInfo info, IntObjectAddBatchUI ui) {
        ui.prmtType.setData((Object)info.getType());
        IntObjectBPDepositInfo depositInfo = info.getDepositRate();
        ui.txtDepositBp.setValue((Object)depositInfo.getRate());
        ui.chkIsPromisssory.setSelected(depositInfo.isIsPromisssory());
        if (depositInfo.isIsPromisssory()) {
            ui.txtQuota.setEnabled(true);
            ui.txtProRate.setEnabled(true);
        } else {
            ui.txtQuota.setEnabled(false);
            ui.txtProRate.setEnabled(false);
        }
        ui.txtQuota.setValue((Object)new Integer(depositInfo.getQuota()));
        ui.txtProRate.setValue((Object)(depositInfo.getProRate() == null ? Constants.ZERO : depositInfo.getProRate()));
        ui.chkIsOverdraft.setSelected(depositInfo.isIsOverdraft());
        if (depositInfo.isIsOverdraft()) {
            ui.txtOverDraftRate.setEnabled(true);
        } else {
            ui.txtOverDraftRate.setEnabled(false);
        }
        ui.txtOverDraftRate.setValue((Object)(depositInfo.getOverDraftRate() == null ? Constants.ZERO : depositInfo.getOverDraftRate()));
        ui.chkIsTaxable.setSelected(depositInfo.isIsTaxable());
        if (depositInfo.isIsTaxable()) {
            ui.txtTaxRate.setEnabled(true);
        } else {
            ui.txtTaxRate.setEnabled(false);
        }
        ui.txtTaxRate.setValue((Object)(depositInfo.getTaxRate() == null ? Constants.ZERO : depositInfo.getTaxRate()));
    }

    public void verifyInfoData(CoreUIObject ui, IntObjectInfo info, boolean isAddBatch) throws EASBizException, BOSException {
        if (info == null) {
            return;
        }
        this.verifyIntObject(ui, info, isAddBatch);
        if (IntObjectTypeEnum.progression != info.getCalculateType()) {
            this.verifyIntObjectBPDeposit(ui, info.getDepositRate());
        } else {
            this.verifySubDepositRate(ui, info);
        }
        this.verifyIntObjectFinance(ui, info);
        if (info.getSourceType() == IntObjectSourceTypeEnum.ACCTANDASST) {
            AssItemsCollection ac = info.getAssItemCol();
            boolean selectAtLeastOne = false;
            for (int i = 0; i < ac.size(); ++i) {
                AssItemsInfo infoAc = ac.get(i);
                if (infoAc.isIsSelected()) {
                    selectAtLeastOne = true;
                    if (infoAc.getFromNumber().equals("")) {
                        MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.fm.im.IMAutoGenerateResource", (String)"10_IntObjectHandler"));
                        SysUtil.abort();
                    }
                }
                if (infoAc.getFromNumber().equals("") || infoAc.isIsSelected()) continue;
                MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.fm.im.IMAutoGenerateResource", (String)"11_IntObjectHandler"));
                SysUtil.abort();
            }
            if (!selectAtLeastOne) {
                MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.fm.im.IMAutoGenerateResource", (String)"12_IntObjectHandler"));
                SysUtil.abort();
            }
        }
    }

    private void verifyIntObject(CoreUIObject ui, IntObjectInfo info, boolean isAddBatch) throws EASBizException, BOSException {
        IIntObject iIntObject;
        BigDecimal unitAmt;
        if (info == null) {
            return;
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)info.getEffectiveDate(), (String)"EffectiveDateIsNull", (String)"pkEffectiveDate");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)((Object)info.getSourceType()), (String)"IntObjectSourceTypeIsNull", (String)"comboSourceType");
        if (!isAddBatch) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)info.getSourceId(), (String)"IntObjectSourceIdIsNull", (String)"prmtSourceId");
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)info.getName(), (String)"NameIsNull", (String)"txtName");
        } else {
            KDTable kdTable = null;
            if (ui instanceof IntObjectAddBatchUI) {
                kdTable = ((IntObjectAddBatchUI)ui).kdtObject;
            }
            if (kdTable == null || kdTable.getRowCount() < 1) {
                MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"IntObjectSourceIdIsNull"));
                SysUtil.abort();
            }
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)info.getCurrency(), (String)"CurrencyIsNull", (String)"comboCurrency");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)new Integer(info.getFloorAmt()), (String)"FloorAmtGreaterZero", (String)"txtFloorAmt");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)info.getLastSettledDate(), (String)"LastSettledDateIsNotValid", (String)"pkLastSettledDate");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)info.getInitialAccumula(), (String)"InitialAccumulaGreaterZero", (String)"txtInitialAccumula");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)info.getUnitAmt(), (String)"UnitAmtIsNotValid", (String)"txtUnitAmt");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)((Object)info.getRateRuleEnum()), (String)"RateRuleIsNull", (String)"comboRateRuleEnum");
        if (info.getFloorAmt() < 0) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"FloorAmtGreaterZero"));
            FMClientVerifyHelper.setComponentFocus((JComponent)ui, (String)"txtFloorAmt");
            SysUtil.abort();
        }
        if ((FMHelper.isEmpty((Object)info.getId()) || !this.hasIntRecords(info.getId().toString())) && info.getLastSettledDate().compareTo(info.getEffectiveDate()) > 0) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"LastSettledDateIsNotValid"));
            FMClientVerifyHelper.setComponentFocus((JComponent)ui, (String)"pkLastSettledDate");
            SysUtil.abort();
        }
        if (!IntObjectHandler.isPowOfX(unitAmt = info.getUnitAmt(), 10)) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"UnitAmtIsNotValid"));
            FMClientVerifyHelper.setComponentFocus((JComponent)ui, (String)"txtUnitAmt");
            SysUtil.abort();
        }
        if ((iIntObject = IntObjectFactory.getRemoteInstance()).checkIsSame(info)) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"IntObjectIsSame"));
            FMClientVerifyHelper.setComponentFocus((JComponent)ui, (String)"prmtSourceId");
            SysUtil.abort();
        }
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        switch (info.getSourceType().getValue()) {
            case 1: {
                PeriodInfo periodOfGL = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
                if (periodOfGL == null) {
                    MsgBox.showWarning((Component)ui, (String)IMUtil.getResString("glNotStarted"));
                    SysUtil.abort();
                }
                if (!DateTimeUtils.truncateDate((Date)info.getEffectiveDate()).before(DateTimeUtils.truncateDate((Date)periodOfGL.getBeginDate()))) break;
                MsgBox.showWarning((Component)ui, (String)IMUtil.getResString("intObjEffDateNotValidOfGL"));
                FMClientVerifyHelper.setComponentFocus((JComponent)ui, (String)"pkEffectiveDate");
                SysUtil.abort();
                break;
            }
            case 2: 
            case 5: {
                PeriodInfo periodOfCash = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
                if (periodOfCash == null) {
                    MsgBox.showWarning((Component)ui, (String)IMUtil.getResString("cashNotStarted"));
                    SysUtil.abort();
                }
                if (!DateTimeUtils.truncateDate((Date)info.getEffectiveDate()).before(DateTimeUtils.truncateDate((Date)periodOfCash.getBeginDate()))) break;
                MsgBox.showWarning((Component)ui, (String)IMUtil.getResString("intObjEffDateNotValidOfBank"));
                FMClientVerifyHelper.setComponentFocus((JComponent)ui, (String)"pkEffectiveDate");
                SysUtil.abort();
                break;
            }
            case 3: {
                BankInfo clearingHouse = FSClientHelper.getClearingHouse();
                if (clearingHouse == null || !clearingHouse.isUsed()) {
                    MsgBox.showWarning((Component)ui, (String)IMUtil.getResString("clearingHouseNotStarted"));
                    SysUtil.abort();
                }
                if (!DateTimeUtils.truncateDate((Date)info.getEffectiveDate()).before(DateTimeUtils.truncateDate((Date)clearingHouse.getOpenDate()))) break;
                MsgBox.showWarning((Component)ui, (String)IMUtil.getResString("intObjEffDateNotValidOfInner"));
                FMClientVerifyHelper.setComponentFocus((JComponent)ui, (String)"pkEffectiveDate");
                SysUtil.abort();
                break;
            }
        }
    }

    private static boolean isPowOfX(BigDecimal a, int b) {
        if (a == null) {
            return false;
        }
        if (a.compareTo(Constants.ZERO) <= 0) {
            return false;
        }
        if (a.compareTo(Constants.ONE) == 0) {
            return true;
        }
        double x = Double.parseDouble(String.valueOf(a));
        double y = Double.parseDouble(String.valueOf(b));
        double temp = 0.0;
        int i = -10;
        while (temp < x) {
            temp = Math.pow(y, Double.parseDouble(String.valueOf(i)));
            ++i;
        }
        y = temp;
        if (y > x) {
            return false;
        }
        return y == x;
    }

    public static int getPowOfX(BigDecimal a) {
        char c;
        if (a == null) {
            return 0;
        }
        if (a.compareTo(Constants.ZERO) <= 0) {
            return 0;
        }
        if (a.compareTo(Constants.ONE) == 0) {
            return 0;
        }
        int scale = a.scale();
        String s = String.valueOf(a);
        for (int i = 0; i < s.length() && (c = s.charAt(s.length() - i - 1)) == '0'; ++i) {
            --scale;
        }
        return scale;
    }

    private void verifyIntObjectBPDeposit(CoreUIObject ui, IntObjectBPDepositInfo info) {
        if (info == null) {
            return;
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)info.getType(), (String)"DepositRateTypeIsNull", (String)"prmtType");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)info.getRate(), (String)"DepositRateIsNull", (String)"txtDepositBp");
        if (info.isIsPromisssory()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)new Integer(info.getQuota()), (String)"QuotaIsNotValid", (String)"txtQuota");
            if (info.getQuota() <= 0) {
                MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"QuotaIsNotValid"));
                FMClientVerifyHelper.setComponentFocus((JComponent)ui, (String)"txtQuota");
                SysUtil.abort();
            }
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)info.getProRate(), (String)"ProRateIsNull", (String)"txtProRate");
        }
        if (info.isIsOverdraft()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)info.getOverDraftRate(), (String)"OverDraftIsNull", (String)"txtOverDraftRate");
        }
        if (info.isIsTaxable()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)info.getTaxRate(), (String)"TaxRateIsNull", (String)"txtTaxRate");
        }
    }

    private void verifySubDepositRate(CoreUIObject ui, IntObjectInfo info) {
        if (info.isIsPromisssory()) {
            if (info.getSubDepositRate() == null || info.getSubDepositRate().size() == 0) {
                MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.fm.im.IMAutoGenerateResource", (String)"13_IntObjectHandler"));
            }
            for (int i = 0; i < info.getSubDepositRate().size(); ++i) {
                SubDepositRateEntryInfo subDepositRateEntryInfo = info.getSubDepositRate().get(i);
            }
        }
        if (info.isIsOverDraft()) {
            // empty if block
        }
    }

    private void verifyIntObjectFinance(CoreUIObject ui, IntObjectInfo info) {
        if (info == null) {
            return;
        }
        IntObjectFinanceInfo financeAttr = info.getFinanceAttr();
        if (financeAttr.getInAccountType().equals((Object)InAccountTypeEnum.PostAccount)) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)financeAttr.getCpInneraccount(), (String)"CpInnerAccountIsNull", (String)"f7CpInnerAccount");
        }
    }

    public boolean hasIntRecords(String fID) throws EASBizException, BOSException {
        IIntObject iIntObject = IntObjectFactory.getRemoteInstance();
        return iIntObject.hasIntRecords(fID);
    }

    public boolean checkAccountIsClosed(int sourceType, String sourceId) throws EASBizException, BOSException {
        IIntObject iIntObject = IntObjectFactory.getRemoteInstance();
        return iIntObject.checkAccountIsClosed(sourceType, sourceId);
    }

    public void delete(CoreUIObject ui, Set idSet) throws EASBizException, BOSException {
        if (idSet.size() < 1) {
            return;
        }
        IIntObject iIntObject = IntObjectFactory.getRemoteInstance();
        String id = null;
        Iterator iter = idSet.iterator();
        if (idSet.size() == 1) {
            while (iter.hasNext()) {
                id = (String)iter.next();
            }
            if (id == null) {
                return;
            }
            if (this.hasIntRecords(id)) {
                MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"IntObjectHasRecords"));
                SysUtil.abort();
            } else {
                iIntObject.delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            }
        } else {
            int i = 0;
            while (iter.hasNext()) {
                id = (String)iter.next();
                if (this.hasIntRecords(id)) continue;
                iIntObject.delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                ++i;
            }
            if (i == 0) {
                MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"IntObjectNotFillCond"));
                SysUtil.abort();
            }
        }
    }

    public void disable(CoreUIObject ui, Set idSet) throws EASBizException, BOSException, UuidException {
        int i;
        if (idSet.size() < 1) {
            return;
        }
        IIntObject iIntObject = IntObjectFactory.getRemoteInstance();
        String id = null;
        Iterator iter = idSet.iterator();
        if (idSet.size() == 1) {
            if (iter.hasNext()) {
                id = (String)iter.next();
            }
            if (id == null) {
                return;
            }
            if (!this.hasIntRecords(id)) {
                MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"IntObjectHasNotRecords"));
                SysUtil.abort();
            }
        }
        if ((i = iIntObject.disable(idSet)) == 0) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"IntObjectNotFillCond"));
            SysUtil.abort();
        } else {
            MsgBox.showInfo((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Forbid _OK"));
        }
    }

    public void enable(CoreUIObject ui, Set idSet) throws EASBizException, BOSException, UuidException {
        int i;
        if (idSet.size() < 1) {
            return;
        }
        IIntObject iIntObject = IntObjectFactory.getRemoteInstance();
        String id = null;
        Iterator iter = idSet.iterator();
        if (idSet.size() == 1) {
            if (iter.hasNext()) {
                id = (String)iter.next();
            }
            if (id == null) {
                return;
            }
            IntObjectInfo info = (IntObjectInfo)iIntObject.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            if (!info.getState().equals((Object)IntObjectStateEnum.DISABLED) && !info.getState().equals((Object)IntObjectStateEnum.CLOSED)) {
                MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"IntObjectIsNotDisable"));
                SysUtil.abort();
            }
            if (info.getState().equals((Object)IntObjectStateEnum.CLOSED)) {
                MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"IntObjectAccountIsClosed"));
                SysUtil.abort();
            }
            if (this.checkAccountIsClosed(info.getSourceType().getValue(), info.getSourceId())) {
                MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"IntObjectAccountIsClosed"));
                SysUtil.abort();
            }
        }
        if ((i = iIntObject.enable(idSet)) == 0) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"IntObjectNotFillCond"));
            SysUtil.abort();
        } else {
            MsgBox.showInfo((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Startup_OK"));
        }
    }

    public static boolean isCHCompany() throws EASBizException, BOSException {
        String cur = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        if (BankFactory.getRemoteInstance().getClearingHouse(cur) == null) {
            return false;
        }
        CompanyOrgUnitInfo currCompanyInfo = SysContext.getSysContext().getCurrentFIUnit();
        CompanyOrgUnitInfo clearingHouseInfo = null;
        try {
            clearingHouseInfo = FSClientHelper.getClearingHouseCompany();
        }
        catch (EASBizException bizEx) {
            logger.debug((Object)bizEx);
        }
        catch (BOSException bosEx) {
            logger.debug((Object)bosEx);
        }
        if (clearingHouseInfo == null || currCompanyInfo == null) {
            return false;
        }
        String clearingHouseId = clearingHouseInfo.getId().toString();
        String currCompanyId = currCompanyInfo.getId().toString();
        return currCompanyId.equals(clearingHouseId);
    }

    public void initSourceType(String type, KDComboBox comboSourceType) throws EASBizException, BOSException {
        comboSourceType.removeAllItems();
        if (TYPE_OUTER.equalsIgnoreCase(type)) {
            comboSourceType.addItem((Object)IntObjectSourceTypeEnum.GLACCT);
            comboSourceType.addItem((Object)IntObjectSourceTypeEnum.BANKACCT);
            comboSourceType.addItem((Object)IntObjectSourceTypeEnum.BANKSTATE);
            comboSourceType.addItem((Object)IntObjectSourceTypeEnum.ACCTANDASST);
        } else if (TYPE_INNER.equalsIgnoreCase(type)) {
            if (IntObjectHandler.isCHCompany() && FSClientHelper.clearingHouseIsUsed(null)) {
                comboSourceType.addItem((Object)IntObjectSourceTypeEnum.INNERACCT);
            } else {
                MsgBox.showError((String)EASResource.getString((String)resourcePath, (String)"companyIsNotCH"));
                SysUtil.abort();
            }
        }
    }

    public Set getIntObjectIdSet(KDTable table) {
        HashSet<String> idSet = new HashSet<String>();
        IRow row = null;
        int count = table.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = table.getRow(i);
            idSet.add(row.getCell(0).getValue().toString());
        }
        return idSet;
    }

    public void initAmtEditor(KDTable table, String currencyId, String colName) throws Exception {
        if (FMHelper.isEmpty((String)currencyId)) {
            return;
        }
        table.checkParsed();
        int prec = FMClientHelper.getPrecOfCurrency((BOSUuid)BOSUuid.read((String)currencyId));
        BookNotifyClientHelper.setTableCellEditorByFormattedTextField((KDTable)table, (String)colName, (int)prec, (BigDecimal)Constants.MIN_VALUE);
        FMClientHelper.setNumberFormat((KDTable)table, (String)colName, (String)currencyId);
    }

    public void initSubTable(KDTable subTtable) throws Exception {
        BookNotifyClientHelper.setTableCellEditorByFormattedTextField((KDTable)subTtable, (String)"subRate", (int)3, (BigDecimal)Constants.MIN_VALUE);
        String numberFormat = FMClientHelper.getKDTNumFormat((int)3);
        StyleAttributes styleAttributes = subTtable.getColumn("subRate").getStyleAttributes();
        styleAttributes.setNumberFormat(numberFormat);
        styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public static void removeSubTableLine(KDTable subTable) {
        int rowToBeDelete = subTable.getRowCount() - 2;
        subTable.removeRow(rowToBeDelete);
        int size = subTable.getRowCount();
        BigDecimal subAmount = (BigDecimal)subTable.getRow(size - 2).getCell("subAmount").getValue();
        subTable.getRow(size - 1).getCell("subAmount").getStyleAttributes().setNumberFormat("%r{!>#,##0.00}f");
        subTable.getRow(size - 1).getCell("subAmount").setValue((Object)subAmount);
    }

    public void verifySubTable(KDTable subtable) {
        BigDecimal subAmountBefore;
        BigDecimal subAmount;
        int i;
        if (subtable.getRowCount() < 2) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.im.IMAutoGenerateResource", (String)"14_IntObjectHandler"));
            SysUtil.abort();
        }
        for (i = 0; i < subtable.getRowCount() - 1; ++i) {
            subAmount = (BigDecimal)subtable.getRow(i).getCell("subAmount").getValue();
            if (Constants.ZERO.compareTo(subAmount) >= 0) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.im.IMAutoGenerateResource", (String)"15_IntObjectHandler"));
                SysUtil.abort();
            }
            BigDecimal bigDecimal = (BigDecimal)subtable.getRow(i).getCell("subRate").getValue();
        }
        for (i = 0; i < subtable.getRowCount() - 2; ++i) {
            BigDecimal subAmountAfter;
            subAmount = (BigDecimal)subtable.getRow(i).getCell("subAmount").getValue();
            if (subAmount.compareTo(subAmountAfter = (BigDecimal)subtable.getRow(i + 1).getCell("subAmount").getValue()) < 0) continue;
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.im.IMAutoGenerateResource", (String)"16_IntObjectHandler"));
            SysUtil.abort();
        }
        BigDecimal subAmountEnd = (BigDecimal)subtable.getRow(subtable.getRowCount() - 1).getCell("subAmount").getValue();
        if (subAmountEnd.compareTo(subAmountBefore = (BigDecimal)subtable.getRow(subtable.getRowCount() - 2).getCell("subAmount").getValue()) != 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.im.IMAutoGenerateResource", (String)"17_IntObjectHandler"));
            SysUtil.abort();
        }
    }

    public void tableEditStoped(KDTEditEvent e, KDTable subtable) {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        int size = subtable.getRowCount();
        IRow row = subtable.getRow(rowIndex);
        ICell cell = subtable.getCell(rowIndex, colIndex);
        if (colIndex == subtable.getColumn("subAmount").getColumnIndex() && rowIndex == size - 2) {
            BigDecimal subAmount = (BigDecimal)cell.getValue();
            subtable.getRow(size - 1).getCell("subAmount").getStyleAttributes().setNumberFormat("%r{!>#,##0.00}f");
            subtable.getRow(size - 1).getCell("subAmount").setValue((Object)subAmount);
        }
    }

    public void selectXiedingOrOver(KDTable subtable) {
        subtable.removeRows();
        IRow row = subtable.addRow();
        row.getCell("subAmount").setValue((Object)Constants.ZERO);
        row.getCell("subRate").setValue((Object)Constants.ZERO);
        IRow endRow = subtable.addRow();
        endRow.getCell("subAmount").setValue((Object)Constants.ZERO);
        endRow.getCell("subRate").setValue((Object)Constants.ZERO);
        endRow.getCell("subAmount").getStyleAttributes().setLocked(true);
    }
}

