/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.im.IMUtil;
import com.kingdee.eas.fm.im.IntObjectException;
import com.kingdee.eas.fm.im.IntObjectFactory;
import com.kingdee.eas.fm.im.IntObjectInfo;
import com.kingdee.eas.fm.im.IntObjectStateEnum;
import com.kingdee.eas.fm.im.client.AbstractIntObjectListUI;
import com.kingdee.eas.fm.im.client.AccrualBillHandler;
import com.kingdee.eas.fm.im.client.IntObjectAddBatchUI;
import com.kingdee.eas.fm.im.client.IntObjectClientHandler;
import com.kingdee.eas.fm.im.client.IntObjectFilterUI;
import com.kingdee.eas.fm.im.client.IntObjectHandler;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class IntObjectListUI
extends AbstractIntObjectListUI {
    private static final String COL_KEY_SOURCETYPE = "sourceType";
    private IntObjectFilterUI filterUI;
    private IntObjectHandler handler;
    private String type;

    protected String getEditUIModal() {
        return FMClientHelper.getEditUIMode((CoreUIObject)this);
    }

    public IntObjectListUI() throws Exception {
        if (this.handler == null) {
            this.handler = IntObjectHandler.create();
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAddBatch.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_newbatch"));
        this.actionJoinQuery.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.actionEnable.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_staruse"));
        this.actionDisable.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_forbid"));
    }

    public String getUITitle() {
        String title = super.getUITitle();
        return AccrualBillHandler.getTitle(this.type, title);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new IntObjectFilterUI(this.type);
            this.filterUI.setListUI((IUIObject)this);
        }
        return this.filterUI;
    }

    protected void preparePrintPageHeader(HeadFootModel headerModel) {
    }

    protected String getPrintPageTitle() {
        return super.getPrintPageTitle();
    }

    public void onLoad() throws Exception {
        String[] NUMBERCOLS = new String[]{"depositRate.rate", "depositRate.taxRate", "depositRate.quota", "floorAmt", "InitialAccumula", "unitAmt", "overDraftRange"};
        int n = NUMBERCOLS.length;
        for (int i = 0; i < n; ++i) {
            this.getMainTable().getColumn(NUMBERCOLS[i]).getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm());
        }
        String ftm = FMClientHelper.getNumberFtm((boolean)false, (int)3, (int)10);
        this.getMainTable().getColumn("depositRate.proRate").getStyleAttributes().setNumberFormat(ftm);
        this.getMainTable().getColumn("depositRate.overDraftRate").getStyleAttributes().setNumberFormat(ftm);
        this.getMainTable().getColumn("overDraftRangeRate").getStyleAttributes().setNumberFormat(ftm);
        if (this.getUIContext().get("UIClassParam") != null) {
            this.type = (String)this.getUIContext().get("UIClassParam");
        }
        AccrualBillHandler.checkUIParamIsValid(this.type);
        if (!(!"INNER".equalsIgnoreCase(this.type) || IntObjectHandler.isCHCompany() && FSClientHelper.clearingHouseIsUsed(null))) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.im.client.ImResource", (String)"companyIsNotCH"));
            SysUtil.abort();
        }
        super.onLoad();
        this.tblMain.setColumnMoveable(true);
        this.tblMain.getColumn("bizType").getStyleAttributes().setHided(true);
        if (!"INNER".equalsIgnoreCase(this.type)) {
            this.tblMain.getColumn("intInnerAccount.name").getStyleAttributes().setHided(true);
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit())) {
            this.actionAddNew.setEnabled(false);
            this.actionAddBatch.setEnabled(false);
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionEnable.setEnabled(false);
            this.actionDisable.setEnabled(false);
            this.actionAddNew.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionRemove.setVisible(false);
            this.actionEnable.setVisible(false);
            this.actionDisable.setVisible(false);
            this.separator2.setVisible(false);
        }
        String dformat = CtrlFormatUtilities.getDateFormatString();
        this.tblMain.getColumn("effectiveDate").getStyleAttributes().setNumberFormat(dformat);
        this.tblMain.getColumn("lastSettledDate").getStyleAttributes().setNumberFormat(dformat);
        this.tblMain.getColumn("nextSettledDate").getStyleAttributes().setNumberFormat(dformat);
    }

    protected CommonQueryDialog getQueryDlg() throws Exception {
        CommonQueryDialog dlg = super.getQueryDlg();
        dlg.setParentUIClassName(this.getMetaDataPK().getFullName() + "_" + this.type);
        return dlg;
    }

    protected String getQueryUiName() {
        return this.getMetaDataPK().getFullName() + "_" + this.type;
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        uiContext.put((Object)"TYPE", (Object)this.type);
        super.prepareUIContext(uiContext, e);
    }

    protected void execQuery() {
        super.execQuery();
        this.tblMain.setColumnMoveable(true);
        this.tblMain.getColumn("bizType").getStyleAttributes().setHided(true);
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (((BizEnumValueInfo)this.getSelectedRow().getCell(COL_KEY_SOURCETYPE).getValue()).getInt() == 3 && !this.isClearingHouseCompany()) {
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fm.im.client.ImResource", (String)"CannotModifyInnerAcctIntObj"));
            this.showMessage();
            return;
        }
        Set idSet = this.getSelectedIdSet();
        String id = (String)idSet.iterator().next();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("state"));
        IntObjectInfo info = IntObjectFactory.getRemoteInstance().getIntObjectInfo((IObjectPK)new ObjectUuidPK(id), selectors);
        if (info.getState() == IntObjectStateEnum.DISABLED || info.getState() == IntObjectStateEnum.CLOSED) {
            this.setMessageText(IMUtil.getResString("cantEditOrDelDisableClosed"));
            this.showMessage();
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    private boolean isClearingHouseCompany() {
        CompanyOrgUnitInfo currCompanyInfo = SysContext.getSysContext().getCurrentFIUnit();
        CompanyOrgUnitInfo clearingHouseCompany = null;
        try {
            BankInfo clearHouse = BankFactory.getRemoteInstance().getClearingHouse(currCompanyInfo.getId().toString());
            if (clearHouse != null) {
                clearingHouseCompany = clearHouse.getRelatedCompany();
            }
        }
        catch (EASBizException bizEx) {
            this.handUIExceptionAndAbort((Exception)((Object)bizEx));
        }
        catch (BOSException bosEx) {
            this.handUIExceptionAndAbort((Exception)((Object)bosEx));
        }
        if (clearingHouseCompany == null || currCompanyInfo == null) {
            return false;
        }
        String clearingHouseId = clearingHouseCompany.getId().toString();
        String currCompanyId = currCompanyInfo.getId().toString();
        return currCompanyId.equals(clearingHouseId);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        Set idSet = this.getSelectedIdSet();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("state"));
        IntObjectInfo info = null;
        if (idSet.size() == 1) {
            String id = (String)idSet.iterator().next();
            info = IntObjectFactory.getRemoteInstance().getIntObjectInfo((IObjectPK)new ObjectUuidPK(id), selectors);
            if (info.getState() == IntObjectStateEnum.DISABLED || info.getState() == IntObjectStateEnum.CLOSED) {
                this.setMessageText(IMUtil.getResString("cantEditOrDelDisableClosed"));
                this.showMessage();
                return;
            }
            if (((BizEnumValueInfo)this.getSelectedRow().getCell(COL_KEY_SOURCETYPE).getValue()).getInt() == 3 && !this.isClearingHouseCompany()) {
                this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fm.im.client.ImResource", (String)"CannotModifyInnerAcctIntObj"));
                this.showMessage();
                return;
            }
        } else {
            Iterator iterator = idSet.iterator();
            while (iterator.hasNext()) {
                String id = (String)iterator.next();
                if (this.handler.hasIntRecords(id)) {
                    iterator.remove();
                    continue;
                }
                info = IntObjectFactory.getRemoteInstance().getIntObjectInfo((IObjectPK)new ObjectUuidPK(id), selectors);
                if (info.getState() != IntObjectStateEnum.DISABLED && info.getState() != IntObjectStateEnum.CLOSED) continue;
                iterator.remove();
            }
            if (idSet.size() == 0) {
                this.setMessageText(IMUtil.getResString("notSuitableObject"));
                this.showMessage();
                return;
            }
        }
        if (this.confirmRemove()) {
            this.handler.delete((CoreUIObject)this, idSet);
            this.refresh(e);
        }
    }

    @Override
    public void actionDisable_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionDisable_actionPerformed(e);
        this.handler.disable((CoreUIObject)this, this.getSelectedIdSet());
        this.refresh(e);
    }

    @Override
    public void actionEnable_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionEnable_actionPerformed(e);
        this.handler.enable((CoreUIObject)this, this.getSelectedIdSet());
        this.refresh(e);
    }

    private Set getSelectedIdSet() {
        return new HashSet(this.getSelectedIdValues());
    }

    @Override
    public void actionAddBatch_actionPerformed(ActionEvent e) throws Exception {
        IntObjectAddBatchUI.showUI((IUIObject)this, this.type, OprtState.ADDNEW);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        IContextHelper helper = ContextHelperFactory.getRemoteInstance();
        if (!helper.isOnlyUnion(helper.getCurrentCompany())) {
            super.actionView_actionPerformed(e);
        } else {
            this.checkSelected();
            String[] idList = new String[]{this.getSelectedKeyValue()};
            FMClientHelper.viewDetailBill((CoreUIObject)this, (String[])idList, (CompanyOrgUnitInfo)helper.getCurrentCompany());
        }
    }

    protected void setActionState() {
        super.setActionState();
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        int top = block.getTop();
        int sourceTypeColIndex = this.tblMain.getColumn(COL_KEY_SOURCETYPE).getColumnIndex();
        if (!this.isClearingHouseCompany() && ((BizEnumValueInfo)this.tblMain.getCell(top, sourceTypeColIndex).getValue()).getInt() == 3) {
            this.setActionStatus(false);
        } else {
            this.setActionStatus(true);
        }
    }

    private void setActionStatus(boolean b) {
        this.actionEdit.setEnabled(b);
        this.actionRemove.setEnabled(b);
        this.actionEnable.setEnabled(b);
        this.actionDisable.setEnabled(b);
    }

    public void onGetRowSet(IRowSet rowSet) {
        try {
            FMHelper.roundRowSetBigDecimal((IRowSet)rowSet, (String[])new String[]{"depositRate.rate", "depositRate.taxRate", "depositRate.overDraftRate", "depositRate.proRate", "depositRate.quota"});
        }
        catch (SQLException e) {
            this.handUIExceptionAndAbort(e);
        }
        super.onGetRowSet(rowSet);
    }

    @Override
    public void actionJoinQuery_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        Object objSrcId = this.getSelectedRow().getCell("srcId").getValue();
        if (objSrcId == null) {
            throw new IntObjectException(IntObjectException.NOSOURCEBILL);
        }
        IntObjectClientHandler.viewDetailBill((CoreUIObject)this, objSrcId.toString(), ContextHelperFactory.getRemoteInstance().getCurrentCompany());
    }
}

