/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.client.CurrencyUtil;
import com.kingdee.eas.fm.im.IntRateBaseFactory;
import com.kingdee.eas.fm.im.IntRateBaseInfo;
import com.kingdee.eas.fm.im.IntRateStateEnum;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.im.client.AbstractIntRateBaseEditUI;
import com.kingdee.eas.fm.im.client.IntRateBaseHandler;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;

public class IntRateBaseEditUI
extends AbstractIntRateBaseEditUI {
    private IntRateBaseHandler handler;
    private static String resourcePath = "com.kingdee.eas.fm.im.client.ImResource";

    public IntRateBaseEditUI() throws Exception {
        if (this.handler == null) {
            this.handler = IntRateBaseHandler.create();
        }
    }

    public void onLoad() throws Exception {
        CurrencyUtil.fillCombCurrency((KDComboBox)this.comboCurrency);
        this.comboCurrency.addItem(null);
        this.txtYearRate.setHorizontalAlignment(4);
        super.onLoad();
        IntRateTypeInfo intRateTypeInfo = null;
        intRateTypeInfo = this.getOprtState().equals(OprtState.ADDNEW) ? (IntRateTypeInfo)this.getUIContext().get("rateType") : this.editData.getType();
        int precision = intRateTypeInfo.getPrecision();
        this.txtYearRate.setPrecision(precision);
        this.txtYearRate.setRemoveingZeroInDispaly(true);
        this.prmtIntTerm.setEnabled(true);
        FMClientHelper.clearSeparatorOnToolBar((KDToolBar)this.toolBar);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        BOSUuid id = this.editData.getId();
        if (!EmptyUtil.isEmpty((Object)id) && this.getBillStatus(id.toString())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"RateModify"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
        this.prmtIntTerm.setEnabled(true);
    }

    private boolean getBillStatus(String pkid) throws BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(pkid);
        try {
            IntRateBaseInfo info = IntRateBaseFactory.getRemoteInstance().getIntRateBaseInfo((IObjectPK)pk);
            return info.getBillState().equals((Object)IntRateStateEnum.AUDITED);
        }
        catch (EASBizException e) {
            this.handUIException(e);
            return true;
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
    }

    @Override
    public void storeFields() {
        this.editData.setEffectiveDate(DateTimeUtils.truncateDate((Date)this.editData.getEffectiveDate()));
        super.storeFields();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return IntRateBaseFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        IntRateBaseInfo objectValue = new IntRateBaseInfo();
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        objectValue.setBillState(IntRateStateEnum.SUBMITED);
        Date currDate = new Date(System.currentTimeMillis());
        objectValue.setEffectiveDate(DateTimeUtils.truncateDate((Date)currDate));
        IntRateTypeInfo intRateTypeInfo = (IntRateTypeInfo)this.getUIContext().get("rateType");
        objectValue.setType(intRateTypeInfo);
        try {
            objectValue.setCurrency(CurrencyUtil.getLocalCurrency());
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return objectValue;
    }

    @Override
    protected void txtYearRate_dataChanged(DataChangeEvent e) throws Exception {
        super.txtYearRate_dataChanged(e);
        if (this.txtYearRate.getBigDecimalValue() != null) {
            BigDecimal yearRate = this.txtYearRate.getBigDecimalValue();
            this.calculateMonthDayRate(yearRate);
        }
    }

    private void calculateMonthDayRate(BigDecimal yearRate) {
        int scale = this.editData.getType().getPrecision();
        BigDecimal monthRate = this.handler.calculateMonthDayRate(yearRate, null, 0, scale);
        int typeFactor = this.editData.getType().getFactorDay();
        BigDecimal dayRate = this.handler.calculateMonthDayRate(yearRate, "day", typeFactor, scale);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        this.handler.verifyInfoData((CoreUIObject)this, this.editData);
        int scale = this.editData.getType().getPrecision();
        BigDecimal oldYearRate = new BigDecimal(String.valueOf(this.editData.getYearRate()));
        BigDecimal newYearRate = oldYearRate.setScale(scale, 4);
        this.editData.setYearRate(newYearRate);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        return sic;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    private void calYearDays() {
        if (this.prmtType.getValue() != null) {
            String strValue = "";
            IntRateTypeInfo intRateTypeInfo = (IntRateTypeInfo)this.prmtType.getData();
            if (intRateTypeInfo.getRateExpression() != null && "day" == intRateTypeInfo.getRateExpression().getValue()) {
                strValue = this.contYearRate.getBoundLabelText();
                strValue = strValue.replaceAll("%", "\u2030");
                this.contYearRate.setBoundLabelText(strValue);
            } else if (intRateTypeInfo.getRateExpression() != null && "month" == intRateTypeInfo.getRateExpression().getValue()) {
                strValue = this.contYearRate.getBoundLabelText();
                strValue = strValue.replaceAll("%", "\u2030");
                this.contYearRate.setBoundLabelText(strValue);
            } else {
                strValue = this.contYearRate.getBoundLabelText();
                strValue = strValue.replaceAll("\u2030", "%");
                this.contYearRate.setBoundLabelText(strValue);
            }
        }
    }

    @Override
    protected void prmtType_dataChanged(DataChangeEvent e) throws Exception {
        this.calYearDays();
        super.prmtType_dataChanged(e);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        String oprtS = this.getOprtState();
        boolean canAddnew = oprtS.equals("ADDNEW");
        this.actionAddNew.setEnabled(canAddnew);
        this.actionRemove.setEnabled(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
    }
}

