/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.im.IntRateBaseFilterParam;
import com.kingdee.eas.fm.im.IntRateStateEnum;
import com.kingdee.eas.fm.im.client.AbstractIntRateBaseFilterUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.DateTimeUtils;
import java.util.Calendar;
import java.util.Date;

public class IntRateBaseFilterUI
extends AbstractIntRateBaseFilterUI {
    private static String resourcePath = "com.kingdee.eas.fm.fs.FSClientResource";

    private void customInit() throws Exception {
        Date date = new Date();
        Date firstdate = FMHelper.getDate((String)"2000-01-01", (String)"yyyy-mm-dd");
        this.pkDateFrom.setValue((Object)firstdate);
        this.pkDateTo.setValue((Object)date);
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
        FMClientHelper.setSelectObject((KDComboBox)this.comboState, (Object)FMSysDefinedEnum.SELECT_ALL);
    }

    public void clear() {
        super.clear();
        try {
            this.customInit();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public Object getParam() {
        DataBaseInfo currencyInfo;
        IntRateBaseFilterParam param = new IntRateBaseFilterParam();
        Object objCurrency = this.comboCurrency.getSelectedItem();
        if (objCurrency != null && objCurrency instanceof DataBaseInfo && !FMHelper.isEmpty((CoreBaseInfo)(currencyInfo = (DataBaseInfo)objCurrency))) {
            param.setCurrencyID(currencyInfo.getId().toString());
            param.setCurrencyName(currencyInfo.getName());
        }
        if (this.pkDateFrom.getValue() != null) {
            param.setDateFrom(DateTimeUtils.truncateDate((Date)((Date)this.pkDateFrom.getValue())));
        }
        if (this.pkDateTo.getValue() != null) {
            param.setDateTo(DateTimeUtils.truncateDate((Date)((Date)this.pkDateTo.getValue())));
        }
        if (FMSysDefinedEnum.SELECT_ALL != this.comboState.getSelectedItem()) {
            param.setBillState(((IntRateStateEnum)((Object)this.comboState.getSelectedItem())).getValue());
        }
        return param;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (param instanceof IntRateBaseFilterParam) {
            IntRateBaseFilterParam filterParam = (IntRateBaseFilterParam)param;
            String currencyID = filterParam.getCurrencyID();
            if (!FMHelper.isEmpty((String)currencyID)) {
                CurrencyInfo currencyInfo = new CurrencyInfo();
                currencyInfo.setId(BOSUuid.read((String)currencyID));
                currencyInfo.setName(filterParam.getCurrencyName());
                FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)currencyInfo);
            } else {
                this.comboCurrency.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
            }
            Date dateForm = filterParam.getDateFrom();
            Date dateTo = filterParam.getDateTo();
            this.pkDateFrom.setValue((Object)dateForm);
            this.pkDateTo.setValue((Object)dateTo);
            String billState = filterParam.getBillState();
            if (!FMHelper.isEmpty((String)billState)) {
                this.comboState.setSelectedItem((Object)IntRateStateEnum.getEnum(billState));
            } else {
                this.comboState.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
            }
        }
    }

    protected void init() throws Exception {
        super.init();
        this.chkIA_actionPerformed(null);
        FMClientHelper.initComboCurrency((KDComboBox)this.comboCurrency);
        this.comboCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.comboState.addItem((Object)IntRateStateEnum.SUBMITED);
        this.comboState.addItem((Object)IntRateStateEnum.AUDITED);
        this.comboState.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
        FMClientHelper.setSelectObject((KDComboBox)this.comboState, (Object)FMSysDefinedEnum.SELECT_ALL);
        Date dateFrom = FMHelper.getDate((String)"2000-01-01", (String)"yyyy-mm-dd");
        this.pkDateFrom.setValue((Object)IntRateBaseFilterUI.truncateDate(dateFrom));
        this.btnCompanySelect.setVisible(false);
    }

    public static Date truncateDate(Date dt) {
        if (dt == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        cal.set(cal.get(1), 0, 1, 0, 0, 0);
        return new Date(cal.getTimeInMillis() / 1000L * 1000L);
    }

    public boolean verify() {
        Date dateFrom = (Date)this.pkDateFrom.getValue();
        Date dateTo = (Date)this.pkDateTo.getValue();
        if (dateFrom != null && dateTo != null) {
            FMClientVerifyHelper.verifyDateFromTo((CoreUIObject)this, (String)resourcePath, (Date)dateFrom, (Date)dateTo, (String)"CheckDateFromTo");
        }
        return true;
    }

    protected Class getParamClass() {
        return IntRateBaseFilterParam.class;
    }
}

