/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.im.IIntRateBase;
import com.kingdee.eas.fm.im.IIntRateType;
import com.kingdee.eas.fm.im.IIntTerm;
import com.kingdee.eas.fm.im.IntRateBaseFactory;
import com.kingdee.eas.fm.im.IntRateBaseFilterParam;
import com.kingdee.eas.fm.im.IntRateBaseInfo;
import com.kingdee.eas.fm.im.IntRateTypeFactory;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.im.IntTermCollection;
import com.kingdee.eas.fm.im.IntTermFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class IntRateBaseHandler {
    public static final String resourcePath = "com.kingdee.eas.fm.im.client.ImResource";
    public static final String XIE_YI_LI_LV_ID = "lJlpCQEQEADgAAc+wKgSjiR9knQ=";
    public static final String GU_DING_LI_LV_ID = "QYYAAAAKQTYkfZJ0";
    private final String EFFECTIVE_DATE = "EffectiveDate";
    private final String CURRENCY = "Currency";
    private final String RATE = "Rate";
    private final String BILLSTATE = "BillState";
    private final String AUDITOR = "Auditor";
    private final String AUDITDATE = "AuditDate";
    public static final String CTX_RATE_TYPE = "rateType";

    public static IntRateBaseHandler create() {
        return new IntRateBaseHandler();
    }

    public static DefaultTreeModel getRateTypeTreeModel() throws EASBizException, BOSException {
        IIntRateType iIntRateType = IntRateTypeFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)XIE_YI_LI_LV_ID, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)GU_DING_LI_LV_ID, CompareType.NOTEQUALS));
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("number"));
        CoreBaseCollection collection = iIntRateType.getCollection(evi);
        DefaultKingdeeTreeNode root = IntRateBaseHandler.bulidTreeByCollection(collection);
        return new DefaultTreeModel((TreeNode)root);
    }

    private static DefaultKingdeeTreeNode bulidTreeByCollection(CoreBaseCollection collection) throws BOSException {
        IntRateTypeInfo rootNodeInfo = new IntRateTypeInfo();
        rootNodeInfo.setName(EASResource.getString((String)resourcePath, (String)"IntRateTypeF7WindowTitle"));
        DefaultKingdeeTreeNode rootTreeNode = new DefaultKingdeeTreeNode((Object)rootNodeInfo);
        if (collection == null || collection.size() == 0) {
            return rootTreeNode;
        }
        try {
            int collSize = collection.size();
            for (int i = 0; i < collSize; ++i) {
                IntRateTypeInfo treeNodeInfo = (IntRateTypeInfo)collection.get(i);
                DefaultKingdeeTreeNode subTreeNode = new DefaultKingdeeTreeNode((Object)treeNodeInfo);
                rootTreeNode.add((MutableTreeNode)subTreeNode);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return rootTreeNode;
    }

    public void initTable(KDTable tblMain, IntRateTypeInfo info) throws Exception {
        String column_effectiveDate = EASResource.getString((String)resourcePath, (String)"EffectiveDate");
        String column_currency = EASResource.getString((String)resourcePath, (String)"Currency");
        String column_rate = EASResource.getString((String)resourcePath, (String)"Rate");
        String column_billState = EASResource.getString((String)resourcePath, (String)"BillState");
        String column_auditor = EASResource.getString((String)resourcePath, (String)"Auditor");
        String column_auditDate = EASResource.getString((String)resourcePath, (String)"AuditDate");
        tblMain.checkParsed();
        IRow headRow = tblMain.addHeadRow();
        tblMain.addColumn().setKey("id");
        tblMain.getColumn("id").getStyleAttributes().setHided(true);
        tblMain.addColumn().setKey("BillState");
        tblMain.addColumn().setKey("EffectiveDate");
        tblMain.addColumn().setKey("Currency");
        headRow.getCell("BillState").setValue((Object)column_billState);
        headRow.getCell("EffectiveDate").setValue((Object)column_effectiveDate);
        headRow.getCell("Currency").setValue((Object)column_currency);
        IIntTerm iIntTerm = IntTermFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSorter().add(new SorterItemInfo("type"));
        evi.getSorter().add(new SorterItemInfo("term"));
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("id", (Object)"jhNyIgEWEADgAAr6wKgSC61eI6Y=", CompareType.NOTEQUALS));
        evi.setFilter(f);
        IntTermCollection termColl = iIntTerm.getIntTermCollection(evi);
        tblMain.addColumn().setKey("null");
        headRow.getCell("null").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.im.IMAutoGenerateResource", (String)"18_IntRateBaseHandler"));
        tblMain.getColumn("null").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        FMClientHelper.setActualDigitNumberFormat((KDTable)tblMain, (String)"null");
        tblMain.addColumn().setKey("Auditor");
        tblMain.addColumn().setKey("AuditDate");
        headRow.getCell("Auditor").setValue((Object)column_auditor);
        headRow.getCell("AuditDate").setValue((Object)column_auditDate);
    }

    public void fillData(KDTable tblMain, IntRateBaseFilterParam param, IntRateTypeInfo info) throws Exception {
        if (info == null || info.getId() == null) {
            return;
        }
        String rateTypeID = info.getId().toString();
        List rateBaseList = this.getRateBaseList(rateTypeID, param);
        IRow headRow = tblMain.getHeadRow(0);
        int i = 0;
        tblMain.getDataRequestManager().setDataRequestMode(0);
        int scale = info.getPrecision();
        for (int l = 0; l < rateBaseList.size(); ++l) {
            IntRateBaseInfo baseInfo = (IntRateBaseInfo)rateBaseList.get(l);
            String id = baseInfo.getId().toString();
            Date effectiveDate = baseInfo.getEffectiveDate();
            String currency = baseInfo.getCurrency().getName();
            BigDecimal yearRate = baseInfo.getYearRate().setScale(scale, 4);
            String termName = baseInfo.getIntTerm().getName();
            String billState = baseInfo.getBillState() == null || "".equals((Object)baseInfo.getBillState()) ? "" : baseInfo.getBillState().getAlias();
            String auditor = baseInfo.getAuditor() == null || "".equals(baseInfo.getAuditor()) ? "" : baseInfo.getAuditor().getName();
            Date auditDate = baseInfo.getAuditDate();
            boolean isSame = false;
            IRow row = null;
            for (int j = 0; j < tblMain.getRowCount(); ++j) {
                row = tblMain.getRow(j);
                if (!((Date)row.getCell("EffectiveDate").getValue()).equals(effectiveDate) || (row.getCell("Currency").getValue() == null || !row.getCell("Currency").getValue().equals(currency)) && (row.getCell("Currency").getValue() != null || currency != null)) continue;
                isSame = true;
                break;
            }
            if (!isSame) {
                row = tblMain.addRow(i);
                ++i;
            }
            row.getCell("EffectiveDate").setValue((Object)effectiveDate);
            row.getCell("Currency").setValue((Object)currency);
            row.getCell("id").setValue((Object)id);
            row.getCell("null").setValue((Object)yearRate);
            row.getCell("null").setUserObject((Object)id);
            row.getCell("BillState").setValue((Object)billState);
            row.getCell("Auditor").setValue((Object)auditor);
            row.getCell("AuditDate").setValue((Object)auditDate);
            row.getCell("EffectiveDate").getStyleAttributes().setNumberFormat(FMHelper.getDateFormatString());
            row.getCell("AuditDate").getStyleAttributes().setNumberFormat(FMHelper.getDateFormatString());
        }
    }

    private List getRateBaseList(String rateTypeID, IntRateBaseFilterParam param) throws EASBizException, BOSException {
        String billState = param.getBillState();
        IIntRateBase iIntRateBase = IntRateBaseFactory.getRemoteInstance();
        List rateBaseList = iIntRateBase.getRateBaseList(rateTypeID, param);
        return rateBaseList;
    }

    public void showDialogWindows(IUIObject ui, String uiName, String id, IntRateTypeInfo info, String status) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"ID", (Object)id);
        uiContext.put((Object)CTX_RATE_TYPE, (Object)info);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, status);
        uiWindow.show();
    }

    public void verifyInfoData(CoreUIObject ui, IntRateBaseInfo info) throws EASBizException, BOSException {
        if (info == null) {
            return;
        }
        if (info.getEffectiveDate() == null) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"EffectiveDateIsNull"));
            SysUtil.abort();
        }
        if (info.getType() == null) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"NoneType"));
            SysUtil.abort();
        }
        if (info.getYearRate() == null || info.getYearRate().compareTo(new BigDecimal("0")) <= 0) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"YearRateIsNotValid"));
            SysUtil.abort();
        }
        if (this.checkIsSame(info)) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"IntRateBaseIsSame"));
            SysUtil.abort();
        }
    }

    public boolean checkIsUsed(String id) throws EASBizException, BOSException {
        IIntRateBase iIntRateBase = IntRateBaseFactory.getRemoteInstance();
        return iIntRateBase.checkIsUsed(id);
    }

    public boolean checkIsSame(IntRateBaseInfo info) throws EASBizException, BOSException {
        IIntRateBase iIntRateBase = IntRateBaseFactory.getRemoteInstance();
        return iIntRateBase.checkIsSame(info);
    }

    public BigDecimal calculateMonthDayRate(BigDecimal yearRate, String type, int typeFactor, int scale) {
        BigDecimal multiplyFactor = new BigDecimal("10");
        BigDecimal divideFactor = new BigDecimal("12");
        if (type != null && type.equals("day")) {
            divideFactor = new BigDecimal(String.valueOf(typeFactor));
        }
        return yearRate.multiply(multiplyFactor).divide(divideFactor, scale, 4);
    }
}

