/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.im.IIntRateBase;
import com.kingdee.eas.fm.im.IIntRateType;
import com.kingdee.eas.fm.im.IntRateBaseFactory;
import com.kingdee.eas.fm.im.IntRateBaseFilterParam;
import com.kingdee.eas.fm.im.IntRateBaseInfo;
import com.kingdee.eas.fm.im.IntRateStateEnum;
import com.kingdee.eas.fm.im.IntRateTypeFactory;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.im.client.AbstractIntRateBaseListUI;
import com.kingdee.eas.fm.im.client.IntRateBaseEditUI;
import com.kingdee.eas.fm.im.client.IntRateBaseFilterUI;
import com.kingdee.eas.fm.im.client.IntRateBaseHandler;
import com.kingdee.eas.fm.im.client.IntRateTypeEditUI;
import com.kingdee.eas.fm.im.client.IntRateTypeHandler;
import com.kingdee.eas.fm.im.client.IntTermListUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.apache.log4j.Logger;

public class IntRateBaseListUI
extends AbstractIntRateBaseListUI {
    private static final Logger logger = CoreUIObject.getLogger(IntRateBaseListUI.class);
    private static String resourcePath = "com.kingdee.eas.fm.im.client.ImResource";
    IntRateBaseHandler handler;
    IntRateBaseFilterParam para;
    private IntRateBaseFilterUI filterUI;
    private IntRateTypeInfo intRateTypeInfo;
    private static final String RATE_TYPE_EDITUI = IntRateTypeEditUI.class.getName();
    private static final String RATE_BASE_EDITUI = IntRateBaseEditUI.class.getName();
    private static final String INT_TERM_LISTUI = IntTermListUI.class.getName();

    public IntRateBaseListUI() throws Exception {
        if (this.handler == null) {
            this.handler = new IntRateBaseHandler();
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionAttachment.setVisible(false);
        this.tHelper.getDisabledTables().add(this.tblMain);
        this.tblMain.setColumnMoveable(true);
        DefaultTreeSelectionModel mode = new DefaultTreeSelectionModel();
        mode.setSelectionMode(1);
        this.treeRateType.setSelectionModel((TreeSelectionModel)mode);
        this.bulidRateTypeTree();
        IntRateTypeInfo irInfo = (IntRateTypeInfo)this.getUIContext().get("fromLoan");
        if (irInfo != null) {
            this.setDefaultTreeNodeFromLoan(irInfo);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionMtnIntTerm.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_maintenance"));
        this.actionNewRateType.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_new"));
        this.actionViewRateType.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_view"));
        this.actionEditRateType.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_edit"));
        this.actionDeleteRateType.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.btnAntiAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.menuAntiaudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.trviewRateType.getControlPane().add((Component)this.btnNewRateType);
        this.trviewRateType.getControlPane().add((Component)this.btnViewRateType);
        this.trviewRateType.getControlPane().add((Component)this.btnEditRateType);
        this.trviewRateType.getControlPane().add((Component)this.btnDeleteRateType);
        this.actionLocate.setVisible(false);
        this.actionAttachment.setVisible(false);
    }

    @Override
    protected String getEditUIName() {
        return IntRateBaseEditUI.class.getName();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return IntRateBaseFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        IntRateBaseInfo objectValue = new IntRateBaseInfo();
        return objectValue;
    }

    private void bulidRateTypeTree() throws EASBizException, BOSException {
        this.treeRateType.setModel((TreeModel)IntRateBaseHandler.getRateTypeTreeModel());
        this.treeRateType.expandAllNodes(true, (TreeNode)this.treeRateType.getModel().getRoot());
        DefaultKingdeeTreeNode rootNode = (DefaultKingdeeTreeNode)this.treeRateType.getModel().getRoot();
        if (rootNode.getChildCount() == 0) {
            this.treeRateType.setSelectionNode(rootNode);
        } else {
            this.treeRateType.setSelectionNode((DefaultKingdeeTreeNode)rootNode.getChildAt(0));
        }
    }

    @Override
    protected void treeRateType_valueChanged(TreeSelectionEvent e) throws Exception {
        TreePath path = e.getNewLeadSelectionPath();
        if (path == null) {
            return;
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeRateType.getModel().getRoot();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        if (node == root) {
            FMClientHelper.clearTable((KDTable)this.tblMain);
            return;
        }
        this.initTableByType();
    }

    protected void execQuery() {
        try {
            this.initTableByType();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void initTableByType() throws Exception {
        IntRateTypeInfo info = this.getCurrentNodeInfo();
        if (info == null) {
            return;
        }
        FMClientHelper.clearTable((KDTable)this.tblMain);
        this.handler.initTable(this.tblMain, info);
        this.handler.fillData(this.tblMain, this.para, info);
    }

    public void executeQuery(FilterParam param) throws BOSException {
        super.executeQuery(param);
        this.para = (IntRateBaseFilterParam)param;
        int i = 2;
        if (this.mainQuery.getSorter() != null && this.mainQuery.getSorter().size() > 0) {
            Iterator iter = this.mainQuery.getSorter().iterator();
            SorterItemInfo sorter = (SorterItemInfo)iter.next();
            if ("auditor.name".equals(sorter.getPropertyName())) {
                sorter.setPropertyName("auditor");
            }
            this.para.setOrderName1(sorter.getPropertyName());
            this.para.setOrderName1Type(sorter.getSortType().toString());
            while (iter.hasNext()) {
                sorter = (SorterItemInfo)iter.next();
                if ("auditor.name".equals(sorter.getPropertyName())) {
                    sorter.setPropertyName("auditor");
                }
                if (i == 2) {
                    this.para.setOrderName2(sorter.getPropertyName());
                    this.para.setOrderName2Type(sorter.getSortType().toString());
                } else if (i == 3) {
                    this.para.setOrderName3(sorter.getPropertyName());
                    this.para.setOrderName3Type(sorter.getSortType().toString());
                } else if (i == 4) {
                    this.para.setOrderName4(sorter.getPropertyName());
                    this.para.setOrderName4Type(sorter.getSortType().toString());
                } else if (i == 5) {
                    this.para.setOrderName5(sorter.getPropertyName());
                    this.para.setOrderName5Type(sorter.getSortType().toString());
                }
                ++i;
            }
        }
        try {
            this.initTableByType();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void tempMergeMainQuery() throws BOSException, Exception {
        this.executeQuery(this.getCustomFilterParam());
    }

    private FilterParam getCustomFilterParam() throws Exception {
        FMFilterBaseUI filterUI = this.getFilterUI();
        FilterParam customFilterParam = null;
        if (filterUI != null) {
            customFilterParam = (FilterParam)filterUI.getParam();
        }
        return customFilterParam;
    }

    public void actionRefresh_actionPerformed(ActionEvent arg0) throws Exception {
        try {
            this.initTableByType();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private IntRateTypeInfo getCurrentNodeInfo() {
        TreePath path = this.treeRateType.getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        IntRateTypeInfo typeInfo = (IntRateTypeInfo)node.getUserObject();
        return typeInfo;
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkTypeIsSelected();
        this.handler.showDialogWindows((IUIObject)this, RATE_BASE_EDITUI, null, this.intRateTypeInfo, OprtState.ADDNEW);
        this.initTableByType();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        String id = this.getSelectCellKeyValue();
        this.handler.showDialogWindows((IUIObject)this, RATE_BASE_EDITUI, id, null, OprtState.VIEW);
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        String id = this.getSelectCellKeyValue();
        if (this.getBillStatus(id)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"RateModify"));
            SysUtil.abort();
        }
        this.handler.showDialogWindows((IUIObject)this, RATE_BASE_EDITUI, id, null, OprtState.EDIT);
        this.initTableByType();
    }

    protected String getSelectedKeyValue() {
        return null;
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        String keyValue = this.getSelectCellKeyValue();
        this.checkSelected();
        if (this.getBillStatus(keyValue)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"RateDelete"));
            SysUtil.abort();
        }
        if (this.confirmRemove()) {
            try {
                this.getBizInterface().delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)keyValue)));
            }
            catch (ObjectNotFoundException onfe) {
                this.handUIException(onfe);
                this.refreshList();
                throw new EASBizException(EASBizException.CHECKEXIST);
            }
            this.refresh(e);
        }
        this.initTableByType();
    }

    @Override
    public void actionMtnIntTerm_actionPerformed(ActionEvent e) throws Exception {
        super.actionMtnIntTerm_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        uiContext.put((Object)"rateType", null);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(INT_TERM_LISTUI, (Map)uiContext, null, null);
        uiWindow.show();
    }

    @Override
    public void actionNewRateType_actionPerformed(ActionEvent e) throws Exception {
        super.actionNewRateType_actionPerformed(e);
        this.handler.showDialogWindows((IUIObject)this, RATE_TYPE_EDITUI, null, null, OprtState.ADDNEW);
        this.bulidRateTypeTree();
    }

    @Override
    public void actionViewRateType_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewRateType_actionPerformed(e);
        this.checkTypeIsSelected();
        String id = this.intRateTypeInfo.getId().toString();
        this.handler.showDialogWindows((IUIObject)this, RATE_TYPE_EDITUI, id, this.intRateTypeInfo, OprtState.VIEW);
        this.bulidRateTypeTree();
    }

    @Override
    public void actionEditRateType_actionPerformed(ActionEvent e) throws Exception {
        super.actionEditRateType_actionPerformed(e);
        this.checkTypeIsSelected();
        String id = this.intRateTypeInfo.getId().toString();
        IntRateTypeHandler typeHandler = new IntRateTypeHandler();
        typeHandler.verifyTypeIsUsed((CoreUIObject)this, id);
        this.handler.showDialogWindows((IUIObject)this, RATE_TYPE_EDITUI, id, this.intRateTypeInfo, OprtState.EDIT);
        this.bulidRateTypeTree();
    }

    @Override
    public void actionDeleteRateType_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeleteRateType_actionPerformed(e);
        this.checkTypeIsSelected();
        String id = this.intRateTypeInfo.getId().toString();
        IntRateTypeHandler typeHandler = new IntRateTypeHandler();
        typeHandler.verifyTypeIsUsed((CoreUIObject)this, id);
        if (!super.confirmRemove()) {
            return;
        }
        IIntRateType iIntRateType = IntRateTypeFactory.getRemoteInstance();
        iIntRateType.delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        this.bulidRateTypeTree();
    }

    public void checkTypeIsSelected() {
        this.intRateTypeInfo = this.getCurrentNodeInfo();
        if (this.intRateTypeInfo == null || this.intRateTypeInfo.getId() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"RateTypeIsNeeded"));
            SysUtil.abort();
        }
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new IntRateBaseFilterUI();
            this.filterUI.setListUI((IUIObject)this);
        }
        return this.filterUI;
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            return;
        }
        if (e.getClickCount() == 1) {
            return;
        }
        String id = this.getSelectCellKeyValue();
        if (id != null) {
            this.handler.showDialogWindows((IUIObject)this, RATE_BASE_EDITUI, id, null, OprtState.VIEW);
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIDs();
        if (idList.size() == 0) {
            return;
        }
        String pkid = (String)idList.get(0);
        IntRateBaseInfo intratebaseinfo = ((IIntRateBase)this.getBizInterface()).getIntRateBaseInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)pkid)));
        IntRateStateEnum billStatus = intratebaseinfo.getBillState();
        this.actionAudit.setEnabled(IntRateStateEnum.SUBMITED.equals((Object)billStatus));
        this.actionAntiaudit.setEnabled(IntRateStateEnum.AUDITED.equals((Object)billStatus));
    }

    private String getSelectCellKeyValue() {
        String id = null;
        KDTSelectBlock sb = this.tblMain.getSelectManager().get();
        int selectedRow = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        if (sb != null) {
            ICell cell = this.tblMain.getCell(selectedRow, 4);
            if (cell == null) {
                return null;
            }
            Object keyValue = cell.getUserObject();
            if (keyValue != null) {
                id = keyValue.toString();
            }
        }
        if (id == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"414_IntRateBaseListUI"));
            SysUtil.abort();
        }
        return id;
    }

    protected CommonQueryDialog getQueryDlg() throws Exception {
        CommonQueryDialog dialog = super.getQueryDlg();
        dialog.setShowFilter(false);
        dialog.setUiObject(null);
        return dialog;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = super.getDefaultFilterForQuery();
        return filter;
    }

    private void setDefaultTreeNodeFromLoan(IntRateTypeInfo irInfo) {
        DefaultKingdeeTreeNode rootNode = (DefaultKingdeeTreeNode)this.treeRateType.getModel().getRoot();
        DefaultKingdeeTreeNode nodeFromLoan = this.searchNodeByTree(rootNode, irInfo.getId().toString());
        this.treeRateType.setSelectionNode(nodeFromLoan);
    }

    private DefaultKingdeeTreeNode searchNodeByTree(DefaultKingdeeTreeNode root, String id) {
        block5: {
            IntRateTypeInfo info = (IntRateTypeInfo)root.getUserObject();
            if (info == null) break block5;
            if (info.getId() != null) {
                if (id.equals(info.getId().toString())) {
                    return root;
                }
                for (int i = 0; i < root.getChildCount(); ++i) {
                    DefaultKingdeeTreeNode node = this.searchNodeByTree((DefaultKingdeeTreeNode)root.getChildAt(i), id);
                    if (node == null) continue;
                    return node;
                }
            } else {
                for (int i = 0; i < root.getChildCount(); ++i) {
                    DefaultKingdeeTreeNode node = this.searchNodeByTree((DefaultKingdeeTreeNode)root.getChildAt(i), id);
                    if (node == null) continue;
                    return node;
                }
            }
        }
        return null;
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"effectiveDate", "currency"};
        return locateNames;
    }

    protected void applyPreference() {
        super.applyPreference();
    }

    @Override
    public void actionAntiaudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList pks = this.getSelectedIdValues();
        Set set = FMHelper.list2Set((List)pks);
        IntRateBaseFactory.getRemoteInstance().antiAudit(set);
        this.showMessage();
        this.initTableByType();
        this.showMsg(e);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList pks = this.getSelectedIdValues();
        Set set = FMHelper.list2Set((List)pks);
        boolean hasWfInstance = FMHelper.hasWFInstance(null, (List)pks);
        if (hasWfInstance) {
            this.actionMultiapprove_actionPerformed(e);
            this.initTableByType();
            return;
        }
        IntRateBaseFactory.getRemoteInstance().audit(set);
        this.showMessage();
        this.initTableByType();
        this.showMsg(e);
    }

    public ArrayList getSelectedIDs() {
        ArrayList<String> list = new ArrayList<String>();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < selectRows.length; ++i) {
            String id;
            ICell cell = this.tblMain.getRow(selectRows[i]).getCell("id");
            if (cell == null || cell.getValue() == null || list.contains(id = cell.getValue().toString())) continue;
            list.add(id);
        }
        return list;
    }

    private boolean getBillStatus(String pkid) throws BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(pkid);
        try {
            IntRateBaseInfo info = IntRateBaseFactory.getRemoteInstance().getIntRateBaseInfo((IObjectPK)pk);
            return info.getBillState().equals((Object)IntRateStateEnum.AUDITED);
        }
        catch (EASBizException e) {
            this.handUIException(e);
            return true;
        }
    }

    private void showMsg(ActionEvent e) throws Exception {
        FMClientHelper.showSuccessMessage((CoreUI)this, (ActionEvent)e);
    }

    public void onShow() {
        this.actionAuditResult.setEnabled(false);
        this.actionAuditResult.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.btnAuditResult.setEnabled(false);
    }
}

