/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.im.IIntRateType;
import com.kingdee.eas.fm.im.IntRateTypeFactory;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;

public class IntRateTypeHandler {
    public static final String resourcePath = "com.kingdee.eas.fm.im.client.ImResource";

    public static IntRateTypeHandler create() {
        return new IntRateTypeHandler();
    }

    public void verifyInfoData(CoreUIObject ui, IntRateTypeInfo info) {
        if (info == null) {
            return;
        }
        if (FMHelper.isEmpty((String)info.getNumber())) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"NoneNumber"));
            SysUtil.abort();
        }
        if (info.getName() == null || info.getName().equals("")) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"NoneName"));
            SysUtil.abort();
        }
        if (info.getPrecision() < 0) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"PrecisionGreaterZero"));
            SysUtil.abort();
        }
    }

    public void verifyTypeIsUsed(CoreUIObject ui, String id) throws EASBizException, BOSException {
        if (this.checkIsUsed(id)) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"RateTypeIsUsed"));
            SysUtil.abort();
        }
    }

    public boolean checkIsUsed(String id) throws EASBizException, BOSException {
        IIntRateType iIntRateType = IntRateTypeFactory.getRemoteInstance();
        return iIntRateType.checkIsUsed(id);
    }
}

