/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.im.IntRateTypeFactory;
import com.kingdee.eas.fm.im.client.AbstractIntRateTypeListUI;
import com.kingdee.eas.fm.im.client.IntRateTypeEditUI;
import com.kingdee.eas.fm.im.client.IntRateTypeHandler;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class IntRateTypeListUI
extends AbstractIntRateTypeListUI {
    private static String resourcePath = "com.kingdee.eas.fm.im.client.ImResource";
    private IntRateTypeHandler handler;

    public IntRateTypeListUI() throws Exception {
        if (this.handler == null) {
            this.handler = IntRateTypeHandler.create();
        }
    }

    @Override
    protected String getEditUIName() {
        return IntRateTypeEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return IntRateTypeFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.setColumnMoveable(true);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        String id = this.getSelectedKeyValue();
        this.verifyRowIsSelected(id);
        this.verifyTypeIsUsed(id);
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        String id = this.getSelectedKeyValue();
        this.verifyRowIsSelected(id);
        this.verifyTypeIsUsed(id);
        super.actionRemove_actionPerformed(e);
    }

    private void verifyRowIsSelected(String id) {
        if (id == null || id.equals("")) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"RowIsNotSelected"));
            SysUtil.abort();
        }
    }

    private void verifyTypeIsUsed(String id) throws EASBizException, BOSException {
        if (this.handler.checkIsUsed(id)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"RateTypeIsUsed"));
            SysUtil.abort();
        }
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }
}

