/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.im.CycleTypeEnum;
import com.kingdee.eas.fm.im.IIntScheme;
import com.kingdee.eas.fm.im.IntSchemeCollection;
import com.kingdee.eas.fm.im.IntSchemeFactory;
import com.kingdee.eas.fm.im.IntSchemeInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;

public class IntSchemeUtils {
    public static final String resourcePath = "com.kingdee.eas.fm.im.client.ImResource";

    public static void initIntScheme() throws EASBizException, BOSException {
        IIntScheme bizInterface = IntSchemeFactory.getRemoteInstance();
        if (!IntSchemeUtils.isExistsNumber(bizInterface, "001")) {
            IntSchemeInfo intSchemeByMonth = new IntSchemeInfo();
            intSchemeByMonth.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            intSchemeByMonth.setNumber("001");
            intSchemeByMonth.setName(EASResource.getString((String)resourcePath, (String)"IntSchemeByMonth"));
            intSchemeByMonth.setCycleType(CycleTypeEnum.MONTH);
            intSchemeByMonth.setSettleDay(20);
            intSchemeByMonth.setDescription(EASResource.getString((String)resourcePath, (String)"CycleType_Month_Desc"));
            bizInterface.submit((CoreBaseInfo)intSchemeByMonth);
        }
        if (!IntSchemeUtils.isExistsNumber(bizInterface, "002")) {
            IntSchemeInfo intSchemeByQuarter = new IntSchemeInfo();
            intSchemeByQuarter.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            intSchemeByQuarter.setNumber("002");
            intSchemeByQuarter.setName(EASResource.getString((String)resourcePath, (String)"IntSchemeByQuarter"));
            intSchemeByQuarter.setCycleType(CycleTypeEnum.QUARTER);
            intSchemeByQuarter.setSettleDay(20);
            intSchemeByQuarter.setDescription(EASResource.getString((String)resourcePath, (String)"CycleType_Quarter_Desc"));
            bizInterface.submit((CoreBaseInfo)intSchemeByQuarter);
        }
        if (!IntSchemeUtils.isExistsNumber(bizInterface, "003")) {
            IntSchemeInfo intSchemeByYear = new IntSchemeInfo();
            intSchemeByYear.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            intSchemeByYear.setNumber("003");
            intSchemeByYear.setName(EASResource.getString((String)resourcePath, (String)"IntSchemeByYear"));
            intSchemeByYear.setCycleType(CycleTypeEnum.YEAR);
            intSchemeByYear.setSettleDay(20);
            intSchemeByYear.setDescription(EASResource.getString((String)resourcePath, (String)"CycleType_Year_Desc"));
            bizInterface.submit((CoreBaseInfo)intSchemeByYear);
        }
    }

    private static boolean isExistsNumber(IIntScheme bizInterface, String number) throws BOSException {
        EntityViewInfo entity = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        entity.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        entity.getSelector().addObjectCollection((IObjectCollection)selector);
        IntSchemeCollection intSchemeCol = bizInterface.getIntSchemeCollection(entity);
        return intSchemeCol != null && intSchemeCol.size() > 0;
    }
}

