/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.im.IntTermFactory;
import com.kingdee.eas.fm.im.IntTermInfo;
import com.kingdee.eas.fm.im.TermTypeEnum;
import com.kingdee.eas.fm.im.client.AbstractIntTermEditUI;
import com.kingdee.eas.fm.im.client.IntTermHandler;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class IntTermEditUI
extends AbstractIntTermEditUI {
    private static String resourcePath = "com.kingdee.eas.fm.im.client.ImResource";
    private IntTermHandler handler;

    public IntTermEditUI() throws Exception {
        if (this.handler == null) {
            this.handler = IntTermHandler.create();
        }
    }

    public void onLoad() throws Exception {
        SpinnerNumberModel precisionSpinnerNumberModel = new SpinnerNumberModel();
        precisionSpinnerNumberModel.setMinimum(new Integer(1));
        precisionSpinnerNumberModel.setMaximum(new Integer(999));
        this.spiTerm.setModel((SpinnerModel)precisionSpinnerNumberModel);
        super.onLoad();
        FMClientHelper.clearSeparatorOnToolBar((KDToolBar)this.toolBar);
        this.txtName.setRequired(true);
        this.menuBar.setVisible(false);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return IntTermFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        IntTermInfo objectValue = new IntTermInfo();
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        objectValue.setTerm(1);
        objectValue.setType(TermTypeEnum.MONTH);
        return objectValue;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        this.handler.verifyInfoData((CoreUIObject)this, this.editData);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    protected void comboType_itemStateChanged(ItemEvent e) throws Exception {
        SpinnerNumberModel spinModel = (SpinnerNumberModel)this.spiTerm.getModel();
        TermTypeEnum termType = (TermTypeEnum)((Object)this.comboType.getSelectedItem());
        if (termType.equals((Object)TermTypeEnum.DAY)) {
            spinModel.setMinimum(new Integer(1));
            spinModel.setMaximum(new Integer(9999));
        } else if (termType.equals((Object)TermTypeEnum.MONTH)) {
            spinModel.setMinimum(new Integer(1));
            spinModel.setMaximum(new Integer(999));
        } else {
            spinModel.setMinimum(new Integer(1));
            spinModel.setMaximum(new Integer(99));
        }
        spinModel.setValue(new Integer(1));
    }

    private void verifyTermIsUsed(String id) throws EASBizException, BOSException {
        if (this.handler.checkIsUsed(id)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"RateTermIsUsed"));
            SysUtil.abort();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        String id = this.editData.getId().toString();
        this.verifyTermIsUsed(id);
        super.actionEdit_actionPerformed(e);
    }
}

