/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.im.IIntTerm;
import com.kingdee.eas.fm.im.IntTermFactory;
import com.kingdee.eas.fm.im.IntTermInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;

public class IntTermHandler {
    public static final String resourcePath = "com.kingdee.eas.fm.im.client.ImResource";

    public static IntTermHandler create() {
        return new IntTermHandler();
    }

    public void verifyInfoData(CoreUIObject ui, IntTermInfo info) throws EASBizException, BOSException {
        if (info == null) {
            return;
        }
        String id = null;
        if (info.getId() != null) {
            id = info.getId().toString();
        }
        if (info.getName() == null || info.getName().equals("")) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"NoneName"));
            SysUtil.abort();
        }
        if (info.getTerm() <= 0) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"TermGreaterZero"));
            SysUtil.abort();
        }
        if (info.getType() == null) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"NoneType"));
            SysUtil.abort();
        }
        if (this.checkNameIsSame(id, info.getName())) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"TermNameSame"));
            SysUtil.abort();
        }
        if (this.checkTermTypeIsSame(id, info.getTerm(), info.getType().getValue())) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"TermTypeSame"));
            SysUtil.abort();
        }
    }

    public boolean checkIsUsed(String id) throws EASBizException, BOSException {
        IIntTerm iIntTerm = IntTermFactory.getRemoteInstance();
        return iIntTerm.checkIsUsed(id);
    }

    public boolean checkNameIsSame(String id, String name) throws EASBizException, BOSException {
        IIntTerm iIntTerm = IntTermFactory.getRemoteInstance();
        return iIntTerm.checkNameIsSame(id, name);
    }

    public boolean checkTermTypeIsSame(String id, int term, int type) throws EASBizException, BOSException {
        IIntTerm iIntTerm = IntTermFactory.getRemoteInstance();
        return iIntTerm.checkTermTypeIsSame(id, term, type);
    }
}

