/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.im.IntTermFactory;
import com.kingdee.eas.fm.im.client.AbstractIntTermListUI;
import com.kingdee.eas.fm.im.client.IntTermEditUI;
import com.kingdee.eas.fm.im.client.IntTermHandler;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class IntTermListUI
extends AbstractIntTermListUI {
    private static String resourcePath = "com.kingdee.eas.fm.im.client.ImResource";
    private IntTermHandler handler;

    public IntTermListUI() throws Exception {
        if (this.handler == null) {
            this.handler = IntTermHandler.create();
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.setColumnMoveable(true);
        FMClientHelper.clearSeparatorOnToolBar((KDToolBar)this.toolBar);
    }

    @Override
    protected String getEditUIName() {
        return IntTermEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return IntTermFactory.getRemoteInstance();
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        String id = this.getSelectedKeyValue();
        this.verifyRowIsSelected(id);
        this.verifyTermIsUsed(id);
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        String id = this.getSelectedKeyValue();
        this.verifyRowIsSelected(id);
        this.verifyTermIsUsed(id);
        super.actionRemove_actionPerformed(e);
    }

    private void verifyRowIsSelected(String id) {
        if (id == null || id.equals("")) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"RowIsNotSelected"));
            SysUtil.abort();
        }
    }

    private void verifyTermIsUsed(String id) throws EASBizException, BOSException {
        if (this.handler.checkIsUsed(id)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"RateTermIsUsed"));
            SysUtil.abort();
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo info = super.getDefaultFilterForQuery();
        info.getFilterItems().add(new FilterItemInfo("id", (Object)"jhNyIgEWEADgAAr6wKgSC61eI6Y=", CompareType.NOTEQUALS));
        return info;
    }
}

