/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.cl.ConsignmentLoanBillInfo;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FloatActionEnum;
import com.kingdee.eas.fm.fin.IntBasis;
import com.kingdee.eas.fm.fin.IntRateModifyType;
import com.kingdee.eas.fm.fin.util.FinHorizon;
import com.kingdee.eas.fm.ft.FundTransferBillInfo;
import com.kingdee.eas.fm.im.IIntRateBase;
import com.kingdee.eas.fm.im.IMException;
import com.kingdee.eas.fm.im.IntCalTypeEnum;
import com.kingdee.eas.fm.im.IntRateBaseCollection;
import com.kingdee.eas.fm.im.IntRateBaseFactory;
import com.kingdee.eas.fm.im.IntRateBaseInfo;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.im.PenAccrualTypeEnum;
import com.kingdee.eas.fm.im.util.IAdjustIntRateCollection;
import com.kingdee.eas.fm.im.util.IAdjustIntRateInfo;
import com.kingdee.eas.fm.im.util.ILoanExtendBillCollection;
import com.kingdee.eas.fm.im.util.ILoanInfo;
import com.kingdee.eas.fm.im.util.IRepaymentBillCollection;
import com.kingdee.eas.fm.im.util.IRepaymentBillInfo;
import com.kingdee.eas.fm.im.util.IntCalHelper;
import com.kingdee.eas.fm.im.util.IntCalModel;
import com.kingdee.eas.fm.im.util.LoanInterestEntryInfo;
import com.kingdee.eas.fm.im.util.LoanInterestInfo;
import com.kingdee.eas.fm.im.util.PayIntCalStragety;
import com.kingdee.eas.fm.im.util.PreIntCalStragety;
import com.kingdee.eas.fm.im.util.RecIntCalStragety;
import com.kingdee.eas.fm.im.util.RepayIntCalStragety;
import com.kingdee.eas.fm.ivt.ChLoanInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractIntCalStragety {
    private static final BigDecimal ONE_HUNDRED = Constants.ONE_HUNDRED;
    private static final int SCALE = 5;
    protected static final String ACCORD_INTRATE_ID = "lJlpCQEQEADgAAc+wKgSjiR9knQ=";
    protected static final String ACCORD_GUDING_ID = "QYYAAAAKQTYkfZJ0";
    private Boolean isPrediction = false;
    protected Date beginDate = null;
    protected Date endDate = null;
    protected ILoanInfo loanInfo = null;
    protected IRepaymentBillInfo repayInfo = null;
    protected ILoanExtendBillCollection loanExColl = null;
    protected IAdjustIntRateCollection adjIntRateColl = null;
    private List<IAdjustIntRateInfo> adjIntRateList = new ArrayList<IAdjustIntRateInfo>();
    protected IRepaymentBillCollection repayColl = null;
    protected IntRateBaseCollection intRateBaseColl = null;
    protected IntRateBaseCollection adjuIntRateBaseColl = new IntRateBaseCollection();
    protected Map<String, IntRateBaseCollection> adjIntRateBaseMap = new HashMap<String, IntRateBaseCollection>();
    private Context ctx = null;
    String currencyId = null;
    protected boolean INT006 = true;

    public static AbstractIntCalStragety getInstance(IntCalTypeEnum intCalType) {
        switch (intCalType.getValue()) {
            case 0: {
                return new PreIntCalStragety();
            }
            case 1: {
                return new RecIntCalStragety();
            }
            case 4: {
                return new PayIntCalStragety();
            }
            case 2: {
                return new RepayIntCalStragety();
            }
        }
        return new PreIntCalStragety();
    }

    private void init(Context ctx, IntCalModel model) throws EASBizException, BOSException {
        this.isPrediction = model.getIsPrediction();
        this.loanInfo = model.getLoanInfo();
        this.repayInfo = model.getRepayInfo();
        this.loanExColl = model.getLoanExColl();
        this.adjIntRateColl = model.getAdjIntRateColl();
        this.repayColl = model.getRepayColl();
        this.ctx = ctx;
        if (!EmptyUtil.isEmpty((CoreBaseInfo)this.loanInfo.getIntRateType())) {
            String intRateTypeId = this.loanInfo.getIntRateType().getId().toString();
            this.currencyId = this.loanInfo.getCurrency().getId().toString();
            this.intRateBaseColl = this.isAccordIntRate() ? new IntRateBaseCollection() : this.getIntRateBaseColl(ctx, intRateTypeId, this.currencyId);
            this.getIntRateBaseCollFromAdj(ctx, this.currencyId);
        }
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        this.INT006 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("INT006", (IObjectPK)new ObjectUuidPK(companyInfo.getId().toString()));
    }

    private IntRateBaseCollection getIntRateBaseColl(Context ctx, String intRateTypeId, String currencyId) throws BOSException, EASBizException {
        if (EmptyUtil.isEmpty((String)intRateTypeId)) {
            return new IntRateBaseCollection();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("type.id", (Object)intRateTypeId));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        filter.getFilterItems().add(new FilterItemInfo("intTerm", null, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)"1"));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("effectiveDate"));
        IIntRateBase iIntRateBase = IntRateBaseFactory.getLocalInstance(ctx);
        IntRateBaseCollection intRateBaseColl = iIntRateBase.getIntRateBaseCollection(evi);
        if (intRateBaseColl == null || intRateBaseColl.isEmpty()) {
            throw new IMException(IMException.NOBASERATE);
        }
        return intRateBaseColl;
    }

    private void getIntRateBaseCollFromAdj(Context ctx, String currencyId) throws BOSException, EASBizException {
        String adjIntRateTypeId = null;
        int count = this.adjIntRateColl.size();
        for (int index = 0; index < count; ++index) {
            if (IntRateModifyType.Agreement.equals((Object)this.adjIntRateColl.get(index).getModifyRateType()) || this.adjIntRateColl.get(index).getIntRateTypeInfo() == null || (adjIntRateTypeId = this.adjIntRateColl.get(index).getIntRateTypeInfo().getId().toString()) == null || adjIntRateTypeId != null && this.isAccordIntRate(adjIntRateTypeId)) continue;
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("type.id", (Object)adjIntRateTypeId));
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
            filter.getFilterItems().add(new FilterItemInfo("intTerm", null, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("billState", (Object)"1"));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            evi.getSorter().add(new SorterItemInfo("effectiveDate"));
            IIntRateBase iIntRateBase = IntRateBaseFactory.getLocalInstance(ctx);
            IntRateBaseCollection intRateBaseColl = iIntRateBase.getIntRateBaseCollection(evi);
            if (intRateBaseColl == null || intRateBaseColl.isEmpty()) {
                throw new IMException(IMException.NOBASERATE);
            }
            this.adjIntRateBaseMap.put(adjIntRateTypeId, intRateBaseColl);
            this.adjuIntRateBaseColl.addCollection(intRateBaseColl);
        }
    }

    public LoanInterestInfo calInt(Context ctx, IntCalModel model) throws EASBizException, BOSException {
        this.init(ctx, model);
        this.beginDate = this.doGetBeginDate(model.getIsPrediction(), model.getBeginDate(), model);
        this.endDate = this.doGetEndDate(model.getEndDate());
        this.beginDate = DateTimeUtils.truncateDate((Date)this.beginDate);
        this.endDate = DateTimeUtils.truncateDate((Date)this.endDate);
        if (this.beginDate.compareTo(this.endDate) > 0) {
            throw new IMException(IMException.CALINTDATEERROR);
        }
        List subBeginDateList = this.getSubBeginDateListRefactor(ctx, this.beginDate, this.endDate);
        Date subBeginDate = this.beginDate;
        Date subEndDate = this.endDate;
        BigDecimal intPrinciple = Constants.ZERO;
        IntRateTypeExpressionEnum intRateTypeExp = null;
        int convertDays = 0;
        BigDecimal intRate = Constants.ZERO;
        PenAccrualTypeEnum punishType = null;
        BigDecimal punishIntRate = Constants.ZERO;
        Date expiredDate = this.loanInfo.getExpiredDate();
        boolean isCalPunishInt = false;
        int seq = 0;
        LoanInterestInfo intInfo = new LoanInterestInfo();
        LoanInterestEntryInfo intEntryInfo = null;
        IAdjustIntRateInfo adjInfo = null;
        SubBeginDateInfo subDateInfo = null;
        boolean notRepayWithSub = true;
        CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.loanInfo.getCurrency().getId()));
        int size = subBeginDateList.size();
        for (int i = 0; i < size; ++i) {
            ++seq;
            if (subBeginDateList.get(i) instanceof SubBeginDateInfo) {
                subDateInfo = (SubBeginDateInfo)subBeginDateList.get(i);
                subEndDate = DateUtil.getBeforeDay((Date)subDateInfo.getBeginDate());
            } else {
                subEndDate = DateUtil.getBeforeDay((Date)((Date)subBeginDateList.get(i)));
            }
            intPrinciple = this.doGetSubIntPrinciple(subBeginDate);
            if (intPrinciple.compareTo(BigDecimal.ZERO) <= 0 && !this.isPrediction.booleanValue()) continue;
            adjInfo = IntCalHelper.getValidAdjInfo(subBeginDate, this.adjIntRateColl);
            intRateTypeExp = this.getSubIntRateTypeExp(subBeginDate, adjInfo);
            convertDays = this.getSubConvertDays(subBeginDate, adjInfo);
            if (notRepayWithSub) {
                intRate = subBeginDate.compareTo(this.beginDate) == 0 && subDateInfo != null ? this.getIntRateAsFirstSub(this.beginDate, adjInfo) : this.getSubIntRate(subBeginDate, adjInfo);
            }
            notRepayWithSub = subDateInfo == null || !subDateInfo.getIsRepayWithPrinciple();
            punishType = this.getSubPunishType(subBeginDate, adjInfo);
            punishIntRate = this.getSubPunishIntRate(subBeginDate, adjInfo);
            isCalPunishInt = this.doIsCalPunishInt(subEndDate);
            intEntryInfo = this.buildIntEntryInfo(seq, subBeginDate, subEndDate, expiredDate, intPrinciple, intRate, convertDays, punishIntRate, isCalPunishInt, punishType, intRateTypeExp, currencyInfo);
            intInfo.getEntries().add(intEntryInfo);
            subBeginDate = subBeginDateList.get(i) instanceof SubBeginDateInfo ? ((SubBeginDateInfo)subBeginDateList.get(i)).getBeginDate() : (Date)subBeginDateList.get(i);
        }
        adjInfo = IntCalHelper.getValidAdjInfo(subBeginDate, this.adjIntRateColl);
        ++seq;
        Date lastSubDate = subEndDate;
        subEndDate = this.endDate;
        intPrinciple = this.doGetSubIntPrinciple(subBeginDate);
        if (intPrinciple.compareTo(BigDecimal.ZERO) > 0 || this.isPrediction.booleanValue()) {
            intRateTypeExp = this.getSubIntRateTypeExp(subBeginDate, adjInfo);
            convertDays = this.getSubConvertDays(subBeginDate, adjInfo);
            if (notRepayWithSub) {
                intRate = subBeginDate.compareTo(this.beginDate) == 0 ? this.getIntRateAsFirstSub(this.beginDate, adjInfo) : this.getSubIntRate(subBeginDate, adjInfo);
            }
            punishType = this.getSubPunishType(subBeginDate, adjInfo);
            punishIntRate = this.getSubPunishIntRate(subBeginDate, adjInfo);
            isCalPunishInt = this.doIsCalPunishInt(subEndDate);
            intEntryInfo = this.buildIntEntryInfo(seq, subBeginDate, subEndDate, expiredDate, intPrinciple, intRate, convertDays, punishIntRate, isCalPunishInt, punishType, intRateTypeExp, currencyInfo);
            intInfo.getEntries().add(intEntryInfo);
        } else {
            this.endDate = lastSubDate;
        }
        intInfo = this.buildIntInfo(ctx, this.beginDate, this.endDate, intInfo);
        if (intInfo.getInterest().compareTo(BigDecimal.ZERO) == 0) {
            if (model.getLoanInfo() instanceof ConsignmentLoanBillInfo) {
                throw new IMException(IMException.CONSIGN_NO_INTEREST);
            }
            if (model.getLoanInfo() instanceof FundTransferBillInfo) {
                throw new IMException(IMException.FUNDTRANS_NO_INTEREST);
            }
            if (model.getLoanInfo() instanceof ChLoanInfo) {
                throw new IMException(IMException.CHLOAN_NO_INTEREST);
            }
        }
        return intInfo;
    }

    private LoanInterestEntryInfo buildIntEntryInfo(int seq, Date subBeginDate, Date subEndDate, Date expiredDate, BigDecimal intPrinciple, BigDecimal intRate, int convertDays, BigDecimal punishIntRate, boolean isCalPunishInt, PenAccrualTypeEnum punishType, IntRateTypeExpressionEnum intRateTypeExp, CurrencyInfo currency) throws EASBizException {
        int days = 0;
        days = this.loanInfo.getIntBasis() == null || IntBasis.Actual.equals((Object)this.loanInfo.getIntBasis()) ? IntCalHelper.getDiffDays(subBeginDate, subEndDate) : IntCalHelper.getDiffDaysByIntBasis(subBeginDate, subEndDate, this.loanInfo.getIntBasis());
        LoanInterestEntryInfo intEntryInfo = new LoanInterestEntryInfo();
        intEntryInfo.setSeq(seq);
        intEntryInfo.setBeginDate(subBeginDate);
        intEntryInfo.setEndDate(subEndDate);
        intEntryInfo.setDays(days);
        intEntryInfo.setPrincipal(intPrinciple);
        intEntryInfo.setIntRate(intRate);
        intEntryInfo.setPunishType(punishType);
        intEntryInfo.setInterest(IntCalHelper.calIntertest(intPrinciple, intRate, convertDays, days, intRateTypeExp, currency));
        intEntryInfo.setConvertDays(convertDays);
        intEntryInfo.setIntRateTypeExp(intRateTypeExp);
        intEntryInfo.setAdjIntBillId(this.getAdjustIntBillIdExt(subBeginDate, this.adjIntRateColl));
        int overdueDays = 0;
        BigDecimal punishInterest = Constants.ZERO;
        if (isCalPunishInt && punishType != null) {
            if (subEndDate.compareTo(expiredDate) >= 0) {
                overdueDays = IntCalHelper.getOverdueDays(subBeginDate, subEndDate, expiredDate);
                punishInterest = IntCalHelper.calPunishInt(intPrinciple, intRate, punishIntRate, overdueDays, convertDays, punishType, intRateTypeExp);
            } else {
                overdueDays = 0;
                punishInterest = Constants.ZERO;
            }
        }
        intEntryInfo.setOverdueDays(overdueDays);
        intEntryInfo.setPunishIntRate(punishIntRate);
        intEntryInfo.setPunishInterest(punishInterest);
        return intEntryInfo;
    }

    private LoanInterestInfo buildIntInfo(Context ctx, Date beginDate, Date endDate, LoanInterestInfo intInfo) throws BOSException, EASBizException {
        intInfo.setRepayInfo(this.repayInfo);
        intInfo.setLoanInfo(this.loanInfo);
        int size = intInfo.getEntries().size();
        if (size == 0) {
            throw new FinBizException(FinBizException.NOT_RECINT);
        }
        int totalDays = 0;
        for (int i = 0; i < intInfo.getEntries().size(); ++i) {
            LoanInterestEntryInfo entry = intInfo.getEntries().get(i);
            totalDays += entry.getDays();
        }
        LoanInterestEntryInfo intEntryInfo = intInfo.getEntries().get(size - 1);
        intInfo.setIntCalType(this.doGetIntCalType());
        intInfo.setCurrency(this.loanInfo.getCurrency());
        intInfo.setBizDate(DateUtil.getDayBegin());
        intInfo.setBeginDate(DateTimeUtils.truncateDate((Date)beginDate));
        intInfo.setEndDate(DateTimeUtils.truncateDate((Date)endDate));
        intInfo.setDays(totalDays);
        intInfo.setPrincipal(intEntryInfo.getPrincipal());
        intInfo.setIntRate(intEntryInfo.getIntRate());
        intInfo.setIntRateTypeExp(intEntryInfo.getIntRateTypeExp());
        intInfo.setOverdueDays(intEntryInfo.getOverdueDays());
        intInfo.setPunishType(intEntryInfo.getPunishType());
        intInfo.setPunishIntRate(intEntryInfo.getPunishIntRate());
        intInfo.setInterest(IntCalHelper.getTotalInterest(intInfo.getEntries()));
        intInfo.setPunishInterest(IntCalHelper.getTotalPunishInterest(intInfo.getEntries()));
        intInfo.setInterestActual(intInfo.getInterest());
        intInfo.setPunishInterestActual(intInfo.getPunishInterest());
        int intCalType = intInfo.getIntCalType().getValue();
        if (intCalType == 1 || intCalType == 4) {
            intInfo.setLastIntDate(this.loanInfo.getLastIntDate());
        } else if (intCalType == 2) {
            BigDecimal balance;
            BigDecimal repatAmt = intInfo.getRepayInfo().getRepayAmt();
            if (repatAmt.compareTo(balance = intInfo.getLoanInfo().getLoanBalance()) == 0) {
                intInfo.setLastIntDate(this.loanInfo.getLastIntDate());
            }
        } else {
            intInfo.setLastIntDate(this.loanInfo.getLastPreIntDate());
        }
        intInfo.setDescription(IntCalHelper.getDefaultDesc(intInfo.getBeginDate(), intInfo.getEndDate()));
        return intInfo;
    }

    List getAccorSubBeginDateList(List list, Date subBeginDate, Date firstRateAdjustRate) {
        int rateAdjustPeriod = 0;
        int size = this.adjIntRateColl.size();
        for (int i = 0; i < size; ++i) {
            IAdjustIntRateInfo adjustInfo = this.adjIntRateColl.get(i);
            subBeginDate = adjustInfo.getAdjustDate();
            subBeginDate = DateTimeUtils.truncateDate((Date)subBeginDate);
            Date firstRateAdjustDate = adjustInfo.getFirstRateAdjustDate();
            IntRateModifyType modifyRateType = adjustInfo.getModifyRateType();
            if (IntRateModifyType.LPR.equals((Object)modifyRateType) || IntRateModifyType.LPR_Adjustment.equals((Object)modifyRateType)) {
                String intRateTypeId = adjustInfo.getIntRateTypeInfo().getId().toString();
                if (ACCORD_GUDING_ID.equals(intRateTypeId)) {
                    if (!this.isBetweenBeginDateAndEndDate(this.beginDate, this.endDate, subBeginDate) || list.contains(subBeginDate)) continue;
                    list.add(subBeginDate);
                    continue;
                }
                firstRateAdjustRate = adjustInfo.getFirstRateAdjustDate();
                if (adjustInfo.getRateAdjustPeriod() > 0) {
                    rateAdjustPeriod = adjustInfo.getRateAdjustPeriod();
                    list = this.getSubBeginDateListWithPeriodAndFirstRateAdjDateAccor(list, firstRateAdjustRate, rateAdjustPeriod);
                    if (!this.isBetweenBeginDateAndEndDate(this.beginDate, this.endDate, subBeginDate)) continue;
                    if (!list.contains(subBeginDate)) {
                        list.add(subBeginDate);
                    }
                    if (!IntRateModifyType.LPR.equals((Object)modifyRateType) && !IntRateModifyType.LPR_Adjustment.equals((Object)modifyRateType) || !firstRateAdjustDate.after(subBeginDate) || !this.isBetweenBeginDateAndEndDate(this.beginDate, this.endDate, firstRateAdjustDate) || list.contains(firstRateAdjustDate)) continue;
                    list.add(firstRateAdjustDate);
                    continue;
                }
                Date adjustDate = adjustInfo.getAdjustDate();
                IntRateBaseCollection coll = this.adjIntRateBaseMap.get(intRateTypeId);
                this.addList(coll, list, adjustDate);
                if (!list.contains(adjustDate) && this.isBetweenBeginDateAndEndDate(this.beginDate, this.endDate, adjustDate)) {
                    list.add(adjustDate);
                }
                if (list.contains(firstRateAdjustDate) || !this.isBetweenBeginDateAndEndDate(this.beginDate, this.endDate, firstRateAdjustDate)) continue;
                list.add(firstRateAdjustDate);
                continue;
            }
            if (!IntRateModifyType.Agreement.equals((Object)modifyRateType) && modifyRateType != null || !this.isBetweenBeginDateAndEndDate(this.beginDate, this.endDate, subBeginDate) || list.contains(subBeginDate)) continue;
            list.add(subBeginDate);
        }
        return list;
    }

    private void addList(IntRateBaseCollection coll, List list, Date adjustDate) {
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            Date effectiveDate = coll.get(i).getEffectiveDate();
            if (!this.isBetweenBeginDateAndEndDate(this.beginDate, this.endDate, effectiveDate = DateTimeUtils.truncateDate((Date)effectiveDate)) || effectiveDate.compareTo(adjustDate) < 0 || list.contains(effectiveDate)) continue;
            list.add(effectiveDate);
        }
    }

    private BigDecimal getIntRateAsFirstSub(Date beginDate, IAdjustIntRateInfo adjInfo) throws EASBizException {
        Date firstAdjDate = this.loanInfo.getFirstRateAdjustDate();
        if (firstAdjDate != null && beginDate.compareTo(firstAdjDate) >= 0 && adjInfo == null) {
            int rateAdjustPeriod = this.loanInfo.getRateAdjustPeriod();
            if (rateAdjustPeriod == 0) {
                return this.getSubIntRate(beginDate, adjInfo);
            }
            Calendar firstCalendar = Calendar.getInstance();
            firstCalendar.setTime(firstAdjDate);
            int flashDay = firstCalendar.get(5);
            Date limitDate = firstAdjDate;
            if (rateAdjustPeriod > 0) {
                while (firstAdjDate.compareTo(beginDate) <= 0) {
                    limitDate = firstCalendar.getTime();
                    firstCalendar = this.setTimeOfNextPeriod(firstCalendar, flashDay, rateAdjustPeriod);
                    firstAdjDate = firstCalendar.getTime();
                }
            }
            return this.getSubIntRate(limitDate, adjInfo);
        }
        return this.getSubIntRate(beginDate, adjInfo);
    }

    private Date getNextPeriodDate(Date prePeriod, int rateAdjustPeriod) {
        return this.getNextPeriodDate(this.loanInfo.getFirstRateAdjustDate(), prePeriod, rateAdjustPeriod);
    }

    private Date getNextPeriodDate(Date firstRateAdjustDate, Date prePeriod, int rateAdjustPeriod) {
        Calendar firstCalendar = Calendar.getInstance();
        firstCalendar.setTime(prePeriod);
        int flashDay = firstCalendar.get(5);
        firstCalendar.add(2, rateAdjustPeriod);
        if (flashDay >= 28) {
            int days = DateTimeUtils.daysOfMonth((int)firstCalendar.get(1), (int)(firstCalendar.get(2) + 1));
            if (this.isLastDayOfMonth(firstRateAdjustDate)) {
                firstCalendar.set(5, days);
            } else {
                int firstRateAdjustDateDay = this.getFirstRateAdjustDateDay(firstRateAdjustDate);
                if (days < firstRateAdjustDateDay) {
                    firstCalendar.set(5, days);
                } else {
                    firstCalendar.set(5, firstRateAdjustDateDay);
                }
            }
        }
        return firstCalendar.getTime();
    }

    private boolean isLastDayOfMonth(Date firstRateAdjustDate) {
        if (firstRateAdjustDate == null) {
            return false;
        }
        Calendar firstCalendar = Calendar.getInstance();
        firstCalendar.setTime(firstRateAdjustDate);
        int flashDay = firstCalendar.get(5);
        int days = DateTimeUtils.daysOfMonth((int)firstCalendar.get(1), (int)(firstCalendar.get(2) + 1));
        return flashDay == days;
    }

    private int getFirstRateAdjustDateDay(Date firstRateAdjustDate) {
        if (firstRateAdjustDate == null) {
            return 0;
        }
        Calendar firstCalendar = Calendar.getInstance();
        firstCalendar.setTime(firstRateAdjustDate);
        int flashDay = firstCalendar.get(5);
        return flashDay;
    }

    List getSubBeginDateListWthPeriod(Context ctx, Date firstRateAdjustDate, int rateAdjustPeriod) {
        List<SubBeginDateInfo> list = new ArrayList<SubBeginDateInfo>();
        Date subBeginDate = null;
        Calendar rateFirstAdjustCalendar = Calendar.getInstance();
        rateFirstAdjustCalendar.setTime(firstRateAdjustDate);
        int flashDay = rateFirstAdjustCalendar.get(5);
        Calendar preCalendar = Calendar.getInstance();
        preCalendar.setTime(this.beginDate);
        Calendar nextCalendar = Calendar.getInstance();
        nextCalendar.setTime(firstRateAdjustDate);
        Date newAdjustDate = null;
        int newRateAdjustPeriod = 0;
        Date newFirstRateAdjustDate = null;
        String newIntRateTypeId = null;
        if (this.hasAdjustInt()) {
            SubBeginDateInfo subDateInfo;
            IAdjustIntRateInfo adjustInfo = this.adjIntRateColl.get(0);
            newAdjustDate = adjustInfo.getAdjustDate();
            newRateAdjustPeriod = adjustInfo.getRateAdjustPeriod();
            newFirstRateAdjustDate = adjustInfo.getFirstRateAdjustDate();
            newIntRateTypeId = adjustInfo.getIntRateTypeInfo().getId().toString();
            while (nextCalendar.getTime().compareTo(DateTimeUtils.truncateDate((Date)this.endDate)) <= 0 && nextCalendar.getTime().compareTo(newAdjustDate) < 0) {
                if (this.hasRateInFlash(preCalendar.getTime(), nextCalendar.getTime(), this.intRateBaseColl) || this.hasRateInFlash(this.loanInfo.getStartDate(), nextCalendar.getTime(), this.intRateBaseColl)) {
                    subDateInfo = new SubBeginDateInfo();
                    subDateInfo.setBeginDate(nextCalendar.getTime());
                    if (!list.contains(subDateInfo) && nextCalendar.getTime().compareTo(this.beginDate) >= 0) {
                        list.add(subDateInfo);
                    }
                }
                preCalendar.setTime(nextCalendar.getTime());
                nextCalendar.setTime(this.setTimeOfNextPeriod(nextCalendar, flashDay, rateAdjustPeriod).getTime());
            }
            if (ACCORD_GUDING_ID.equals(newIntRateTypeId)) {
                if (this.isBetweenBeginDateAndEndDate(this.beginDate, this.endDate, newAdjustDate)) {
                    subDateInfo = new SubBeginDateInfo();
                    subDateInfo.setBeginDate(newAdjustDate);
                    if (!list.contains(subDateInfo)) {
                        list.add(subDateInfo);
                    }
                }
            } else if (!ACCORD_GUDING_ID.equals(newIntRateTypeId)) {
                subBeginDate = adjustInfo.getAdjustDate();
                subBeginDate = DateTimeUtils.truncateDate((Date)subBeginDate);
                if (newRateAdjustPeriod > 0) {
                    list = this.getSubBeginDateListWithPeriodAndFirRateAdjDate(list, newFirstRateAdjustDate, newRateAdjustPeriod);
                    subDateInfo = new SubBeginDateInfo();
                    subDateInfo.setBeginDate(subBeginDate);
                    if (this.isBetweenBeginDateAndEndDate(this.beginDate, this.endDate, subBeginDate) && !list.contains(subDateInfo) && subBeginDate.compareTo(newFirstRateAdjustDate) != 0) {
                        list.add(subDateInfo);
                    }
                } else if (newRateAdjustPeriod <= 0) {
                    int size = this.adjuIntRateBaseColl.size();
                    for (int i = 0; i < size; ++i) {
                        subBeginDate = this.adjuIntRateBaseColl.get(i).getEffectiveDate();
                        if (!this.isBetweenBeginDateAndEndDate(this.beginDate, this.endDate, subBeginDate = DateTimeUtils.truncateDate((Date)subBeginDate)) || subBeginDate.compareTo(newAdjustDate) < 0) continue;
                        SubBeginDateInfo subDateInfo2 = new SubBeginDateInfo();
                        subDateInfo2.setBeginDate(subBeginDate);
                        if (list.contains(subDateInfo2)) continue;
                        list.add(subDateInfo2);
                    }
                    subDateInfo = new SubBeginDateInfo();
                    subDateInfo.setBeginDate(newAdjustDate);
                    if (!list.contains(subDateInfo) && this.isBetweenBeginDateAndEndDate(this.beginDate, this.endDate, newAdjustDate)) {
                        list.add(subDateInfo);
                    }
                    subDateInfo = new SubBeginDateInfo();
                    subDateInfo.setBeginDate(newFirstRateAdjustDate);
                    if (!list.contains(subDateInfo) && this.isBetweenBeginDateAndEndDate(this.beginDate, this.endDate, newFirstRateAdjustDate)) {
                        list.add(subDateInfo);
                    }
                }
            }
            subDateInfo = new SubBeginDateInfo();
            subDateInfo.setBeginDate(firstRateAdjustDate);
            if (this.isBetweenBeginDateAndEndDate(this.beginDate, this.endDate, firstRateAdjustDate)) {
                int flag = 0;
                for (int i = 0; i < list.size(); ++i) {
                    if (list.get(i) instanceof SubBeginDateInfo) {
                        SubBeginDateInfo subDateInfo1 = (SubBeginDateInfo)list.get(i);
                        ++flag;
                        if (!subDateInfo1.equals(subDateInfo)) continue;
                        break;
                    }
                    if (!(list.get(i) instanceof Date)) continue;
                    ++flag;
                    if (firstRateAdjustDate.equals((Date)list.get(i))) break;
                }
                if (flag == list.size()) {
                    list.add(subDateInfo);
                }
            }
        } else if (this.adjIntRateColl.size() == 0) {
            SubBeginDateInfo subDateInfo;
            while (DateTimeUtils.truncateDate((Date)this.beginDate).compareTo(nextCalendar.getTime()) >= 0) {
                nextCalendar.setTime(this.setTimeOfNextPeriod(nextCalendar, flashDay, rateAdjustPeriod).getTime());
            }
            while (nextCalendar.getTime().compareTo(DateTimeUtils.truncateDate((Date)this.endDate)) <= 0) {
                if (this.hasRateInFlash(preCalendar.getTime(), nextCalendar.getTime(), this.intRateBaseColl) || this.hasRateInFlash(this.loanInfo.getStartDate(), nextCalendar.getTime(), this.intRateBaseColl)) {
                    subDateInfo = new SubBeginDateInfo();
                    subDateInfo.setBeginDate(nextCalendar.getTime());
                    if (!list.contains(subDateInfo)) {
                        list.add(subDateInfo);
                    }
                }
                preCalendar.setTime(nextCalendar.getTime());
                nextCalendar.setTime(this.setTimeOfNextPeriod(nextCalendar, flashDay, rateAdjustPeriod).getTime());
            }
            subDateInfo = new SubBeginDateInfo();
            subDateInfo.setBeginDate(firstRateAdjustDate);
            if (!list.contains(subDateInfo) && this.isBetweenBeginDateAndEndDate(this.beginDate, this.endDate, firstRateAdjustDate)) {
                list.add(subDateInfo);
            }
        }
        int size = this.repayColl.size();
        for (int i = 0; i < size; ++i) {
            subBeginDate = this.repayColl.get(i).getRepayDate();
            if (!this.isBetweenBeginDateAndEndDate(this.beginDate, this.endDate, subBeginDate = DateTimeUtils.truncateDate((Date)subBeginDate)) || this.isNotSubWithRepay(this.repayColl.get(i))) continue;
            SubBeginDateInfo subDateInfo = new SubBeginDateInfo();
            subDateInfo.setIsRepayWithPrinciple(true);
            subDateInfo.setBeginDate(subBeginDate);
            if (list.contains(subDateInfo)) continue;
            list.add(subDateInfo);
        }
        VOComparator c = new VOComparator();
        if (!EmptyUtil.isEmpty(list)) {
            Collections.sort(list, c);
        }
        return list;
    }

    List getSubBeginDateListWithPeriodAndFirRateAdjDate(List list, Date firstRateAdjustDate, int rateAdjustPeriod) {
        Calendar rateFirstAdjustCalendar = Calendar.getInstance();
        rateFirstAdjustCalendar.setTime(firstRateAdjustDate);
        int flashDay = rateFirstAdjustCalendar.get(5);
        Calendar preCalendar = Calendar.getInstance();
        preCalendar.setTime(this.beginDate);
        Calendar nextCalendar = Calendar.getInstance();
        nextCalendar.setTime(firstRateAdjustDate);
        while (DateTimeUtils.truncateDate((Date)this.beginDate).compareTo(nextCalendar.getTime()) >= 0) {
            nextCalendar.setTime(this.setTimeOfNextPeriod(nextCalendar, flashDay, rateAdjustPeriod).getTime());
        }
        while (nextCalendar.getTime().compareTo(DateTimeUtils.truncateDate((Date)this.endDate)) <= 0) {
            SubBeginDateInfo subDateInfo;
            if (this.hasRateInFlash(preCalendar.getTime(), nextCalendar.getTime(), this.intRateBaseColl) || this.hasRateInFlash(this.loanInfo.getStartDate(), nextCalendar.getTime(), this.intRateBaseColl)) {
                subDateInfo = new SubBeginDateInfo();
                subDateInfo.setBeginDate(nextCalendar.getTime());
                if (!list.contains(subDateInfo)) {
                    list.add(subDateInfo);
                }
            }
            if (this.hasRateInFlash(preCalendar.getTime(), nextCalendar.getTime(), this.adjuIntRateBaseColl)) {
                subDateInfo = new SubBeginDateInfo();
                subDateInfo.setBeginDate(nextCalendar.getTime());
                if (!list.contains(subDateInfo)) {
                    list.add(subDateInfo);
                }
            }
            preCalendar.setTime(nextCalendar.getTime());
            nextCalendar.setTime(this.setTimeOfNextPeriod(nextCalendar, flashDay, rateAdjustPeriod).getTime());
        }
        VOComparator c = new VOComparator();
        if (!EmptyUtil.isEmpty((Collection)list)) {
            Collections.sort(list, c);
        }
        return list;
    }

    List getSubBeginDateListWithPeriodAndFirstRateAdjDateAccor(List list, Date firstRateAdjustDate, int rateAdjustPeriod) {
        Object subBeginDate = null;
        Calendar rateFirstAdjustCalendar = Calendar.getInstance();
        rateFirstAdjustCalendar.setTime(firstRateAdjustDate);
        int flashDay = rateFirstAdjustCalendar.get(5);
        Calendar preCalendar = Calendar.getInstance();
        preCalendar.setTime(this.beginDate);
        Calendar nextCalendar = Calendar.getInstance();
        nextCalendar.setTime(firstRateAdjustDate);
        while (DateTimeUtils.truncateDate((Date)this.beginDate).compareTo(nextCalendar.getTime()) >= 0) {
            nextCalendar.setTime(this.setTimeOfNextPeriod(nextCalendar, flashDay, rateAdjustPeriod).getTime());
        }
        while (nextCalendar.getTime().compareTo(DateTimeUtils.truncateDate((Date)this.endDate)) <= 0) {
            SubBeginDateInfo subDateInfo;
            if (this.hasRateInFlash(preCalendar.getTime(), nextCalendar.getTime(), this.intRateBaseColl) || this.hasRateInFlash(this.loanInfo.getStartDate(), nextCalendar.getTime(), this.intRateBaseColl)) {
                subDateInfo = new SubBeginDateInfo();
                subDateInfo.setBeginDate(nextCalendar.getTime());
                if (!list.contains(nextCalendar.getTime())) {
                    list.add(nextCalendar.getTime());
                }
            }
            if (this.hasRateInFlash(preCalendar.getTime(), nextCalendar.getTime(), this.adjuIntRateBaseColl) || this.hasRateInFlash(this.loanInfo.getStartDate(), nextCalendar.getTime(), this.adjuIntRateBaseColl)) {
                subDateInfo = new SubBeginDateInfo();
                subDateInfo.setBeginDate(nextCalendar.getTime());
                if (!list.contains(nextCalendar.getTime())) {
                    list.add(nextCalendar.getTime());
                }
            }
            preCalendar.setTime(nextCalendar.getTime());
            nextCalendar.setTime(this.setTimeOfNextPeriod(nextCalendar, flashDay, rateAdjustPeriod).getTime());
        }
        DateComparator c = new DateComparator();
        Collections.sort(list, c);
        return list;
    }

    protected abstract boolean isNotSubWithRepay(IRepaymentBillInfo var1);

    protected boolean hasRateInFlash(Date preDate, Date nextDate, IntRateBaseCollection intRateBaseColl) {
        Date intRateDate;
        preDate = DateTimeUtils.truncateDate((Date)preDate);
        nextDate = DateTimeUtils.truncateDate((Date)nextDate);
        boolean hasRateInFlash = false;
        Iterator iter = intRateBaseColl.iterator();
        while (iter.hasNext() && !(hasRateInFlash = (intRateDate = DateTimeUtils.truncateDate((Date)((IntRateBaseInfo)iter.next()).getEffectiveDate())).compareTo(preDate) > 0 && intRateDate.compareTo(nextDate) <= 0)) {
        }
        return hasRateInFlash;
    }

    protected Calendar setTimeOfNextPeriod(Calendar nextCalendar, int flashDay, int rateAdjustPeriod) {
        Calendar tmp = Calendar.getInstance();
        tmp.setTime(nextCalendar.getTime());
        if (flashDay == 29 || flashDay == 30 || flashDay == 31) {
            tmp.add(2, rateAdjustPeriod);
            int days = DateTimeUtils.daysOfMonth((int)tmp.get(1), (int)(tmp.get(2) + 1));
            if (days >= flashDay) {
                tmp.set(5, flashDay);
            } else {
                tmp.set(5, days);
            }
        } else {
            tmp.add(2, rateAdjustPeriod);
        }
        return tmp;
    }

    protected boolean isRepayWithInt(IRepaymentBillInfo repayInfo) {
        if (!repayInfo.isIsCalInt()) {
            return true;
        }
        return repayInfo.isIsCalInt() && repayInfo.isIsRepayWithInt();
    }

    private String getAdjustIntBillIdExt(Date subBeginDate, IAdjustIntRateCollection adjIntRateColl) {
        if (adjIntRateColl == null || adjIntRateColl.isEmpty()) {
            return "";
        }
        IAdjustIntRateInfo info = adjIntRateColl.get(0);
        Date preDate = info.getAdjustDate();
        int size = adjIntRateColl.size();
        for (int i = 1; i < size; ++i) {
            if (subBeginDate.compareTo(preDate) >= 0 && subBeginDate.compareTo(adjIntRateColl.get(i).getAdjustDate()) < 0) {
                return info.getId().toString();
            }
            info = adjIntRateColl.get(i);
            preDate = info.getAdjustDate();
        }
        if (subBeginDate.compareTo(preDate) >= 0) {
            return info.getId().toString();
        }
        return "";
    }

    private boolean isBetweenBeginDateAndEndDate(Date beginDate, Date endDate, Date date) {
        beginDate = DateTimeUtils.truncateDate((Date)beginDate);
        endDate = DateTimeUtils.truncateDate((Date)endDate);
        return (date = DateTimeUtils.truncateDate((Date)date)).compareTo(beginDate) > 0 && date.compareTo(endDate) <= 0;
    }

    private boolean isSameDay(Date date1, Date date2) {
        return (date1 = DateTimeUtils.truncateDate((Date)date1)).compareTo(date2 = DateTimeUtils.truncateDate((Date)date2)) == 0;
    }

    private boolean isAccordIntRate() {
        if (EmptyUtil.isEmpty((CoreBaseInfo)this.loanInfo.getIntRateType())) {
            return true;
        }
        return this.loanInfo.getIntRateType().getId().toString().equals(ACCORD_INTRATE_ID) || this.loanInfo.getIntRateType().getId().toString().equals(ACCORD_GUDING_ID);
    }

    private boolean isAccordIntRate(String adjIntRateRateId) {
        return ACCORD_INTRATE_ID.equals(adjIntRateRateId) || ACCORD_GUDING_ID.equals(adjIntRateRateId);
    }

    private boolean isBaseLprRate() {
        return !this.loanInfo.getIntRateType().getId().toString().equals(ACCORD_INTRATE_ID) || !this.loanInfo.getIntRateType().getId().toString().equals(ACCORD_GUDING_ID);
    }

    private BigDecimal getSubIntRate(Date subBeginDate, IAdjustIntRateInfo adjInfo) throws EASBizException {
        if (this.isAccordIntRate()) {
            if (this.isLessFirstAdjust(subBeginDate, this.adjIntRateColl)) {
                return this.loanInfo.getIntRate();
            }
            if (!IntRateModifyType.Agreement.equals((Object)adjInfo.getModifyRateType()) && adjInfo.getModifyRateType() != null && ACCORD_GUDING_ID.equals(adjInfo.getIntRateTypeInfo().getId().toString())) {
                Date adjDate = adjInfo.getAdjustDate();
                if (subBeginDate.compareTo(adjDate) >= 0) {
                    return adjInfo.getIntRateAfterAdj();
                }
            } else if (adjInfo.getModifyRateType() != null && !IntRateModifyType.Agreement.equals((Object)adjInfo.getModifyRateType()) && subBeginDate.compareTo(adjInfo.getFirstRateAdjustDate()) >= 0) {
                int rateAdjustPeriod = adjInfo.getRateAdjustPeriod();
                if (rateAdjustPeriod > 0) {
                    Date firstRateAdjustDate = adjInfo.getFirstRateAdjustDate();
                    BigDecimal hoziron = FinHorizon.getHorizon((Date)firstRateAdjustDate, (Date)this.loanInfo.getExpiredDate());
                    BigDecimal round = hoziron.divide(new BigDecimal(rateAdjustPeriod), 0, RoundingMode.CEILING);
                    int size = round.intValue();
                    for (int i = 0; i < size; ++i) {
                        Date nextPeriodDate = this.getNextPeriodDate(adjInfo.getFirstRateAdjustDate(), firstRateAdjustDate, adjInfo.getRateAdjustPeriod());
                        if (subBeginDate.compareTo(nextPeriodDate) < 0) {
                            subBeginDate = firstRateAdjustDate;
                            break;
                        }
                        if (subBeginDate.compareTo(nextPeriodDate) == 0) {
                            subBeginDate = nextPeriodDate;
                            break;
                        }
                        if (subBeginDate.compareTo(nextPeriodDate) <= 0) continue;
                        firstRateAdjustDate = nextPeriodDate;
                    }
                }
                IntRateBaseCollection filteredAdjuIntRateBaseColl = this.filterAdjuIntRateBaseColl(this.adjuIntRateBaseColl, adjInfo);
                BigDecimal intRateBase = IntCalHelper.getIntRateUnsortSupported(subBeginDate, filteredAdjuIntRateBaseColl);
                BigDecimal intRateAfterAdj = intRateBase.add(adjInfo.getBasePoints());
                return intRateAfterAdj;
            }
            BigDecimal intRateBase = null;
            BigDecimal intRateAfterAdj = null;
            if (IntRateModifyType.Agreement.equals((Object)adjInfo.getModifyRateType()) || adjInfo.getModifyRateType() == null) {
                intRateAfterAdj = adjInfo.getIntRateAfterAdj();
            } else {
                IntRateBaseCollection filteredAdjuIntRateBaseColl = this.filterAdjuIntRateBaseColl(this.adjuIntRateBaseColl, adjInfo);
                intRateBase = subBeginDate.compareTo(adjInfo.getFirstRateAdjustDate()) <= 0 && subBeginDate.compareTo(adjInfo.getAdjustDate()) > 0 ? IntCalHelper.getIntRateUnsortSupported(adjInfo.getAdjustDate(), filteredAdjuIntRateBaseColl) : IntCalHelper.getIntRateUnsortSupported(subBeginDate, filteredAdjuIntRateBaseColl);
                intRateAfterAdj = intRateBase.add(adjInfo.getBasePoints());
            }
            return intRateAfterAdj;
        }
        BigDecimal intRateBase = Constants.ZERO;
        if (adjInfo != null && adjInfo.getIntRateTypeInfo() != null && ACCORD_GUDING_ID.equals(adjInfo.getIntRateTypeInfo().getId().toString())) {
            if (adjInfo.getAdjustDate().compareTo(subBeginDate) <= 0) {
                intRateBase = adjInfo.getIntRateAfterAdj();
            }
        } else if (!(this.isAccordIntRate() || this.loanInfo.getFirstRateAdjustDate() == null || subBeginDate.compareTo(this.loanInfo.getFirstRateAdjustDate()) >= 0 || this.hasEffectedAdjustInt() && subBeginDate.compareTo(this.adjIntRateList.get(0).getAdjustDate()) >= 0)) {
            intRateBase = IntCalHelper.getIntRateBase(subBeginDate, this.intRateBaseColl);
        } else if (adjInfo != null && adjInfo.getModifyRateType() != null && !IntRateModifyType.Agreement.equals((Object)adjInfo.getModifyRateType()) && subBeginDate.compareTo(adjInfo.getFirstRateAdjustDate()) >= 0) {
            int rateAdjustPeriod = adjInfo.getRateAdjustPeriod();
            if (rateAdjustPeriod > 0) {
                Date firstRateAdjustDate = adjInfo.getFirstRateAdjustDate();
                BigDecimal hoziron = FinHorizon.getHorizon((Date)firstRateAdjustDate, (Date)this.loanInfo.getExpiredDate());
                BigDecimal round = hoziron.divide(new BigDecimal(rateAdjustPeriod), 0, RoundingMode.CEILING);
                int size = round.intValue();
                for (int i = 0; i < size; ++i) {
                    Date nextPeriodDate = this.getNextPeriodDate(adjInfo.getFirstRateAdjustDate(), firstRateAdjustDate, adjInfo.getRateAdjustPeriod());
                    if (subBeginDate.compareTo(nextPeriodDate) < 0) {
                        subBeginDate = firstRateAdjustDate;
                        break;
                    }
                    if (subBeginDate.compareTo(nextPeriodDate) == 0) {
                        subBeginDate = nextPeriodDate;
                        break;
                    }
                    if (subBeginDate.compareTo(nextPeriodDate) <= 0) continue;
                    firstRateAdjustDate = nextPeriodDate;
                }
            }
            IntRateBaseCollection filteredAdjuIntRateBaseColl = this.filterAdjuIntRateBaseColl(this.adjuIntRateBaseColl, adjInfo);
            intRateBase = IntCalHelper.getIntRateUnsortSupported(subBeginDate, filteredAdjuIntRateBaseColl);
        } else if (adjInfo == null) {
            if (this.loanInfo.getFirstRateAdjustDate() != null && this.loanInfo.getRateAdjustPeriod() > 0) {
                Date firstRateAdjustDate = this.loanInfo.getFirstRateAdjustDate();
                int rateAdjustPeriod = this.loanInfo.getRateAdjustPeriod();
                BigDecimal hoziron = FinHorizon.getHorizon((Date)firstRateAdjustDate, (Date)this.loanInfo.getExpiredDate());
                BigDecimal round = hoziron.divide(new BigDecimal(rateAdjustPeriod), 0, RoundingMode.CEILING);
                int size = round.intValue();
                for (int i = 0; i < size; ++i) {
                    Date nextPeriodDate = this.getNextPeriodDate(firstRateAdjustDate, rateAdjustPeriod);
                    if (subBeginDate.compareTo(nextPeriodDate) < 0) {
                        subBeginDate = firstRateAdjustDate;
                        break;
                    }
                    if (subBeginDate.compareTo(nextPeriodDate) == 0) {
                        subBeginDate = nextPeriodDate;
                        break;
                    }
                    if (subBeginDate.compareTo(nextPeriodDate) <= 0) continue;
                    firstRateAdjustDate = nextPeriodDate;
                }
            }
            intRateBase = IntCalHelper.getIntRateBase(subBeginDate, this.intRateBaseColl);
        } else {
            IntRateBaseCollection filteredAdjuIntRateBaseColl = this.filterAdjuIntRateBaseColl(this.adjuIntRateBaseColl, adjInfo);
            intRateBase = IntCalHelper.getIntRateUnsortSupported(subBeginDate, filteredAdjuIntRateBaseColl);
        }
        if (adjInfo != null) {
            return intRateBase.add(adjInfo.getBasePoints());
        }
        if (adjInfo == null && this.loanInfo.getFloatAction() != null) {
            if (this.loanInfo.getFloatAction().equals((Object)FloatActionEnum.BASEINTRATE_FLOAT)) {
                return intRateBase.multiply(Constants.ONE.add(this.loanInfo.getFloatPoint().divide(ONE_HUNDRED, 5, 4)));
            }
            return intRateBase.add(this.loanInfo.getFloatPoint());
        }
        return intRateBase.multiply(Constants.ONE.add(this.loanInfo.getFloatPoint().divide(ONE_HUNDRED, 5, 4)));
    }

    private IntRateBaseCollection filterAdjuIntRateBaseColl(IntRateBaseCollection coll, IAdjustIntRateInfo adjInfo) {
        IntRateBaseCollection retColl = new IntRateBaseCollection();
        if (coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                if (!adjInfo.getIntRateTypeInfo().getId().toString().equals(coll.get(i).getType().getId().toString())) continue;
                retColl.add(coll.get(i));
            }
        }
        return retColl;
    }

    private IntRateTypeExpressionEnum getSubIntRateTypeExp(Date subBeginDate, IAdjustIntRateInfo adjInfo) {
        if (this.isLessFirstAdjust(subBeginDate, this.adjIntRateColl)) {
            return this.loanInfo.getIntRateTypeExp();
        }
        return adjInfo.getIntRateTypeExp();
    }

    private int getSubConvertDays(Date subBeginDate, IAdjustIntRateInfo adjInfo) {
        if (this.isLessFirstAdjust(subBeginDate, this.adjIntRateColl)) {
            return this.loanInfo.getConvertDays();
        }
        return adjInfo.getConvertDays();
    }

    private PenAccrualTypeEnum getSubPunishType(Date subBeginDate, IAdjustIntRateInfo adjInfo) {
        if (this.isLessFirstAdjust(subBeginDate, this.adjIntRateColl)) {
            return this.loanInfo.getPunishIntRateType();
        }
        return adjInfo.getPunishIntRateType();
    }

    private BigDecimal getSubPunishIntRate(Date subBeginDate, IAdjustIntRateInfo adjInfo) {
        if (this.isLessFirstAdjust(subBeginDate, this.adjIntRateColl)) {
            return this.loanInfo.getPunishIntRate();
        }
        return adjInfo.getPunishIntRateAfterAdj();
    }

    protected boolean isLessFirstAdjust(Date beginDate, IAdjustIntRateCollection adjIntRateColl) {
        if (adjIntRateColl == null || adjIntRateColl.isEmpty()) {
            return true;
        }
        return beginDate.compareTo(adjIntRateColl.get(0).getAdjustDate()) < 0;
    }

    protected abstract IntCalTypeEnum doGetIntCalType();

    protected abstract Date doGetBeginDate(boolean var1, Date var2, IntCalModel var3);

    protected abstract Date doGetEndDate(Date var1);

    protected abstract BigDecimal doGetSubIntPrinciple(Date var1);

    protected BigDecimal getTotalRepayAmtWithoutInt(Date subBeginDate) {
        BigDecimal repayTotalAmt = Constants.ZERO;
        IRepaymentBillInfo repayInfo = null;
        for (int i = this.repayColl.size() - 1; i >= 0; --i) {
            repayInfo = this.repayColl.get(i);
            if (this.isRepayWithInt(repayInfo) || repayInfo.getRepayDate().compareTo(subBeginDate) <= 0) continue;
            repayTotalAmt = repayTotalAmt.add(repayInfo.getRepayAmt());
        }
        return repayTotalAmt;
    }

    protected BigDecimal getTotalRepayAmtWithInt(Date subBeginDate) {
        BigDecimal repayTotalAmt = Constants.ZERO;
        IRepaymentBillInfo repayInfo = null;
        for (int i = this.repayColl.size() - 1; i >= 0; --i) {
            repayInfo = this.repayColl.get(i);
            if (repayInfo.getRepayDate().compareTo(subBeginDate) <= 0) continue;
            repayTotalAmt = repayTotalAmt.add(repayInfo.getRepayAmt());
        }
        return repayTotalAmt;
    }

    protected abstract boolean doIsCalPunishInt(Date var1);

    private List getSubBeginDateListRefactor(Context ctx, Date beginDate, Date endDate) throws EASBizException, BOSException {
        ArrayList<Date> list = new ArrayList<Date>();
        VOComparator c = new VOComparator();
        Date subBeginDate = null;
        if (!EmptyUtil.isEmpty((CoreBaseInfo)this.loanInfo.getIntRateType()) && this.loanInfo.getIntRateType().getId().toString().equals(ACCORD_INTRATE_ID) || EmptyUtil.isEmpty((CoreBaseInfo)this.loanInfo.getIntRateType())) {
            if (this.hasEffectedAdjustInt()) {
                this.addAdjustDate(list);
                this.addAdjustPeriodFromAdj(list);
            }
        } else if (this.isBaseLprRate()) {
            Date designateEndDate = endDate;
            if (this.hasEffectedAdjustInt()) {
                designateEndDate = this.adjIntRateList.get(0).getAdjustDate();
                this.addAdjustPeriodFromAdj(list);
                this.addAdjustDate(list);
            }
            if (this.loanInfo.getRateAdjustPeriod() > 0) {
                this.addAdjustPeriodFromLoan(list, designateEndDate);
            } else {
                this.fillBaseRateChangeDate(list, beginDate, designateEndDate, this.intRateBaseColl, this.loanInfo.getFirstRateAdjustDate());
            }
        }
        int size = this.repayColl.size();
        for (int i = 0; i < size; ++i) {
            subBeginDate = this.repayColl.get(i).getRepayDate();
            if (!this.isBetweenBeginDateAndEndDate(beginDate, endDate, subBeginDate = DateTimeUtils.truncateDate((Date)subBeginDate)) || this.isNotSubWithRepay(this.repayColl.get(i)) || list.contains(subBeginDate)) continue;
            list.add(subBeginDate);
        }
        if (!EmptyUtil.isEmpty(list)) {
            Collections.sort(list, c);
        }
        return list;
    }

    private void fillBaseRateChangeDate(List list, Date designateBeginDate, Date designateEndDate, IntRateBaseCollection rateBaseColl, Date firstRateAdjustDate) {
        if (!EmptyUtil.isEmpty((Object)firstRateAdjustDate) && firstRateAdjustDate.after(designateBeginDate) && firstRateAdjustDate.before(designateEndDate)) {
            this.tryAddToList(list, firstRateAdjustDate);
        }
        Iterator iter = rateBaseColl.iterator();
        while (iter.hasNext()) {
            boolean hasRateInFlash;
            Date intRateDate = DateTimeUtils.truncateDate((Date)((IntRateBaseInfo)iter.next()).getEffectiveDate());
            if (firstRateAdjustDate != null) {
                hasRateInFlash = intRateDate.compareTo(firstRateAdjustDate) > 0 && intRateDate.compareTo(designateEndDate) <= 0;
                if (!hasRateInFlash) continue;
                this.tryAddToList(list, intRateDate);
                continue;
            }
            if (designateEndDate == null) {
                hasRateInFlash = intRateDate.compareTo(designateBeginDate) > 0 && intRateDate.compareTo(this.endDate) <= 0;
                if (!hasRateInFlash) continue;
                this.tryAddToList(list, intRateDate);
                continue;
            }
            hasRateInFlash = intRateDate.compareTo(designateBeginDate) > 0 && intRateDate.compareTo(designateEndDate) <= 0;
            if (!hasRateInFlash) continue;
            this.tryAddToList(list, intRateDate);
        }
    }

    private void addAdjIntRateChangeDate(List list, Date designateBeginDate, Date designateEndDate, IntRateBaseCollection rateBaseColl) {
        Iterator iter = rateBaseColl.iterator();
        while (iter.hasNext()) {
            boolean hasRateInFlash;
            Date intRateDate = DateTimeUtils.truncateDate((Date)((IntRateBaseInfo)iter.next()).getEffectiveDate());
            if (designateEndDate == null) {
                hasRateInFlash = intRateDate.compareTo(designateBeginDate) > 0 && intRateDate.compareTo(this.endDate) <= 0;
                if (!hasRateInFlash) continue;
                this.tryAddToList(list, intRateDate);
                continue;
            }
            hasRateInFlash = intRateDate.compareTo(designateBeginDate) > 0 && intRateDate.compareTo(designateEndDate) <= 0;
            if (!hasRateInFlash) continue;
            this.tryAddToList(list, intRateDate);
        }
    }

    private boolean hasAdjustInt() {
        return this.adjIntRateColl.size() > 0;
    }

    private boolean hasEffectedAdjustInt() {
        if (!this.hasAdjustInt()) {
            return false;
        }
        this.filterAdjIntRateColl();
        return this.adjIntRateList.size() > 0;
    }

    private void addAdjustPeriodFromAdj(List list) throws EASBizException, BOSException {
        for (int i = 0; i < this.adjIntRateList.size(); ++i) {
            IAdjustIntRateInfo info = this.adjIntRateList.get(i);
            if (info.getIntRateTypeInfo() == null) continue;
            if (!info.getModifyRateType().equals((Object)IntRateModifyType.Agreement) && !this.isAccordIntRate(info.getIntRateTypeInfo().getId().toString())) {
                if (info.getRateAdjustPeriod() > 0) {
                    Date rateAdjustDate;
                    Date designateEndDate = this.endDate;
                    if (i < this.adjIntRateList.size() - 1) {
                        designateEndDate = this.adjIntRateList.get(i + 1).getAdjustDate();
                    }
                    if (EmptyUtil.isEmpty((Object)(rateAdjustDate = info.getFirstRateAdjustDate()))) continue;
                    while (rateAdjustDate.compareTo(designateEndDate) <= 0) {
                        if (rateAdjustDate.after(info.getAdjustDate())) {
                            this.tryAddToList(list, rateAdjustDate);
                        }
                        rateAdjustDate = this.getNextPeriodDate(info.getFirstRateAdjustDate(), rateAdjustDate, info.getRateAdjustPeriod());
                    }
                    continue;
                }
                IntRateBaseCollection rateBaseColl = this.getIntRateBaseColl(this.ctx, info.getIntRateTypeInfo().getId().toString(), this.currencyId);
                Date designateEndDate = this.endDate;
                if (i < this.adjIntRateList.size() - 1) {
                    designateEndDate = this.adjIntRateList.get(i + 1).getAdjustDate();
                }
                this.fillBaseRateChangeDate(list, info.getAdjustDate(), designateEndDate, rateBaseColl, info.getFirstRateAdjustDate());
                continue;
            }
            if (!info.getModifyRateType().equals((Object)IntRateModifyType.Agreement) && !this.isAccordIntRate(info.getIntRateTypeInfo().getId().toString())) continue;
        }
    }

    private void tryAddToList(List list, Date date) {
        if (this.isBetweenBeginDateAndEndDate(this.beginDate, this.endDate, date) && !list.contains(date)) {
            list.add(date);
        }
    }

    private void addAdjustPeriodFromLoan(List list, Date designateEndDate) {
        Date nextPeriod;
        if (this.loanInfo.getFirstRateAdjustDate() != null && this.isBetweenBeginDateAndEndDate(this.beginDate, designateEndDate == null ? this.endDate : designateEndDate, this.loanInfo.getFirstRateAdjustDate()) && !this.isSameDay(this.beginDate, this.loanInfo.getFirstRateAdjustDate())) {
            this.tryAddToList(list, this.loanInfo.getFirstRateAdjustDate());
            nextPeriod = this.getNextPeriodDate(this.loanInfo.getFirstRateAdjustDate(), this.loanInfo.getRateAdjustPeriod());
        } else {
            nextPeriod = this.getNextPeriodDate(this.loanInfo.getFirstRateAdjustDate() == null ? this.beginDate : this.loanInfo.getFirstRateAdjustDate(), this.loanInfo.getRateAdjustPeriod());
        }
        while (nextPeriod.compareTo(designateEndDate == null ? this.endDate : designateEndDate) <= 0) {
            this.tryAddToList(list, nextPeriod);
            nextPeriod = this.getNextPeriodDate(nextPeriod, this.loanInfo.getRateAdjustPeriod());
        }
    }

    private void addAdjustDate(List list) {
        for (IAdjustIntRateInfo info : this.adjIntRateList) {
            if (!this.isBetweenBeginDateAndEndDate(this.beginDate, this.endDate, info.getAdjustDate())) continue;
            this.tryAddToList(list, info.getAdjustDate());
        }
    }

    private void filterAdjIntRateColl() {
        this.adjIntRateList.clear();
        for (int i = 0; i < this.adjIntRateColl.size(); ++i) {
            IAdjustIntRateInfo info = this.adjIntRateColl.get(i);
            if (info.getAdjustDate().compareTo(this.endDate) > 0) continue;
            this.adjIntRateList.add(info);
        }
        if (!this.adjIntRateList.isEmpty()) {
            adjustVOComparator c = new adjustVOComparator();
            Collections.sort(this.adjIntRateList, c);
        }
    }

    private class DateComparator
    implements Comparator {
        private DateComparator() {
        }

        public int compare(Object o1, Object o2) {
            Date date1 = (Date)o1;
            Date date2 = (Date)o2;
            return date1.compareTo(date2);
        }
    }

    private class adjustVOComparator
    implements Comparator {
        private adjustVOComparator() {
        }

        public int compare(Object o1, Object o2) {
            IAdjustIntRateInfo info1 = (IAdjustIntRateInfo)o1;
            IAdjustIntRateInfo info2 = (IAdjustIntRateInfo)o2;
            return info1.getAdjustDate().compareTo(info2.getAdjustDate());
        }
    }

    private class VOComparator
    implements Comparator {
        private VOComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Date && o2 instanceof Date) {
                Date date1 = (Date)o1;
                Date date2 = (Date)o2;
                return date1.compareTo(date2);
            }
            if (o1 instanceof SubBeginDateInfo && o2 instanceof SubBeginDateInfo) {
                SubBeginDateInfo info1 = (SubBeginDateInfo)o1;
                SubBeginDateInfo info2 = (SubBeginDateInfo)o2;
                return info1.getBeginDate().compareTo(info2.getBeginDate());
            }
            if (o1 instanceof SubBeginDateInfo && o2 instanceof Date) {
                SubBeginDateInfo info1 = (SubBeginDateInfo)o1;
                Date date2 = (Date)o2;
                return info1.getBeginDate().compareTo(date2);
            }
            Date date1 = (Date)o1;
            SubBeginDateInfo info2 = (SubBeginDateInfo)o2;
            return date1.compareTo(info2.getBeginDate());
        }
    }

    private class SubBeginDateInfo {
        private Date beginDate;
        private boolean isRepayWithPrinciple = false;

        private SubBeginDateInfo() {
        }

        public Date getBeginDate() {
            return this.beginDate;
        }

        public void setBeginDate(Date beginDate) {
            this.beginDate = beginDate;
        }

        public boolean getType() {
            return this.isRepayWithPrinciple;
        }

        public void setIsRepayWithPrinciple(boolean isRepayWithPrinciple) {
            this.isRepayWithPrinciple = isRepayWithPrinciple;
        }

        public boolean getIsRepayWithPrinciple() {
            return this.isRepayWithPrinciple;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SubBeginDateInfo)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            SubBeginDateInfo info = (SubBeginDateInfo)obj;
            return this.beginDate.compareTo(info.beginDate) == 0;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

