/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.fin.IntBasis;
import com.kingdee.eas.fm.im.IMException;
import com.kingdee.eas.fm.im.IntRateBaseCollection;
import com.kingdee.eas.fm.im.IntRateBaseInfo;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.im.PenAccrualTypeEnum;
import com.kingdee.eas.fm.im.util.IAdjustIntRateCollection;
import com.kingdee.eas.fm.im.util.IAdjustIntRateInfo;
import com.kingdee.eas.fm.im.util.LoanInterestEntryCollection;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;

public class IntCalHelper {
    private static final BigDecimal ONE_HUNDRED = Constants.ONE_HUNDRED;
    private static final BigDecimal ONE_THOUSAND = Constants.ONE_THOUSAND;
    private static final int ROUND = 4;
    private static final int SCALE = 5;

    public static void main(String[] args) {
    }

    public static BigDecimal getIntRateBase(Date beginDate, IntRateBaseCollection rateBaseColl) throws EASBizException {
        if (rateBaseColl == null || rateBaseColl.isEmpty()) {
            return Constants.ZERO;
        }
        IntRateBaseInfo info = null;
        Date preDate = rateBaseColl.get(0).getEffectiveDate();
        BigDecimal yearRate = rateBaseColl.get(0).getYearRate();
        int size = rateBaseColl.size();
        for (int i = 1; i < size; ++i) {
            info = rateBaseColl.get(i);
            if (beginDate.compareTo(preDate) >= 0 && beginDate.compareTo(info.getEffectiveDate()) < 0) {
                return yearRate;
            }
            preDate = info.getEffectiveDate();
            yearRate = info.getYearRate();
        }
        if (beginDate.compareTo(preDate) >= 0) {
            return yearRate;
        }
        DateFormat df = DateFormat.getDateInstance();
        throw new IMException(IMException.NOT_INTRATEBASE_EXIST, new Object[]{df.format(beginDate)});
    }

    public static BigDecimal getIntRateUnsortSupported(Date beginDate, IntRateBaseCollection rateBaseColl) throws EASBizException {
        if (rateBaseColl == null || rateBaseColl.isEmpty()) {
            return Constants.ZERO;
        }
        ArrayList<IntRateBaseInfo> list = new ArrayList<IntRateBaseInfo>();
        for (int i = 0; i < rateBaseColl.size(); ++i) {
            IntRateBaseInfo info = rateBaseColl.get(i);
            if (beginDate.compareTo(info.getEffectiveDate()) == 0) {
                return info.getYearRate();
            }
            if (beginDate.compareTo(info.getEffectiveDate()) <= 0) continue;
            list.add(info);
        }
        if (list.size() > 0) {
            IntRateBaseInfo laterest = (IntRateBaseInfo)list.get(0);
            for (IntRateBaseInfo rateInfo : list) {
                if (!rateInfo.getEffectiveDate().after(laterest.getEffectiveDate())) continue;
                laterest = rateInfo;
            }
            return laterest.getYearRate();
        }
        DateFormat df = DateFormat.getDateInstance();
        throw new IMException(IMException.NOT_INTRATEBASE_EXIST, new Object[]{df.format(beginDate)});
    }

    public static BigDecimal getAdjIntRate(Date beginDate, IAdjustIntRateCollection adjIntRateColl) throws EASBizException {
        if (adjIntRateColl == null || adjIntRateColl.isEmpty()) {
            return null;
        }
        IAdjustIntRateInfo info = adjIntRateColl.get(0);
        Date preDate = info.getAdjustDate();
        BigDecimal yearRate = info.getIntRateAfterAdj();
        int size = adjIntRateColl.size();
        for (int i = 1; i < size; ++i) {
            info = adjIntRateColl.get(i);
            if (beginDate.compareTo(preDate) >= 0 && beginDate.compareTo(info.getAdjustDate()) < 0) {
                return yearRate;
            }
            preDate = info.getAdjustDate();
            yearRate = info.getIntRateAfterAdj();
        }
        if (beginDate.compareTo(preDate) >= 0) {
            return yearRate;
        }
        return null;
    }

    public static IAdjustIntRateInfo getValidAdjInfo(Date beginDate, IAdjustIntRateCollection adjIntRateColl) throws EASBizException {
        if (adjIntRateColl == null || adjIntRateColl.isEmpty()) {
            return null;
        }
        IAdjustIntRateInfo info = adjIntRateColl.get(0);
        Date preDate = info.getAdjustDate();
        int size = adjIntRateColl.size();
        for (int i = 1; i < size; ++i) {
            if (beginDate.compareTo(preDate) >= 0 && beginDate.compareTo(adjIntRateColl.get(i).getAdjustDate()) < 0) {
                return info;
            }
            info = adjIntRateColl.get(i);
            preDate = info.getAdjustDate();
        }
        if (beginDate.compareTo(preDate) >= 0) {
            return info;
        }
        return null;
    }

    public static boolean isLessOrEqualsFirstAdjust(Date beginDate, IAdjustIntRateCollection adjIntRateColl) {
        if (adjIntRateColl == null || adjIntRateColl.isEmpty()) {
            return true;
        }
        return beginDate.compareTo(adjIntRateColl.get(0).getAdjustDate()) <= 0;
    }

    public static int getDiffDays(Date beginDate, Date endDate) {
        long diff = (endDate.getTime() - beginDate.getTime()) / 86400000L;
        int days = new Long(diff).intValue() + 1;
        return days;
    }

    public static int getDiffDaysByIntBasis(Date beginDate, Date endDate, IntBasis basis) {
        GregorianCalendar gCal = (GregorianCalendar)GregorianCalendar.getInstance();
        gCal.setTime(beginDate);
        int y1 = gCal.get(1);
        int m1 = gCal.get(2);
        int d1 = gCal.get(5);
        gCal.setTime(endDate);
        gCal.add(5, 1);
        int y2 = gCal.get(1);
        int m2 = gCal.get(2);
        int d2 = gCal.get(5);
        switch (basis.getValue()) {
            case 10: {
                if (d1 == 31) {
                    d1 = 30;
                }
                if (d2 != 31) break;
                d2 = 30;
                break;
            }
            case 20: {
                int daysOfMonth;
                if (d2 == 31 && d1 == 30) {
                    d2 = 30;
                }
                if (d1 != (daysOfMonth = DateTimeUtils.daysOfMonth((int)y1, (int)(m1 + 1)))) break;
                d1 = 30;
                break;
            }
            case 30: {
                if (d2 == 31 && d1 == 30) {
                    d2 = 30;
                }
                if (d1 != 31) break;
                d1 = 30;
                break;
            }
            case 40: {
                int daysOfFeb;
                if (d2 == 31 && d1 == 30) {
                    d2 = 30;
                }
                int daysOfMonth1 = DateTimeUtils.daysOfMonth((int)y1, (int)(m1 + 1));
                if (m1 == 1 && m2 == 1 && d2 == (daysOfFeb = DateTimeUtils.daysOfMonth((int)y2, (int)(m2 + 1))) && d1 == daysOfMonth1) {
                    d2 = 30;
                }
                if (d1 != daysOfMonth1) break;
                d1 = 30;
                break;
            }
        }
        int days = 360 * (y2 - y1) + 30 * (m2 - m1) + (d2 - d1);
        return days;
    }

    public static int getOverdueDays(Date beginDate, Date endDate, Date expiredDate) {
        Date bigDate = beginDate.compareTo(expiredDate) > 0 ? beginDate : expiredDate;
        return IntCalHelper.getDiffDays(bigDate, endDate);
    }

    public static BigDecimal calIntertest(BigDecimal intPrinciple, BigDecimal intRate, int covertDays, int days, IntRateTypeExpressionEnum intRateTypeExp, CurrencyInfo currency) {
        BigDecimal bConvertDay = new BigDecimal(String.valueOf(covertDays));
        BigDecimal bDays = new BigDecimal(String.valueOf(days));
        BigDecimal interest = intPrinciple.multiply(intRate).multiply(bDays);
        BigDecimal temp = Constants.ZERO;
        temp = intRateTypeExp == IntRateTypeExpressionEnum.YEAR ? bConvertDay.multiply(ONE_HUNDRED) : bConvertDay.multiply(ONE_THOUSAND);
        interest = interest.divide(temp, currency.getPrecision(), 4);
        return interest;
    }

    public static BigDecimal calPunishInt(BigDecimal intPrinciple, BigDecimal intRate, BigDecimal punishIntRate, int overdueDays, int convertDays, PenAccrualTypeEnum punishType, IntRateTypeExpressionEnum intRateTypeExp) throws EASBizException {
        BigDecimal bOverdueDays = new BigDecimal(String.valueOf(overdueDays));
        BigDecimal bConvertDay = new BigDecimal(String.valueOf(convertDays));
        punishIntRate = punishIntRate == null ? Constants.ZERO : punishIntRate;
        intRate = intRateTypeExp == IntRateTypeExpressionEnum.YEAR ? intRate.divide(ONE_HUNDRED, 5, 4) : intRate.divide(ONE_THOUSAND, 5, 4);
        if (punishType == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{EASResource.getString((String)"com.kingdee.eas.fm.im.IMAutoGenerateResource", (String)"19_IntCalHelper")});
        }
        if (punishType.equals((Object)PenAccrualTypeEnum.ADD_PERCENT)) {
            return intPrinciple.multiply(intRate).multiply(punishIntRate).multiply(bOverdueDays).divide(bConvertDay.multiply(ONE_HUNDRED), 5, 4);
        }
        if (punishType.equals((Object)PenAccrualTypeEnum.ADD_ACCRUAL)) {
            return intPrinciple.multiply(punishIntRate).multiply(bOverdueDays).divide(ONE_THOUSAND, 5, 4);
        }
        return Constants.ZERO;
    }

    public static BigDecimal getTotalInterest(LoanInterestEntryCollection intEntryColl) {
        BigDecimal totalInt = Constants.ZERO;
        int size = intEntryColl.size();
        for (int i = 0; i < size; ++i) {
            totalInt = totalInt.add(intEntryColl.get(i).getInterest());
        }
        return totalInt;
    }

    public static BigDecimal getTotalPunishInterest(LoanInterestEntryCollection intEntryColl) {
        BigDecimal totalInt = Constants.ZERO;
        int size = intEntryColl.size();
        for (int i = 0; i < size; ++i) {
            totalInt = totalInt.add(intEntryColl.get(i).getPunishInterest());
        }
        return totalInt;
    }

    public static String getDefaultDesc(Date beginDate, Date endDate) {
        StringBuffer msg = new StringBuffer();
        DateFormat df = BOSLocaleUtil.getDateFormat();
        String sBeginDate = df.format(beginDate);
        String sEndDate = df.format(endDate);
        msg.append(sBeginDate).append(" - ").append(sEndDate).append(EASResource.getString((String)"com.kingdee.eas.fm.im.IMAutoGenerateResource", (String)"20_IntCalHelper"));
        return msg.toString();
    }

    public static String getDefaultDesc(DateFormat df, Date beginDate, Date endDate) {
        StringBuffer msg = new StringBuffer();
        String sBeginDate = df.format(beginDate);
        String sEndDate = df.format(endDate);
        msg.append(sBeginDate).append(" - ").append(sEndDate).append(EASResource.getString((String)"com.kingdee.eas.fm.im.IMAutoGenerateResource", (String)"20_IntCalHelper"));
        return msg.toString();
    }

    public static BigDecimal getExchangeRate(Context ctx, CurrencyInfo srcCurr, CompanyOrgUnitInfo company, Date date) throws EASBizException, BOSException {
        if (srcCurr == null || date == null) {
            return null;
        }
        if (company == null) {
            company = ctx == null ? ContextHelperFactory.getRemoteInstance().getCurrentCompany() : ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        }
        if (IntCalHelper.isLocalCurrency(srcCurr, company)) {
            return Constants.ONE;
        }
        ExchangeRateInfo exRateInfo = IntCalHelper.getExRateInfo(ctx, srcCurr, null, company, date = DateTimeUtils.truncateDate((Date)date));
        if (exRateInfo == null) {
            return Constants.ONE;
        }
        return exRateInfo.getConvertRate();
    }

    public static boolean isLocalCurrency(CurrencyInfo currency, CompanyOrgUnitInfo company) {
        boolean isLocCurrency = false;
        if (currency == null) {
            return isLocCurrency;
        }
        if (company == null) {
            company = SysContext.getSysContext().getCurrentFIUnit();
        }
        CurrencyInfo localCurrency = company.getBaseCurrency();
        if (currency.getId().equals((Object)localCurrency.getId())) {
            isLocCurrency = true;
        }
        return isLocCurrency;
    }

    private static ExchangeRateInfo getExRateInfo(Context ctx, CurrencyInfo srcCurr, CurrencyInfo destCurr, CompanyOrgUnitInfo company, Date date) throws EASBizException, BOSException {
        ExchangeTableInfo baseExchangeTable;
        if (srcCurr == null || date == null) {
            return null;
        }
        if (destCurr == null) {
            destCurr = company.getBaseCurrency();
        }
        if ((baseExchangeTable = company.getBaseExchangeTable()) == null) {
            return null;
        }
        date = DateTimeUtils.truncateDate((Date)date);
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(srcCurr.getId());
        ObjectUuidPK destCurrpk = new ObjectUuidPK(destCurr.getId());
        ObjectUuidPK exchangeTablepk = new ObjectUuidPK(baseExchangeTable.getId());
        IExchangeRate iExchangRate = null;
        iExchangRate = ctx == null ? ExchangeRateFactory.getRemoteInstance() : ExchangeRateFactory.getLocalInstance((Context)ctx);
        ExchangeRateInfo exRateInfo = iExchangRate.getExchangeRate((IObjectPK)exchangeTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, date);
        return exRateInfo;
    }
}

