/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.util;

import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.fm.im.IntCalTypeEnum;
import com.kingdee.eas.fm.im.util.AbstractIntCalStragety;
import com.kingdee.eas.fm.im.util.IRepaymentBillInfo;
import com.kingdee.eas.fm.im.util.IntCalModel;
import java.math.BigDecimal;
import java.util.Date;

public class PreIntCalStragety
extends AbstractIntCalStragety {
    @Override
    protected IntCalTypeEnum doGetIntCalType() {
        return IntCalTypeEnum.PRE_INT;
    }

    @Override
    protected boolean doIsCalPunishInt(Date subEndDate) {
        return subEndDate.compareTo(this.loanInfo.getExpiredDate()) > 0;
    }

    @Override
    protected Date doGetBeginDate(boolean isPrediction, Date condBeginDate, IntCalModel model) {
        if (model.isNewRequirement()) {
            return this.newRequirement(isPrediction, condBeginDate, model);
        }
        return this.old(isPrediction, condBeginDate);
    }

    private Date newRequirement(boolean isPrediction, Date condBeginDate, IntCalModel model) {
        Date billStartDate;
        Date lastPreIntDate;
        Date returnDate = null;
        if (isPrediction) {
            returnDate = condBeginDate;
        }
        returnDate = condBeginDate == null ? ((lastPreIntDate = model.getLoanInfo().getLastPreIntDate()) != null ? lastPreIntDate : model.getLoanInfo().getStartDate()) : (condBeginDate.compareTo(billStartDate = model.getLoanInfo().getStartDate()) <= 0 ? billStartDate : condBeginDate);
        return returnDate;
    }

    private Date old(boolean isPrediction, Date condBeginDate) {
        if (isPrediction) {
            return condBeginDate;
        }
        Date startDate = this.loanInfo.getStartDate();
        Date lastPreIntDate = this.loanInfo.getLastPreIntDate();
        Date lastIntDate = this.loanInfo.getLastIntDate();
        lastPreIntDate = lastPreIntDate == null ? startDate : DateUtil.getAfterDay((Date)lastPreIntDate);
        lastIntDate = lastIntDate == null ? startDate : DateUtil.getAfterDay((Date)lastIntDate);
        Date bigDate = condBeginDate;
        if (bigDate == null) {
            bigDate = startDate;
        }
        if (startDate != null && bigDate.compareTo(startDate) < 0) {
            bigDate = startDate;
        }
        if (lastPreIntDate != null && bigDate.compareTo(lastPreIntDate) < 0) {
            bigDate = lastPreIntDate;
        }
        if (this.INT006 && lastIntDate != null && bigDate.compareTo(lastIntDate) < 0) {
            bigDate = lastIntDate;
        }
        return bigDate;
    }

    @Override
    protected Date doGetEndDate(Date condEndDate) {
        return DateUtil.getBeforeDay((Date)condEndDate);
    }

    @Override
    protected BigDecimal doGetSubIntPrinciple(Date subBeginDate) {
        BigDecimal intFreeAmt;
        BigDecimal loanBalance = this.loanInfo.getLoanBalance();
        BigDecimal bigDecimal = intFreeAmt = this.loanInfo.getIntFreeAmt() == null ? BigDecimal.ZERO : this.loanInfo.getIntFreeAmt();
        if (this.repayColl == null || this.repayColl.isEmpty()) {
            return loanBalance.add(intFreeAmt.negate());
        }
        BigDecimal repayTotalAmt = BigDecimal.ZERO;
        repayTotalAmt = loanBalance.compareTo(BigDecimal.ZERO) > 0 ? this.getTotalRepayAmtWithoutInt(subBeginDate) : this.getTotalRepayAmtWithInt(subBeginDate);
        return loanBalance.add(repayTotalAmt).add(intFreeAmt.negate());
    }

    @Override
    protected boolean isNotSubWithRepay(IRepaymentBillInfo repayInfo) {
        if (this.INT006) {
            if (!repayInfo.isIsCalInt()) {
                return true;
            }
            if (repayInfo.isIsCalInt() && repayInfo.isIsRepayWithInt()) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isRepayWithInt(IRepaymentBillInfo repayInfo) {
        if (this.INT006) {
            if (!repayInfo.isIsCalInt()) {
                return true;
            }
            if (repayInfo.isIsCalInt() && repayInfo.isIsRepayWithInt()) {
                return true;
            }
        }
        return false;
    }
}

