/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.im.util;

import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.fm.im.IntCalTypeEnum;
import com.kingdee.eas.fm.im.util.AbstractIntCalStragety;
import com.kingdee.eas.fm.im.util.IRepaymentBillInfo;
import com.kingdee.eas.fm.im.util.IntCalModel;
import java.math.BigDecimal;
import java.util.Date;

public class RepayIntCalStragety
extends AbstractIntCalStragety {
    @Override
    protected IntCalTypeEnum doGetIntCalType() {
        return IntCalTypeEnum.REPAY_INT;
    }

    @Override
    protected Date doGetBeginDate(boolean isPrediction, Date condBeginDate, IntCalModel model) {
        Date startDate = this.loanInfo.getStartDate();
        Date lastIntDate = this.loanInfo.getLastIntDate();
        if (isPrediction) {
            return condBeginDate;
        }
        if (lastIntDate == null) {
            return startDate;
        }
        return DateUtil.getAfterDay((Date)lastIntDate);
    }

    @Override
    protected Date doGetEndDate(Date condEndDate) {
        return DateUtil.getBeforeDay((Date)this.repayInfo.getRepayDate());
    }

    @Override
    protected BigDecimal doGetSubIntPrinciple(Date subBeginDate) {
        boolean isAllRepay = this.isAllRepay();
        if (!isAllRepay) {
            return this.repayInfo.getRepayAmt();
        }
        BigDecimal loanBalance = this.loanInfo.getLoanBalance();
        BigDecimal intFreeAmt = this.loanInfo.getIntFreeAmt();
        BigDecimal repayTotalAmt = this.getTotalRepayAmtWithoutInt(subBeginDate);
        return loanBalance.add(repayTotalAmt).add(intFreeAmt.negate());
    }

    private boolean isAllRepay() {
        boolean isAllRepay = this.loanInfo.getLoanBalance().compareTo(this.repayInfo.getRepayAmt()) == 0;
        return isAllRepay;
    }

    @Override
    protected boolean doIsCalPunishInt(Date subEndDate) {
        return this.repayInfo.isIsCalPunishInt();
    }

    @Override
    protected boolean isNotSubWithRepay(IRepaymentBillInfo repayInfo) {
        boolean isAllRepay = this.isAllRepay();
        if (!isAllRepay) {
            return true;
        }
        return this.isRepayWithInt(repayInfo);
    }
}

