/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.im.FactorEnum;
import com.kingdee.eas.fm.im.IntRateStateEnum;
import com.kingdee.eas.fm.im.IntRateTypeCollection;
import com.kingdee.eas.fm.im.IntRateTypeFactory;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.ivt.CHLoanException;
import com.kingdee.eas.fm.ivt.CHLoanExtendBillCollection;
import com.kingdee.eas.fm.ivt.CHLoanExtendBillFactory;
import com.kingdee.eas.fm.ivt.ChLoanInfo;
import com.kingdee.eas.fm.ivt.ConsultativeExhTableEnum;
import com.kingdee.eas.fm.ivt.EntRepaymentBillCollection;
import com.kingdee.eas.fm.ivt.EntRepaymentBillFactory;
import com.kingdee.eas.fm.ivt.EntRepaymentBillInfo;
import com.kingdee.eas.fm.ivt.LoanInterestBillCollection;
import com.kingdee.eas.fm.ivt.LoanInterestBillFactory;
import com.kingdee.eas.fm.ivt.LoanInterestBillInfo;
import com.kingdee.eas.fm.ivt.PenAccrualTypeEnum;
import com.kingdee.eas.fm.ivt.ReturnWayEnum;
import com.kingdee.eas.fm.ivt.client.CHLoanExtendBillEditUI;
import com.kingdee.eas.fm.ivt.client.LoanInterestBillEditUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import javax.swing.JTextField;

public class ChLoanHelper {
    private static ChLoanHelper enLoanHelper;
    private static String[] HanDigiStr;
    private static String[] HanDiviStr;

    public static ChLoanHelper getInstance() {
        if (enLoanHelper == null) {
            enLoanHelper = new ChLoanHelper();
        }
        return enLoanHelper;
    }

    public int showIntReceiveEditUI(CoreUIObject ui, EntRepaymentBillInfo editData) {
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"repaymentbillid", (Object)editData);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(LoanInterestBillEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            LoanInterestBillInfo info = (LoanInterestBillInfo)((LoanInterestBillEditUI)uiWindow.getUIObject()).getEditData();
            if (info.getInterest().compareTo(Constants.ZERO) <= 0) {
                uiWindow.close();
                return 1;
            }
            uiWindow.show();
            boolean success = ((LoanInterestBillEditUI)uiWindow.getUIObject()).getSuccessFlag();
            if (success) {
                uiWindow.close();
            }
            return 2;
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
            return 0;
        }
    }

    public void showExtendBillEditUI(CoreUI ui, ChLoanInfo chLoanInfo) {
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"chloanid", (Object)chLoanInfo);
            uiContext.put((Object)"pull_or_push", (Object)"push");
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(CHLoanExtendBillEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
    }

    public void initComboExchangeTable(KDComboBox comboExchangeTable) throws Exception {
        IntRateTypeCollection col = IntRateTypeFactory.getRemoteInstance().getIntRateTypeCollection();
        comboExchangeTable.addItems(col.toArray());
        comboExchangeTable.addItem((Object)ConsultativeExhTableEnum.consultativeExchangeTable);
    }

    public CompanyOrgUnitInfo getRelatedCompany(Context ctx, BankInfo bank) throws EASBizException, BOSException {
        BankInfo returnInfo = null;
        returnInfo = ctx == null ? BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(bank.getId()), this.getSelect()) : BankFactory.getLocalInstance((Context)ctx).getBankInfo((IObjectPK)new ObjectUuidPK(bank.getId()), this.getSelect());
        return returnInfo.getRelatedCompany();
    }

    public SelectorItemCollection getSelect() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("relatedCompany.*"));
        return sic;
    }

    public BigDecimal calcYearRate(IntRateTypeInfo intType, BigDecimal floating, CurrencyInfo currency, Date date) throws Exception {
        BigDecimal yearRate = this.getYearRateFromRateTable(date, currency.getId().toString(), intType.getId().toString());
        floating = floating.divide(Constants.ONE_HUNDRED, 2, 4);
        BigDecimal tmp = FMHelper.add((BigDecimal)Constants.ONE, (BigDecimal)floating);
        return FMHelper.multiply((BigDecimal)yearRate, (BigDecimal)tmp);
    }

    private BigDecimal getYearRateFromRateTable(Date endDate, String currencyID, String typeID) throws BOSException, SQLException {
        BigDecimal yearRate = Constants.ZERO;
        String dateStr = FMConstants.FORMAT_TIME.format(endDate);
        StringBuffer sql = new StringBuffer();
        String billState = IntRateStateEnum.AUDITED.getValue();
        sql.append("select top 1 a.fid, a.fyearRate, a.ftypeid, b.ffactor ");
        sql.append("from t_int_IntRateBase as a left outer join t_int_intRateType as b on a.fTypeId = b.fid ");
        sql.append("where a.feffectiveDate <= {" + dateStr + "} and a.fcurrencyid = '" + currencyID + "' and a.ftypeid = '" + typeID + "' and a.fbillState = '" + billState + "' and FIntTermID  is null ");
        sql.append("order by a.feffectiveDate desc");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        if (rs.next()) {
            yearRate = rs.getBigDecimal(2);
        }
        return yearRate;
    }

    public void initComboYearDays(KDComboBox comboYearDays) {
        comboYearDays.addItems(FactorEnum.getEnumList().toArray());
    }

    public void initComboPenaAccrualWay(KDComboBox comboPenAccrualType) {
        comboPenAccrualType.addItems(PenAccrualTypeEnum.getEnumList().toArray());
    }

    public void initComboReturnWay(KDComboBox comboReturnWay) {
        comboReturnWay.addItems(ReturnWayEnum.getEnumList().toArray());
        comboReturnWay.setSelectedItem((Object)ReturnWayEnum.AT_TERM_WITH_ORI_AMT);
    }

    public void setTableCellEditorByDate(KDTable tblMain, String property) {
        KDDatePicker dpDate = new KDDatePicker();
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor(dpDate));
    }

    public void setTableCellEditorByFormattedTextField(KDTable tblMain, String property, int precision) throws Exception {
        KDFormattedTextField formattedTextField = new KDFormattedTextField();
        formattedTextField.setDataType(1);
        formattedTextField.setPrecision(precision);
        formattedTextField.setRoundingMode(4);
        formattedTextField.setMinimumValue((Comparable)Constants.ZERO);
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
        tblMain.getColumn(property).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public void setTableCellEditorByF7(KDTable tblMain, String f7, FilterInfo fi, String property) throws Exception {
        KDBizPromptBox promptBox = new KDBizPromptBox();
        promptBox.setDisplayFormat("$name$");
        promptBox.setEditFormat("$number$");
        promptBox.setCommitFormat("$number$");
        promptBox.setQueryInfo(f7);
        if (fi != null) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(fi);
            promptBox.setEntityViewInfo(evi);
        }
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)promptBox));
    }

    public void setAcctEvi(IUIObject ui, BankInfo clearingHouse, CompanyOrgUnitInfo currentCompany, CurrencyInfo info, KDBizPromptBox promtAccount) throws EASBizException, BOSException {
        String cuId = currentCompany.getCU().getId().toString();
        String currencyId = info.getId().toString();
        promtAccount.getQueryAgent().resetRuntimeEntityView();
        EntityViewInfo evi = this.getCustomAcctEvi(cuId, currencyId);
        this.addFilter(evi, clearingHouse);
        KDPromptSelector opseelect = F7SelectorFactory.getAccountF7((IUIObject)ui, (String)currentCompany.getId().toString());
        promtAccount.setEntityViewInfo(evi);
        promtAccount.setSelector(opseelect);
    }

    private void addFilter(EntityViewInfo evi, BankInfo clearingHouse) {
        FilterItemInfo filterClearingHouse = new FilterItemInfo("company.id", (Object)clearingHouse.getId().toString());
        FilterItemInfo filterIsUsed = new FilterItemInfo("isUsed", (Object)Boolean.TRUE);
        evi.getFilter().getFilterItems().add(filterClearingHouse);
        evi.getFilter().getFilterItems().add(filterIsUsed);
    }

    private EntityViewInfo getCustomAcctEvi(String cuId, String currencyId) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuId));
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Constants.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Constants.FALSE));
        EntityViewInfo customEvi = new EntityViewInfo();
        customEvi.setFilter(filter);
        return customEvi;
    }

    public int getCurrencyPre(String currencyID) throws EASBizException, BOSException {
        CurrencyInfo info = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyID));
        return info.getPrecision();
    }

    public void setAccountFilter(BankInfo clearingHouse, KDBizPromptBox ptmtAccount, CompanyOrgUnitInfo loanCompany, int type) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("closed", (Object)"0"));
        filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)"1"));
        if (loanCompany != null) {
            filter.getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)loanCompany.getId().toString()));
        }
        if (clearingHouse != null) {
            filter.getFilterItems().add(new FilterItemInfo("clearingHouse.id", (Object)clearingHouse.getId().toString()));
        }
        if (type == 1) {
            filter.getFilterItems().add(new FilterItemInfo("type.property", (Object)new Integer(1)));
        } else if (type == 2) {
            filter.getFilterItems().add(new FilterItemInfo("type.property", (Object)new Integer(3)));
        }
        evi.setFilter(filter);
        ptmtAccount.setEntityViewInfo(evi);
        ptmtAccount.setSelectorCollection(this.getCustomSelectors());
        ptmtAccount.getQueryAgent().resetRuntimeEntityView();
    }

    private SelectorItemCollection getCustomSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("applyUnit.*"));
        return sic;
    }

    public String trimZero(String str, String simbol) {
        String tmp;
        int i;
        if (str.indexOf(".") == -1) {
            return str.substring(0, str.indexOf(simbol)) + ".00" + simbol;
        }
        for (i = str.length() - 1; i >= 0; --i) {
            tmp = "";
            tmp = str.substring(i - 1, i);
            if (!tmp.equals("0") && !tmp.equals(" ")) break;
        }
        str = str.substring(0, i) + simbol;
        for (i = 0; i < str.length() - 1; ++i) {
            tmp = "";
            tmp = str.substring(i, i + 1);
            if (!tmp.equals("0")) break;
        }
        if ((str = str.substring(i)).equals("." + simbol)) {
            str = "0.00" + simbol;
        }
        if (str.startsWith(".")) {
            str = "0" + str;
        }
        if (str.endsWith("." + simbol)) {
            str = str.substring(0, str.indexOf(simbol));
            str = str + "00" + simbol;
        }
        return str;
    }

    public CHLoanExtendBillCollection getLoanExColl(Context ctx, String loanId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("chLoan.id", (Object)loanId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("beforeExDate"));
        return CHLoanExtendBillFactory.getLocalInstance(ctx).getCHLoanExtendBillCollection(evi);
    }

    public EntRepaymentBillCollection getRepayColl(Context ctx, String loanId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("loanBillID.id", (Object)loanId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("repayDate"));
        return EntRepaymentBillFactory.getLocalInstance(ctx).getEntRepaymentBillCollection(evi);
    }

    public LoanInterestBillCollection getIntColl(Context ctx, String loanId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("loanBill.id", (Object)loanId));
        filter.getFilterItems().add(new FilterItemInfo("isPrediction", (Object)new Boolean(false)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return LoanInterestBillFactory.getLocalInstance(ctx).getLoanInterestBillCollection(evi);
    }

    public boolean hasExtendRecord(Context ctx, String loanId) throws BOSException {
        CHLoanExtendBillCollection col = this.getLoanExColl(ctx, loanId);
        return col != null && col.size() > 0;
    }

    public boolean hasRepayRecord(Context ctx, String loanId) throws BOSException {
        EntRepaymentBillCollection col = this.getRepayColl(ctx, loanId);
        return col != null && col.size() > 0;
    }

    public boolean hasIntRecord(Context ctx, String loanId) throws BOSException {
        LoanInterestBillCollection col = this.getIntColl(ctx, loanId);
        return col != null && col.size() > 0;
    }

    public String PositiveIntegerToHanStr(String NumStr) {
        StringBuffer RMBStr = new StringBuffer();
        boolean lastzero = false;
        boolean hasvalue = false;
        int len = NumStr.length();
        if (len > 15) {
            return EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"49_ChLoanHelper");
        }
        for (int i = len - 1; i >= 0; --i) {
            if (NumStr.charAt(len - i - 1) == ' ') continue;
            int n = NumStr.charAt(len - i - 1) - 48;
            if (n < 0 || n > 9) {
                return EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"50_ChLoanHelper");
            }
            if (n != 0) {
                if (lastzero) {
                    RMBStr.append(HanDigiStr[0]);
                }
                if (n != 1 || i % 4 != 1 || i != len - 1) {
                    RMBStr.append(HanDigiStr[n]);
                }
                RMBStr.append(HanDiviStr[i]);
                hasvalue = true;
            } else if (i % 8 == 0 || i % 8 == 4 && hasvalue) {
                RMBStr.append(HanDiviStr[i]);
            }
            if (i % 8 == 0) {
                hasvalue = false;
            }
            lastzero = n == 0 && i % 4 != 0;
        }
        if (RMBStr.length() == 0) {
            return HanDigiStr[0];
        }
        return RMBStr.toString();
    }

    public String NumToRMBStr(double val) {
        String SignStr = "";
        String TailStr = "";
        if (val < 0.0) {
            val = -val;
            SignStr = EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"51_ChLoanHelper");
        }
        if (val > 1.0E14 || val < -1.0E14) {
            return EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"52_ChLoanHelper");
        }
        long temp = Math.round(val * 100.0);
        long integer = temp / 100L;
        long fraction = temp % 100L;
        int jiao = (int)fraction / 10;
        int fen = (int)fraction % 10;
        if (jiao == 0 && fen == 0) {
            TailStr = EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"53_ChLoanHelper");
        } else {
            TailStr = HanDigiStr[jiao];
            if (jiao != 0) {
                TailStr = TailStr + EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"54_ChLoanHelper");
            }
            if (integer == 0L && jiao == 0) {
                TailStr = "";
            }
            if (fen != 0) {
                TailStr = TailStr + HanDigiStr[fen] + EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"55_ChLoanHelper");
            }
        }
        StringBuffer retSB = new StringBuffer();
        retSB.append("\uffe5").append(SignStr).append(this.PositiveIntegerToHanStr(String.valueOf(integer))).append(EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"56_ChLoanHelper")).append(TailStr);
        return retSB.toString();
    }

    public static void checkClearingHouseUsed(CompanyOrgUnitInfo currentCompany) throws Exception {
        boolean isUsed = FSClientHelper.clearingHouseIsUsed((String)currentCompany.getId().toString());
        if (!isUsed) {
            throw new CHLoanException(CHLoanException.USE_CLEARING_HOUSE_FIRST);
        }
    }

    static {
        HanDigiStr = new String[]{EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"34_ChLoanHelper"), EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"35_ChLoanHelper"), EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"36_ChLoanHelper"), EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"37_ChLoanHelper"), EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"38_ChLoanHelper"), EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"39_ChLoanHelper"), EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"40_ChLoanHelper"), EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"41_ChLoanHelper"), EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"42_ChLoanHelper"), EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"43_ChLoanHelper")};
        HanDiviStr = new String[]{"", EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"44_ChLoanHelper"), EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"45_ChLoanHelper"), EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"46_ChLoanHelper"), EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"47_ChLoanHelper"), EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"44_ChLoanHelper"), EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"45_ChLoanHelper"), EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"46_ChLoanHelper"), EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"48_ChLoanHelper"), EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"44_ChLoanHelper"), EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"45_ChLoanHelper"), EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"46_ChLoanHelper"), EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"47_ChLoanHelper"), EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"44_ChLoanHelper"), EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"45_ChLoanHelper"), EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"46_ChLoanHelper"), EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"48_ChLoanHelper"), EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"44_ChLoanHelper"), EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"45_ChLoanHelper"), EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"46_ChLoanHelper"), EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"47_ChLoanHelper"), EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"44_ChLoanHelper"), EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"45_ChLoanHelper"), EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"46_ChLoanHelper")};
    }
}

