/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.IReceivingDisposer;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fm.ivt.FinancingRedeemFactory;
import com.kingdee.eas.fm.ivt.FinancingRedeemInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;

public class FinanRedeemDisposer
implements IReceivingDisposer {
    private static final String RESOURCE = "com.kingdee.eas.fm.ivt.IVTFINANCINGResource";

    public BigDecimal getCashRebate(Date billDate, BigDecimal arAmount, String srcBillId, String srcBillEntryId) {
        return null;
    }

    public void dispose(Context ctx, BillDisposerAction action) throws BOSException, EASBizException {
        CoreBaseInfo destInfo = action.getDestBill();
        DisposerActionEnum actionType = action.getActionType();
        if (actionType == DisposerActionEnum.SUBMIT) {
            this.savedipose(ctx, destInfo);
        } else if (actionType == DisposerActionEnum.DELETE) {
            this.deletedipose(ctx, destInfo);
        }
    }

    private void deletedipose(Context ctx, CoreBaseInfo destInfo) throws BOSException, EASBizException {
        String sourceBillId = ((ReceivingBillInfo)destInfo).getSourceBillId();
        BigDecimal payAmount = ((ReceivingBillInfo)destInfo).getActRecAmt();
        FinancingRedeemInfo info = FinancingRedeemFactory.getLocalInstance(ctx).getFinancingRedeemInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
        BigDecimal recTotalAmount = info.getRecTotalAmount().subtract(payAmount);
        String sql = "update T_IVT_FinancingRedeem set FIsGeneGaterBill =0,FRecTotalAmount= ? where FID= ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{recTotalAmount, sourceBillId});
    }

    private void savedipose(Context ctx, CoreBaseInfo destInfo) throws EASBizException, BOSException {
        BigDecimal paymount = ((ReceivingBillInfo)destInfo).getActRecAmt();
        String sourceBillId = ((ReceivingBillInfo)destInfo).getSourceBillId();
        FinancingRedeemInfo info = FinancingRedeemFactory.getLocalInstance(ctx).getFinancingRedeemInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
        BigDecimal finamount = info.getRedeemAmount();
        BigDecimal recTotalAmount = paymount;
        String amountSql = "SELECT sum( b.FACTRECAMT)  FROM t_bot_relation a left join t_cas_receivingbill b on a.FDESTOBJECTID =b.fid where a.FSRCOBJECTID =? and a.FDESTENTITYID =? and a.FDESTOBJECTID!=?";
        IRowSet iSet = DbUtil.executeQuery((Context)ctx, (String)amountSql, (Object[])new Object[]{sourceBillId, destInfo.getBOSType().toString(), destInfo.getId().toString()});
        try {
            while (iSet.next()) {
                BigDecimal sum = iSet.getBigDecimal(1) == null ? BigDecimal.ZERO : iSet.getBigDecimal(1);
                recTotalAmount = sum.add(paymount);
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        if (recTotalAmount.compareTo(finamount.add(info.getPracticalWinAmount())) == 1) {
            throw new EASBizException(new NumericExceptionSubItem("85", ResourceBase.getString((String)RESOURCE, (String)"017_OVERGATERAMOUNT", (Locale)ctx.getLocale())));
        }
        String sql = "update T_IVT_FinancingRedeem set  FRecTotalAmount= ?, FIsGeneGaterBill =1 where FID= ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{recTotalAmount, sourceBillId});
    }
}

