/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IvtModualUtils;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.LoanExhibitionInfo;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.ivt.CHLoanExtendBillFactory;
import com.kingdee.eas.fm.ivt.CHLoanExtendBillInfo;
import com.kingdee.eas.fm.ivt.ChLoanFactory;
import com.kingdee.eas.fm.ivt.ChLoanHelper;
import com.kingdee.eas.fm.ivt.ChLoanInfo;
import com.kingdee.eas.fm.ivt.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.ivt.PenAccrualTypeEnum;
import com.kingdee.eas.fm.ivt.client.AbstractCHLoanExtendBillEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CHLoanExtendBillEditUI
extends AbstractCHLoanExtendBillEditUI {
    private static final String AFTER_EXT_RATE_TEN_PER = EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"after_ext_rate_ten_per");
    private static final String AFTER_EXT_RATE_PER = EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"after_ext_rate_per");
    private static final Logger logger = CoreUIObject.getLogger(CHLoanExtendBillEditUI.class);
    private ChLoanInfo chLoanInfo;
    private String type;
    private UserInfo userinfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
    private BankInfo clearingHouse;
    private CtrlUnitInfo ctrlUnitInfo = ContextHelperFactory.getRemoteInstance().getCurrentCtrlUnit();
    private Integer maxSeq;
    private Date lastExdDate;
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private boolean isFirstTime = true;

    protected String getOnloadPermItemName() {
        String state = this.getOprtState();
        if (FMHelper.isEmpty((String)state)) {
            super.getOnloadPermItemName();
        }
        if (state.equals(OprtState.ADDNEW)) {
            return "loan_extend_02addNew";
        }
        return "loan_extend_01view";
    }

    @Override
    public void storeFields() {
        super.storeFields();
        try {
            this.editData.setCompany(ChLoanHelper.getInstance().getRelatedCompany(null, this.clearingHouse));
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e.getCause());
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e.getCause());
        }
        this.editData.setHandler(FMClientHelper.getUserByF7Person((CoreUI)this, (KDBizPromptBox)this.prmtHandler));
    }

    public void onLoad() throws Exception {
        String selectedValue;
        this.isFirstTime = true;
        FSClientHelper.checkClearingHouseCompany();
        ChLoanHelper.checkClearingHouseUsed(this.currentCompany);
        this.clearingHouse = FSClientHelper.getClearingHouse();
        this.chLoanInfo = (ChLoanInfo)this.getUIContext().get("chloanid");
        if (this.chLoanInfo == null && (selectedValue = (String)this.getUIContext().get("viewObjectID")) != null) {
            this.chLoanInfo = ChLoanFactory.getRemoteInstance().getChLoanInfo((IObjectPK)new ObjectUuidPK(selectedValue));
        }
        this.type = (String)this.getUIContext().get("pull_or_push");
        this.initControl();
        super.onLoad();
        F7SelectorFactory.initPerson((IUIObject)this, (KDBizPromptBox)this.prmtHandler);
        this.actionPrint.setEnabled(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setEnabled(false);
        this.actionPrintPreview.setVisible(false);
        this.actionCopy.setEnabled(false);
        this.actionCopy.setVisible(false);
        this.actionCopyFrom.setVisible(false);
        this.actionCopyFrom.setVisible(false);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.txtDescription.setMaxLength(80);
        this.txtNumber.setMaxLength(50);
        this.txtextendSeq.setPrecision(0);
        this.txtextendSeq.setRemoveingZeroInDispaly(true);
    }

    public void onShow() throws Exception {
        super.onShow();
        FMClientHelper.setFirstFocus((Component[])new Component[]{this.txtNumber, this.dpBizDate});
    }

    protected boolean isSetPrecisionAuto() {
        return true;
    }

    protected void resetPrecisionForLocalAmt() {
    }

    protected CurrencyInfo getSelectCurrency() {
        return (CurrencyInfo)this.currency.getSelectedItem();
    }

    protected void resetPrecisionForOtherComponent() {
        this.txtexchangeRate.setPrecision(4);
        this.txtpeneIntRate.setPrecision(4);
        this.txtafterExRate.setPrecision(4);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        CHLoanExtendBillInfo info = (CHLoanExtendBillInfo)this.getDataObject();
        if (info.getCurrency() != null && this.currentCompany.getBaseCurrency().getId().toString().equals(info.getCurrency().getId().toString())) {
            this.txtexchangeRate.setEditable(false);
        } else {
            this.txtexchangeRate.setEditable(true);
        }
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.actionCreateFrom.setEnabled(false);
            this.actionCopy.setEnabled(false);
        } else {
            this.actionCreateFrom.setEnabled(true);
            this.actionCopy.setEnabled(true);
        }
        this.pkafterExDate.setMinimumDate(info.getBeforeExDate());
        this.actionCopy.setVisible(false);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.ptmtLoanBill.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"shouldcreatefrom1"));
            SysUtil.abort();
        }
        FMClientVerifyHelper.verifyRequire((CoreUIObject)this);
        if (this.editData.getBeforeExDate().compareTo(this.editData.getAfterExDate()) >= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"60_CHLoanExtendBillEditUI"));
            this.pkafterExDate.requestFocus();
            SysUtil.abort();
        }
    }

    private void emptyControllers() {
        this.ptmtLoanBill.setValue(null);
        this.txtNumber.setText("");
        this.prmtloanAccount.setValue(null);
        this.txtCompany.setText("");
        this.txtextendSeq.setText("");
        this.txtloanBalance.setValue((Object)Constants.ZERO);
        this.txtexchangeRate.setValue((Object)Constants.ZERO);
        this.txtlocalAmt.setValue((Object)Constants.ZERO);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.clearingHouse != null && this.clearingHouse.getRelatedCompany() != null) {
            FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.clearingHouse.getRelatedCompany().getId().toString());
        }
        if (this.editData.getBeforeExDate() != null) {
            this.pkafterExDate.setMinimumDate(DateTimeUtils.addDay((Date)this.editData.getBeforeExDate(), (long)1L));
        }
        this.txtlocalAmt.setValue((Object)FMHelper.multiply((BigDecimal)this.txtexchangeRate.getBigDecimalValue(), (BigDecimal)this.txtloanBalance.getBigDecimalValue()));
        if (this.editData.getRateExpression() == null) {
            this.rateExpression.setSelectedItem((Object)IntRateTypeExpressionEnum.YEAR);
        }
        if (this.editData.getPenaIntType() == null) {
            this.penaIntType.setSelectedItem((Object)com.kingdee.eas.fm.fin.PenAccrualTypeEnum.ADD_ACCRUAL);
        }
        if (this.editData.getCurrency() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.currency, (Object)this.editData.getCurrency());
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("loanAccount.applyUnit.*"));
        return sic;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if (this.getBOTPViewStatus() == 1) {
            BOSUuid bisid;
            BOSObjectType idType;
            ChLoanInfo infoChLoan;
            CHLoanExtendBillInfo chLoanExtendBillInfo = (CHLoanExtendBillInfo)this.getUIContext().get("InitDataObject");
            if (chLoanExtendBillInfo == null || chLoanExtendBillInfo.getChLoan() == null) {
                return;
            }
            this.setExdRecord(chLoanExtendBillInfo.getChLoan());
            Date tmp = null;
            tmp = this.maxSeq == 1 ? DateTimeUtils.truncateDate((Date)chLoanExtendBillInfo.getChLoan().getEndDate()) : DateTimeUtils.truncateDate((Date)this.lastExdDate);
            CHLoanExtendBillInfo loanExtendBillInfo = (CHLoanExtendBillInfo)dataObject;
            loanExtendBillInfo.setCreator(this.userinfo);
            if (loanExtendBillInfo.getAfterExDate() == null) {
                loanExtendBillInfo.setAfterExDate(DateTimeUtils.addDay((Date)tmp, (long)1L));
            }
            if (loanExtendBillInfo.getExtendSeq() == 0) {
                loanExtendBillInfo.setExtendSeq(this.maxSeq);
            }
            if ((infoChLoan = this.getChLoan(chLoanExtendBillInfo)).getLoanBalance() != null && infoChLoan.getExchangeRate() != null) {
                BigDecimal tmpAmt = infoChLoan.getLoanBalance().multiply(infoChLoan.getExchangeRate());
                loanExtendBillInfo.setLocalAmt(tmpAmt);
            }
            loanExtendBillInfo.setLoanCompany(infoChLoan.getLoanAccount().getApplyUnit().getName());
            loanExtendBillInfo.setHandler(infoChLoan.getHandler());
            loanExtendBillInfo.setAccountant(infoChLoan.getAccountant());
            loanExtendBillInfo.setPeneIntRate(infoChLoan.getPenAccrualRate());
            loanExtendBillInfo.setBizDate(DateUtil.getDayBegin());
            loanExtendBillInfo.setChLoan(infoChLoan);
            loanExtendBillInfo.setLoanAccount(infoChLoan.getLoanAccount());
            String srcID = this.getUIContext().get("srcBillID").toString();
            if (null != srcID && !(idType = (bisid = BOSUuid.read((String)srcID)).getType()).equals((Object)LoanExhibitionInfo.BOSTYPE)) {
                loanExtendBillInfo.setBeforeExDate(tmp);
            }
            this.isFirstTime = false;
            String sourceBillId = chLoanExtendBillInfo.getSourceBillId();
            if (!EmptyUtil.isEmpty((String)sourceBillId)) {
                BOSUuid bosUuid = BOSUuid.read((String)sourceBillId);
                if (bosUuid.getType().equals((Object)new ChLoanInfo().getBOSType())) {
                    if (infoChLoan == null || infoChLoan.getYearRate() == null) {
                        // empty if block
                    }
                    this.txtafterExRate.setEnabled(false);
                } else if (bosUuid.getType().equals((Object)new LoanExhibitionInfo().getBOSType())) {
                    this.txtafterExRate.setEnabled(false);
                }
                this.txtafterExRate.setPrecision(4);
            }
            BigDecimal rate = BigDecimal.ZERO;
            try {
                rate = IvtModualUtils.getExpendedRate((String)chLoanExtendBillInfo.getChLoan().getId().toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            loanExtendBillInfo.setAfterExRate(rate);
        }
    }

    private ChLoanInfo getChLoan(CHLoanExtendBillInfo chLoanExtendBillInfo) {
        ChLoanInfo infoChLoan = null;
        try {
            infoChLoan = ChLoanFactory.getRemoteInstance().getChLoanInfo((IObjectPK)new ObjectUuidPK(chLoanExtendBillInfo.getChLoan().getId()), this.getSelectors());
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        return infoChLoan;
    }

    private void initControl() {
        this.dpBizDate.setSupportedEmpty(false);
        this.pkafterExDate.setSupportedEmpty(false);
        if (this.chLoanInfo != null) {
            this.pkafterExDate.setMinimumDate(DateTimeUtils.addDay((Date)this.chLoanInfo.getEndDate(), (long)1L));
        }
        CashHelper.initCombCurrency((KDComboBox)this.currency, (boolean)false);
        this.actionCreateTo.setVisible(false);
        this.txtafterExRate.setPrecision(4);
        this.txtpeneIntRate.setPrecision(4);
        this.txtafterExRate.setMinimumValue((Comparable)Constants.ZERO);
    }

    @Override
    protected String getEditUIName() {
        return CHLoanExtendBillEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return CHLoanExtendBillFactory.getRemoteInstance();
    }

    private boolean isPush() {
        return "push".equals(this.type);
    }

    @Override
    protected void txtexchangeRate_dataChanged(DataChangeEvent e) throws Exception {
        this.txtlocalAmt.setValue((Object)FMHelper.multiply((BigDecimal)this.txtexchangeRate.getBigDecimalValue(), (BigDecimal)this.txtloanBalance.getBigDecimalValue()));
    }

    @Override
    protected IObjectValue createNewData() {
        CHLoanExtendBillInfo info = new CHLoanExtendBillInfo();
        info.setBizDate(DateUtil.getDayBegin());
        info.setCreator(this.userinfo);
        if (this.isPush()) {
            this.setExdRecord(this.chLoanInfo);
            info.setSourceBillId(this.chLoanInfo.getId().toString());
            info.setBank(this.clearingHouse);
            info.setChLoan(this.chLoanInfo);
            info.setLoanAccount(this.chLoanInfo.getLoanAccount());
            if (this.maxSeq == 1) {
                info.setBeforeExDate(DateTimeUtils.truncateDate((Date)this.chLoanInfo.getEndDate()));
            } else {
                info.setBeforeExDate(DateTimeUtils.truncateDate((Date)this.lastExdDate));
            }
            info.setAfterExDate(DateTimeUtils.addDay((Date)info.getBeforeExDate(), (long)1L));
            info.setExtendSeq(this.maxSeq);
            info.setCurrency(this.chLoanInfo.getCurrency());
            info.setLoanBalance(this.chLoanInfo.getLoanBalance());
            info.setLocalAmt(info.getLoanBalance().multiply(this.chLoanInfo.getExchangeRate()));
            info.setExchangeRate(this.chLoanInfo.getExchangeRate());
            info.setHandler(this.chLoanInfo.getHandler());
            info.setYearDays(this.chLoanInfo.getYearDays());
            info.setPenaIntType(this.chLoanInfo.getPenAccrualType());
            if (this.chLoanInfo.getIntRateTypeExpression() != null) {
                info.setRateExpression(this.chLoanInfo.getIntRateTypeExpression());
            }
            info.setPeneIntRate(this.chLoanInfo.getPenAccrualRate());
            BigDecimal rate = BigDecimal.ZERO;
            try {
                rate = IvtModualUtils.getExpendedRate((String)this.chLoanInfo.getId().toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            info.setAfterExRate(rate);
            info.setLoanCompany(this.chLoanInfo.getLoanCompany().getName());
        } else {
            info.setExtendSeq(1);
            info.setExchangeRate(Constants.ZERO);
            info.setAfterExDate(DateUtil.getDayBegin());
            info.setAfterExRate(Constants.ZERO);
            info.setPenaIntType(PenAccrualTypeEnum.ADD_ACCRUAL);
            info.setPeneIntRate(Constants.ZERO);
            info.setCurrency(this.currentCompany.getBaseCurrency());
        }
        info.setIsDownLoaded(false);
        return info;
    }

    protected void comboRateTypeExpression_actionPerformed(ActionEvent e) throws Exception {
        IntRateTypeExpressionEnum intRateTypeExpressionEnum = (IntRateTypeExpressionEnum)((Object)this.rateExpression.getSelectedItem());
        if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.YEAR) {
            this.txtyearDays.setValue((Object)new Integer(360));
            this.contafterExRate.setBoundLabelText(AFTER_EXT_RATE_PER);
        } else if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.MONTH) {
            this.txtyearDays.setValue((Object)new Integer(30));
            this.contafterExRate.setBoundLabelText(AFTER_EXT_RATE_TEN_PER);
        } else {
            this.txtyearDays.setValue((Object)new Integer(1));
            this.contafterExRate.setBoundLabelText(AFTER_EXT_RATE_TEN_PER);
        }
    }

    private void setExdRecord(ChLoanInfo chLoanInfo2) {
        try {
            Map exdRecord = CHLoanExtendBillFactory.getRemoteInstance().getInitDate((IObjectPK)new ObjectUuidPK(chLoanInfo2.getId().toString()));
            this.maxSeq = (Integer)exdRecord.get("maxseq");
            this.lastExdDate = (Date)exdRecord.get("lastExdDate");
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public int getBtpCreateFromType() {
        return 0;
    }

    @Override
    protected KDTable getDetailTable() {
        return null;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("BOTPViewStatus", new Integer(0));
        super.actionSubmit_actionPerformed(e);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        FMClientHelper.setFirstFocus((Component[])new Component[]{this.txtNumber, this.dpBizDate});
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("BOTPViewStatus", new Integer(0));
        super.actionSave_actionPerformed(e);
        FMClientHelper.setFirstFocus((Component[])new Component[]{this.txtNumber, this.dpBizDate});
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("DefaultQueryFilter", this.getFilter());
        ctx.put("showType", "ExtendBill");
        this.getBillEdit().createFrom(null, ctx);
        this.getUIContext().put("BOTPViewStatus", new Integer(0));
    }

    private FilterInfo getFilter() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("bank.id", (Object)this.clearingHouse.getId()));
        filterInfo.getFilterItems().add(new FilterItemInfo("loanBalance", (Object)Constants.ZERO, CompareType.GREATER));
        filterInfo.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(4)));
        filterInfo.getFilterItems().add(new FilterItemInfo("isOverdue", (Object)new Boolean(false)));
        return filterInfo;
    }

    @Override
    public void penaIntType_actionPerformed(ActionEvent e) {
        PenAccrualTypeEnum penAccrualType = (PenAccrualTypeEnum)((Object)this.penaIntType.getShowSelectedItem());
        if (penAccrualType == PenAccrualTypeEnum.ADD_ACCRUAL) {
            this.contpeneIntRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"dailyrate"));
        } else if (penAccrualType == PenAccrualTypeEnum.ADD_PERCENT) {
            this.contpeneIntRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"penerate_text"));
        }
    }

    @Override
    protected void rateExpression_actionPerformed(ActionEvent e) throws Exception {
        IntRateTypeExpressionEnum intRateTypeExpressionEnum = (IntRateTypeExpressionEnum)((Object)this.rateExpression.getSelectedItem());
        boolean view = false;
        if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.YEAR && !view) {
            this.txtyearDays.setValue((Object)new Integer(360));
            this.contafterExRate.setBoundLabelText(AFTER_EXT_RATE_PER);
        } else if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.MONTH && !view) {
            this.txtyearDays.setValue((Object)new Integer(30));
            this.contafterExRate.setBoundLabelText(AFTER_EXT_RATE_TEN_PER);
        } else if (!view) {
            this.txtyearDays.setValue((Object)new Integer(1));
            this.contafterExRate.setBoundLabelText(AFTER_EXT_RATE_TEN_PER);
        }
    }

    @Override
    protected void setAutoNumberByOrg(String orgType) {
    }
}

