/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.ivt.CHLoanException;
import com.kingdee.eas.fm.ivt.CHLoanExtendBillFactory;
import com.kingdee.eas.fm.ivt.CHLoanExtendBillInfo;
import com.kingdee.eas.fm.ivt.ChLoanHelper;
import com.kingdee.eas.fm.ivt.client.AbstractCHLoanExtendBillListUI;
import com.kingdee.eas.fm.ivt.client.CHLoanExtendBillEditUI;
import com.kingdee.eas.fm.ivt.client.ChLoanExtendBillFilterUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CHLoanExtendBillListUI
extends AbstractCHLoanExtendBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(CHLoanExtendBillListUI.class);
    private CHLoanExtendBillInfo chLoanInfo;
    private CompanyOrgUnitInfo currentCompany;
    private static final String STATUS_SUMBIT_DISPLAY = EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"status_submit");
    private static final String STATUS_TMP_SAVE = EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"status_tempsave");
    private ChLoanExtendBillFilterUI filterUI;
    FillListener fillListener = new FillListener();
    public static final String PAYMENTBILL_FILENAME = "/FM/INVEST/IVT/CHLOANEXT";

    public CHLoanExtendBillListUI() throws Exception {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    }

    @Override
    protected String getEditUIName() {
        return CHLoanExtendBillEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return CHLoanExtendBillFactory.getRemoteInstance();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.chLoanInfo = this.getExdInfo();
        this.checkCanModify(this.chLoanInfo);
        super.actionEdit_actionPerformed(e);
    }

    private CHLoanExtendBillInfo getExdInfo() throws Exception {
        return CHLoanExtendBillFactory.getRemoteInstance().getCHLoanExtendBillInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            Map hm = (Map)this.getUIContext().get("BTPEDITPARAMETER");
            boolean flag = hm != null && hm.get("fromBankLoan") != null;
            this.filterUI = new ChLoanExtendBillFilterUI(flag);
        }
        return this.filterUI;
    }

    public void onLoad() throws Exception {
        Map hm = (Map)this.getUIContext().get("BTPEDITPARAMETER");
        Map ctx1 = (Map)this.getUIContext().get("BTPNAVCTX");
        boolean lb_formTraceUp = false;
        boolean lb_ispush = false;
        if (hm != null && hm.get("fromBankLoan") != null) {
            lb_ispush = true;
        } else {
            Map hm2;
            if (ctx1 != null && ctx1.get("addType") != null && ctx1.get("addType") instanceof Map && (hm2 = (Map)ctx1.get("addType")) != null && hm2.get("fromBankLoan") != null) {
                lb_formTraceUp = true;
            }
            if (!lb_formTraceUp && !lb_ispush) {
                FSClientHelper.checkClearingHouseCompany();
                ChLoanHelper.checkClearingHouseUsed(this.currentCompany);
            }
        }
        super.onLoad();
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_print"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
        this.actionAuditResult.setVisible(false);
        this.actionAuditResult.setEnabled(false);
        this.tblMain.getColumn("beforeExDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("afterExDate").getStyleAttributes().setNumberFormat(this.dformat);
    }

    private void checkCanModify(CHLoanExtendBillInfo chExLoanInfo) throws Exception {
        if (chExLoanInfo.isFivouchered()) {
            throw new CHLoanException(CHLoanException.POSTPONE_ERROR2);
        }
        this.checkSeq(chExLoanInfo, 1);
    }

    private void checkSeq(CHLoanExtendBillInfo chExLoanInfo, int type) throws Exception {
        Map map = CHLoanExtendBillFactory.getRemoteInstance().getInitDate((IObjectPK)new ObjectUuidPK(chExLoanInfo.getChLoan().getId().toString()));
        Integer maxSeq = (Integer)map.get("maxseq");
        if (chExLoanInfo.getExtendSeq() != maxSeq - 1) {
            if (type == 1) {
                throw new CHLoanException(CHLoanException.POSTPONE_ERROR3);
            }
            throw new CHLoanException(CHLoanException.POSTPONE_ERROR4);
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.chLoanInfo = this.getExdInfo();
        this.checkSeq(this.chLoanInfo, 2);
        super.actionRemove_actionPerformed(e);
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    @Override
    public String[] getMergeColumnKeys() {
        this.tblMain.checkParsed();
        int size = 2;
        String[] keys = new String[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = this.tblMain.getColumn(i).getKey();
        }
        return keys;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = super.getFilterInfo();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null && ((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("DefaultQueryFilter") != null) {
            return (FilterInfo)((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("DefaultQueryFilter");
        }
        return filter;
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        Set idSet = FMHelper.list2Set((List)idList);
        IMetaDataPK headPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.ivt.app.CHLoanExtendBillTDQuery");
        DefaultNoteDataProvider dataProvider = new DefaultNoteDataProvider(idSet, headPK);
        String mainDsName = "CHLoanExtendBillTDQuery";
        dataProvider.addMetaDataPK(mainDsName, headPK);
        dataProvider.addCustomFilterMaker(mainDsName, (DefaultNoteDataProvider.ICustomFilterMaker)new DefaultNoteDataProvider.DefaultIdFilterMaker(idSet));
        dataProvider.setBatchSupported(true);
        dataProvider.setNumberOfEachBatch(100);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(PAYMENTBILL_FILENAME, (Object)dataProvider, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        Set idSet = FMHelper.list2Set((List)idList);
        IMetaDataPK headPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.ivt.app.CHLoanExtendBillTDQuery");
        DefaultNoteDataProvider dataProvider = new DefaultNoteDataProvider(idSet, headPK);
        String mainDsName = "CHLoanExtendBillTDQuery";
        dataProvider.addMetaDataPK(mainDsName, headPK);
        dataProvider.addCustomFilterMaker(mainDsName, (DefaultNoteDataProvider.ICustomFilterMaker)new DefaultNoteDataProvider.DefaultIdFilterMaker(idSet));
        dataProvider.setBatchSupported(true);
        dataProvider.setNumberOfEachBatch(100);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(PAYMENTBILL_FILENAME, (Object)dataProvider, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(CHLoanExtendBillListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                this.setRow(tblMain.getRow(i));
            }
        }

        private void setRow(IRow row) {
            Object strObj = row.getCell("exYearRate").getValue();
            BizEnumValueInfo exp = (BizEnumValueInfo)row.getCell("rateExpression").getValue();
            Object enu = exp.getValue();
            if (strObj != null) {
                if ("year".equalsIgnoreCase(enu.toString())) {
                    row.getCell("exYearRate").getStyleAttributes().setNumberFormat("#,##0.000000000\\%");
                } else {
                    row.getCell("exYearRate").getStyleAttributes().setNumberFormat("#,##0.000000000\\\u2030");
                }
                row.getCell("exYearRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
            exp = (BizEnumValueInfo)row.getCell("penaIntType").getValue();
            enu = exp.getValue();
            strObj = row.getCell("peneRateDisplay").getValue();
            if (strObj != null) {
                if ("addPercent".equalsIgnoreCase(enu.toString())) {
                    row.getCell("peneRateDisplay").getStyleAttributes().setNumberFormat("#,##0.000000000\\%");
                } else {
                    row.getCell("peneRateDisplay").getStyleAttributes().setNumberFormat("#,##0.000000000\\\u2030");
                }
                row.getCell("peneRateDisplay").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
            BizEnumValueInfo status = (BizEnumValueInfo)row.getCell("status").getValue();
            String statusDisplay = "";
            int type = Integer.parseInt((String)status.getValue());
            statusDisplay = type == 2 ? STATUS_SUMBIT_DISPLAY : STATUS_TMP_SAVE;
            row.getCell("statusDisplay").setValue((Object)statusDisplay);
        }
    }
}

