/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.fm.common.IvtModuleResourceReader;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.ivt.ChLoanHelper;
import com.kingdee.eas.fm.ivt.ChLoanRateAdjustBillFactory;
import com.kingdee.eas.fm.ivt.ChLoanRateAdjustBillInfo;
import com.kingdee.eas.fm.ivt.client.AbstractChLoanRateAdjustBillListUI;
import com.kingdee.eas.fm.ivt.client.ChLoanRateAdjustBillEditUI;
import com.kingdee.eas.fm.ivt.client.ChLoanRateAdjustBillFilterUI;
import com.kingdee.eas.fm.ivt.client.ChLoanRateAdjustBillListUIQueryProcessor;
import com.kingdee.eas.fm.ivt.client.ChloanRateAdjBillChooseUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.service.LicenseService;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Set;
import org.apache.log4j.Logger;

public class ChLoanRateAdjustBillListUI
extends AbstractChLoanRateAdjustBillListUI {
    private Set setIDs;
    private LicenseService licenseService = new LicenseService((IUIObject)this);
    private String uiParam;
    private static final Logger logger = CoreUIObject.getLogger(ChLoanRateAdjustBillListUI.class);
    private ChLoanRateAdjustBillFilterUI filter;
    FillListener fillListener = new FillListener();

    public void onLoad() throws Exception {
        if (this.getOprtState() == null) {
            FSClientHelper.checkClearingHouseCompany();
            ChLoanHelper.checkClearingHouseUsed(this.currentCompanyCommon);
        } else if (!this.getOprtState().equals("FINDVIEW")) {
            FSClientHelper.checkClearingHouseCompany();
            ChLoanHelper.checkClearingHouseUsed(this.currentCompanyCommon);
        }
        this.uiParam = (String)this.getUIContext().get("UIClassParam");
        if (this.uiParam != null) {
            this.licenseService.checkLicence();
            if (this.getBOTPViewStatus() != 1 && this.uiParam.equals("DO_ADJUST")) {
                this.checkHasNumber();
                this.setIDs = ChloanRateAdjBillChooseUI.show((CoreUI)this);
                if (this.setIDs == null) {
                    SysUtil.abort();
                }
            }
        }
        super.onLoad();
        this.actionAuditResult.setEnabled(false);
        this.actionAuditResult.setVisible(this.actionAuditResult.isEnabled());
        this.actionCreateTo.setVisible(false);
        this.actionCreateTo.setEnabled(false);
        this.actionWorkFlowG.setEnabled(false);
        this.actionWorkFlowG.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.actionRateAdj.setEnabled(true);
        this.tblMain.getColumn("adjustDate").getStyleAttributes().setNumberFormat(this.dformat);
    }

    private void checkHasNumber() {
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            codingRuleManager.readNumber((IObjectValue)new ChLoanRateAdjustBillInfo(), this.currentCompanyCommon.getId().toString());
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)e.getMessage());
            SysUtil.abort();
        }
    }

    protected CommonQueryProcessor getQueryProcessor() {
        return new ChLoanRateAdjustBillListUIQueryProcessor();
    }

    protected void execQuery() {
        if (this.setIDs != null) {
            String includeValue = this.parseValue(this.setIDs);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)includeValue, CompareType.INCLUDE));
            this.mainQuery.setFilter(filter);
        }
        super.execQuery();
        this.setIDs = null;
    }

    private String parseValue(Set setIDs) {
        StringBuffer returnSb = new StringBuffer();
        Object[] ids = setIDs.toArray();
        for (int i = 0; i < ids.length; ++i) {
            if (i == ids.length - 1) {
                returnSb.append(ids[i].toString());
                continue;
            }
            returnSb.append(ids[i].toString()).append(",");
        }
        return returnSb.toString();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filter == null) {
            this.filter = new ChLoanRateAdjustBillFilterUI();
        }
        return this.filter;
    }

    protected String getEditUIName() {
        return ChLoanRateAdjustBillEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ChLoanRateAdjustBillFactory.getRemoteInstance();
    }

    public String[] getMergeColumnKeys() {
        this.tblMain.checkParsed();
        int size = 10;
        String[] keys = new String[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = this.tblMain.getColumn(i).getKey();
        }
        return keys;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionRateAdj.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_backwarddepreciat"));
    }

    @Override
    public void actionRateAdj_actionPerformed(ActionEvent e) throws Exception {
        this.checkHasNumber();
        this.setIDs = ChloanRateAdjBillChooseUI.show((CoreUI)this);
        if (this.setIDs != null) {
            String includeValue = this.parseValue(this.setIDs);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)includeValue, CompareType.INCLUDE));
            this.mainQuery.setFilter(filter);
            this.refresh(e);
        }
    }

    private ChLoanRateAdjustBillInfo getSelectInfo() throws Exception {
        this.checkSelected();
        return ChLoanRateAdjustBillFactory.getRemoteInstance().getChLoanRateAdjustBillInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()), this.getCustomerSelectors());
    }

    private SelectorItemCollection getCustomerSelectors() {
        SelectorItemCollection selector = super.getSelectors();
        selector.add("loan.adjustRateTimes");
        return selector;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.deleteCheck();
        super.actionRemove_actionPerformed(e);
    }

    protected boolean isMutiRemove() {
        return false;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.editCheck();
        super.actionEdit_actionPerformed(e);
    }

    private void editCheck() throws Exception {
        ChLoanRateAdjustBillInfo rateAdjustInfo = this.getSelectInfo();
        if (rateAdjustInfo.isIsUsed()) {
            MsgBox.showWarning((String)IvtModuleResourceReader.getMsg((String)"rateAdjBillEdit_error1"));
            SysUtil.abort();
        }
        if (rateAdjustInfo.getAdjustSeq() != rateAdjustInfo.getLoan().getAdjustRateTimes()) {
            MsgBox.showWarning((String)IvtModuleResourceReader.getMsg((String)"rateAdjBillEdit_error2"));
            SysUtil.abort();
        }
    }

    private void deleteCheck() throws Exception {
        ChLoanRateAdjustBillInfo rateAdjustInfo = this.getSelectInfo();
        if (rateAdjustInfo.getAdjustSeq() != rateAdjustInfo.getLoan().getAdjustRateTimes()) {
            MsgBox.showWarning((String)IvtModuleResourceReader.getMsg((String)"rateAdjBillDelete_error2"));
            SysUtil.abort();
        }
        if (rateAdjustInfo.isIsUsed()) {
            MsgBox.showWarning((String)IvtModuleResourceReader.getMsg((String)"rateAdjBillDelete_error1"));
            SysUtil.abort();
        }
    }

    public boolean destroyWindow() {
        try {
            this.licenseService.releaseLicense();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return super.destroyWindow();
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(ChLoanRateAdjustBillListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            IRow row = null;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = tblMain.getRow(i);
                this.setAmtCellNumberFormat(row);
            }
        }

        private void setAmtCellNumberFormat(IRow row) {
            String rateFormat = "";
            BizEnumValueInfo exp = (BizEnumValueInfo)row.getCell("rateExpression").getValue();
            Object enu = exp.getValue();
            rateFormat = "year".equals(enu.toString()) ? "#,##0.00000\\%" : "#,##0.00000\\\u2030";
            row.getCell("rateAfterAdjt").getStyleAttributes().setNumberFormat(rateFormat);
            row.getCell("rateAfterAdjt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            exp = (BizEnumValueInfo)row.getCell("penAccrualType").getValue();
            enu = exp.getValue();
            rateFormat = "addPercent".equals(enu.toString()) ? "#,##0.00000\\%" : "#,##0.00000\\\u2030";
            row.getCell("penaRateAfterAdj").getStyleAttributes().setNumberFormat(rateFormat);
            row.getCell("penaRateAfterAdj").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("yearDays").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("adjustSeq").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }
}

