/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.ivt.CreditLevelFactory;
import com.kingdee.eas.fm.ivt.CreditLevelInfo;
import com.kingdee.eas.fm.ivt.client.AbstractCreditLevelEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.Set;
import org.apache.log4j.Logger;

public class CreditLevelEditUI
extends AbstractCreditLevelEditUI {
    private static final Logger logger = CoreUIObject.getLogger(CreditLevelEditUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.initPage();
        this.initData();
    }

    private void initPage() {
        this.resetControl(true);
        if (this.getOprtState().equals(OprtState.EDIT)) {
            this.initEditStatePage();
        }
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.initViewStatePage();
        }
        this.txtRemark.setMaxLength(200);
        this.txtName.setMaxLength(60);
        this.txtNumber.setMaxLength(60);
    }

    private void initData() {
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.editData.setIsStart(true);
        }
    }

    private void resetControl(boolean isEnabled) {
        this.contName.setEnabled(isEnabled);
        this.contNumber.setEnabled(isEnabled);
        this.txtRemark.setEnabled(isEnabled);
    }

    private void initEditStatePage() {
        try {
            if (this.editData == null) {
                return;
            }
            if ("001".equals(this.editData.getNumber().trim())) {
                this.contNumber.setEnabled(false);
            } else if (CreditLevelFactory.getRemoteInstance().isUsed(this.editData)) {
                this.contNumber.setEnabled(false);
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void initViewStatePage() {
        this.resetControl(false);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        try {
            String number = this.editData.getNumber();
            if (number != null && number.trim().length() != 0) {
                this.editData.setNumber(number.trim());
            }
            super.actionSubmit_actionPerformed(e);
        }
        catch (BOSException exception) {
            MsgBox.showInfo((String)exception.getMessage());
            SysUtil.abort();
        }
        this.setOprtState(OprtState.VIEW);
        Set allLeafComponents = FMClientHelper.getAllComponents((Container)((Object)this));
        for (Component comp : allLeafComponents) {
            if (comp instanceof KDLabelContainer) continue;
            comp.setEnabled(false);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDMultiLangBox)this.txtName);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CreditLevelFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        return new CreditLevelInfo();
    }
}

