/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.OverdraftCtrlEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.ivt.CHLoanException;
import com.kingdee.eas.fm.ivt.ChLoanFactory;
import com.kingdee.eas.fm.ivt.ChLoanHelper;
import com.kingdee.eas.fm.ivt.ChLoanInfo;
import com.kingdee.eas.fm.ivt.EntRepaymentBillCollection;
import com.kingdee.eas.fm.ivt.EntRepaymentBillFactory;
import com.kingdee.eas.fm.ivt.EntRepaymentBillInfo;
import com.kingdee.eas.fm.ivt.LoanInterestBillCollection;
import com.kingdee.eas.fm.ivt.LoanInterestBillFactory;
import com.kingdee.eas.fm.ivt.client.AbstractEntRepaymentBillEditUI;
import com.kingdee.eas.fm.ivt.client.EntRepayDataProvider;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class EntRepaymentBillEditUI
extends AbstractEntRepaymentBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(EntRepaymentBillEditUI.class);
    private UserInfo userinfo;
    private ChLoanInfo chLoanInfo;
    private BankInfo clearingHouse;
    private String type;
    private BigDecimal lstBalance = Constants.ZERO;
    private CompanyOrgUnitInfo company;
    private static final BOSObjectType srcObjType = new ChLoanInfo().getBOSType();
    private Integer maxSeq = new Integer(0);
    private Date lastRepayDate = DateUtil.getDayBegin();
    private boolean successFlag = false;
    private String LOANINTBILL_FILENAME = "/FM/INVEST/IVT/ENTREPAY";

    public EntRepaymentBillEditUI() throws Exception {
        this.userinfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        this.company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    }

    public static void showRepayEdidUI(CoreUIObject ui, IObjectPK pk) throws EASBizException, UIException {
        if (pk == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"chloanid", (Object)pk);
        uiContext.put((Object)"pull_or_push", (Object)"push");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EntRepaymentBillEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        boolean flag = ((EntRepaymentBillEditUI)uiWindow.getUIObject()).getSuccessFlag();
        if (flag) {
            uiWindow.close();
        }
    }

    protected String getOnloadPermItemName() {
        String state = this.getOprtState();
        if (EmptyUtil.isEmpty((String)state)) {
            super.getOnloadPermItemName();
        }
        if (state.equals(OprtState.ADDNEW)) {
            return "ent_repay_02addNew";
        }
        return "ent_repay_01view";
    }

    private boolean chekcHasIntRelated(String id) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("repayment.id", (Object)id));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        LoanInterestBillCollection intBillCol = LoanInterestBillFactory.getRemoteInstance().getLoanInterestBillCollection(evi);
        return intBillCol != null && intBillCol.size() > 0;
    }

    public void onLoad() throws Exception {
        if (null == this.getUIContext().get("InitDataObject") && !this.getOprtState().equals("FINDVIEW")) {
            FSClientHelper.checkClearingHouseCompany();
            ChLoanHelper.checkClearingHouseUsed(this.currentCompany);
            this.clearingHouse = FSClientHelper.getClearingHouse();
        }
        this.type = (String)this.getUIContext().get("pull_or_push");
        this.txtRepayAmt.setMaximumValue((Comparable)Constants.MAX_VALUE);
        this.pkRepayDate.setSupportedEmpty(false);
        super.onLoad();
        if (this.getOprtState().equals(OprtState.EDIT)) {
            this.txtRepayAmt.setEnabled(false);
            this.chkIsRepayWithAccrual.setEnabled(false);
            this.chkIsPenaAccrual.setEnabled(false);
            if (this.chekcHasIntRelated(this.editData.getId().toString())) {
                this.pkBizDate.setEnabled(false);
                this.pkRepayDate.setEnabled(false);
            }
        }
        CashHelper.initCombCurrency((KDComboBox)this.comboCurrency, (boolean)false);
        if (this.editData.getCurrency() != null) {
            UIUtil.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
        }
        this.initPre((CurrencyInfo)this.comboCurrency.getSelectedItem());
        F7SelectorFactory.initPerson((IUIObject)this, (KDBizPromptBox)this.prmtHandler);
        this.initControl();
        this.txtDescription.setMaxLength(80);
        this.txtNumber.setMaxLength(50);
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)this.prmtProject);
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.input, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
        this.txtRepayAmt.setHorizontalAlignment(4);
        this.txtLocalAmt.setHorizontalAlignment(4);
        this.txtLoanTotalAmt.setHorizontalAlignment(4);
        this.txtRepayTotalAmt.setHorizontalAlignment(4);
        this.txtLoanRemAmt.setHorizontalAlignment(4);
        this.txtIntAmt.setHorizontalAlignment(4);
        this.txtPenaAmt.setHorizontalAlignment(4);
        this.txtRecAmt.setHorizontalAlignment(4);
        this.txtRepayAmt.setRemoveingZeroInDispaly(false);
        this.txtLocalAmt.setRemoveingZeroInDispaly(false);
        this.txtLoanTotalAmt.setRemoveingZeroInDispaly(false);
        this.txtRepayTotalAmt.setRemoveingZeroInDispaly(false);
        this.txtLoanRemAmt.setRemoveingZeroInDispaly(false);
        this.txtIntAmt.setRemoveingZeroInDispaly(false);
        this.txtPenaAmt.setRemoveingZeroInDispaly(false);
        this.txtRecAmt.setRemoveingZeroInDispaly(false);
        FMClientHelper.initFundFlowItemF7((IUIObject)this, (KDLabelContainer)this.contBgItem, (KDLabelContainer)this.contFundFlowItem, (FundFlowDirection)FundFlowDirection.IN);
    }

    public void onShow() throws Exception {
        super.onShow();
        UIUtil.setFirstFocus((Component[])new Component[]{this.txtNumber, this.pkBizDate});
    }

    protected boolean isSetPrecisionAuto() {
        return true;
    }

    protected CurrencyInfo getSelectCurrency() {
        return (CurrencyInfo)this.comboCurrency.getSelectedItem();
    }

    protected void resetPrecisionForOtherComponent() {
        this.txtExchangeRate.setPrecision(4);
    }

    protected void resetPrecisionForLocalAmt() {
        this.txtLocalAmt.setPrecision(this.getBaseCurrencyPrecision());
    }

    private boolean isPush() {
        return "push".equals(this.type);
    }

    private void initControl() throws EASBizException, BOSException {
        this.actionCopyFrom.setVisible(false);
        this.actionPrint.setEnabled(false);
        this.actionPrint.setVisible(false);
        this.actionEdit.setEnabled(false);
        this.actionEdit.setVisible(false);
        this.actionPrintPreview.setEnabled(false);
        this.actionPrintPreview.setVisible(false);
        this.actionCopy.setEnabled(false);
        this.actionCopy.setVisible(false);
        this.actionCopyFrom.setVisible(false);
        this.actionCopyFrom.setVisible(false);
        this.txtIntAmt.setDataType(1);
        this.txtPenaAmt.setDataType(1);
        this.txtRecAmt.setDataType(1);
    }

    private void initPre(CurrencyInfo currency) throws EASBizException, BOSException {
        if (currency != null) {
            int pre = FMClientHelper.getPrecOfCurrency((BOSUuid)currency.getId());
            this.txtRepayAmt.setPrecision(pre);
            this.txtRepayTotalAmt.setPrecision(pre);
            this.txtLoanRemAmt.setPrecision(pre);
            this.txtLocalAmt.setPrecision(pre);
            this.txtLoanTotalAmt.setPrecision(pre);
            this.txtExchangeRate.setPrecision(4);
            this.txtIntAmt.setPrecision(pre);
            this.txtPenaAmt.setPrecision(pre);
            this.txtRecAmt.setPrecision(pre);
        }
    }

    @Override
    public void loadFields() {
        if (this.clearingHouse == null) {
            this.clearingHouse = this.editData.getBank();
        }
        if (null != this.getUIContext().get("InitDataObject")) {
            this.chLoanInfo = ((EntRepaymentBillInfo)this.getUIContext().get("InitDataObject")).getLoanBillID();
            try {
                this.chLoanInfo = ChLoanFactory.getRemoteInstance().getChLoanInfo((IObjectPK)new ObjectUuidPK(this.chLoanInfo.getId()), EntRepaymentBillEditUI.getChLoanSelectors());
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
            this.lstBalance = this.chLoanInfo.getLoanBalance();
            this.editData.setRepayTotalAmt(this.chLoanInfo.getLoanTotalAmt());
            this.editData.setRemAmt(Constants.ZERO);
            this.txtRepayAmt.setMinimumValue((Comparable)Constants.ZERO);
            EntRepaymentBillInfo rInfo = this.editData;
            if (rInfo.getId() == null) {
                rInfo.setId(BOSUuid.create((BOSObjectType)rInfo.getBOSType()));
            }
            try {
                if (EmptyUtil.isEmpty((CoreBaseInfo)this.editData.getCompany())) {
                    rInfo.setCompany(ChLoanHelper.getInstance().getRelatedCompany(null, this.clearingHouse));
                }
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
            rInfo.setLoanCompany(this.chLoanInfo.getLoanAccount().getApplyUnit());
            rInfo.setExchangeRate(this.chLoanInfo.getExchangeRate());
            rInfo.setReceiveBankAccount(this.chLoanInfo.getLoanAccount());
            rInfo.setBizDate(this.editData.getBizDate());
            this.initRepayRecord(this.chLoanInfo.getId().toString());
            rInfo.setRepaySeq(this.maxSeq);
            rInfo.setHandler(this.chLoanInfo.getHandler());
            if (rInfo.getRepayDate() == null) {
                rInfo.setRepayDate(this.chLoanInfo.getEndDate());
            }
            rInfo.setIsHistroyBill(false);
            this.dpEndDate.setValue((Object)this.chLoanInfo.getEndDate());
            this.editData.setLoanInnerAccount(this.chLoanInfo.getDistributeAccou());
        }
        if (this.chLoanInfo != null) {
            this.txtLoanTotalAmt.setValue((Object)this.chLoanInfo.getLoanTotalAmt());
            this.dpEndDate.setValue((Object)this.chLoanInfo.getEndDate());
        }
        super.loadFields();
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        if (this.clearingHouse != null && this.clearingHouse.getRelatedCompany() != null) {
            FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.clearingHouse.getRelatedCompany().getId().toString());
        }
        this.txtExchangeRate.setValue((Object)this.editData.getExchangeRate());
        this.txtLocalAmt.setValue((Object)this.editData.getRepayAmt().multiply(this.editData.getExchangeRate()));
        this.txtRepayAmt.setValue((Object)this.editData.getRepayAmt());
        this.txtRepayTotalAmt.setValue((Object)this.getRepayTotleAmt());
        if (this.getOprtState().equals(OprtState.VIEW) || this.getOprtState().equals(OprtState.EDIT)) {
            this.chkIsRepayWithAccrual.setSelected(this.editData.isIsRepayWithAccrual());
            this.chkIsPenaAccrual.setSelected(this.editData.isIsPenaAccrual());
        } else if (this.getBOTPViewStatus() == 1) {
            if (!this.editData.containsKey("isRepayWithAccrual")) {
                this.chkIsRepayWithAccrual.setSelected(true);
            }
            if (this.editData.containsKey("isPenaAccrual")) {
                this.chkIsPenaAccrual.setSelected(this.editData.isIsPenaAccrual());
            }
        } else {
            this.chkIsRepayWithAccrual.setSelected(true);
        }
        this.prmtCreator.setValue((Object)this.editData.getCreator());
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    private CurrencyInfo getCurrency(BOSUuid id) {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        CurrencyInfo info = null;
        try {
            ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
            info = iCurrency.getCurrencyInfo((IObjectPK)pk);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        return info;
    }

    @Override
    public void storeFields() {
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        CashHelper.initCombCurrency((KDComboBox)this.comboCurrency, (boolean)false);
        UIUtil.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
        super.storeFields();
        this.editData.setBizDate(DateTimeUtils.truncateDate((Date)this.editData.getBizDate()));
        this.editData.setRepayDate(DateTimeUtils.truncateDate((Date)this.editData.getRepayDate()));
        this.editData.setRemAmt(this.txtLoanRemAmt.getBigDecimalValue());
        this.editData.setIsRepayWithAccrual(this.chkIsRepayWithAccrual.isSelected());
        this.editData.setIsPenaAccrual(this.chkIsPenaAccrual.isSelected());
        this.editData.setHandler(FMClientHelper.getUserByF7Person((CoreUI)this, (KDBizPromptBox)this.prmtHandler));
        this.editData.setFivouchered(false);
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if (this.getBOTPViewStatus() == 1) {
            EntRepaymentBillInfo info = (EntRepaymentBillInfo)dataObject;
            if (this.editData.getLoanBillID() != null) {
                try {
                    ChLoanInfo chloanInfo = ChLoanFactory.getRemoteInstance().getChLoanInfo((IObjectPK)new ObjectUuidPK(this.editData.getLoanBillID().getId()), EntRepaymentBillEditUI.getChLoanSelectors());
                    this.editData.setLoanBillID(chloanInfo);
                    this.editData.setLoanInnerAccount(chloanInfo.getDistributeAccou());
                    this.editData.setCompany(chloanInfo.getCompany());
                }
                catch (EASBizException e) {
                    this.handUIExceptionAndAbort((Exception)((Object)e));
                }
                catch (BOSException e) {
                    this.handUIExceptionAndAbort((Exception)((Object)e));
                }
            }
            if (info.getPenaAmt() == null) {
                info.setPenaAmt(Constants.ZERO);
            }
            if (info.getReceAmt() == null) {
                info.setReceAmt(Constants.ZERO);
            }
            if (info.getIntAmt() == null) {
                info.setIntAmt(Constants.ZERO);
            }
            if (((EntRepaymentBillInfo)dataObject).getBizDate() == null) {
                ((EntRepaymentBillInfo)dataObject).setBizDate(DateUtil.getDayBegin());
            }
        }
    }

    @Override
    public void prmtReceiveBankAccount_willShow(SelectorEvent e) {
        this.setRecBankFilter();
    }

    @Override
    public void prmtReceiveBankAccount_willCommit(CommitEvent e) {
        this.setRecBankFilter();
    }

    private void setRecBankFilter() {
        int result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"57_ChLoanEditUI"));
        if (result == 0) {
            ChLoanHelper.getInstance().setAccountFilter(this.clearingHouse, this.prmtReceiveBankAccount, (CompanyOrgUnitInfo)this.prmtCompany.getValue(), 2);
        } else {
            ChLoanHelper.getInstance().setAccountFilter(this.clearingHouse, this.prmtReceiveBankAccount, null, 2);
        }
    }

    protected IObjectValue createNewData() {
        EntRepaymentBillInfo info = new EntRepaymentBillInfo();
        info.setRepayAmt(Constants.ZERO);
        info.setExchangeRate(Constants.ONE);
        if (this.getUIContext().get("chloanid") != null) {
            IObjectPK pk = (IObjectPK)this.getUIContext().get("chloanid");
            try {
                this.chLoanInfo = ChLoanFactory.getRemoteInstance().getChLoanInfo(pk, EntRepaymentBillEditUI.getChLoanSelectors());
                this.lstBalance = this.chLoanInfo.getLoanBalance();
                info.setRepayAmt(this.lstBalance);
                info.setRepayTotalAmt(this.chLoanInfo.getLoanTotalAmt());
                info.setRemAmt(Constants.ZERO);
                this.txtRepayAmt.setMinimumValue((Comparable)Constants.ZERO);
                this.btnCreateFrom.setEnabled(false);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
        }
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setChLoanInfo(this.chLoanInfo);
        info.setBizDate(this.clearingHouse.getSettleDate());
        info.setCreator(this.userinfo);
        info.setRepayDate(info.getBizDate());
        if (this.chLoanInfo != null) {
            this.initRepayRecord(this.chLoanInfo.getId().toString());
        }
        if (this.isPush()) {
            try {
                info.setCompany(ChLoanHelper.getInstance().getRelatedCompany(null, this.clearingHouse));
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
            info.setLoanCompany(this.chLoanInfo.getLoanAccount().getApplyUnit());
            info.setBank(this.chLoanInfo.getBank());
            info.setLoanBillID(this.chLoanInfo);
            info.setCurrency(this.chLoanInfo.getCurrency());
            info.setRepayAmt(this.chLoanInfo.getLoanBalance());
            info.setReceiveBankAccount(this.chLoanInfo.getLoanAccount());
            info.setHandler(this.chLoanInfo.getHandler());
            info.setExchangeRate(this.chLoanInfo.getExchangeRate());
            info.setLoanInnerAccount(this.chLoanInfo.getDistributeAccou());
            info.setRepaySeq(this.maxSeq);
        }
        info.setIsHistroyBill(false);
        info.setIsDownLoaded(false);
        info.setFivouchered(false);
        info.setPenaAmt(Constants.ZERO);
        info.setIntAmt(Constants.ZERO);
        info.setReceAmt(Constants.ZERO);
        return info;
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.pkBizDate.setSupportedEmpty(false);
        EntRepaymentBillInfo info = (EntRepaymentBillInfo)this.getDataObject();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.chkIsRepayWithAccrual.setSelected(true);
            this.chkIsPenaAccrual.setSelected(true);
        }
        if (info.getCurrency() != null && this.company.getBaseCurrency().getId().toString().equals(info.getCurrency().getId().toString())) {
            this.txtExchangeRate.setEditable(false);
        } else {
            this.txtExchangeRate.setEditable(true);
        }
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.actionCreateFrom.setEnabled(false);
            this.actionCopy.setEnabled(false);
            this.actionRemove.setEnabled(false);
        } else {
            this.actionCreateFrom.setEnabled(true);
            this.actionCopy.setEnabled(true);
        }
        this.actionCopy.setVisible(false);
        this.menuBiz.setVisible(false);
        boolean TDPStatus = this.getOprtState().equals(OprtState.ADDNEW);
        this.actionTDPrint.setVisible(!TDPStatus);
        this.actionTDPrint.setEnabled(!TDPStatus);
        this.actionTDPrintPreView.setVisible(!TDPStatus);
        this.actionTDPrintPreView.setEnabled(!TDPStatus);
        this.txtIntAmt.setEnabled(false);
        this.txtPenaAmt.setEnabled(false);
        this.txtRecAmt.setEnabled(false);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EntRepaymentBillFactory.getRemoteInstance();
    }

    public int getBtpCreateFromType() {
        return 0;
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("DefaultQueryFilter", this.getFilter());
        ctx.put("showType", "RepaymentBill");
        ctx.put("CURRENTCOMPANY", this.currentCompany.getId().toString());
        this.getBillEdit().createFrom(null, ctx);
        this.btnCreateFrom.setEnabled(true);
    }

    public List getSrcBosTypeForBotp(List srcBosTypeList) {
        return srcBosTypeList;
    }

    private FilterInfo getFilter() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("bank.id", (Object)this.clearingHouse.getId()));
        filterInfo.getFilterItems().add(new FilterItemInfo("loanBalance", (Object)Constants.ZERO, CompareType.GREATER));
        filterInfo.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(4)));
        return filterInfo;
    }

    @Override
    protected void txtExchangeRate_dataChanged(DataChangeEvent e) throws Exception {
        this.txtLocalAmt.setValue((Object)FMHelper.multiply((BigDecimal)this.txtExchangeRate.getBigDecimalValue(), (BigDecimal)this.txtRepayAmt.getBigDecimalValue()));
    }

    @Override
    protected void txtRepayAmt_dataChanged(DataChangeEvent e) throws Exception {
        if (this.txtRepayAmt.getBigDecimalValue() != null) {
            this.txtRepayTotalAmt.setValue((Object)this.getRepayTotleAmt());
            this.txtLocalAmt.setValue((Object)this.getLocalAmt());
            this.txtLoanRemAmt.setValue((Object)this.getLoanRemtAmt());
        }
    }

    private BigDecimal getLoanRemtAmt() {
        return FMHelper.subtract((BigDecimal)this.txtLoanTotalAmt.getBigDecimalValue(), (BigDecimal)this.txtRepayTotalAmt.getBigDecimalValue());
    }

    private BigDecimal getRepayTotleAmt() {
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            if (this.chLoanInfo != null) {
                return this.chLoanInfo.getLoanTotalAmt().subtract(this.lstBalance).add(this.txtRepayAmt.getBigDecimalValue());
            }
        } else {
            return this.editData.getRepayTotalAmt();
        }
        return Constants.ZERO;
    }

    private BigDecimal getLocalAmt() {
        if (this.chLoanInfo != null && this.txtRepayAmt.getBigDecimalValue() != null) {
            return this.txtRepayAmt.getBigDecimalValue().multiply(this.chLoanInfo.getExchangeRate());
        }
        return Constants.ZERO;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.prmtLoanBill.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"shouldcreatefrom"));
            SysUtil.abort();
        }
        ClientVerifyHelper.verifyRequire((CoreUIObject)this);
        this.doBizVerify();
    }

    private void doBizVerify() throws Exception {
        this.checkRepayDate();
        this.checkRepayAmt();
        if (!this.editData.getIsModifyOper() && this.chLoanInfo.getLoanBalance().compareTo(this.editData.getRepayAmt()) < 0) {
            this.checkCtrlStrategy();
        }
    }

    private void checkCtrlStrategy() throws Exception {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("ctrlStrategy.lowestBalance");
        InnerAccountInfo info = (InnerAccountInfo)AccountBankFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(this.chLoanInfo.getLoanAccount().getId()));
        if (info.getCtrlParam() != null && info.getCtrlParam().getOverdraftCtrl() == OverdraftCtrlEnum.NOTALLOW) {
            throw new CHLoanException(CHLoanException.CTRL_STRATEGY_ERROR);
        }
    }

    private void checkRepayAmt() throws Exception {
        BigDecimal retotal;
        if (this.txtRepayAmt.getBigDecimalValue().compareTo(Constants.ZERO) <= 0) {
            throw new CHLoanException(CHLoanException.REPAY_AMT_ERROR1);
        }
        if (this.txtRepayAmt.getBigDecimalValue().compareTo(this.chLoanInfo.getLoanBalance()) != 0) {
            BigDecimal tmp = this.chLoanInfo.getLoanBalance().subtract(this.chLoanInfo.getFloorAmt());
            if (this.txtRepayAmt.getBigDecimalValue().compareTo(tmp) > 0 && !this.editData.getIsModifyOper() && this.chLoanInfo.getLoanTotalAmt().compareTo(this.chLoanInfo.getFloorAmt()) != 0) {
                throw new CHLoanException(CHLoanException.REPAY_AMT_ERROR2);
            }
        }
        BigDecimal re = this.txtRepayAmt.getBigDecimalValue();
        BigDecimal loanTotal = this.txtLoanTotalAmt.getBigDecimalValue();
        BigDecimal balance = loanTotal.subtract(retotal = this.txtRepayTotalAmt.getBigDecimalValue());
        if (balance.signum() < 0) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"repayamt_error"));
            SysUtil.abort();
        }
    }

    private void checkRepayDate() throws Exception {
        if (this.editData.getIsModifyOper()) {
            FilterInfo filter = new FilterInfo();
            EntityViewInfo evi = new EntityViewInfo();
            filter.getFilterItems().add(new FilterItemInfo("loanBillID.id", (Object)this.chLoanInfo.getId().toString()));
            evi.setFilter(filter);
            EntRepaymentBillCollection entRepayCol = EntRepaymentBillFactory.getRemoteInstance().getEntRepaymentBillCollection(evi);
            if (entRepayCol != null && entRepayCol.size() > 0) {
                HashMap<Integer, Date> map = new HashMap<Integer, Date>();
                int size = entRepayCol.size();
                for (int i = 0; i < size; ++i) {
                    EntRepaymentBillInfo entRepayBill = entRepayCol.get(i);
                    map.put(entRepayBill.getRepaySeq(), entRepayBill.getRepayDate());
                }
                int lastRepaySeq = this.editData.getRepaySeq() - 1;
                int nextRepaySeq = this.editData.getRepaySeq() + 1;
                Date nextRepayDate = (Date)map.get(nextRepaySeq);
                Date lastRepayDate = (Date)map.get(lastRepaySeq);
                if (lastRepayDate != null && this.editData.getRepayDate().before(lastRepayDate)) {
                    throw new CHLoanException(CHLoanException.REPAY_DATE_ERROR1);
                }
                nextRepayDate = (Date)map.get(nextRepaySeq);
                if (nextRepayDate != null && this.editData.getRepayDate().after(nextRepayDate)) {
                    throw new CHLoanException(CHLoanException.REPAY_DATE_ERROR2);
                }
                if (this.editData.getRepayDate().before(this.chLoanInfo.getStartDate())) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"72_EntRepaymentBillEditUI"));
                    SysUtil.abort();
                }
            }
        } else {
            if (this.lastRepayDate != null && this.editData.getRepayDate().before(this.lastRepayDate)) {
                throw new CHLoanException(CHLoanException.REPAY_DATE_ERROR1);
            }
            if (this.editData.getRepayDate().before(this.chLoanInfo.getStartDate())) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"72_EntRepaymentBillEditUI"));
                SysUtil.abort();
            }
        }
    }

    private void initRepayRecord(String loanId) {
        Map repayRecord = null;
        try {
            repayRecord = EntRepaymentBillFactory.getRemoteInstance().getInitEditData((IObjectPK)new ObjectUuidPK(loanId));
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.maxSeq = (Integer)repayRecord.get("maxseq");
        this.lastRepayDate = (Date)repayRecord.get("lastrepaydate");
    }

    private void emptyControllers() {
        this.prmtLoanBill.setValue(null);
        this.txtNumber.setText("");
        this.prmtCompany.setValue(null);
        this.txtRepaySeq.setValue(null);
        this.txtLoanRemAmt.setValue(null);
        this.txtRepayTotalAmt.setValue(null);
        this.txtLoanTotalAmt.setValue(null);
        this.txtRepayAmt.setValue(null);
    }

    public void checkNumberDup(BOSObjectType bosType, String number) throws Exception {
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.editData.setIsModifyOper(false);
        } else {
            this.editData.setIsModifyOper(true);
        }
        this.verify(e);
        if (!this.editData.getIsModifyOper() && this.editData.isIsRepayWithAccrual()) {
            this.editData.setChLoanInfo(this.chLoanInfo);
            this.editData.setCU(ContextHelperFactory.getRemoteInstance().getCurrentCtrlUnit());
            EntRepaymentBillFactory.getRemoteInstance().checkNumberDup(null, (CoreBillBaseInfo)this.editData);
            int result = ChLoanHelper.getInstance().showIntReceiveEditUI((CoreUIObject)this, this.editData);
            if (result == 2) {
                this.storeFields();
                this.initOldData((IObjectValue)this.editData);
                super.disposeUIWindow();
                this.successFlag = true;
                this.emptyControllers();
            } else if (result == 1) {
                super.actionSubmit_actionPerformed(e);
                this.successFlag = true;
                if (this.successFlag) {
                    this.storeFields();
                    this.initOldData((IObjectValue)this.editData);
                    this.disposeUIWindow();
                    this.emptyControllers();
                }
            } else {
                throw new CHLoanException(CHLoanException.REPAY_ERROR3);
            }
            if (this.successFlag) {
                this.storeFields();
                this.initOldData((IObjectValue)this.editData);
                this.disposeUIWindow();
            }
        } else {
            super.actionSubmit_actionPerformed(e);
            this.successFlag = true;
            this.storeFields();
            this.initOldData((IObjectValue)this.editData);
            this.disposeUIWindow();
            this.emptyControllers();
        }
        UIUtil.setFirstFocus((Component[])new Component[]{this.txtNumber, this.pkBizDate});
    }

    public boolean getSuccessFlag() {
        return this.successFlag;
    }

    @Override
    public void chkIsRepayWithAccrual_actionPerformed(ActionEvent e) {
    }

    @Override
    public void chkIsRepayWithAccrual_stateChanged(ChangeEvent e) {
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return;
        }
        if (this.chkIsRepayWithAccrual.isSelected()) {
            if (!this.chkIsPenaAccrual.isSelected()) {
                this.chkIsPenaAccrual.setEnabled(true);
            } else {
                this.chkIsPenaAccrual.setSelected(false);
                this.chkIsPenaAccrual.setEnabled(false);
            }
        } else {
            this.chkIsPenaAccrual.setSelected(false);
            this.chkIsPenaAccrual.setEnabled(false);
        }
    }

    @Override
    public void chkIsPenaAccrual_actionPerformed(ActionEvent e) {
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        EntRepaymentBillInfo objectValue = (EntRepaymentBillInfo)super.getValue(pk);
        this.chLoanInfo = objectValue.getLoanBillID();
        this.initRepayRecord(this.chLoanInfo.getId().toString());
        return objectValue;
    }

    public static SelectorItemCollection getChLoanSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("loanAccount.name"));
        sic.add(new SelectorItemInfo("loanAccountView.name"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("assureWay.name"));
        sic.add(new SelectorItemInfo("rateType.name"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("handler.name"));
        sic.add(new SelectorItemInfo("finacingProduct.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("bank.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("handler.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("rateType.*"));
        sic.add(new SelectorItemInfo("loanAccount.*"));
        sic.add(new SelectorItemInfo("loanAccount.applyUnit.*"));
        sic.add(new SelectorItemInfo("distributeAccou.*"));
        return sic;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("handler.id"));
        sic.add(new SelectorItemInfo("handler.number"));
        sic.add(new SelectorItemInfo("handler.name"));
        sic.add(new SelectorItemInfo("loanCompany.id"));
        sic.add(new SelectorItemInfo("loanCompany.name"));
        sic.add(new SelectorItemInfo("loanCompany.number"));
        sic.add(new SelectorItemInfo("receiveBankAccount.id"));
        sic.add(new SelectorItemInfo("receiveBankAccount.name"));
        sic.add(new SelectorItemInfo("receiveBankAccount.number"));
        sic.add(new SelectorItemInfo("loanInnerAccount.id"));
        sic.add(new SelectorItemInfo("loanInnerAccount.name"));
        sic.add(new SelectorItemInfo("loanInnerAccount.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("accountant.id"));
        sic.add(new SelectorItemInfo("accountant.number"));
        sic.add(new SelectorItemInfo("accountant.name"));
        sic.add(new SelectorItemInfo("loanBillID.*"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("fpItem.id"));
        sic.add(new SelectorItemInfo("fpItem.number"));
        sic.add(new SelectorItemInfo("fpItem.name"));
        sic.add("fundFlowItem.*");
        sic.add("*");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("company.number");
        sic.add("bank.relatedCompany.id");
        return sic;
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        this.editData.setCompany(company);
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fm.ivt.app.EntRepaymentBill", null, (IObjectValue)this.editData);
    }

    protected boolean showViewBdgBalanceBtn() {
        return true;
    }

    protected void setAutoNumberByOrg(String orgType) {
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        EntRepaymentBillInfo info = (EntRepaymentBillInfo)this.getDataObject();
        if (info.getId() != null) {
            ArrayList<String> idList = new ArrayList<String>();
            idList.add(info.getId().toString());
            if (idList == null || idList.size() == 0) {
                return;
            }
            EntRepayDataProvider data = new EntRepayDataProvider(idList);
            KDNoteHelper appHlp = new KDNoteHelper();
            appHlp.print(this.LOANINTBILL_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    @Override
    public void actionTDPrintPreView_actionPerformed(ActionEvent e) throws Exception {
        EntRepaymentBillInfo info = (EntRepaymentBillInfo)this.getDataObject();
        if (info.getId() != null) {
            ArrayList<String> idList = new ArrayList<String>();
            idList.add(info.getId().toString());
            if (idList == null || idList.size() == 0) {
                return;
            }
            EntRepayDataProvider data = new EntRepayDataProvider(idList);
            KDNoteHelper appHlp = new KDNoteHelper();
            appHlp.printPreview(this.LOANINTBILL_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    public void initWorkButton() {
        super.initWorkButton();
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreView.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dysz"));
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.FIN_MANAGE;
    }

    protected String getDateField() {
        return "repayDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionSave", "actionSubmit", "actionCancelBook", "actionAntiAudit"};
    }

    public boolean checkBeforeWindowClosing() {
        if (this.getUIContext().get("chloanid") != null) {
            return false;
        }
        return super.checkBeforeWindowClosing();
    }
}

