/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyFactory;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.OverdraftCtrlEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IvtModualUtils;
import com.kingdee.eas.fm.common.SumBillEnum;
import com.kingdee.eas.fm.common.SumFiledsInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.erec.client.EReceiptInnerClientHelper;
import com.kingdee.eas.fm.fin.RepaymentCollection;
import com.kingdee.eas.fm.fin.RepaymentFactory;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.ivt.CHLoanException;
import com.kingdee.eas.fm.ivt.ChLoanHelper;
import com.kingdee.eas.fm.ivt.EntRepaymentBillCollection;
import com.kingdee.eas.fm.ivt.EntRepaymentBillFactory;
import com.kingdee.eas.fm.ivt.EntRepaymentBillInfo;
import com.kingdee.eas.fm.ivt.IntCalTypeEnum;
import com.kingdee.eas.fm.ivt.IvtBillStatusEnum;
import com.kingdee.eas.fm.ivt.LoanInterestBillCollection;
import com.kingdee.eas.fm.ivt.LoanInterestBillFactory;
import com.kingdee.eas.fm.ivt.LoanInterestBillInfo;
import com.kingdee.eas.fm.ivt.client.AbstractEntRepaymentBillListUI;
import com.kingdee.eas.fm.ivt.client.EntRepayDataProvider;
import com.kingdee.eas.fm.ivt.client.EntRepaymentBillEditUI;
import com.kingdee.eas.fm.ivt.client.EntRepaymentBillFilterUI;
import com.kingdee.eas.fm.ivt.client.EntRepaymentBillParam;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class EntRepaymentBillListUI
extends AbstractEntRepaymentBillListUI {
    private String LOANINTBILL_FILENAME = "/FM/INVEST/IVT/ENTREPAY";
    private static final Logger logger = CoreUIObject.getLogger(EntRepaymentBillListUI.class);
    private static final ContextHelperFactory FundTransferRepayBillFactory = null;
    private EntRepaymentBillFilterUI filterUI;
    private CompanyOrgUnitInfo currentCompany;
    FillListener fillListener = new FillListener();

    public EntRepaymentBillListUI() throws Exception {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("*");
        sic.add("fpItem.id");
        sic.add("fpItem.number");
        sic.add("fpItem.name");
        sic.add("outBgItemId");
        sic.add("oUtBgItemName");
        sic.add("outBgItemNumber");
        return sic;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dysz"));
        this.actionBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_post"));
        this.actionCancelBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_versapost"));
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        boolean IVT005_Value = IvtModualUtils.getSysParam(null, (String)"IVT006");
        this.actionAudit.setVisible(IVT005_Value);
        this.actionAntiAudit.setVisible(IVT005_Value);
        this.actionNavInnerEreceipt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
    }

    public void onLoad() throws Exception {
        Map hm = (Map)this.getUIContext().get("BTPEDITPARAMETER");
        if (hm == null || hm.get("fromBankLoan") == null) {
            if (this.getOprtState() == null) {
                FSClientHelper.checkClearingHouseCompany();
                ChLoanHelper.checkClearingHouseUsed(this.currentCompany);
            } else if (!this.getOprtState().equals("FINDVIEW")) {
                FSClientHelper.checkClearingHouseCompany();
                ChLoanHelper.checkClearingHouseUsed(this.currentCompany);
            }
        }
        super.onLoad();
        this.actionWorkFlowG.setVisible(true);
        this.actionWorkFlowG.setEnabled(true);
        this.actionCancelBook.setEnabled(true);
        this.actionCancelBook.setVisible(true);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnTDPrint.setVisible(false);
        this.btnTDPrePrintView.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnAntiAudit.setVisible(false);
        this.btnCancelBook.setVisible(false);
        this.actionEdit.setEnabled(true);
        this.tblMain.getColumn("repayDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("loanEndDate").getStyleAttributes().setNumberFormat(this.dformat);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(this.mainQueryPK, this.mainQuery);
        return exec;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EntRepaymentBillFactory.getRemoteInstance();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            Map hm = (Map)this.getUIContext().get("BTPEDITPARAMETER");
            boolean flag = hm != null && hm.get("fromBankLoan") != null;
            this.filterUI = new EntRepaymentBillFilterUI(flag);
        }
        return this.filterUI;
    }

    protected String getEditUIName() {
        return EntRepaymentBillEditUI.class.getName();
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(rowNumber);
        this.deleteCheck(row);
        super.actionRemove_actionPerformed(e);
    }

    private boolean chekcHasRepaymentBillRelated(String id) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("entRepaymentBill.id", (Object)id));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        RepaymentCollection intBillCol = RepaymentFactory.getRemoteInstance().getRepaymentCollection(evi);
        return intBillCol != null && intBillCol.size() > 0;
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String keyValue = this.getSelectedKeyValue();
        if (keyValue == null) {
            return;
        }
        EntRepaymentBillInfo info = EntRepaymentBillFactory.getRemoteInstance().getEntRepaymentBillInfo((IObjectPK)new ObjectUuidPK(keyValue));
        if (IvtBillStatusEnum.AUDIT.equals((Object)info.getBillStatus()) || IvtBillStatusEnum.BOOK.equals((Object)info.getBillStatus())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"372_RepaymentListUI"));
            this.abort();
        }
        if (this.chekcHasRepaymentBillRelated(keyValue)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"687_Repayment_edit"));
            this.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    private void deleteCheck(IRow row) throws Exception {
        Boolean isVoucher = (Boolean)row.getCell("fivouchered").getValue();
        if (isVoucher.booleanValue()) {
            throw new CHLoanException(CHLoanException.ENTREPAYMENT_DELETE_ERROR1);
        }
        String id = (String)row.getCell("loanBillID.id").getValue();
        int maxSeqNo = this.getMaxSeqNo(id);
        int deletedSeqNo = (Integer)row.getCell("repaySeq").getValue();
        if (deletedSeqNo != maxSeqNo - 1) {
            throw new CHLoanException(CHLoanException.ENTREPAYMENT_DELETE_ERROR2);
        }
        BizEnumValueDTO statusObj = (BizEnumValueDTO)row.getCell("status").getValue();
        if (statusObj.getValue() != null) {
            int status = Integer.parseInt(statusObj.getValue().toString());
            if (status == 4) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"73_EntRepaymentBillListUI"));
                SysUtil.abort();
            }
            if (status == 3) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"74_EntRepaymentBillListUI"));
                SysUtil.abort();
            }
        }
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        ItemAction action = this.getActionFromActionEvent(e);
        if (action.equals(this.actionAddNew)) {
            uiContext.put((Object)"pull_or_push", (Object)"pull");
            uiContext.put((Object)"addType", (Object)Boolean.FALSE);
        }
        if (action.equals((Object)this.actionAddNewHis)) {
            uiContext.put((Object)"addType", (Object)Boolean.TRUE);
        }
        if (action.equals(this.actionView)) {
            // empty if block
        }
    }

    private int getMaxSeqNo(String id) {
        int maxSeqNo = 0;
        try {
            Map hm = EntRepaymentBillFactory.getRemoteInstance().getInitEditData((IObjectPK)new ObjectUuidPK(id));
            Integer maxSeqInteger = (Integer)hm.get("maxseq");
            maxSeqNo = maxSeqInteger;
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        return maxSeqNo;
    }

    @Override
    public void actionAddNewHis_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanVoucher(0);
        super.actionVoucher_actionPerformed(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanVoucher(1);
        super.actionDelVoucher_actionPerformed(e);
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        EntRepayDataProvider data = new EntRepayDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(this.LOANINTBILL_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        EntRepayDataProvider data = new EntRepayDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(this.LOANINTBILL_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    private void checkCanVoucher(int type) throws Exception {
        this.checkSelected();
        EntRepaymentBillInfo entRepayInfo = EntRepaymentBillFactory.getRemoteInstance().getEntRepaymentBillInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        if (0 == type) {
            if (entRepayInfo.isIsHistroyBill()) {
                // empty if block
            }
            if (entRepayInfo.getBillStatus() != IvtBillStatusEnum.BOOK) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"75_EntRepaymentBillListUI"));
                SysUtil.abort();
            }
        } else if (1 == type && !entRepayInfo.isFivouchered()) {
            throw new CHLoanException(CHLoanException.REPAYBILL_VOUCHER_ERROR2);
        }
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    public String[] getMergeColumnKeys() {
        this.tblMain.checkParsed();
        int size = 2;
        String[] keys = new String[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = this.tblMain.getColumn(i).getKey();
        }
        return keys;
    }

    public void gainBillSet(List list) throws Exception {
        String VOUCHERFLAG = "fiVouchered";
        String strIdLists = StringUtils.arrayToString((Object[])list.toArray(), (String)",");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo(VOUCHERFLAG, (Object)Boolean.TRUE));
        StringBuffer maskString = new StringBuffer();
        maskString.append("#0 AND #1");
        filterInfo.setMaskString(maskString.toString());
        boolean isExist = ((ICoreBillBase)this.getCoreBaseInterface()).exists(filterInfo);
        filterInfo.getFilterItems().clear();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo(VOUCHERFLAG, (Object)Boolean.TRUE, CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo(VOUCHERFLAG, null, CompareType.EQUALS));
        maskString = new StringBuffer();
        maskString.append("#0 AND (#1 or #2)");
        filterInfo.setMaskString(maskString.toString());
        boolean isNotExist = ((ICoreBillBase)this.getCoreBaseInterface()).exists(filterInfo);
        if (isExist && isNotExist) {
            this.actionVoucher.setEnabled(true);
            this.actionDelVoucher.setEnabled(true);
        } else if (!isExist && isNotExist) {
            this.actionVoucher.setEnabled(true);
            this.actionDelVoucher.setEnabled(false);
        } else if (isExist && !isNotExist) {
            this.actionVoucher.setEnabled(false);
            this.actionDelVoucher.setEnabled(true);
        }
    }

    protected boolean showViewBdgBalanceBtn() {
        return true;
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        if (id != null) {
            FMClientHelper.viewBgBalance4ListUI((Component)((Object)this), (String)id);
        }
    }

    private SelectorItemCollection getCustomSelectors() {
        SelectorItemCollection select = new SelectorItemCollection();
        select.add("*");
        select.add("currency.id");
        select.add("currency.number");
        select.add("currency.name");
        select.add("company.*");
        select.add("outBgItemId");
        select.add("outBgItemNumber");
        select.add("outBgItemName");
        select.add("project.name");
        select.add("project.number");
        return select;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = super.getFilterInfo();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null) {
            if (((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("filterInfo") != null) {
                return (FilterInfo)((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("filterInfo");
            }
            if (((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("DefaultQueryFilter") != null) {
                return (FilterInfo)((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("DefaultQueryFilter");
            }
        }
        return filter;
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.formatFootRow();
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected void execQuery() {
        super.execQuery();
        this.formatFootRow();
    }

    protected IRow appendFootRow() {
        IRow sumRow = super.appendFootRow();
        this.formatFootRow();
        return sumRow;
    }

    private void formatFootRow() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            EntRepaymentBillParam param = (EntRepaymentBillParam)this.getFilterUI().getParam();
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrencyInfo() == null ? company.getBaseCurrency().getId().toString() : AccessHelper.getId((Object)param.getCurrencyInfo());
            String[] columns = new SumFiledsInfo(SumBillEnum.EntRepay).getSumFileds();
            for (int i = 0; i < columns.length; ++i) {
                FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.doAntiAudit();
        this.refresh(e);
    }

    private void doAntiAudit() throws Exception {
        int result;
        HashSet allSelected = new HashSet(this.getSelectedIdValues());
        Set toAntiBeAudited = this.getToBeAntiAuditIdSet(allSelected);
        if (toAntiBeAudited.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"63_ChLoanListUI"));
            SysUtil.abort();
        }
        if (toAntiBeAudited.size() > allSelected.size()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"unkownerror"));
            SysUtil.abort();
        } else if (toAntiBeAudited.size() == allSelected.size()) {
            EntRepaymentBillFactory.getRemoteInstance().antiAudit(toAntiBeAudited);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"operSucess_antiaudit"));
        } else if (toAntiBeAudited.size() < allSelected.size() && (result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"antiauditoption"))) == 0) {
            EntRepaymentBillFactory.getRemoteInstance().antiAudit(toAntiBeAudited);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"operSucess_antiaudit"));
        }
    }

    private Set getToBeAntiAuditIdSet(Set allSelected) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("id", (Object)allSelected, CompareType.INCLUDE));
        f.getFilterItems().add(new FilterItemInfo("billStatus", (Object)IvtModualUtils.AUDIT));
        evi.setFilter(f);
        EntRepaymentBillCollection toBeAudit = EntRepaymentBillFactory.getRemoteInstance().getEntRepaymentBillCollection(evi);
        HashSet<String> toBeAuditIDSet = new HashSet<String>();
        int size = toBeAudit.size();
        if (toBeAudit != null && size > 0) {
            for (int i = 0; i < size; ++i) {
                toBeAuditIDSet.add(toBeAudit.get(i).getId().toString());
            }
        }
        return toBeAuditIDSet;
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.doAudit();
        this.refresh(e);
    }

    private void doAudit() throws Exception {
        int result;
        HashSet allSelected = new HashSet(this.getSelectedIdValues());
        Set toBeAudited = this.getToBeAuditIdSet(allSelected);
        if (toBeAudited.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"63_ChLoanListUI"));
            SysUtil.abort();
        }
        if (toBeAudited.size() > allSelected.size()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"unkownerror"));
            SysUtil.abort();
        } else if (toBeAudited.size() == allSelected.size()) {
            EntRepaymentBillFactory.getRemoteInstance().audit(toBeAudited);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"operSucess_audit"));
        } else if (toBeAudited.size() < allSelected.size() && (result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"auditoption"))) == 0) {
            EntRepaymentBillFactory.getRemoteInstance().audit(toBeAudited);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"operSucess_audit"));
        }
    }

    private Set getToBeAuditIdSet(Set allSelected) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("id", (Object)allSelected, CompareType.INCLUDE));
        f.getFilterItems().add(new FilterItemInfo("billStatus", (Object)IvtModualUtils.SUBMIT));
        evi.setFilter(f);
        EntRepaymentBillCollection toBeAudit = EntRepaymentBillFactory.getRemoteInstance().getEntRepaymentBillCollection(evi);
        HashSet<String> toBeAuditIDSet = new HashSet<String>();
        int size = toBeAudit.size();
        if (toBeAudit != null && size > 0) {
            for (int i = 0; i < size; ++i) {
                toBeAuditIDSet.add(toBeAudit.get(i).getId().toString());
            }
        }
        return toBeAuditIDSet;
    }

    @Override
    public void actionBook_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        HashSet allSelected = new HashSet(this.getSelectedIdValues());
        boolean IVT006_Value = IvtModualUtils.getSysParam(null, (String)"IVT006");
        Set toBeBooked = this.getToBeBookedIdSet(allSelected, IVT006_Value);
        this.doBook(toBeBooked);
        this.refresh(e);
    }

    private void doBook(Set toBeBooked) throws Exception {
        int result;
        HashSet allSelected = new HashSet(this.getSelectedIdValues());
        if (toBeBooked.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"76_EntRepaymentBillListUI"));
            SysUtil.abort();
        }
        if (toBeBooked.size() > allSelected.size()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"unkownerror"));
            SysUtil.abort();
        } else if (toBeBooked.size() == allSelected.size()) {
            boolean IVT006_Value = IvtModualUtils.getSysParam(null, (String)"IVT006");
            boolean IVT003_Value = IvtModualUtils.getSysParam(null, (String)"IVT003");
            if (IVT003_Value) {
                EntRepaymentBillFactory.getRemoteInstance().audit(toBeBooked);
            } else if (!IVT006_Value) {
                EntRepaymentBillFactory.getRemoteInstance().audit(toBeBooked);
            }
            if (IvtModualUtils.getSysParam(null, (String)"IVT007")) {
                Set loanIntIDSet = EntRepaymentBillFactory.getRemoteInstance().getLoanInterestBill(toBeBooked);
                this.doLoanIntCheck(loanIntIDSet);
            }
            EntRepaymentBillFactory.getRemoteInstance().book(toBeBooked);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"operSucess_book"));
        } else if (toBeBooked.size() < allSelected.size() && (result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"bookoption"))) == 0) {
            EntRepaymentBillFactory.getRemoteInstance().audit(toBeBooked);
            EntRepaymentBillFactory.getRemoteInstance().book(toBeBooked);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"operSucess_book"));
        }
    }

    private void doLoanIntCheck(Set loanIntIDSet) throws EASBizException, BOSException {
        int count = 0;
        StringBuffer msgDetail = new StringBuffer();
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)loanIntIDSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getLoanInterestBillSelectors());
        LoanInterestBillCollection coll = LoanInterestBillFactory.getRemoteInstance().getLoanInterestBillCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            LoanInterestBillInfo intInfo = coll.get(i);
            if (intInfo.getIntCalType().equals((Object)IntCalTypeEnum.PRE_INT)) continue;
            BigDecimal interestActual = FMHelper.add((BigDecimal)intInfo.getInterestAcctual(), (BigDecimal)intInfo.getPunishInterestActual());
            InnerAccountInfo innerAccountInfo = InnerAccountFactory.getRemoteInstance().getInnerAccountInfo((IObjectPK)new ObjectUuidPK(intInfo.getIntAccount().getId()));
            BigDecimal payeeInnerAcctBalance = FMHelper.getBalanceValue(null, (CurrencyInfo)intInfo.getCurrency(), (InnerAccountInfo)innerAccountInfo);
            AccountMgrStrategyInfo accountMgrStrategyInfo = innerAccountInfo.getCtrlParam();
            accountMgrStrategyInfo = AccountMgrStrategyFactory.getRemoteInstance().getAccountMgrStrategyInfo((IObjectPK)new ObjectUuidPK(accountMgrStrategyInfo.getId()), this.getAccountMgrStrategySelector());
            OverdraftCtrlEnum overdraftCtrl = accountMgrStrategyInfo.getOverdraftCtrl();
            if (!overdraftCtrl.equals((Object)OverdraftCtrlEnum.NOTCONTROL) || !accountMgrStrategyInfo.isRemind() || interestActual.compareTo(payeeInnerAcctBalance) <= 0) continue;
            ++count;
            numberFormat.setMaximumFractionDigits(intInfo.getCurrency().getPrecision());
            numberFormat.setMinimumFractionDigits(intInfo.getCurrency().getPrecision());
            String tmp = FMHelper.formatMessage(null, (String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"DraftDetail", (Object[])new String[]{intInfo.getLoanBill().getNumber(), intInfo.getIntAccount().getName(), numberFormat.format(payeeInnerAcctBalance), numberFormat.format(FMHelper.subtract((BigDecimal)interestActual, (BigDecimal)payeeInnerAcctBalance))});
            msgDetail.append(tmp + "\n");
        }
        int result = 0;
        if (count > 0) {
            result = MsgBox.showConfirm4a((String)FMHelper.formatMessage(null, (String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"DraftMain", (Object[])new String[]{String.valueOf(loanIntIDSet.size()), String.valueOf(count)}), (String)msgDetail.toString());
        }
        if (result != 0) {
            SysUtil.abort();
        }
    }

    private SelectorItemCollection getLoanInterestBillSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("intAccount.name"));
        sic.add(new SelectorItemInfo("intAccount.number"));
        sic.add(new SelectorItemInfo("intAccount.company"));
        sic.add(new SelectorItemInfo("loanBill.id"));
        sic.add(new SelectorItemInfo("loanBill.number"));
        return sic;
    }

    private SelectorItemCollection getAccountMgrStrategySelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("overdraftCtrl");
        sic.add("overDraftAmount");
        sic.add("lowestBalance");
        sic.add("remind");
        return sic;
    }

    private Set getToBeBookedIdSet(Set allSelected, boolean needAudit) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("id", (Object)allSelected, CompareType.INCLUDE));
        if (needAudit) {
            f.getFilterItems().add(new FilterItemInfo("billStatus", (Object)IvtModualUtils.AUDIT));
        } else {
            f.getFilterItems().add(new FilterItemInfo("billStatus", (Object)IvtModualUtils.SUBMIT));
            f.getFilterItems().add(new FilterItemInfo("billStatus", (Object)IvtModualUtils.AUDIT));
            f.setMaskString("#0 and (#1 or #2)");
        }
        evi.setFilter(f);
        EntRepaymentBillCollection toBeBooked = EntRepaymentBillFactory.getRemoteInstance().getEntRepaymentBillCollection(evi);
        HashSet<String> toBeBookIDSet = new HashSet<String>();
        int size = toBeBooked.size();
        if (toBeBooked != null && size > 0) {
            for (int i = 0; i < size; ++i) {
                toBeBookIDSet.add(toBeBooked.get(i).getId().toString());
            }
        }
        return toBeBookIDSet;
    }

    @Override
    public void actionCancelBook_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.doCancelBook();
        this.refresh(e);
    }

    private void doCancelBook() throws Exception {
        int result;
        HashSet allSelected = new HashSet(this.getSelectedIdValues());
        boolean IVT006_Value = IvtModualUtils.getSysParam(null, (String)"IVT006");
        Set toBeBooked = this.getToBeCancelBookedIdSet(allSelected);
        if (toBeBooked.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"63_ChLoanListUI"));
            SysUtil.abort();
        }
        if (toBeBooked.size() > allSelected.size()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"unkownerror"));
            SysUtil.abort();
        } else if (toBeBooked.size() == allSelected.size()) {
            EntRepaymentBillFactory.getRemoteInstance().cancelBook(toBeBooked);
            if (IvtModualUtils.getSysParam(null, (String)"IVT003") || !IvtModualUtils.getSysParam(null, (String)"IVT006")) {
                EntRepaymentBillFactory.getRemoteInstance().antiAudit(toBeBooked);
            }
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"operSucess_cancelbook"));
        } else if (toBeBooked.size() < allSelected.size() && (result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"cancelbookoption"))) == 0) {
            EntRepaymentBillFactory.getRemoteInstance().cancelBook(toBeBooked);
            if (IvtModualUtils.getSysParam(null, (String)"IVT003") || !IvtModualUtils.getSysParam(null, (String)"IVT006")) {
                EntRepaymentBillFactory.getRemoteInstance().antiAudit(toBeBooked);
            }
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"operSucess_cancelbook"));
        }
    }

    private Set getToBeCancelBookedIdSet(Set allSelected) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("id", (Object)allSelected, CompareType.INCLUDE));
        f.getFilterItems().add(new FilterItemInfo("billStatus", (Object)IvtModualUtils.BOOK));
        evi.setFilter(f);
        EntRepaymentBillCollection toBeBooked = EntRepaymentBillFactory.getRemoteInstance().getEntRepaymentBillCollection(evi);
        HashSet<String> toBeCancelBookIDSet = new HashSet<String>();
        int size = toBeBooked.size();
        if (toBeBooked != null && size > 0) {
            for (int i = 0; i < size; ++i) {
                toBeCancelBookIDSet.add(toBeBooked.get(i).getId().toString());
            }
        }
        return toBeCancelBookIDSet;
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.FIN_MANAGE;
    }

    protected String getDateField() {
        return "repayDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionEdit", "actionRemove", "actionCancelBook", "actionAntiAudit"};
    }

    @Override
    public void actionNavInnerEreceipt_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        EReceiptInnerClientHelper.viewInnerEreceiptByBillIdList((List)idList, (Component)((Object)this));
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(EntRepaymentBillListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            IRow row = null;
            String currencyId = null;
            CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            BigDecimal loanAmt = Constants.ZERO;
            BigDecimal exchangeRate = Constants.ZERO;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = tblMain.getRow(i);
                row.getCell("repaySeq").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                row.getCell("exchangeRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                loanAmt = (BigDecimal)row.getCell("repayAmt").getValue();
                exchangeRate = (BigDecimal)row.getCell("exchangeRate").getValue();
                currencyId = (String)row.getCell("currency.id").getValue();
                if (currencyId != null) {
                    this.setAmtCellNumberFormat(row, currencyId);
                }
                if (companyInfo == null || companyInfo.getBaseCurrency() == null) continue;
                String baseCurrency = companyInfo.getBaseCurrency().getId().toString();
                FMClientHelper.setNumberFormat((IRow)row, (String)"localAmt", (String)baseCurrency);
            }
        }

        private void setAmtCellNumberFormat(IRow row, String currencyId) {
            FMClientHelper.setNumberFormat((IRow)row, (String)"repayAmt", (String)currencyId);
            FMClientHelper.setNumberFormat((IRow)row, (String)"loanTotalAmt", (String)currencyId);
            FMClientHelper.setNumberFormat((IRow)row, (String)"repayAmt", (String)currencyId);
            FMClientHelper.setNumberFormat((IRow)row, (String)"accumulateRePay", (String)currencyId);
            FMClientHelper.setNumberFormat((IRow)row, (String)"intAmt", (String)currencyId);
            FMClientHelper.setNumberFormat((IRow)row, (String)"penaAmt", (String)currencyId);
            FMClientHelper.setNumberFormat((IRow)row, (String)"recAmt", (String)currencyId);
        }
    }
}

