/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.ivt.BillStateEnum;
import com.kingdee.eas.fm.ivt.FinancingAccountApplyCollection;
import com.kingdee.eas.fm.ivt.FinancingAccountApplyFactory;
import com.kingdee.eas.fm.ivt.FinancingAccountApplyInfo;
import com.kingdee.eas.fm.ivt.IFinancingAccountApply;
import com.kingdee.eas.fm.ivt.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.ivt.client.AbstractFinancingAccountApplyEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.sql.Date;
import org.apache.log4j.Logger;

public class FinancingAccountApplyEditUI
extends AbstractFinancingAccountApplyEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FinancingAccountApplyEditUI.class);
    private CurrencyInfo baseCurrency;
    private int curCurrencyPrecision;
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    protected static final String IVT_RES = "com.kingdee.eas.fm.ivt.IVTFINANCINGResource";

    public FinancingAccountApplyEditUI() throws Exception {
        this.baseCurrency = this.currentCompany.getBaseCurrency();
        this.curCurrencyPrecision = this.baseCurrency.getPrecision();
        this.baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.baseCurrency.getId()));
    }

    @Override
    public void loadFields() {
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtnumber, (String)this.currentCompany.getId().toString());
        super.loadFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initComponent();
    }

    private void initComponent() {
        this.actionCopy.setVisible(false);
        this.pkBizDate.setSupportedEmpty(false);
        this.pkBeginDate.setSupportedEmpty(false);
        this.txtdays.setHorizontalAlignment(4);
        this.txtExchangeRate.setHorizontalAlignment(4);
        this.txtsaleSize.setHorizontalAlignment(4);
        this.txtfinanceAmount.setHorizontalAlignment(4);
        this.txtfinanceLocAmount.setHorizontalAlignment(4);
        this.txtPredictYield.setHorizontalAlignment(4);
        this.txtPredictWinAmount.setHorizontalAlignment(4);
        this.txtPredictWinLocAmount.setHorizontalAlignment(4);
        this.txtsaleSize.setRemoveingZeroInDispaly(false);
        this.txtfinanceAmount.setRemoveingZeroInDispaly(false);
        this.txtfinanceLocAmount.setRemoveingZeroInDispaly(false);
        this.txtExchangeRate.setRemoveingZeroInDispaly(false);
        this.txtfinanceAmount.setNegatived(false);
        this.txtsaleSize.setNegatived(false);
        this.txtfinanceLocAmount.setNegatived(false);
        this.txtdays.setNegatived(false);
        this.txtPredictWinAmount.setNegatived(false);
        this.txtPredictYield.setNegatived(false);
        this.prmtcurrency.setEnabled(false);
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            this.actionAddNew.setVisible(false);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.initComponent();
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.actionCopy.setVisible(false);
        String oprtState = this.getOprtState();
        if (!"ADDNEW".equals(oprtState)) {
            try {
                FinancingAccountApplyInfo info = (FinancingAccountApplyInfo)this.getDataObject();
                FinancingAccountApplyInfo accInfo = FinancingAccountApplyFactory.getRemoteInstance().getFinancingAccountApplyInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()));
                boolean isAudit = accInfo.getState() != BillStateEnum.AUDITED;
                this.actionEdit.setEnabled(isAudit);
                this.actionRemove.setEnabled(isAudit);
                boolean isSave = accInfo.getState() == BillStateEnum.SAVED;
                this.actionSave.setEnabled(isSave);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void initPropEvi() throws Exception {
        super.initPropEvi();
        this.initF7AccountBank();
        F7SelectorFactory.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtBank);
        this.initF7Bank();
    }

    private void initF7AccountBank() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId()));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Constants.FALSE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtbankaccount.setEntityViewInfo(evi);
    }

    private void initF7Bank() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE));
        filterInfo.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        this.prmtBank.setEntityViewInfo(evi);
    }

    @Override
    protected void intRateTypeExpression_itemStateChanged(ItemEvent e) throws Exception {
        IntRateTypeExpressionEnum intRateTypeExpressionEnum = (IntRateTypeExpressionEnum)((Object)this.intRateTypeExpression.getShowSelectedItem());
        if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.YEAR) {
            this.txtdays.setValue((Object)new Integer(360));
            this.contPredictYield.setBoundLabelText(EASResource.getString((String)IVT_RES, (String)"081_PredictYield"));
        } else if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.MONTH) {
            this.txtdays.setValue((Object)new Integer(30));
            this.contPredictYield.setBoundLabelText(EASResource.getString((String)IVT_RES, (String)"082_PredictYield"));
        } else if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.DAY) {
            this.txtdays.setValue((Object)new Integer(1));
            this.contPredictYield.setBoundLabelText(EASResource.getString((String)IVT_RES, (String)"082_PredictYield"));
        }
        this.setPredictWinAmount();
    }

    @Override
    protected void pkEndDate_dataChanged(DataChangeEvent e) throws Exception {
        this.setTerm();
        if (e.getNewValue() != null) {
            this.txtPredictWinAmount.setEnabled(true);
            this.txtTerm.setEnabled(true);
            this.setPredictWinAmount();
        } else {
            this.txtTerm.setEnabled(false);
            this.txtTerm.setText(null);
            this.editData.setTerm(null);
            this.txtPredictWinAmount.setValue(null);
            this.txtPredictWinAmount.setEnabled(false);
        }
        super.pkEndDate_dataChanged(e);
    }

    @Override
    protected void pkBeginDate_dataChanged(DataChangeEvent e) throws Exception {
        this.setTerm();
        this.setPredictWinAmount();
        super.pkBeginDate_dataChanged(e);
    }

    public void setTerm() throws Exception {
        java.util.Date beginDate = (java.util.Date)this.pkBeginDate.getValue();
        java.util.Date endDate = (java.util.Date)this.pkEndDate.getValue();
        if (beginDate != null && endDate != null) {
            int days = DateUtil.getDiffDays((java.util.Date)beginDate, (java.util.Date)endDate) - 1;
            if (days > 0) {
                this.txtTerm.setText(days + "");
            }
            this.editData.setTerm(String.valueOf(days));
        } else {
            this.txtTerm.setText(null);
            this.editData.setTerm(null);
        }
    }

    @Override
    protected IObjectValue createNewData() {
        FinancingAccountApplyInfo info = new FinancingAccountApplyInfo();
        info.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        info.setCompany(this.currentCompany);
        info.setCurrency(this.baseCurrency);
        info.setBizDate(DateUtil.getDayBegin());
        info.setBeginDate(DateUtil.getDayBegin());
        info.setFinanceAmount(new BigDecimal("0"));
        info.setFinanceLocAmount(new BigDecimal("0"));
        info.setSaleSize(new BigDecimal("0"));
        info.setExchangeRate(Constants.ONE);
        info.setIntRateTypeExpression(IntRateTypeExpressionEnum.YEAR);
        info.setDays(360);
        info.setIsCreatetoFac(false);
        info.setIsNoOut(true);
        info.setCU(this.currentCompany.getCU());
        return info;
    }

    @Override
    protected void prmtbankaccount_dataChanged(DataChangeEvent e) throws Exception {
        AccountBankInfo accountbank = (AccountBankInfo)e.getNewValue();
        if (accountbank != null) {
            CurrencyInfo currencyInfo;
            if (accountbank.getCurrency() != null) {
                currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(accountbank.getCurrency().getId()));
                this.prmtcurrency.setData((Object)currencyInfo);
                this.prmtcurrency.setEnabled(false);
            }
            if (!accountbank.isIsByCurrency()) {
                currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getBaseCurrency().getId()));
                this.prmtcurrency.setData((Object)currencyInfo);
                this.prmtcurrency.setEnabled(true);
            }
        }
    }

    @Override
    protected void prmtcurrency_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtcurrency_dataChanged(e);
        CurrencyInfo currency = (CurrencyInfo)this.prmtcurrency.getValue();
        if (currency != null) {
            Date date = this.pkBizDate.getSqlDate();
            FinUtils.initExchangeRate(null, (BasicFormattedTextField)this.txtExchangeRate, (CompanyOrgUnitInfo)this.currentCompany, (CurrencyInfo)currency, (CurrencyInfo)this.baseCurrency, (java.util.Date)date, null);
            int precision = currency.getPrecision();
            this.txtfinanceAmount.setPrecision(precision);
            this.txtsaleSize.setPrecision(precision);
            this.txtfinanceLocAmount.setPrecision(precision);
            this.txtPredictWinAmount.setPrecision(precision);
            this.txtPredictWinAmount.setPrecision(precision);
            this.txtPredictWinLocAmount.setPrecision(precision);
        }
    }

    @Override
    protected void txtExchangeRate_dataChanged(DataChangeEvent e) throws Exception {
        super.txtExchangeRate_dataChanged(e);
        this.calcAmt(this.txtfinanceAmount, this.txtfinanceLocAmount);
        this.calcAmt(this.txtPredictWinAmount, this.txtPredictWinLocAmount);
        this.setPredictWinAmount();
    }

    @Override
    protected void txtPredictYield_dataChanged(DataChangeEvent e) throws Exception {
        this.setPredictWinAmount();
    }

    @Override
    protected void txtdays_dataChanged(DataChangeEvent e) throws Exception {
        this.setPredictWinAmount();
    }

    @Override
    protected void txtFinanceAmount_dataChanged(DataChangeEvent e) throws Exception {
        super.txtFinanceAmount_dataChanged(e);
        this.calcAmt(this.txtfinanceAmount, this.txtfinanceLocAmount);
        this.setPredictWinAmount();
    }

    @Override
    protected void txtPredictWinAmount_dataChanged(DataChangeEvent e) throws Exception {
        super.txtPredictWinAmount_dataChanged(e);
        this.calcAmt(this.txtPredictWinAmount, this.txtPredictWinLocAmount);
    }

    private void setPredictWinAmount() throws Exception {
        BigDecimal FinanceAmount = Constants.ZERO;
        BigDecimal PredictYield = Constants.ZERO;
        BigDecimal term = Constants.ZERO;
        BigDecimal days = Constants.ZERO;
        if (this.txtfinanceAmount.getBigDecimalValue() == null) {
            return;
        }
        FinanceAmount = this.txtfinanceAmount.getBigDecimalValue();
        if (this.txtPredictYield.getBigDecimalValue() == null) {
            return;
        }
        PredictYield = this.txtPredictYield.getBigDecimalValue();
        if (this.txtdays.getBigDecimalValue() == null) {
            return;
        }
        days = this.txtdays.getBigDecimalValue();
        if (this.txtTerm.getText().equals("")) {
            return;
        }
        term = new BigDecimal(this.txtTerm.getText());
        if (this.intRateTypeExpression.getSelectedItem() == IntRateTypeExpressionEnum.YEAR) {
            BigDecimal PredictWinAmount = FinHelper.calcBigDecimalExprs((String)"{0}*({1}/{2})/{3}*{4}", (BigDecimal[])new BigDecimal[]{FinanceAmount, PredictYield, new BigDecimal("100"), days, term});
            this.txtPredictWinAmount.setValue((Object)PredictWinAmount);
        } else {
            BigDecimal PredictWinAmount = FinHelper.calcBigDecimalExprs((String)"{0}*({1}/{2})/{3}*{4}", (BigDecimal[])new BigDecimal[]{FinanceAmount, PredictYield, new BigDecimal("1000"), days, term});
            this.txtPredictWinAmount.setValue((Object)PredictWinAmount);
        }
    }

    private void calcAmt(KDFormattedTextField txtAmount, KDFormattedTextField txtLocAmount) {
        BigDecimal rate = this.txtExchangeRate.getBigDecimalValue();
        BigDecimal applyAmt = txtAmount.getBigDecimalValue();
        if (rate != null && applyAmt != null) {
            txtLocAmount.setValue((Object)applyAmt.multiply(rate));
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        if (this.editData.getEndDate() != null && this.editData.getEndDate().compareTo(this.editData.getBeginDate()) < 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"82_FinancingAccountEditUI"));
            SysUtil.abort();
        }
        if (this.editData.getExchangeRate().compareTo(BigDecimal.ZERO) != 1) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"80_FinancingAccountEditUI"));
            SysUtil.abort();
        }
        if (this.editData.getFinanceAmount().compareTo(BigDecimal.ZERO) != 1) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"79_FinancingAccountEditUI"));
            SysUtil.abort();
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.checkbillStatusChanged();
        super.verifyInput(e);
        super.actionSave_actionPerformed(e);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkbillStatusChanged();
        super.actionSubmit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkbillStatusChanged();
        super.actionRemove_actionPerformed(e);
    }

    private void checkbillStatusChanged() {
        try {
            if (this.editData.getId() != null) {
                FinancingAccountApplyInfo accountInfo;
                IFinancingAccountApply account = FinancingAccountApplyFactory.getRemoteInstance();
                FinancingAccountApplyCollection accountCollection = null;
                EntityViewInfo query = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                query.setFilter(filter);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("state");
                query.setSelector(sic);
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId().toString()));
                accountCollection = account.getFinancingAccountApplyCollection(query);
                if (accountCollection != null && accountCollection.size() == 1 && (accountInfo = accountCollection.get(0)).getState() != this.editData.getState()) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)IVT_RES, (String)"055_ADD_ERROR"));
                    SysUtil.abort();
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.prmtcurrency.setEnabled(false);
    }
}

