/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.MutexUtils;
import com.kingdee.eas.fm.common.util.FMARAPUtil;
import com.kingdee.eas.fm.ivt.BillStateEnum;
import com.kingdee.eas.fm.ivt.FinancingAccountApplyFactory;
import com.kingdee.eas.fm.ivt.FinancingAccountApplyInfo;
import com.kingdee.eas.fm.ivt.IFinancingAccountApply;
import com.kingdee.eas.fm.ivt.client.AbstractFinancingAccountApplyListUI;
import com.kingdee.eas.fm.ivt.client.FinancingAccountApplyDataProvider;
import com.kingdee.eas.fm.ivt.client.FinancingAccountApplyFilterUI;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class FinancingAccountApplyListUI
extends AbstractFinancingAccountApplyListUI {
    private static final Logger logger = CoreUIObject.getLogger(FinancingAccountApplyListUI.class);
    FMFilterBaseUI filterUI = null;
    protected static final String IVT_RES = "com.kingdee.eas.fm.ivt.IVTFINANCINGResource";
    FillListener fillListener = new FillListener();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return FinancingAccountApplyFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        FinancingAccountApplyInfo objectValue = new FinancingAccountApplyInfo();
        return objectValue;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (null == this.filterUI) {
            this.filterUI = new FinancingAccountApplyFilterUI();
        }
        return this.filterUI;
    }

    public void setListUITable(KDTable tblMain, KDTDataRequestEvent e) {
        IRow row = null;
        String currencyId = null;
        if (e == null) {
            return;
        }
        for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
            row = tblMain.getRow(i);
            currencyId = (String)row.getCell("currency.id").getValue();
            if (currencyId != null) {
                String[] formatCol = this.getPrecColName();
                for (int j = 0; j < formatCol.length; ++j) {
                    FMClientHelper.setNumberFormat((IRow)row, (String)formatCol[j], (String)currencyId);
                }
            }
            int prec = CasRecPayHandler.getExRatePrec((String)row.getCell("currency.id").getValue().toString(), null, (CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany(), (Date)((Date)row.getCell("bizDate").getValue()));
            FMARAPUtil.setPrecision((ICell)row.getCell("exchangeRate"), (int)prec);
            BizEnumValueInfo exp = (BizEnumValueInfo)row.getCell("intRateTypeExpression").getValue();
            Object enu = exp.getValue();
            if ("year".equalsIgnoreCase(enu.toString())) {
                row.getCell("predictYield").getStyleAttributes().setNumberFormat("#,##0.00000\\%");
                continue;
            }
            row.getCell("predictYield").getStyleAttributes().setNumberFormat("#,##0.00000\\\u2030");
        }
    }

    protected String[] getPrecColName() {
        return new String[]{"financeAmount", "predictWinAmount", "predictWinLocAmount"};
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompanyCommon)) {
            this.actionAddNew.setVisible(false);
        }
        this.actionGenPayBill.setVisible(false);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        ArrayList<String> lst = new ArrayList<String>();
        IFinancingAccountApply finapply = (IFinancingAccountApply)this.getBizInterface();
        StringBuffer str = new StringBuffer();
        if (idList != null && idList.size() > 0) {
            for (int i = 0; i < idList.size(); ++i) {
                String id = (String)idList.get(i);
                boolean hasWf = FMHelper.hasWFInstance(null, (String)id);
                if (hasWf) {
                    MultiApproveUtil.multiapproveBills((CoreUIObject)this, (String)userID, (String[])new String[]{id});
                    continue;
                }
                FinancingAccountApplyInfo info = finapply.getFinancingAccountApplyInfo((IObjectPK)new ObjectUuidPK(id));
                if (!BillStateEnum.SAVED.equals((Object)info.getState())) {
                    str.append(EASResource.getString((String)IVT_RES, (String)"041_SUBMIT_ERROR", (Object[])new String[]{info.getNumber()}));
                    str.append("\r\n");
                    continue;
                }
                lst.add(id);
            }
        }
        if (lst.size() != 0) {
            finapply.batchSubmit(lst);
        }
        if (str.length() > 0) {
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)IVT_RES, (String)"011_SUBMIT_RESULT", (Object[])new String[]{String.valueOf(lst.size()), String.valueOf(idList.size() - lst.size())}), (String)str.toString(), (int)1);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)IVT_RES, (String)"012_SUBMIT_SUCCESS"));
        }
        this.refreshList();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String keyValue = this.getSelectedKeyValue();
        if (keyValue == null) {
            return;
        }
        MutexUtils.requestMutex((CoreUI)this, (String)keyValue);
        FinancingAccountApplyInfo info = FinancingAccountApplyFactory.getRemoteInstance().getFinancingAccountApplyInfo((IObjectPK)new ObjectUuidPK(keyValue));
        if (info.getState() == BillStateEnum.AUDITED) {
            MsgBox.showInfo((String)EASResource.getString((String)IVT_RES, (String)"042_EDIT_ERROR"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        ArrayList<String> lst = new ArrayList<String>();
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        IFinancingAccountApply finapply = (IFinancingAccountApply)this.getBizInterface();
        StringBuffer str = new StringBuffer();
        if (idList != null && idList.size() > 0) {
            for (int i = 0; i < idList.size(); ++i) {
                String id = (String)idList.get(i);
                boolean hasWf = FMHelper.hasWFInstance(null, (String)id);
                if (hasWf) {
                    MultiApproveUtil.multiapproveBills((CoreUIObject)this, (String)userID, (String[])new String[]{id});
                    continue;
                }
                FinancingAccountApplyInfo info = finapply.getFinancingAccountApplyInfo((IObjectPK)new ObjectUuidPK(id));
                if (!BillStateEnum.AUDITED.equals((Object)info.getState())) {
                    str.append(EASResource.getString((String)IVT_RES, (String)"043_UNAUDIT_ERROR", (Object[])new String[]{info.getNumber()}));
                    str.append("\r\n");
                    continue;
                }
                if (info.isIsCreatetoFac()) {
                    str.append(EASResource.getString((String)IVT_RES, (String)"044_UNAUDIT_ERROR", (Object[])new String[]{info.getNumber()}));
                    str.append("\r\n");
                    continue;
                }
                if (info.isIsGenePayBill()) {
                    str.append(EASResource.getString((String)IVT_RES, (String)"045_UNAUDIT_ERROR", (Object[])new String[]{info.getNumber()}));
                    str.append("\r\n");
                    continue;
                }
                lst.add(id);
            }
        }
        if (lst.size() != 0) {
            finapply.antiaudit(lst);
        }
        if (str.length() > 0) {
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)IVT_RES, (String)"007_UNAUDIT_RESULT", (Object[])new String[]{String.valueOf(lst.size()), String.valueOf(idList.size() - lst.size())}), (String)str.toString(), (int)1);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)IVT_RES, (String)"008_UNAUDIT_SUCCESS"));
        }
        this.refreshList();
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        ArrayList<String> lst = new ArrayList<String>();
        IFinancingAccountApply finapply = (IFinancingAccountApply)this.getBizInterface();
        StringBuffer str = new StringBuffer();
        if (idList != null && idList.size() > 0) {
            for (int i = 0; i < idList.size(); ++i) {
                String id = (String)idList.get(i);
                boolean hasWf = FMHelper.hasWFInstance(null, (String)id);
                if (hasWf) {
                    MultiApproveUtil.multiapproveBills((CoreUIObject)this, (String)userID, (String[])new String[]{id});
                    continue;
                }
                FinancingAccountApplyInfo info = finapply.getFinancingAccountApplyInfo((IObjectPK)new ObjectUuidPK(id));
                if (!BillStateEnum.SUBMITED.equals((Object)info.getState())) {
                    str.append(EASResource.getString((String)IVT_RES, (String)"046_AUDIT_ERROR", (Object[])new String[]{info.getNumber()}));
                    str.append("\r\n");
                    continue;
                }
                lst.add(id);
            }
        }
        if (lst.size() != 0) {
            finapply.audit(lst);
        }
        if (str.length() > 0) {
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)IVT_RES, (String)"005_AUDIT_RESULT", (Object[])new String[]{String.valueOf(lst.size()), String.valueOf(idList.size() - lst.size())}), (String)str.toString(), (int)1);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)IVT_RES, (String)"006_AUDIT_SUCCESS"));
        }
        this.refreshList();
    }

    @Override
    public void actionGenPayBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() > 1) {
            MsgBox.showInfo((String)EASResource.getString((String)IVT_RES, (String)"031_SELECT_ONE"));
            SysUtil.abort();
        }
        String id = (String)idList.get(0);
        FinancingAccountApplyInfo info = FinancingAccountApplyFactory.getRemoteInstance().getFinancingAccountApplyInfo((IObjectPK)new ObjectUuidPK(id));
        if (info.getState() != BillStateEnum.AUDITED || info.isIsCreatetoFac()) {
            if (info.getState() != BillStateEnum.AUDITED) {
                MsgBox.showInfo((String)EASResource.getString((String)IVT_RES, (String)"036_PAY_ERROR", (Object[])new String[]{info.getNumber()}));
            }
            if (info.isIsCreatetoFac()) {
                MsgBox.showInfo((String)EASResource.getString((String)IVT_RES, (String)"047_PAY_ERROR", (Object[])new String[]{info.getNumber()}));
            }
        } else {
            FMClientHelper.generateDestBill((CoreBillListUI)this, (String)FinancingAccountApplyInfo.BOSTYPE.toString(), (String)new PaymentBillInfo().getBOSType().toString(), (String)this.getSelectedKeyValue());
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        ArrayList<String> lst = new ArrayList<String>();
        IFinancingAccountApply finapply = (IFinancingAccountApply)this.getBizInterface();
        StringBuffer str = new StringBuffer();
        if (idList != null && idList.size() > 0) {
            for (int i = 0; i < idList.size(); ++i) {
                String id = (String)idList.get(i);
                boolean hasWf = FMHelper.hasWFInstance(null, (String)id);
                if (hasWf) {
                    MultiApproveUtil.multiapproveBills((CoreUIObject)this, (String)userID, (String[])new String[]{id});
                    continue;
                }
                FinancingAccountApplyInfo info = finapply.getFinancingAccountApplyInfo((IObjectPK)new ObjectUuidPK(id));
                if (BillStateEnum.AUDITED.equals((Object)info.getState())) {
                    str.append(EASResource.getString((String)IVT_RES, (String)"048_DELETE_ERROR", (Object[])new String[]{info.getNumber()}));
                    str.append("\r\n");
                    continue;
                }
                lst.add(id);
            }
        }
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")))) {
            if (lst.size() != 0) {
                finapply.batchDelete(lst);
            }
        } else {
            return;
        }
        if (str.length() > 0) {
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)IVT_RES, (String)"009_DELETE_RESULT", (Object[])new String[]{String.valueOf(lst.size()), String.valueOf(idList.size() - lst.size())}), (String)str.toString(), (int)1);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)IVT_RES, (String)"010_DELETE_SUCCESS"));
        }
        this.refreshList();
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.getSelectedIdValues().size() > 1) {
            MsgBox.showInfo((String)EASResource.getString((String)IVT_RES, (String)"031_SELECT_ONE"));
            this.abort();
        }
        String id = this.getSelectedKeyValue();
        FinancingAccountApplyInfo info = FinancingAccountApplyFactory.getRemoteInstance().getFinancingAccountApplyInfo((IObjectPK)new ObjectUuidPK(id));
        if (info.getState() != BillStateEnum.AUDITED) {
            MsgBox.showInfo((String)EASResource.getString((String)IVT_RES, (String)"049_CREAT_ERROR"));
            this.abort();
        }
        if (info.isIsCreatetoFac()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"424_FinancingAccountApplyListUI"));
            this.abort();
        }
        super.actionCreateTo_actionPerformed(e);
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(false);
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(true);
    }

    private void tdPrint(boolean isPreview) {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        FinancingAccountApplyDataProvider data = new FinancingAccountApplyDataProvider(idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        if (isPreview) {
            appHlp.printPreview("/FM/INVEST/FINIVT/FINAPPLYACCOUNT", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.print("/FM/INVEST/FINIVT/FINAPPLYACCOUNT", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    @Override
    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fm.ivt.app.FinancingAccountApplyTDQuery");
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        String companyid = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(3)));
        filter.getFilterItems().add(new FilterItemInfo("isCreatetoFac", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
        return filter;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("accountBank.id"));
        sic.add(new SelectorItemInfo("accountBank.number"));
        sic.add(new SelectorItemInfo("accountBank.name"));
        sic.add(new SelectorItemInfo("accountBank.*"));
        return sic;
    }

    public List getDestBosTypeForBotp(CoreBillBaseCollection srcBillInfos, List destBosTypeList) {
        if (!EmptyUtil.isEmpty((Collection)destBosTypeList)) {
            Iterator it = destBosTypeList.iterator();
            while (it.hasNext()) {
                if (!"40284E81".equals(it.next())) continue;
                it.remove();
            }
        }
        return destBosTypeList;
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            FinancingAccountApplyListUI.this.setListUITable(FinancingAccountApplyListUI.this.tblMain, e);
        }
    }
}

